import datetime

from tests.data.geolayers import (
    geolayer_attributes_only,
    geolayer_attributes_only_boolean_false,
    geolayer_geometry_only_all_geometries_type,
    geolayer_fr_dept_data_and_geometry,
    geolayer_attributes_to_force_only_forced,
)

from tests.data.fields_metadata import (
    geolayer_attributes_only_fields_metadata,
    geolayer_attributes_only_fields_metadata_without_index,
    geolayer_data_fields_metadata_complete,
    geolayer_data_fields_metadata_extract,
)


from geoformat_lib.driver.postgresql_driver import (
    fields_metadata_to_create_table_fields_structure,
    geolayer_to_postgres,
    geometry_ref_to_geometry_field_structure,
    format_to_posgresq_values,
    _method_execute_batch
)

from tests.test_all import test_function

try:
    import psycopg2
    import psycopg2.extras

    import_psycopg2_success = True
except ImportError:
    import_psycopg2_success = False


host = "localhost"
database_name = "guilhain"
user = "redpig"
password = "Flostib4"
port = 5433
schema = "public"
geometry_column_name = "geom"
overwrite = True

fields_metadata_to_create_table_fields_structure_parameters = {
    0: {
        "geolayer_fields_metadata": geolayer_attributes_only_fields_metadata,
        "consider_width_and_precision": False,
        "return_value": "field_integer integer, field_integer_list integer[], field_real numeric, field_real_list numeric[], field_string character varying, field_string_list character varying[], field_date date, field_time time, field_datetime timestamp, field_binary bytea, field_boolean boolean",
    },
    1: {
        "geolayer_fields_metadata": geolayer_attributes_only_fields_metadata_without_index,
        "consider_width_and_precision": False,
        "return_value": "field_integer integer, field_integer_list integer[], field_real numeric, field_real_list numeric[], field_string character varying, field_string_list character varying[], field_date date, field_time time, field_datetime timestamp, field_binary bytea, field_boolean boolean",
    },
    2: {
        "geolayer_fields_metadata": geolayer_data_fields_metadata_complete,
        "consider_width_and_precision": False,
        "return_value": "CODE_DEPT character varying, NOM_DEPT character varying",
    },
    3: {
        "geolayer_fields_metadata": geolayer_data_fields_metadata_extract,
        "consider_width_and_precision": False,
        "return_value": "CODE_DEPT character varying, NOM_DEPT character varying",
    },
    4: {
        "geolayer_fields_metadata": geolayer_attributes_only_fields_metadata,
        "consider_width_and_precision": True,
        "return_value": "field_integer integer, field_integer_list integer[], field_real numeric(9, 5), field_real_list numeric[], field_string character varying(5), field_string_list character varying[], field_date date, field_time time, field_datetime timestamp, field_binary bytea, field_boolean boolean",
    },
    5: {
        "geolayer_fields_metadata": geolayer_attributes_only_fields_metadata_without_index,
        "consider_width_and_precision": True,
        "return_value": "field_integer integer, field_integer_list integer[], field_real numeric(9, 5), field_real_list numeric[], field_string character varying(5), field_string_list character varying[], field_date date, field_time time, field_datetime timestamp, field_binary bytea, field_boolean boolean",
    },
    6: {
        "geolayer_fields_metadata": geolayer_data_fields_metadata_complete,
        "consider_width_and_precision": True,
        "return_value": "CODE_DEPT character varying(2), NOM_DEPT character varying(23)",
    },
    7: {
        "geolayer_fields_metadata": geolayer_data_fields_metadata_extract,
        "consider_width_and_precision": True,
        "return_value": "CODE_DEPT character varying(2), NOM_DEPT character varying(10)",
    },
}

geolayer_to_postgres_parameters = {
    0: {
        "geolayer": geolayer_attributes_only,
        "host": host,
        "database_name": database_name,
        "user": user,
        "password": password,
        "port": port,
        "schema": schema,
        "geometry_column_name": "geom",
        "overwrite": True,
        "constraint_geometry_type": False,
        "consider_width_and_precision": True,
        "return_value": None,
    },
    1: {
        "geolayer": geolayer_geometry_only_all_geometries_type,
        "host": host,
        "database_name": database_name,
        "user": user,
        "password": password,
        "port": port,
        "schema": schema,
        "geometry_column_name": "geom",
        "overwrite": True,
        "constraint_geometry_type": "Polygon",
        "consider_width_and_precision": True,
        "return_value": None,
    },
    2: {
        "geolayer": geolayer_fr_dept_data_and_geometry,
        "host": host,
        "database_name": database_name,
        "user": user,
        "password": password,
        "port": port,
        "schema": schema,
        "geometry_column_name": "geom",
        "overwrite": True,
        "constraint_geometry_type": False,
        "consider_width_and_precision": True,
        "return_value": None,
    },
    3: {
        "geolayer": geolayer_attributes_to_force_only_forced,
        "host": host,
        "database_name": database_name,
        "user": user,
        "password": password,
        "port": port,
        "schema": schema,
        "geometry_column_name": "geom",
        "overwrite": True,
        "constraint_geometry_type": False,
        "consider_width_and_precision": True,
        "return_value": None,
    },
    4: {
        "geolayer": geolayer_attributes_only_boolean_false,
        "host": host,
        "database_name": database_name,
        "user": user,
        "password": password,
        "port": port,
        "schema": schema,
        "geometry_column_name": "geom",
        "overwrite": True,
        "constraint_geometry_type": False,
        "consider_width_and_precision": True,
        "return_value": None,
    },
}

geometry_ref_to_geometry_field_structure_parameters = {
    0: {
        "geometry_ref": {
            "type": {
                "Point",
                "LineString",
                "Polygon",
                "MultiPoint",
                "MultiLineString",
                "MultiPolygon",
                "GeometryCollection",
            },
            "crs": 4326,
        },
        "geometry_field_name": "geom",
        "constraint_geometry_type": False,
        "return_value": "geom geometry('Geometry', 4326)",
    },
    1: {
        "geometry_ref": {"type": {"Point"}},
        "geometry_field_name": "geom",
        "constraint_geometry_type": False,
        "return_value": "geom geometry('Geometry')",
    },
    2: {
        "geometry_ref": {"type": {"Point"}},
        "geometry_field_name": "geom",
        "constraint_geometry_type": True,
        "return_value": "geom geometry('Point')",
    },
    3: {
        "geometry_ref": {"type": {"Point", "LineString"}},
        "geometry_field_name": "geom",
        "constraint_geometry_type": True,
        "return_value": "geom geometry('Geometry')",
    },
}

format_to_posgresq_values_parameters = {
    0: {
        "geolayer": geolayer_attributes_only,
        "return_value": [
            [
                586,
                [5879, 8557],
                8789.97568,
                [89798.3654, 8757.97568],
                "salut",
                ["bonjour", "monsieur"],
                datetime.date(2020, 3, 31),
                datetime.time(11, 22, 10, 999),
                datetime.datetime(2020, 3, 31, 11, 22, 10, 999),
                b"\x00\x00\x00\x00\x04\x00\x00\x00\x02\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01?\xf0\x00\x00\x00\x00\x00\x00?\xf0\x00\x00\x00\x00\x00\x00",
                True,
            ]
        ],
    },
    1: {
        "geolayer": geolayer_attributes_only_boolean_false,
        "return_value": [
            [
                0,
                [],
                0.0,
                [],
                "False",
                [],
                datetime.date(2020, 3, 31),
                datetime.time(11, 22, 10, 999),
                datetime.datetime(2020, 3, 31, 11, 22, 10, 999),
                b"",
                False,
            ]
        ],
    },
    2: {
        "geolayer": geolayer_geometry_only_all_geometries_type,
        "return_value": [
            ["SRID=4326;POINT (-115.81 37.24)"],
            ["SRID=4326;POINT EMPTY"],
            ["SRID=4326;LINESTRING (8.919 44.4074,8.923 44.4075)"],
            ["SRID=4326;LINESTRING EMPTY"],
            [
                "SRID=4326;POLYGON ((2.38 57.322,23.194 -20.28,-120.43 19.15,2.38 57.322),(-5.21 23.51,15.21 -10.81,-20.51 1.51,-5.21 23.51))"
            ],
            ["SRID=4326;POLYGON EMPTY"],
            ["SRID=4326;MULTIPOINT (-155.52 19.61,-156.22 20.74,-157.97 21.46)"],
            ["SRID=4326;MULTIPOINT EMPTY"],
            [
                "SRID=4326;MULTILINESTRING ((3.75 9.25,-130.95 1.52),(23.15 -34.25,-1.35 -4.65,3.45 77.95))"
            ],
            ["SRID=4326;MULTILINESTRING EMPTY"],
            [
                "SRID=4326;MULTIPOLYGON (((3.78 9.28,-130.91 1.52,35.12 72.234,3.78 9.28)),((23.18 -34.29,-1.31 -4.61,3.41 77.91,23.18 -34.29)))"
            ],
            ["SRID=4326;MULTIPOLYGON EMPTY"],
            [
                "SRID=4326;GEOMETRYCOLLECTION (POINT (-115.81 37.24),LINESTRING (8.919 44.4074,8.923 44.4075),POLYGON ((2.38 57.322,23.194 -20.28,-120.43 19.15,2.38 57.322),(-5.21 23.51,15.21 -10.81,-20.51 1.51,-5.21 23.51)),MULTIPOINT (-155.52 19.61,-156.22 20.74,-157.97 21.46),MULTILINESTRING ((3.75 9.25,-130.95 1.52),(23.15 -34.25,-1.35 -4.65,3.45 77.95)),MULTIPOLYGON (((3.78 9.28,-130.91 1.52,35.12 72.234,3.78 9.28)),((23.18 -34.29,-1.31 -4.61,3.41 77.91,23.18 -34.29))))"
            ],
            ["SRID=4326;GEOMETRYCOLLECTION EMPTY"],
            [
                "SRID=4326;GEOMETRYCOLLECTION (POINT EMPTY,LINESTRING (8.919 44.4074,8.923 44.4075),POLYGON ((2.38 57.322,23.194 -20.28,-120.43 19.15,2.38 57.322),(-5.21 23.51,15.21 -10.81,-20.51 1.51,-5.21 23.51)),MULTIPOINT EMPTY,MULTILINESTRING ((3.75 9.25,-130.95 1.52),(23.15 -34.25,-1.35 -4.65,3.45 77.95)),MULTIPOLYGON EMPTY)"
            ],
        ],
    },
    3: {
        "geolayer": geolayer_fr_dept_data_and_geometry,
        "return_value": [
            [
                "32",
                "GERS",
                "SRID=2154;POLYGON ((505760.0 6248691.0,509767.0 6249274.0,514960.0 6255730.0,523428.0 6259977.0,531230.0 6258583.0,536034.0 6253601.0,539594.0 6265818.0,554723.0 6278961.0,550482.0 6283435.0,545681.0 6284750.0,535303.0 6300840.0,531445.0 6300603.0,531142.0 6309545.0,528381.0 6316132.0,520187.0 6318466.0,528536.0 6329188.0,521740.0 6328834.0,519117.0 6332164.0,512956.0 6327891.0,507637.0 6333951.0,502833.0 6331375.0,496470.0 6331745.0,495008.0 6328849.0,483787.0 6325253.0,474692.0 6327970.0,465465.0 6324803.0,465239.0 6317398.0,461632.0 6315722.0,453303.0 6321029.0,444807.0 6320573.0,440195.0 6315550.0,443572.0 6313646.0,442698.0 6298315.0,439499.0 6295895.0,438084.0 6281592.0,443497.0 6282643.0,449863.0 6280833.0,456497.0 6283051.0,457450.0 6278664.0,461941.0 6273297.0,466465.0 6272970.0,468215.0 6263513.0,471536.0 6256527.0,479309.0 6257879.0,496988.0 6250664.0,505760.0 6248691.0))",
            ],
            [
                "47",
                "LOT-ET-GARONNE",
                "SRID=2154;POLYGON ((547193.0 6388334.0,539761.0 6395885.0,530971.0 6390971.0,526858.0 6394383.0,527849.0 6401566.0,514373.0 6400391.0,512334.0 6403639.0,495031.0 6397493.0,491196.0 6399384.0,489091.0 6407815.0,486169.0 6410676.0,474628.0 6407547.0,472909.0 6402270.0,476701.0 6399758.0,474218.0 6394851.0,464993.0 6388179.0,460343.0 6383021.0,460366.0 6373402.0,462536.0 6370133.0,454032.0 6364649.0,457916.0 6359953.0,455164.0 6354504.0,449164.0 6352477.0,449759.0 6344226.0,459734.0 6343570.0,462757.0 6341305.0,470769.0 6340294.0,467874.0 6336236.0,464468.0 6326808.0,465465.0 6324803.0,474692.0 6327970.0,483787.0 6325253.0,495008.0 6328849.0,496470.0 6331745.0,502833.0 6331375.0,507637.0 6333951.0,512956.0 6327891.0,519117.0 6332164.0,520115.0 6336256.0,529462.0 6338671.0,533815.0 6350996.0,536387.0 6355171.0,530427.0 6360537.0,531660.0 6365290.0,544593.0 6364542.0,545774.0 6366277.0,541673.0 6377661.0,542159.0 6383881.0,547193.0 6388334.0))",
            ],
            [
                "38",
                "ISERE",
                "SRID=2154;POLYGON ((841110.0 6468164.0,847361.0 6468209.0,855768.0 6473591.0,860939.0 6470947.0,866406.0 6463235.0,870728.0 6463360.0,871909.0 6454823.0,871457.0 6445038.0,888053.0 6440277.0,892767.0 6444271.0,895595.0 6439026.0,895949.0 6427870.0,894862.0 6413405.0,907889.0 6409384.0,918546.0 6403480.0,921863.0 6404787.0,925560.0 6409806.0,930672.0 6410433.0,933177.0 6416064.0,939410.0 6420031.0,941569.0 6417648.0,947667.0 6423241.0,956742.0 6422339.0,960775.0 6424797.0,965006.0 6422921.0,964872.0 6432532.0,961377.0 6439340.0,952342.0 6439924.0,953909.0 6450690.0,956276.0 6452799.0,950505.0 6456663.0,945165.0 6465401.0,945461.0 6470305.0,949441.0 6473761.0,948557.0 6482085.0,943964.0 6486985.0,938381.0 6486658.0,931624.0 6492445.0,925224.0 6482705.0,917457.0 6486189.0,913763.0 6489603.0,904449.0 6504924.0,897998.0 6515860.0,888123.0 6525941.0,888996.0 6528631.0,882529.0 6534232.0,879159.0 6530984.0,876089.0 6523611.0,870291.0 6521483.0,863140.0 6525920.0,862850.0 6517700.0,865784.0 6514252.0,858527.0 6506228.0,848198.0 6502534.0,841056.0 6498593.0,845846.0 6493277.0,837308.0 6485557.0,837457.0 6475559.0,841110.0 6468164.0))",
            ],
            [
                "62",
                "PAS-DE-CALAIS",
                "SRID=2154;POLYGON ((634422.0 7101577.0,623701.0 7099214.0,610465.0 7094261.0,605814.0 7089013.0,599885.0 7086576.0,601399.0 7078135.0,598139.0 7067917.0,599563.0 7049801.0,597332.0 7035063.0,603193.0 7029103.0,605232.0 7026713.0,612989.0 7030025.0,622831.0 7024302.0,624801.0 7021563.0,634147.0 7017146.0,635372.0 7012312.0,648121.0 7014552.0,654991.0 7012592.0,660837.0 7014835.0,663948.0 7010834.0,656343.0 7006536.0,658067.0 7000416.0,662547.0 7004433.0,667892.0 7004913.0,669642.0 7001764.0,689814.0 6997681.0,691147.0 6993758.0,706470.0 6995042.0,706855.0 7002888.0,711164.0 7009522.0,712383.0 7015916.0,699507.0 7031355.0,702680.0 7038239.0,701478.0 7042709.0,697493.0 7046164.0,692820.0 7044918.0,687641.0 7047582.0,686184.0 7056263.0,688698.0 7062196.0,683642.0 7063001.0,679720.0 7059405.0,673807.0 7057943.0,664277.0 7059477.0,658064.0 7064147.0,653390.0 7071778.0,644454.0 7079622.0,642453.0 7087769.0,636514.0 7100652.0,634422.0 7101577.0))",
            ],
            [
                "08",
                "ARDENNES",
                "SRID=2154;POLYGON ((776081.0 6923412.0,782994.0 6923346.0,790665.0 6921022.0,795010.0 6915033.0,803525.0 6909934.0,814643.0 6911926.0,818364.0 6905215.0,822754.0 6907655.0,833062.0 6905548.0,837898.0 6908256.0,842092.0 6905887.0,849280.0 6910207.0,847303.0 6917040.0,853548.0 6926776.0,849442.0 6935263.0,853210.0 6945817.0,856532.0 6942619.0,867310.0 6942452.0,873032.0 6949057.0,869864.0 6950495.0,863792.0 6957578.0,856370.0 6957018.0,850915.0 6964755.0,848735.0 6964497.0,834935.0 6970707.0,833403.0 6975569.0,835414.0 6979112.0,832902.0 6984653.0,828614.0 6985882.0,833821.0 7001508.0,834466.0 7007583.0,830491.0 7008459.0,826108.0 7005649.0,820627.0 6997569.0,821199.0 6989850.0,814347.0 6988595.0,808498.0 6984157.0,803958.0 6983050.0,795770.0 6985807.0,788558.0 6985051.0,789845.0 6973793.0,787172.0 6965431.0,790134.0 6962730.0,781387.0 6953785.0,779463.0 6948255.0,774574.0 6946610.0,777906.0 6941851.0,775403.0 6934852.0,776081.0 6923412.0))",
            ],
            [
                "10",
                "AUBE",
                "SRID=2154;POLYGON ((730707.0 6810078.0,736893.0 6807760.0,745765.0 6796957.0,746161.0 6791892.0,749678.0 6782304.0,755033.0 6785741.0,759917.0 6778325.0,763413.0 6765164.0,767353.0 6760249.0,783028.0 6759096.0,789480.0 6763963.0,796594.0 6759156.0,797692.0 6763119.0,808147.0 6762855.0,816397.0 6764598.0,817962.0 6771080.0,827043.0 6770243.0,825768.0 6776095.0,828770.0 6781171.0,835407.0 6779651.0,837598.0 6783989.0,837935.0 6797546.0,834073.0 6806764.0,827022.0 6811887.0,822210.0 6820200.0,823302.0 6827043.0,819107.0 6829393.0,814106.0 6826118.0,803526.0 6829924.0,796995.0 6835851.0,797551.0 6845278.0,785824.0 6845891.0,779497.0 6845091.0,773768.0 6840880.0,769985.0 6834113.0,760761.0 6824301.0,753955.0 6826609.0,746802.0 6826973.0,740952.0 6835710.0,737148.0 6833964.0,731262.0 6826009.0,728998.0 6813854.0,730707.0 6810078.0))",
            ],
            [
                "06",
                "ALPES-MARITIMES",
                "SRID=2154;POLYGON ((1009696.0 6370071.0,1002665.0 6364730.0,997268.0 6357103.0,994698.0 6348019.0,1000668.0 6338218.0,1000089.0 6334256.0,1007601.0 6328762.0,1009068.0 6324850.0,1014122.0 6322114.0,1012050.0 6317690.0,1007566.0 6320724.0,1000978.0 6315262.0,997097.0 6315251.0,992638.0 6305621.0,1002326.0 6300425.0,1003290.0 6292496.0,1006552.0 6288390.0,1015523.0 6285590.0,1014132.0 6274778.0,1018256.0 6272482.0,1020971.0 6279894.0,1026533.0 6279746.0,1033109.0 6287175.0,1036126.0 6293135.0,1041921.0 6296903.0,1048217.0 6297561.0,1064350.0 6309506.0,1061225.0 6317546.0,1066133.0 6321494.0,1066468.0 6326676.0,1072800.0 6330433.0,1073742.0 6336784.0,1077560.0 6342698.0,1073403.0 6350462.0,1060282.0 6348576.0,1054180.0 6344806.0,1042408.0 6347558.0,1034654.0 6353189.0,1025044.0 6356596.0,1020000.0 6356725.0,1018585.0 6361599.0,1009696.0 6370071.0))",
            ],
            [
                "42",
                "LOIRE",
                "SRID=2154;POLYGON ((753779.0 6537018.0,758503.0 6532097.0,754369.0 6520637.0,760734.0 6514163.0,764154.0 6503988.0,770440.0 6500348.0,774454.0 6495613.0,776221.0 6483674.0,770335.0 6479388.0,770263.0 6473476.0,776677.0 6475557.0,780259.0 6472021.0,792166.0 6477709.0,802398.0 6475469.0,807029.0 6471772.0,806856.0 6463705.0,811227.0 6465007.0,816370.0 6460772.0,825694.0 6462649.0,826509.0 6469123.0,831517.0 6473257.0,837457.0 6475559.0,837308.0 6485557.0,834511.0 6489782.0,829797.0 6488843.0,825934.0 6498617.0,818524.0 6498224.0,809870.0 6504594.0,806255.0 6511913.0,808147.0 6518212.0,807296.0 6530310.0,802643.0 6534285.0,800220.0 6540120.0,801039.0 6547667.0,798995.0 6551156.0,802035.0 6559678.0,810991.0 6564128.0,806993.0 6569822.0,798969.0 6562707.0,797273.0 6565101.0,787355.0 6564848.0,785138.0 6567101.0,776287.0 6563809.0,774989.0 6567447.0,768620.0 6568680.0,769267.0 6575508.0,762003.0 6573092.0,760949.0 6561975.0,763504.0 6554575.0,762385.0 6549859.0,763887.0 6544360.0,761084.0 6541876.0,754888.0 6541809.0,753779.0 6537018.0))",
            ],
            [
                "31",
                "HAUTE-GARONNE",
                "SRID=2154;POLYGON ((505760.0 6248691.0,506455.0 6246240.0,501020.0 6240519.0,500952.0 6237523.0,491741.0 6229153.0,498958.0 6224762.0,501199.0 6216194.0,506394.0 6214104.0,501753.0 6199863.0,493715.0 6200925.0,492032.0 6195420.0,491362.0 6184305.0,493119.0 6181125.0,509918.0 6181609.0,507071.0 6189939.0,508439.0 6196068.0,512551.0 6198492.0,524704.0 6194181.0,522873.0 6204718.0,526458.0 6208824.0,535012.0 6210452.0,537386.0 6214080.0,535770.0 6220735.0,540236.0 6224348.0,541984.0 6228895.0,547328.0 6230443.0,554118.0 6225953.0,555809.0 6233248.0,562910.0 6233771.0,567825.0 6236309.0,561407.0 6244405.0,565565.0 6247682.0,572065.0 6240985.0,575081.0 6235814.0,582028.0 6242918.0,589272.0 6240503.0,593467.0 6242482.0,598408.0 6250205.0,603733.0 6249863.0,603060.0 6255463.0,607574.0 6261192.0,611672.0 6256714.0,621363.0 6260238.0,620519.0 6263967.0,609628.0 6269734.0,605052.0 6276459.0,594074.0 6282175.0,597601.0 6285124.0,595737.0 6291653.0,592076.0 6294561.0,590928.0 6301074.0,586632.0 6302842.0,583878.0 6308763.0,583992.0 6314318.0,575242.0 6309509.0,567948.0 6310839.0,568130.0 6303820.0,556606.0 6298479.0,550735.0 6304341.0,535303.0 6300840.0,545681.0 6284750.0,550482.0 6283435.0,554723.0 6278961.0,539594.0 6265818.0,536034.0 6253601.0,531230.0 6258583.0,523428.0 6259977.0,514960.0 6255730.0,509767.0 6249274.0,505760.0 6248691.0))",
            ],
            [
                "71",
                "SAONE-ET-LOIRE",
                "SRID=2154;POLYGON ((806993.0 6569822.0,808209.0 6578315.0,815826.0 6575242.0,824653.0 6575157.0,830305.0 6579430.0,833486.0 6565745.0,837322.0 6565642.0,839484.0 6574938.0,845050.0 6590960.0,845229.0 6595067.0,848718.0 6603737.0,857422.0 6600366.0,868758.0 6603264.0,869949.0 6598870.0,877344.0 6596683.0,885325.0 6599852.0,880824.0 6605207.0,886706.0 6618161.0,882575.0 6628163.0,880659.0 6638936.0,887343.0 6642371.0,876345.0 6647462.0,872158.0 6650880.0,871408.0 6655745.0,860161.0 6652754.0,855755.0 6655507.0,831500.0 6648015.0,823470.0 6650227.0,813434.0 6659755.0,806754.0 6662035.0,806631.0 6665548.0,795506.0 6668991.0,791663.0 6673495.0,789554.0 6672918.0,784602.0 6669828.0,780471.0 6669516.0,778810.0 6664936.0,781374.0 6662136.0,779000.0 6654397.0,778932.0 6646959.0,783308.0 6642195.0,780490.0 6638662.0,781064.0 6632682.0,775685.0 6631211.0,770503.0 6626941.0,760920.0 6622686.0,756196.0 6628301.0,748049.0 6627896.0,748734.0 6623209.0,753291.0 6618069.0,756931.0 6607772.0,761463.0 6602522.0,763922.0 6603795.0,768312.0 6598303.0,773476.0 6599308.0,776586.0 6596649.0,775079.0 6589273.0,775913.0 6580395.0,769267.0 6575508.0,768620.0 6568680.0,774989.0 6567447.0,776287.0 6563809.0,785138.0 6567101.0,787355.0 6564848.0,797273.0 6565101.0,798969.0 6562707.0,806993.0 6569822.0))",
            ],
            [
                "53",
                "MAYENNE",
                "SRID=2154;POLYGON ((399495.0 6830885.0,398130.0 6822559.0,400321.0 6810723.0,395852.0 6803336.0,398626.0 6784333.0,400465.0 6781914.0,400197.0 6773697.0,394099.0 6773357.0,390140.0 6770978.0,386941.0 6760260.0,382932.0 6754022.0,389872.0 6749698.0,393110.0 6750366.0,402067.0 6747685.0,404251.0 6751414.0,412442.0 6746090.0,419671.0 6744167.0,429458.0 6743442.0,440863.0 6746201.0,446732.0 6745443.0,446459.0 6750432.0,442128.0 6753611.0,448124.0 6758669.0,447308.0 6764356.0,455060.0 6767070.0,451057.0 6776681.0,459373.0 6778102.0,460615.0 6783387.0,458409.0 6789055.0,466280.0 6794064.0,465298.0 6799724.0,467628.0 6811401.0,473893.0 6813452.0,474394.0 6821359.0,467262.0 6822174.0,466087.0 6830999.0,463434.0 6833996.0,457920.0 6827997.0,451256.0 6826715.0,446687.0 6829012.0,441174.0 6828584.0,437568.0 6825109.0,429868.0 6822252.0,422197.0 6821752.0,414934.0 6829326.0,407934.0 6831360.0,404267.0 6828490.0,399495.0 6830885.0))",
            ],
            [
                "16",
                "CHARENTE",
                "SRID=2154;POLYGON ((459784.0 6545825.0,457303.0 6539406.0,458386.0 6534878.0,455132.0 6526680.0,449713.0 6524677.0,445866.0 6528260.0,434480.0 6521530.0,434607.0 6512022.0,436951.0 6506668.0,442913.0 6501478.0,446521.0 6493231.0,444696.0 6489309.0,445861.0 6484044.0,443202.0 6478722.0,447267.0 6474282.0,456356.0 6470307.0,455660.0 6465791.0,461242.0 6465553.0,464807.0 6459164.0,468806.0 6462928.0,474561.0 6460744.0,485798.0 6470195.0,484697.0 6477489.0,489646.0 6488189.0,493466.0 6488572.0,504657.0 6496986.0,505177.0 6505055.0,513233.0 6510903.0,515635.0 6515544.0,522412.0 6520738.0,522669.0 6525452.0,527825.0 6527023.0,534383.0 6537804.0,540666.0 6541823.0,539507.0 6547743.0,531290.0 6552122.0,531964.0 6561069.0,526089.0 6562344.0,521367.0 6557890.0,509938.0 6556936.0,507509.0 6562167.0,499249.0 6554736.0,489751.0 6554866.0,483517.0 6558927.0,473907.0 6559092.0,469589.0 6554692.0,465641.0 6555184.0,464645.0 6548283.0,459784.0 6545825.0))",
            ],
            [
                "50",
                "MANCHE",
                "SRID=2154;POLYGON ((417723.0 6857101.0,408651.0 6861319.0,399642.0 6861271.0,396867.0 6868913.0,401493.0 6871059.0,411444.0 6881401.0,417375.0 6892264.0,416434.0 6899162.0,413253.0 6901117.0,415797.0 6907383.0,406933.0 6907874.0,400663.0 6914651.0,399047.0 6920143.0,400759.0 6925144.0,397607.0 6926545.0,396597.0 6932989.0,388320.0 6946238.0,388687.0 6950091.0,394381.0 6955463.0,390587.0 6963240.0,381046.0 6965005.0,372051.0 6959988.0,362230.0 6961356.0,343652.0 6969661.0,343012.0 6963991.0,349037.0 6960923.0,349892.0 6952123.0,346450.0 6948841.0,350114.0 6938864.0,350193.0 6931900.0,357636.0 6924163.0,364780.0 6906370.0,363427.0 6896430.0,366480.0 6887586.0,365701.0 6878731.0,362959.0 6869214.0,363872.0 6859932.0,368562.0 6852485.0,376547.0 6847928.0,372261.0 6845150.0,363309.0 6845999.0,366767.0 6839135.0,368413.0 6830443.0,376536.0 6826525.0,384742.0 6834496.0,389634.0 6835155.0,399495.0 6830885.0,404267.0 6828490.0,407934.0 6831360.0,414934.0 6829326.0,421619.0 6835816.0,423498.0 6841841.0,420581.0 6852284.0,417723.0 6857101.0))",
            ],
            [
                "78",
                "YVELINES",
                "SRID=2154;POLYGON ((590236.0 6872273.0,594217.0 6866696.0,596554.0 6858123.0,595472.0 6845570.0,597086.0 6841311.0,604791.0 6831646.0,608912.0 6830618.0,611402.0 6819097.0,620311.0 6818025.0,623768.0 6826369.0,627504.0 6829048.0,627800.0 6838438.0,632440.0 6843248.0,634691.0 6849194.0,643163.0 6853168.0,637702.0 6857774.0,637864.0 6864035.0,641404.0 6867928.0,641836.0 6872490.0,633062.0 6879807.0,628641.0 6878089.0,622312.0 6880731.0,614076.0 6886919.0,606678.0 6883543.0,603102.0 6887292.0,598361.0 6887345.0,591984.0 6886421.0,587216.0 6881812.0,590236.0 6872273.0))",
            ],
            [
                "25",
                "DOUBS",
                "SRID=2154;POLYGON ((986155.0 6724947.0,984341.0 6721925.0,977033.0 6724531.0,974258.0 6721322.0,969354.0 6721610.0,967469.0 6716290.0,955890.0 6718838.0,950918.0 6717032.0,945847.0 6708437.0,932449.0 6699390.0,925719.0 6696195.0,922029.0 6697905.0,904021.0 6688452.0,905832.0 6683506.0,912920.0 6678099.0,913407.0 6674258.0,909981.0 6669146.0,913780.0 6661601.0,925599.0 6657600.0,925393.0 6653995.0,928880.0 6645788.0,940225.0 6640408.0,944367.0 6635241.0,942748.0 6631718.0,934547.0 6625608.0,937312.0 6621303.0,933274.0 6616467.0,940343.0 6611180.0,938167.0 6613167.0,950995.0 6626461.0,962319.0 6634781.0,961533.0 6640379.0,963711.0 6649123.0,961099.0 6653277.0,967437.0 6658254.0,976505.0 6662212.0,981857.0 6667617.0,983508.0 6674248.0,992174.0 6680929.0,993793.0 6685149.0,999048.0 6690006.0,1001635.0 6695987.0,1006570.0 6701646.0,1002944.0 6704539.0,995578.0 6702427.0,996902.0 6711079.0,994087.0 6717743.0,993651.0 6723596.0,986155.0 6724947.0))",
            ],
            [
                "55",
                "MEUSE",
                "SRID=2154;POLYGON ((904250.0 6825381.0,904895.0 6830283.0,900379.0 6832469.0,903561.0 6837915.0,902927.0 6847494.0,899528.0 6852809.0,904125.0 6862116.0,901302.0 6871865.0,905066.0 6875501.0,906433.0 6884047.0,905859.0 6891045.0,901739.0 6893315.0,900172.0 6898682.0,901547.0 6903348.0,898091.0 6905220.0,898652.0 6915853.0,895087.0 6927281.0,891117.0 6929633.0,883576.0 6926040.0,878534.0 6930925.0,879041.0 6935896.0,875512.0 6946935.0,873032.0 6949057.0,867310.0 6942452.0,856532.0 6942619.0,853210.0 6945817.0,849442.0 6935263.0,853548.0 6926776.0,847303.0 6917040.0,849280.0 6910207.0,842092.0 6905887.0,841416.0 6900107.0,845429.0 6892400.0,846791.0 6883540.0,848915.0 6882413.0,848655.0 6874905.0,841874.0 6870868.0,838677.0 6859119.0,846329.0 6850924.0,846365.0 6844539.0,847795.0 6838972.0,852692.0 6834838.0,856191.0 6834907.0,863008.0 6828766.0,873603.0 6822775.0,882722.0 6816263.0,893443.0 6818701.0,904250.0 6825381.0))",
            ],
            [
                "33",
                "GIRONDE",
                "SRID=2154;POLYGON ((486169.0 6410676.0,482141.0 6421330.0,476390.0 6418176.0,469504.0 6418931.0,461839.0 6422164.0,466012.0 6428425.0,464018.0 6432038.0,469719.0 6445475.0,467756.0 6450339.0,460931.0 6449393.0,457280.0 6451647.0,452009.0 6448234.0,444096.0 6451365.0,437492.0 6457585.0,433418.0 6457450.0,431214.0 6470295.0,421098.0 6472770.0,418478.0 6475494.0,406100.0 6476140.0,404682.0 6481482.0,399796.0 6489042.0,386164.0 6505245.0,380995.0 6504145.0,375328.0 6494206.0,373905.0 6475097.0,366594.0 6427323.0,365668.0 6410104.0,370987.0 6417061.0,380337.0 6407555.0,382533.0 6402380.0,376517.0 6401861.0,367865.0 6404553.0,364521.0 6395279.0,361697.0 6391399.0,361774.0 6383396.0,373686.0 6386677.0,375548.0 6389853.0,383562.0 6383958.0,381182.0 6379048.0,388231.0 6379327.0,393973.0 6376334.0,403228.0 6378937.0,411314.0 6378206.0,411174.0 6373203.0,418928.0 6369127.0,419635.0 6366255.0,426389.0 6364119.0,430077.0 6359927.0,429214.0 6351421.0,438523.0 6349285.0,442465.0 6350467.0,445091.0 6357381.0,449164.0 6352477.0,455164.0 6354504.0,457916.0 6359953.0,454032.0 6364649.0,462536.0 6370133.0,460366.0 6373402.0,460343.0 6383021.0,464993.0 6388179.0,474218.0 6394851.0,476701.0 6399758.0,472909.0 6402270.0,474628.0 6407547.0,486169.0 6410676.0))",
            ],
            [
                "14",
                "CALVADOS",
                "SRID=2154;POLYGON ((503908.0 6928958.0,498291.0 6928808.0,490213.0 6925480.0,480923.0 6917694.0,474554.0 6915313.0,465316.0 6913926.0,451821.0 6920480.0,444571.0 6921849.0,429556.0 6922759.0,420281.0 6924935.0,414059.0 6928862.0,403953.0 6928646.0,400759.0 6925144.0,399047.0 6920143.0,400663.0 6914651.0,406933.0 6907874.0,415797.0 6907383.0,413253.0 6901117.0,416434.0 6899162.0,417375.0 6892264.0,411444.0 6881401.0,401493.0 6871059.0,396867.0 6868913.0,399642.0 6861271.0,408651.0 6861319.0,417723.0 6857101.0,427244.0 6861949.0,446005.0 6869054.0,449827.0 6868751.0,454384.0 6863198.0,457511.0 6867107.0,469104.0 6863978.0,475607.0 6865852.0,484257.0 6870962.0,489675.0 6876299.0,491678.0 6873174.0,500558.0 6877307.0,504730.0 6874732.0,510545.0 6875400.0,512505.0 6881741.0,508338.0 6886469.0,512079.0 6895331.0,509950.0 6897618.0,509502.0 6910309.0,505278.0 6914121.0,503908.0 6928958.0))",
            ],
            [
                "88",
                "VOSGES",
                "SRID=2154;POLYGON ((915394.0 6762341.0,919858.0 6768473.0,924039.0 6766004.0,929025.0 6772821.0,935284.0 6772098.0,936416.0 6766072.0,941726.0 6764118.0,951150.0 6767749.0,956126.0 6765947.0,959909.0 6759629.0,964569.0 6761737.0,968808.0 6766577.0,972278.0 6762245.0,982963.0 6756697.0,986052.0 6752778.0,987691.0 6753958.0,993060.0 6757264.0,991355.0 6761730.0,993983.0 6773739.0,998205.0 6776671.0,1001795.0 6789636.0,1006708.0 6801985.0,1011125.0 6809400.0,1005338.0 6811635.0,1003109.0 6819572.0,1004385.0 6831654.0,994239.0 6827289.0,987769.0 6820181.0,982282.0 6817771.0,973656.0 6818945.0,964951.0 6823820.0,963830.0 6819154.0,935203.0 6815546.0,930831.0 6810526.0,919362.0 6809623.0,910921.0 6826770.0,904250.0 6825381.0,893443.0 6818701.0,882722.0 6816263.0,878315.0 6811920.0,883843.0 6809100.0,896020.0 6796835.0,901295.0 6794520.0,899609.0 6786135.0,895837.0 6779219.0,900794.0 6778635.0,906998.0 6773750.0,908017.0 6765028.0,912655.0 6766332.0,915394.0 6762341.0))",
            ],
            [
                "18",
                "CHER",
                "SRID=2154;POLYGON ((642856.0 6724786.0,634456.0 6720842.0,639501.0 6716775.0,642622.0 6708275.0,632231.0 6698879.0,634922.0 6687596.0,624165.0 6685496.0,619951.0 6688294.0,617060.0 6680060.0,612147.0 6680536.0,612309.0 6675948.0,607114.0 6670785.0,615265.0 6667454.0,621646.0 6669974.0,627833.0 6667741.0,627981.0 6660408.0,631131.0 6657674.0,629301.0 6648616.0,633457.0 6642556.0,627496.0 6637025.0,632500.0 6630848.0,628673.0 6627353.0,634340.0 6622075.0,637665.0 6611745.0,635550.0 6606712.0,638969.0 6598575.0,634893.0 6595681.0,636090.0 6591904.0,644784.0 6591412.0,645179.0 6595086.0,650317.0 6601560.0,660370.0 6603761.0,664479.0 6602292.0,670500.0 6605989.0,669145.0 6615318.0,677474.0 6626628.0,682775.0 6624336.0,686837.0 6626145.0,696943.0 6633749.0,702446.0 6632753.0,705186.0 6641947.0,703828.0 6645606.0,706033.0 6650549.0,705753.0 6657660.0,701762.0 6662486.0,702129.0 6669867.0,698614.0 6680189.0,698745.0 6684384.0,690449.0 6694237.0,694642.0 6704915.0,690565.0 6713347.0,685430.0 6710473.0,682544.0 6713710.0,678869.0 6710238.0,674282.0 6709782.0,669909.0 6717111.0,661757.0 6718781.0,657729.0 6723417.0,652875.0 6720759.0,646396.0 6725640.0,642856.0 6724786.0))",
            ],
            [
                "07",
                "ARDECHE",
                "SRID=2154;POLYGON ((779411.0 6373918.0,785084.0 6367917.0,783861.0 6358147.0,791158.0 6357807.0,800494.0 6352553.0,802764.0 6358131.0,806518.0 6360956.0,819866.0 6361270.0,824346.0 6357163.0,831641.0 6353746.0,831614.0 6360351.0,832713.0 6371581.0,835151.0 6374038.0,834538.0 6384016.0,835764.0 6388411.0,841041.0 6396655.0,839715.0 6410394.0,844069.0 6414766.0,848816.0 6428161.0,844782.0 6435636.0,842390.0 6453321.0,841110.0 6468164.0,837457.0 6475559.0,831517.0 6473257.0,826509.0 6469123.0,825694.0 6462649.0,816370.0 6460772.0,813436.0 6450097.0,808187.0 6450395.0,808165.0 6446004.0,801638.0 6433950.0,796332.0 6429870.0,791307.0 6420019.0,782106.0 6419872.0,781273.0 6415520.0,774103.0 6411136.0,768276.0 6405343.0,771844.0 6388592.0,775042.0 6386528.0,779411.0 6373918.0))",
            ],
            [
                "02",
                "AISNE",
                "SRID=2154;POLYGON ((776081.0 6923412.0,775403.0 6934852.0,777906.0 6941851.0,774574.0 6946610.0,779463.0 6948255.0,781387.0 6953785.0,790134.0 6962730.0,787172.0 6965431.0,789845.0 6973793.0,788558.0 6985051.0,781905.0 6987282.0,778060.0 6986162.0,770359.0 6988977.0,766237.0 6992385.0,753505.0 6995276.0,751253.0 6997000.0,744014.0 6992056.0,739058.0 6995179.0,735248.0 6991264.0,725313.0 6993104.0,720100.0 6990781.0,716534.0 6992565.0,712391.0 6990404.0,713833.0 6986563.0,708480.0 6979518.0,705667.0 6969289.0,708546.0 6956332.0,707064.0 6950845.0,709520.0 6938240.0,706939.0 6934901.0,711648.0 6928031.0,706805.0 6926038.0,706929.0 6919738.0,698137.0 6911415.0,701957.0 6908433.0,704672.0 6899225.0,710189.0 6894765.0,705248.0 6890863.0,712067.0 6888882.0,712559.0 6879371.0,722321.0 6872132.0,724211.0 6867685.0,729581.0 6862815.0,735603.0 6861428.0,738742.0 6868146.0,744067.0 6871735.0,747254.0 6882494.0,743801.0 6891376.0,745398.0 6894771.0,751361.0 6898188.0,747051.0 6913033.0,761575.0 6918670.0,767112.0 6923360.0,775242.0 6918312.0,776081.0 6923412.0))",
            ],
            [
                "64",
                "PYRENEES-ATLANTIQUES",
                "SRID=2154;POLYGON ((334283.0 6280551.0,327832.0 6270658.0,324268.0 6267623.0,314107.0 6264613.0,316186.0 6255555.0,321493.0 6257288.0,325696.0 6250142.0,329513.0 6253905.0,334359.0 6254169.0,344050.0 6249226.0,343580.0 6242296.0,340751.0 6235590.0,335750.0 6230517.0,338499.0 6226346.0,344947.0 6224142.0,346289.0 6231519.0,352412.0 6225527.0,355170.0 6226484.0,373097.0 6218255.0,377794.0 6214129.0,388910.0 6213290.0,393755.0 6214784.0,395170.0 6206882.0,409841.0 6194695.0,412796.0 6198151.0,418372.0 6194685.0,422245.0 6194862.0,428954.0 6200122.0,428150.0 6207547.0,431947.0 6209367.0,431385.0 6215423.0,437107.0 6220297.0,440142.0 6228799.0,443868.0 6230545.0,446410.0 6236240.0,454979.0 6245934.0,452746.0 6249402.0,457777.0 6262698.0,451477.0 6264635.0,454138.0 6272903.0,449863.0 6280833.0,443497.0 6282643.0,438084.0 6281592.0,433057.0 6279053.0,424830.0 6280287.0,421554.0 6283529.0,412501.0 6278002.0,403447.0 6281078.0,399714.0 6278404.0,394475.0 6281218.0,385124.0 6280151.0,377063.0 6275535.0,367753.0 6276986.0,362964.0 6280741.0,352961.0 6276001.0,342731.0 6276517.0,338238.0 6281381.0,334283.0 6280551.0))",
            ],
            [
                "41",
                "LOIR-ET-CHER",
                "SRID=2154;POLYGON ((642856.0 6724786.0,640167.0 6731164.0,620646.0 6731114.0,613256.0 6732409.0,609792.0 6727136.0,605429.0 6729771.0,602374.0 6738361.0,591237.0 6742041.0,590280.0 6747700.0,594464.0 6753836.0,589886.0 6759775.0,589601.0 6765689.0,573758.0 6762848.0,566408.0 6764638.0,559999.0 6772636.0,559439.0 6777275.0,551727.0 6777731.0,551017.0 6782681.0,539332.0 6780273.0,535875.0 6773086.0,539183.0 6762306.0,532634.0 6757689.0,533549.0 6751156.0,528757.0 6745774.0,518605.0 6737439.0,521086.0 6735350.0,530153.0 6735215.0,539386.0 6732046.0,543743.0 6727862.0,552256.0 6724799.0,555366.0 6719856.0,552945.0 6716389.0,559271.0 6706788.0,557303.0 6702930.0,558309.0 6696538.0,557051.0 6690388.0,561058.0 6687382.0,565759.0 6689706.0,569696.0 6685244.0,573297.0 6677558.0,582631.0 6683116.0,593597.0 6687211.0,602149.0 6685865.0,612147.0 6680536.0,617060.0 6680060.0,619951.0 6688294.0,624165.0 6685496.0,634922.0 6687596.0,632231.0 6698879.0,642622.0 6708275.0,639501.0 6716775.0,634456.0 6720842.0,642856.0 6724786.0))",
            ],
            [
                "57",
                "MOSELLE",
                "SRID=2154;POLYGON ((1001023.0 6834020.0,1007603.0 6833382.0,1013753.0 6840510.0,1015426.0 6846104.0,1012123.0 6851875.0,1016765.0 6860562.0,1004387.0 6868517.0,1002983.0 6863593.0,997609.0 6864713.0,996607.0 6871102.0,990508.0 6874464.0,991999.0 6880708.0,996400.0 6888804.0,1000174.0 6890502.0,1005257.0 6886565.0,1014136.0 6883372.0,1016790.0 6880171.0,1025429.0 6883147.0,1032318.0 6879884.0,1035096.0 6882767.0,1038624.0 6893752.0,1031356.0 6897552.0,1023578.0 6906994.0,1018182.0 6905695.0,1013674.0 6899390.0,1009903.0 6900358.0,996736.0 6898172.0,992282.0 6906134.0,986611.0 6909639.0,979390.0 6908077.0,979652.0 6901424.0,972590.0 6902443.0,968604.0 6909024.0,966935.0 6915200.0,959086.0 6922273.0,960438.0 6926520.0,957718.0 6930675.0,948608.0 6936180.0,945901.0 6934734.0,938917.0 6936180.0,935871.0 6939385.0,928691.0 6938466.0,926408.0 6934964.0,916749.0 6932316.0,915342.0 6936492.0,909643.0 6936903.0,913390.0 6932141.0,912688.0 6923499.0,920628.0 6907653.0,917676.0 6905219.0,920671.0 6900380.0,914011.0 6893894.0,914442.0 6889764.0,922708.0 6883240.0,922735.0 6879575.0,928151.0 6878713.0,929417.0 6875078.0,939656.0 6875317.0,945024.0 6864515.0,946451.0 6858744.0,961206.0 6856322.0,964692.0 6852206.0,969100.0 6851558.0,971773.0 6847764.0,976380.0 6847597.0,983189.0 6843093.0,993487.0 6842033.0,1001023.0 6834020.0))",
            ],
            [
                "86",
                "VIENNE",
                "SRID=2154;POLYGON ((483517.0 6558927.0,489751.0 6554866.0,499249.0 6554736.0,507509.0 6562167.0,509938.0 6556936.0,521367.0 6557890.0,526089.0 6562344.0,531964.0 6561069.0,530127.0 6570272.0,538896.0 6578287.0,546474.0 6577615.0,548271.0 6584464.0,556218.0 6586207.0,559931.0 6588729.0,562773.0 6594026.0,558128.0 6596023.0,557842.0 6602380.0,547958.0 6609437.0,542426.0 6611026.0,538906.0 6616112.0,541431.0 6623495.0,537221.0 6629765.0,533123.0 6635020.0,531658.0 6641492.0,525272.0 6647330.0,524608.0 6655240.0,515158.0 6658631.0,517389.0 6653506.0,510389.0 6653999.0,505157.0 6650870.0,494833.0 6656131.0,494947.0 6665028.0,485608.0 6667284.0,482922.0 6672972.0,478404.0 6673399.0,476861.0 6677880.0,471947.0 6677374.0,469141.0 6670338.0,464624.0 6667352.0,465537.0 6662685.0,471018.0 6649618.0,469757.0 6639127.0,470952.0 6628365.0,467588.0 6622657.0,472374.0 6614809.0,467690.0 6607234.0,468300.0 6594579.0,472081.0 6590232.0,472141.0 6584899.0,475179.0 6582497.0,479925.0 6587264.0,482897.0 6584792.0,478920.0 6578170.0,477460.0 6571967.0,480502.0 6565882.0,485043.0 6563684.0,483517.0 6558927.0))",
            ],
            [
                "24",
                "DORDOGNE",
                "SRID=2154;POLYGON ((515635.0 6515544.0,513233.0 6510903.0,505177.0 6505055.0,504657.0 6496986.0,493466.0 6488572.0,489646.0 6488189.0,484697.0 6477489.0,485798.0 6470195.0,474561.0 6460744.0,468806.0 6462928.0,464807.0 6459164.0,460931.0 6449393.0,467756.0 6450339.0,469719.0 6445475.0,464018.0 6432038.0,466012.0 6428425.0,461839.0 6422164.0,469504.0 6418931.0,476390.0 6418176.0,482141.0 6421330.0,486169.0 6410676.0,489091.0 6407815.0,491196.0 6399384.0,495031.0 6397493.0,512334.0 6403639.0,514373.0 6400391.0,527849.0 6401566.0,526858.0 6394383.0,530971.0 6390971.0,539761.0 6395885.0,547193.0 6388334.0,553597.0 6395079.0,553113.0 6398528.0,559319.0 6399932.0,564402.0 6403210.0,570668.0 6413830.0,570522.0 6417080.0,576964.0 6421036.0,574976.0 6434607.0,577774.0 6436765.0,573095.0 6446142.0,566113.0 6450433.0,564865.0 6461779.0,560988.0 6465186.0,568750.0 6477311.0,563844.0 6479160.0,563452.0 6484264.0,553144.0 6489340.0,546900.0 6501981.0,539039.0 6503445.0,529342.0 6499739.0,524801.0 6504583.0,526849.0 6509996.0,515635.0 6515544.0))",
            ],
            [
                "39",
                "JURA",
                "SRID=2154;POLYGON ((877344.0 6596683.0,877221.0 6593352.0,882664.0 6589574.0,882486.0 6586333.0,887558.0 6582363.0,890444.0 6576892.0,895736.0 6577631.0,903737.0 6585593.0,908880.0 6582354.0,909869.0 6577050.0,919460.0 6577537.0,923919.0 6580132.0,929573.0 6589336.0,935280.0 6595262.0,935835.0 6600587.0,941800.0 6609883.0,940343.0 6611180.0,933274.0 6616467.0,937312.0 6621303.0,934547.0 6625608.0,942748.0 6631718.0,944367.0 6635241.0,940225.0 6640408.0,928880.0 6645788.0,925393.0 6653995.0,925599.0 6657600.0,913780.0 6661601.0,909981.0 6669146.0,913407.0 6674258.0,912920.0 6678099.0,905832.0 6683506.0,904021.0 6688452.0,896736.0 6687711.0,890265.0 6692353.0,888032.0 6690633.0,887407.0 6682465.0,884880.0 6674426.0,881002.0 6667371.0,876191.0 6666228.0,875449.0 6660099.0,871408.0 6655745.0,872158.0 6650880.0,876345.0 6647462.0,887343.0 6642371.0,880659.0 6638936.0,882575.0 6628163.0,886706.0 6618161.0,880824.0 6605207.0,885325.0 6599852.0,877344.0 6596683.0))",
            ],
            [
                "82",
                "TARN-ET-GARONNE",
                "SRID=2154;POLYGON ((610874.0 6360746.0,596271.0 6358053.0,592401.0 6355117.0,585843.0 6356520.0,581893.0 6352690.0,570617.0 6348643.0,562737.0 6350024.0,549131.0 6360516.0,545774.0 6366277.0,544593.0 6364542.0,531660.0 6365290.0,530427.0 6360537.0,536387.0 6355171.0,533815.0 6350996.0,529462.0 6338671.0,520115.0 6336256.0,519117.0 6332164.0,521740.0 6328834.0,528536.0 6329188.0,520187.0 6318466.0,528381.0 6316132.0,531142.0 6309545.0,531445.0 6300603.0,535303.0 6300840.0,550735.0 6304341.0,556606.0 6298479.0,568130.0 6303820.0,567948.0 6310839.0,575242.0 6309509.0,583992.0 6314318.0,583816.0 6319290.0,589156.0 6320414.0,595091.0 6325907.0,592665.0 6336179.0,599594.0 6336049.0,602120.0 6333848.0,607335.0 6338978.0,613603.0 6341028.0,619220.0 6339455.0,618185.0 6342854.0,612268.0 6345645.0,617826.0 6353582.0,612319.0 6353954.0,610874.0 6360746.0))",
            ],
            [
                "49",
                "MAINE-ET-LOIRE",
                "SRID=2154;POLYGON ((404251.0 6660135.0,413368.0 6662854.0,417889.0 6660618.0,424993.0 6661094.0,429262.0 6663802.0,429925.0 6668493.0,434893.0 6670550.0,442005.0 6668948.0,454238.0 6672319.0,458546.0 6672434.0,464624.0 6667352.0,469141.0 6670338.0,471947.0 6677374.0,476861.0 6677880.0,479254.0 6691029.0,487846.0 6706491.0,490772.0 6714971.0,489539.0 6719725.0,491931.0 6726763.0,485937.0 6723990.0,478533.0 6727039.0,474490.0 6731769.0,469484.0 6733109.0,464631.0 6730466.0,460339.0 6732350.0,457617.0 6739093.0,450112.0 6740918.0,446732.0 6745443.0,440863.0 6746201.0,429458.0 6743442.0,419671.0 6744167.0,412442.0 6746090.0,404251.0 6751414.0,402067.0 6747685.0,393110.0 6750366.0,389872.0 6749698.0,382932.0 6754022.0,382163.0 6750361.0,381255.0 6745617.0,386987.0 6740963.0,389301.0 6732485.0,398982.0 6728603.0,395905.0 6725901.0,386462.0 6727467.0,387234.0 6720426.0,401401.0 6717774.0,402393.0 6705897.0,396890.0 6703794.0,385609.0 6704471.0,375470.0 6701871.0,374867.0 6698071.0,378391.0 6691949.0,382659.0 6691801.0,384839.0 6683588.0,379159.0 6679552.0,379298.0 6676338.0,387784.0 6670618.0,385082.0 6667087.0,392012.0 6664073.0,401283.0 6663962.0,404251.0 6660135.0))",
            ],
            [
                "69",
                "RHONE",
                "SRID=2154;POLYGON ((863140.0 6525920.0,849404.0 6524528.0,844536.0 6535588.0,833933.0 6540287.0,835850.0 6543054.0,834501.0 6551198.0,835220.0 6556428.0,838741.0 6561678.0,837322.0 6565642.0,833486.0 6565745.0,830305.0 6579430.0,824653.0 6575157.0,815826.0 6575242.0,808209.0 6578315.0,806993.0 6569822.0,810991.0 6564128.0,802035.0 6559678.0,798995.0 6551156.0,801039.0 6547667.0,800220.0 6540120.0,802643.0 6534285.0,807296.0 6530310.0,808147.0 6518212.0,806255.0 6511913.0,809870.0 6504594.0,818524.0 6498224.0,825934.0 6498617.0,829797.0 6488843.0,834511.0 6489782.0,837308.0 6485557.0,845846.0 6493277.0,841056.0 6498593.0,848198.0 6502534.0,858527.0 6506228.0,865784.0 6514252.0,862850.0 6517700.0,863140.0 6525920.0))",
            ],
            [
                "27",
                "EURE",
                "SRID=2154;POLYGON ((606642.0 6924066.0,602657.0 6922993.0,596650.0 6927678.0,584841.0 6929723.0,579971.0 6928884.0,574422.0 6917678.0,566281.0 6917384.0,564288.0 6913853.0,558013.0 6912674.0,555352.0 6907664.0,548914.0 6917432.0,548813.0 6922655.0,537794.0 6926754.0,530512.0 6925008.0,524567.0 6928708.0,520591.0 6933755.0,506978.0 6930086.0,503908.0 6928958.0,505278.0 6914121.0,509502.0 6910309.0,509950.0 6897618.0,512079.0 6895331.0,508338.0 6886469.0,512505.0 6881741.0,510545.0 6875400.0,508448.0 6870995.0,513552.0 6867418.0,520512.0 6866728.0,524600.0 6861683.0,533488.0 6856087.0,536389.0 6850906.0,533024.0 6847407.0,539112.0 6843338.0,543803.0 6848251.0,555241.0 6849633.0,566604.0 6854037.0,576482.0 6852521.0,580772.0 6855857.0,579784.0 6860594.0,587701.0 6866890.0,590236.0 6872273.0,587216.0 6881812.0,591984.0 6886421.0,598361.0 6887345.0,601892.0 6893098.0,603501.0 6902160.0,605624.0 6904387.0,606128.0 6907968.0,610931.0 6911811.0,609871.0 6919444.0,606642.0 6924066.0))",
            ],
            [
                "12",
                "AVEYRON",
                "SRID=2154;POLYGON ((619220.0 6339455.0,628552.0 6344336.0,632260.0 6344664.0,651092.0 6332910.0,652742.0 6328715.0,656723.0 6328192.0,661724.0 6320369.0,659810.0 6316970.0,664259.0 6313698.0,664946.0 6304799.0,674324.0 6293934.0,679276.0 6292258.0,684993.0 6295873.0,693643.0 6293013.0,694796.0 6288406.0,698819.0 6289943.0,704898.0 6288229.0,704815.0 6303628.0,716344.0 6301672.0,722102.0 6311077.0,728786.0 6312824.0,736140.0 6324746.0,726344.0 6331169.0,726879.0 6340020.0,729879.0 6341376.0,728598.0 6344387.0,718362.0 6347498.0,709994.0 6353946.0,712305.0 6356606.0,709537.0 6364934.0,710800.0 6372878.0,705449.0 6378272.0,706639.0 6384441.0,698547.0 6393953.0,693924.0 6403282.0,694820.0 6408897.0,690477.0 6411547.0,688126.0 6419157.0,684359.0 6419403.0,679353.0 6426925.0,676829.0 6423158.0,668604.0 6416079.0,668313.0 6410487.0,665404.0 6408608.0,664849.0 6402561.0,655192.0 6393469.0,646639.0 6396959.0,637228.0 6394175.0,637122.0 6391031.0,632813.0 6386229.0,625170.0 6387538.0,615061.0 6379167.0,607709.0 6375883.0,610874.0 6360746.0,612319.0 6353954.0,617826.0 6353582.0,612268.0 6345645.0,618185.0 6342854.0,619220.0 6339455.0))",
            ],
            [
                "23",
                "CREUSE",
                "SRID=2154;POLYGON ((636090.0 6591904.0,630016.0 6590287.0,622684.0 6592821.0,609355.0 6592908.0,602234.0 6588456.0,595863.0 6588324.0,586530.0 6592902.0,578129.0 6584256.0,580236.0 6579624.0,574730.0 6569689.0,580656.0 6565605.0,587795.0 6549437.0,586335.0 6540289.0,592200.0 6538029.0,591561.0 6529605.0,597279.0 6527024.0,604752.0 6527760.0,613074.0 6522626.0,612524.0 6515422.0,614305.0 6511565.0,623634.0 6517796.0,631053.0 6514297.0,635791.0 6515072.0,637278.0 6511373.0,648450.0 6509221.0,649366.0 6512420.0,656101.0 6511235.0,660507.0 6515469.0,656022.0 6519074.0,652489.0 6525488.0,656753.0 6529414.0,660605.0 6529501.0,668605.0 6543382.0,665172.0 6557241.0,666451.0 6560450.0,662729.0 6571178.0,659880.0 6575828.0,653217.0 6581299.0,647921.0 6581264.0,644784.0 6591412.0,636090.0 6591904.0))",
            ],
            [
                "45",
                "LOIRET",
                "SRID=2154;POLYGON ((695265.0 6784783.0,685053.0 6785343.0,678166.0 6780535.0,665644.0 6782354.0,663338.0 6793247.0,657236.0 6795707.0,655721.0 6802434.0,653275.0 6801114.0,639308.0 6801806.0,625387.0 6798948.0,623220.0 6795517.0,615539.0 6776549.0,606511.0 6774717.0,597558.0 6774986.0,595216.0 6770968.0,589165.0 6770859.0,589601.0 6765689.0,589886.0 6759775.0,594464.0 6753836.0,590280.0 6747700.0,591237.0 6742041.0,602374.0 6738361.0,605429.0 6729771.0,609792.0 6727136.0,613256.0 6732409.0,620646.0 6731114.0,640167.0 6731164.0,642856.0 6724786.0,646396.0 6725640.0,652875.0 6720759.0,657729.0 6723417.0,661757.0 6718781.0,669909.0 6717111.0,674282.0 6709782.0,678869.0 6710238.0,682544.0 6713710.0,685430.0 6710473.0,690565.0 6713347.0,693556.0 6718403.0,698236.0 6718784.0,695341.0 6722058.0,694231.0 6731133.0,689391.0 6734632.0,689262.0 6740069.0,695135.0 6740319.0,701782.0 6742907.0,700769.0 6756036.0,703743.0 6756785.0,709585.0 6763406.0,706580.0 6772621.0,703759.0 6774663.0,702192.0 6781427.0,695265.0 6784783.0))",
            ],
            [
                "70",
                "HAUTE-SAONE",
                "SRID=2154;POLYGON ((986052.0 6752778.0,982963.0 6756697.0,972278.0 6762245.0,968808.0 6766577.0,964569.0 6761737.0,959909.0 6759629.0,956126.0 6765947.0,951150.0 6767749.0,941726.0 6764118.0,936416.0 6766072.0,935284.0 6772098.0,929025.0 6772821.0,924039.0 6766004.0,919858.0 6768473.0,915394.0 6762341.0,910900.0 6755744.0,906433.0 6754603.0,901288.0 6749897.0,900414.0 6745482.0,902985.0 6741752.0,901778.0 6735043.0,894824.0 6733348.0,886220.0 6734507.0,880542.0 6733086.0,878352.0 6725366.0,882147.0 6728546.0,886108.0 6726069.0,887785.0 6718944.0,884206.0 6713509.0,880595.0 6713705.0,884919.0 6701062.0,890265.0 6692353.0,896736.0 6687711.0,904021.0 6688452.0,922029.0 6697905.0,925719.0 6696195.0,932449.0 6699390.0,945847.0 6708437.0,950918.0 6717032.0,955890.0 6718838.0,967469.0 6716290.0,969354.0 6721610.0,974258.0 6721322.0,977033.0 6724531.0,984341.0 6721925.0,986155.0 6724947.0,983826.0 6731782.0,981470.0 6745308.0,986052.0 6752778.0))",
            ],
            [
                "63",
                "PUY-DE-DOME",
                "SRID=2154;POLYGON ((753779.0 6537018.0,745523.0 6547324.0,735860.0 6546571.0,732386.0 6552810.0,728730.0 6550656.0,712873.0 6551781.0,697819.0 6557998.0,693029.0 6567076.0,695157.0 6571452.0,688886.0 6572856.0,685369.0 6566281.0,679424.0 6569309.0,672252.0 6557694.0,666451.0 6560450.0,665172.0 6557241.0,668605.0 6543382.0,660605.0 6529501.0,656753.0 6529414.0,652489.0 6525488.0,656022.0 6519074.0,660507.0 6515469.0,663288.0 6509261.0,662164.0 6504560.0,658322.0 6500286.0,662264.0 6494997.0,661594.0 6486680.0,672750.0 6482640.0,677684.0 6475835.0,688449.0 6477003.0,693859.0 6474045.0,695974.0 6467752.0,701310.0 6465307.0,708104.0 6472781.0,713160.0 6472555.0,722742.0 6478087.0,735734.0 6477978.0,739202.0 6481030.0,749018.0 6471190.0,752222.0 6475420.0,760473.0 6472496.0,763248.0 6477235.0,770263.0 6473476.0,770335.0 6479388.0,776221.0 6483674.0,774454.0 6495613.0,770440.0 6500348.0,764154.0 6503988.0,760734.0 6514163.0,754369.0 6520637.0,758503.0 6532097.0,753779.0 6537018.0))",
            ],
            [
                "81",
                "TARN",
                "SRID=2154;POLYGON ((583992.0 6314318.0,583878.0 6308763.0,586632.0 6302842.0,590928.0 6301074.0,592076.0 6294561.0,595737.0 6291653.0,597601.0 6285124.0,594074.0 6282175.0,605052.0 6276459.0,609628.0 6269734.0,620519.0 6263967.0,621363.0 6260238.0,624846.0 6255615.0,637154.0 6259493.0,640013.0 6262596.0,651680.0 6257911.0,654081.0 6259728.0,664821.0 6258302.0,668090.0 6259189.0,672444.0 6264623.0,672394.0 6269695.0,668935.0 6274250.0,671212.0 6283521.0,676690.0 6282993.0,680178.0 6279485.0,693221.0 6284557.0,694796.0 6288406.0,693643.0 6293013.0,684993.0 6295873.0,679276.0 6292258.0,674324.0 6293934.0,664946.0 6304799.0,664259.0 6313698.0,659810.0 6316970.0,661724.0 6320369.0,656723.0 6328192.0,652742.0 6328715.0,651092.0 6332910.0,632260.0 6344664.0,628552.0 6344336.0,619220.0 6339455.0,613603.0 6341028.0,607335.0 6338978.0,602120.0 6333848.0,599594.0 6336049.0,592665.0 6336179.0,595091.0 6325907.0,589156.0 6320414.0,583816.0 6319290.0,583992.0 6314318.0))",
            ],
            [
                "76",
                "SEINE-MARITIME",
                "SRID=2154;POLYGON ((612314.0 6962826.0,608347.0 6970745.0,605014.0 6980736.0,589321.0 6994349.0,583880.0 6997485.0,570354.0 6986979.0,561015.0 6982476.0,553619.0 6982021.0,539569.0 6977082.0,525341.0 6975010.0,506777.0 6963564.0,498821.0 6960824.0,494437.0 6953650.0,487453.0 6938754.0,491281.0 6933115.0,506978.0 6930086.0,520591.0 6933755.0,524567.0 6928708.0,530512.0 6925008.0,537794.0 6926754.0,548813.0 6922655.0,548914.0 6917432.0,555352.0 6907664.0,558013.0 6912674.0,564288.0 6913853.0,566281.0 6917384.0,574422.0 6917678.0,579971.0 6928884.0,584841.0 6929723.0,596650.0 6927678.0,602657.0 6922993.0,606642.0 6924066.0,610545.0 6930338.0,607205.0 6935073.0,609123.0 6937659.0,606321.0 6945902.0,607933.0 6953359.0,605401.0 6955866.0,612314.0 6962826.0))",
            ],
            [
                "52",
                "HAUTE-MARNE",
                "SRID=2154;POLYGON ((823302.0 6827043.0,822210.0 6820200.0,827022.0 6811887.0,834073.0 6806764.0,837935.0 6797546.0,837598.0 6783989.0,835407.0 6779651.0,828770.0 6781171.0,825768.0 6776095.0,827043.0 6770243.0,833398.0 6769005.0,833316.0 6764154.0,838226.0 6763382.0,846087.0 6753627.0,848388.0 6746302.0,846031.0 6742315.0,848455.0 6733791.0,858300.0 6729814.0,863148.0 6730266.0,868188.0 6726357.0,878352.0 6725366.0,880542.0 6733086.0,886220.0 6734507.0,894824.0 6733348.0,901778.0 6735043.0,902985.0 6741752.0,900414.0 6745482.0,901288.0 6749897.0,906433.0 6754603.0,910900.0 6755744.0,915394.0 6762341.0,912655.0 6766332.0,908017.0 6765028.0,906998.0 6773750.0,900794.0 6778635.0,895837.0 6779219.0,899609.0 6786135.0,901295.0 6794520.0,896020.0 6796835.0,883843.0 6809100.0,878315.0 6811920.0,882722.0 6816263.0,873603.0 6822775.0,863008.0 6828766.0,856191.0 6834907.0,852692.0 6834838.0,847795.0 6838972.0,846365.0 6844539.0,840675.0 6844876.0,835676.0 6840415.0,836281.0 6837534.0,830469.0 6833515.0,832829.0 6827018.0,823302.0 6827043.0))",
            ],
            [
                "30",
                "GARD",
                "SRID=2154;POLYGON ((831641.0 6353746.0,824346.0 6357163.0,819866.0 6361270.0,806518.0 6360956.0,802764.0 6358131.0,800494.0 6352553.0,791158.0 6357807.0,783861.0 6358147.0,785084.0 6367917.0,779411.0 6373918.0,775211.0 6367175.0,770571.0 6365836.0,775941.0 6359276.0,773621.0 6356674.0,775968.0 6350322.0,776174.0 6341769.0,768987.0 6337162.0,763780.0 6336809.0,754256.0 6342872.0,750995.0 6342037.0,750700.0 6336169.0,735189.0 6336775.0,729879.0 6341376.0,726879.0 6340020.0,726344.0 6331169.0,736140.0 6324746.0,728786.0 6312824.0,734096.0 6312602.0,742673.0 6306434.0,746263.0 6307559.0,750088.0 6313306.0,758340.0 6319159.0,763184.0 6318967.0,766255.0 6313712.0,766790.0 6307842.0,773726.0 6310049.0,780634.0 6301895.0,792244.0 6293431.0,796379.0 6284647.0,792922.0 6276955.0,788998.0 6273432.0,792112.0 6270978.0,792074.0 6265425.0,799607.0 6263119.0,800175.0 6267290.0,813903.0 6274579.0,815212.0 6281222.0,819908.0 6290041.0,828463.0 6288899.0,833168.0 6302217.0,831988.0 6308980.0,839658.0 6315433.0,847769.0 6322554.0,843231.0 6331183.0,836689.0 6335330.0,837656.0 6344658.0,831641.0 6353746.0))",
            ],
            [
                "67",
                "BAS-RHIN",
                "SRID=2154;POLYGON ((1011125.0 6809400.0,1016850.0 6809125.0,1022638.0 6802981.0,1032428.0 6798669.0,1032222.0 6793924.0,1036067.0 6790258.0,1040408.0 6789869.0,1046450.0 6801750.0,1048508.0 6811325.0,1051141.0 6812923.0,1050303.0 6822049.0,1052109.0 6831679.0,1054677.0 6834498.0,1054069.0 6843233.0,1056359.0 6848835.0,1064869.0 6858273.0,1065247.0 6862338.0,1074008.0 6868775.0,1077114.0 6879387.0,1081448.0 6887616.0,1072364.0 6888601.0,1060439.0 6895482.0,1055798.0 6892558.0,1050607.0 6895578.0,1045763.0 6893084.0,1038624.0 6893752.0,1035096.0 6882767.0,1032318.0 6879884.0,1025429.0 6883147.0,1016790.0 6880171.0,1014136.0 6883372.0,1005257.0 6886565.0,1000174.0 6890502.0,996400.0 6888804.0,991999.0 6880708.0,990508.0 6874464.0,996607.0 6871102.0,997609.0 6864713.0,1002983.0 6863593.0,1004387.0 6868517.0,1016765.0 6860562.0,1012123.0 6851875.0,1015426.0 6846104.0,1013753.0 6840510.0,1007603.0 6833382.0,1001023.0 6834020.0,1004385.0 6831654.0,1003109.0 6819572.0,1005338.0 6811635.0,1011125.0 6809400.0))",
            ],
            [
                "11",
                "AUDE",
                "SRID=2154;POLYGON ((719561.0 6234874.0,716336.0 6238907.0,711963.0 6238657.0,700385.0 6243263.0,700353.0 6246775.0,686427.0 6247043.0,681495.0 6239871.0,667653.0 6244475.0,662679.0 6249784.0,664821.0 6258302.0,654081.0 6259728.0,651680.0 6257911.0,640013.0 6262596.0,637154.0 6259493.0,624846.0 6255615.0,621363.0 6260238.0,611672.0 6256714.0,607574.0 6261192.0,603060.0 6255463.0,603733.0 6249863.0,598408.0 6250205.0,593467.0 6242482.0,596256.0 6236985.0,595072.0 6233132.0,604330.0 6228108.0,614442.0 6225039.0,613663.0 6217624.0,617210.0 6214637.0,617137.0 6197372.0,608402.0 6195450.0,610538.0 6185966.0,614361.0 6182470.0,622733.0 6184536.0,632373.0 6176261.0,631545.0 6174170.0,644388.0 6178927.0,647326.0 6181831.0,644930.0 6193342.0,655189.0 6193206.0,659825.0 6194610.0,675246.0 6192375.0,678721.0 6193157.0,682753.0 6199641.0,688989.0 6202113.0,693222.0 6198384.0,703560.0 6193187.0,704952.0 6201963.0,703499.0 6206754.0,709550.0 6222514.0,719561.0 6234874.0))",
            ],
            [
                "77",
                "SEINE-ET-MARNE",
                "SRID=2154;POLYGON ((695265.0 6784783.0,700383.0 6789702.0,703237.0 6796855.0,703668.0 6806647.0,712422.0 6807964.0,727042.0 6808060.0,730707.0 6810078.0,728998.0 6813854.0,731262.0 6826009.0,737148.0 6833964.0,740952.0 6835710.0,733915.0 6839303.0,735102.0 6844463.0,732040.0 6850473.0,735603.0 6861428.0,729581.0 6862815.0,724211.0 6867685.0,722321.0 6872132.0,712559.0 6879371.0,712067.0 6888882.0,705248.0 6890863.0,700622.0 6887964.0,680633.0 6884542.0,673222.0 6889902.0,670084.0 6886723.0,667303.0 6878971.0,670882.0 6870004.0,667928.0 6865519.0,670056.0 6856451.0,671600.0 6851283.0,668472.0 6843626.0,665649.0 6839786.0,666363.0 6833836.0,663045.0 6825117.0,663371.0 6815578.0,665496.0 6812431.0,657768.0 6807009.0,655721.0 6802434.0,657236.0 6795707.0,663338.0 6793247.0,665644.0 6782354.0,678166.0 6780535.0,685053.0 6785343.0,695265.0 6784783.0))",
            ],
            [
                "80",
                "SOMME",
                "SRID=2154;POLYGON ((706470.0 6995042.0,691147.0 6993758.0,689814.0 6997681.0,669642.0 7001764.0,667892.0 7004913.0,662547.0 7004433.0,658067.0 7000416.0,656343.0 7006536.0,663948.0 7010834.0,660837.0 7014835.0,654991.0 7012592.0,648121.0 7014552.0,635372.0 7012312.0,634147.0 7017146.0,624801.0 7021563.0,622831.0 7024302.0,612989.0 7030025.0,605232.0 7026713.0,603193.0 7029103.0,596733.0 7029014.0,595668.0 7021497.0,599348.0 7018454.0,591189.0 7008466.0,589294.0 7002423.0,583880.0 6997485.0,589321.0 6994349.0,605014.0 6980736.0,608347.0 6970745.0,612314.0 6962826.0,620154.0 6956108.0,623025.0 6958366.0,636565.0 6954687.0,645659.0 6956103.0,654712.0 6950974.0,664208.0 6949037.0,669006.0 6944292.0,676176.0 6942514.0,677528.0 6947426.0,685504.0 6946842.0,685089.0 6950779.0,693916.0 6955962.0,708546.0 6956332.0,705667.0 6969289.0,708480.0 6979518.0,713833.0 6986563.0,712391.0 6990404.0,706470.0 6995042.0))",
            ],
            [
                "43",
                "HAUTE-LOIRE",
                "SRID=2154;POLYGON ((708104.0 6472781.0,709251.0 6464988.0,717445.0 6463649.0,722648.0 6446835.0,725628.0 6444038.0,723408.0 6437470.0,727352.0 6435060.0,728488.0 6430309.0,732563.0 6427378.0,732994.0 6422485.0,737614.0 6413026.0,746579.0 6414955.0,746937.0 6419760.0,752090.0 6419191.0,752669.0 6414624.0,758530.0 6415778.0,768276.0 6405343.0,774103.0 6411136.0,781273.0 6415520.0,782106.0 6419872.0,791307.0 6420019.0,796332.0 6429870.0,801638.0 6433950.0,808165.0 6446004.0,808187.0 6450395.0,813436.0 6450097.0,816370.0 6460772.0,811227.0 6465007.0,806856.0 6463705.0,807029.0 6471772.0,802398.0 6475469.0,792166.0 6477709.0,780259.0 6472021.0,776677.0 6475557.0,770263.0 6473476.0,763248.0 6477235.0,760473.0 6472496.0,752222.0 6475420.0,749018.0 6471190.0,739202.0 6481030.0,735734.0 6477978.0,722742.0 6478087.0,713160.0 6472555.0,708104.0 6472781.0))",
            ],
            [
                "51",
                "MARNE",
                "SRID=2154;POLYGON ((776081.0 6923412.0,775242.0 6918312.0,767112.0 6923360.0,761575.0 6918670.0,747051.0 6913033.0,751361.0 6898188.0,745398.0 6894771.0,743801.0 6891376.0,747254.0 6882494.0,744067.0 6871735.0,738742.0 6868146.0,735603.0 6861428.0,732040.0 6850473.0,735102.0 6844463.0,733915.0 6839303.0,740952.0 6835710.0,746802.0 6826973.0,753955.0 6826609.0,760761.0 6824301.0,769985.0 6834113.0,773768.0 6840880.0,779497.0 6845091.0,785824.0 6845891.0,797551.0 6845278.0,796995.0 6835851.0,803526.0 6829924.0,814106.0 6826118.0,819107.0 6829393.0,823302.0 6827043.0,832829.0 6827018.0,830469.0 6833515.0,836281.0 6837534.0,835676.0 6840415.0,840675.0 6844876.0,846365.0 6844539.0,846329.0 6850924.0,838677.0 6859119.0,841874.0 6870868.0,848655.0 6874905.0,848915.0 6882413.0,846791.0 6883540.0,845429.0 6892400.0,841416.0 6900107.0,842092.0 6905887.0,837898.0 6908256.0,833062.0 6905548.0,822754.0 6907655.0,818364.0 6905215.0,814643.0 6911926.0,803525.0 6909934.0,795010.0 6915033.0,790665.0 6921022.0,782994.0 6923346.0,776081.0 6923412.0))",
            ],
            [
                "65",
                "HAUTES-PYRENEES",
                "SRID=2154;POLYGON ((428954.0 6200122.0,442286.0 6190571.0,445343.0 6185147.0,453012.0 6180794.0,468501.0 6186020.0,475317.0 6183479.0,477861.0 6178841.0,483521.0 6184043.0,489111.0 6180226.0,493119.0 6181125.0,491362.0 6184305.0,492032.0 6195420.0,493715.0 6200925.0,501753.0 6199863.0,506394.0 6214104.0,501199.0 6216194.0,498958.0 6224762.0,491741.0 6229153.0,500952.0 6237523.0,501020.0 6240519.0,506455.0 6246240.0,505760.0 6248691.0,496988.0 6250664.0,479309.0 6257879.0,471536.0 6256527.0,468215.0 6263513.0,466465.0 6272970.0,461941.0 6273297.0,457450.0 6278664.0,456497.0 6283051.0,449863.0 6280833.0,454138.0 6272903.0,451477.0 6264635.0,457777.0 6262698.0,452746.0 6249402.0,454979.0 6245934.0,446410.0 6236240.0,443868.0 6230545.0,440142.0 6228799.0,437107.0 6220297.0,431385.0 6215423.0,431947.0 6209367.0,428150.0 6207547.0,428954.0 6200122.0))",
            ],
            [
                "46",
                "LOT",
                "SRID=2154;POLYGON ((547193.0 6388334.0,542159.0 6383881.0,541673.0 6377661.0,545774.0 6366277.0,549131.0 6360516.0,562737.0 6350024.0,570617.0 6348643.0,581893.0 6352690.0,585843.0 6356520.0,592401.0 6355117.0,596271.0 6358053.0,610874.0 6360746.0,607709.0 6375883.0,615061.0 6379167.0,625170.0 6387538.0,632813.0 6386229.0,637122.0 6391031.0,634129.0 6393565.0,633003.0 6406356.0,634482.0 6410441.0,628463.0 6419614.0,626129.0 6431248.0,613933.0 6431618.0,607209.0 6426078.0,601475.0 6429196.0,593751.0 6437105.0,584718.0 6439628.0,577774.0 6436765.0,574976.0 6434607.0,576964.0 6421036.0,570522.0 6417080.0,570668.0 6413830.0,564402.0 6403210.0,559319.0 6399932.0,553113.0 6398528.0,553597.0 6395079.0,547193.0 6388334.0))",
            ],
            [
                "04",
                "ALPES-DE-HAUTE-PROVENCE",
                "SRID=2154;POLYGON ((992638.0 6305621.0,997097.0 6315251.0,1000978.0 6315262.0,1007566.0 6320724.0,1012050.0 6317690.0,1014122.0 6322114.0,1009068.0 6324850.0,1007601.0 6328762.0,1000089.0 6334256.0,1000668.0 6338218.0,994698.0 6348019.0,997268.0 6357103.0,1002665.0 6364730.0,1009696.0 6370071.0,1008626.0 6382943.0,1006125.0 6388590.0,1012175.0 6394096.0,1012913.0 6402904.0,1010207.0 6403290.0,1004568.0 6397351.0,999315.0 6394909.0,992592.0 6389297.0,988952.0 6378656.0,983401.0 6378221.0,971476.0 6380340.0,967103.0 6386021.0,957182.0 6379131.0,959705.0 6373500.0,957118.0 6369997.0,950982.0 6378672.0,944316.0 6377139.0,935206.0 6370624.0,932421.0 6356788.0,925339.0 6357350.0,930231.0 6349978.0,920148.0 6349530.0,913873.0 6347227.0,911050.0 6344481.0,905908.0 6346585.0,903520.0 6340766.0,899978.0 6338355.0,900470.0 6332559.0,903879.0 6328807.0,901642.0 6319541.0,909386.0 6316209.0,907367.0 6306820.0,913516.0 6306489.0,922160.0 6296144.0,923991.0 6299127.0,933734.0 6296912.0,944763.0 6293054.0,956283.0 6301072.0,958836.0 6305328.0,970413.0 6298787.0,974848.0 6301646.0,974774.0 6305117.0,983574.0 6307147.0,992638.0 6305621.0))",
            ],
            [
                "72",
                "SARTHE",
                "SRID=2154;POLYGON ((521086.0 6735350.0,518605.0 6737439.0,528757.0 6745774.0,533549.0 6751156.0,532634.0 6757689.0,539183.0 6762306.0,535875.0 6773086.0,539332.0 6780273.0,542578.0 6786711.0,536374.0 6790515.0,531913.0 6790043.0,528051.0 6796772.0,517130.0 6797243.0,513744.0 6803794.0,506061.0 6806938.0,505117.0 6820071.0,500193.0 6823412.0,486746.0 6818925.0,482552.0 6813147.0,477803.0 6815005.0,473893.0 6813452.0,467628.0 6811401.0,465298.0 6799724.0,466280.0 6794064.0,458409.0 6789055.0,460615.0 6783387.0,459373.0 6778102.0,451057.0 6776681.0,455060.0 6767070.0,447308.0 6764356.0,448124.0 6758669.0,442128.0 6753611.0,446459.0 6750432.0,446732.0 6745443.0,450112.0 6740918.0,457617.0 6739093.0,460339.0 6732350.0,464631.0 6730466.0,469484.0 6733109.0,474490.0 6731769.0,478533.0 6727039.0,485937.0 6723990.0,491931.0 6726763.0,502971.0 6722018.0,509057.0 6729569.0,515591.0 6731294.0,521086.0 6735350.0))",
            ],
            [
                "56",
                "MORBIHAN",
                "SRID=2154;MULTIPOLYGON (((229520.0 6710085.0,240383.0 6704696.0,240163.0 6708285.0,235835.0 6713741.0,229006.0 6716339.0,229520.0 6710085.0)),((212687.0 6770001.0,211559.0 6762660.0,216528.0 6752538.0,224759.0 6753321.0,234540.0 6747533.0,234220.0 6745025.0,240082.0 6736634.0,251238.0 6736509.0,260889.0 6740570.0,266327.0 6740184.0,271833.0 6736526.0,269308.0 6731426.0,263161.0 6733044.0,258643.0 6731063.0,263631.0 6725691.0,274085.0 6728424.0,283689.0 6728526.0,290663.0 6724762.0,288997.0 6719519.0,300067.0 6720583.0,315995.0 6726944.0,317487.0 6738014.0,315562.0 6748257.0,318803.0 6749864.0,322365.0 6758359.0,317839.0 6765781.0,320890.0 6769878.0,317014.0 6776765.0,309516.0 6779524.0,306739.0 6782705.0,310549.0 6787938.0,306966.0 6794650.0,300637.0 6793781.0,298204.0 6799128.0,291749.0 6798375.0,285132.0 6789099.0,280665.0 6785525.0,277875.0 6787107.0,279762.0 6794931.0,270150.0 6795768.0,252150.0 6805897.0,246074.0 6807146.0,242780.0 6802066.0,233945.0 6800703.0,229439.0 6804532.0,212675.0 6807535.0,202658.0 6804638.0,202166.0 6798131.0,205220.0 6785800.0,211608.0 6786141.0,216607.0 6782805.0,223352.0 6780867.0,221788.0 6771592.0,212687.0 6770001.0)))",
            ],
            [
                "28",
                "EURE-ET-LOIR",
                "SRID=2154;POLYGON ((539112.0 6843338.0,541484.0 6833537.0,549859.0 6826656.0,547706.0 6812952.0,543224.0 6808364.0,535921.0 6806758.0,534094.0 6803079.0,538862.0 6792254.0,536374.0 6790515.0,542578.0 6786711.0,539332.0 6780273.0,551017.0 6782681.0,551727.0 6777731.0,559439.0 6777275.0,559999.0 6772636.0,566408.0 6764638.0,573758.0 6762848.0,589601.0 6765689.0,589165.0 6770859.0,595216.0 6770968.0,597558.0 6774986.0,606511.0 6774717.0,615539.0 6776549.0,623220.0 6795517.0,625387.0 6798948.0,624251.0 6811501.0,620852.0 6812073.0,620311.0 6818025.0,611402.0 6819097.0,608912.0 6830618.0,604791.0 6831646.0,597086.0 6841311.0,595472.0 6845570.0,596554.0 6858123.0,594217.0 6866696.0,590236.0 6872273.0,587701.0 6866890.0,579784.0 6860594.0,580772.0 6855857.0,576482.0 6852521.0,566604.0 6854037.0,555241.0 6849633.0,543803.0 6848251.0,539112.0 6843338.0))",
            ],
            [
                "2A",
                "CORSE-DU-SUD",
                "SRID=2154;POLYGON ((1232225.0 6105798.0,1226359.0 6102880.0,1217754.0 6104291.0,1215715.0 6123336.0,1210743.0 6122769.0,1206639.0 6131576.0,1202519.0 6133762.0,1199675.0 6142105.0,1187662.0 6146432.0,1180116.0 6152978.0,1164950.0 6158109.0,1159342.0 6158599.0,1169805.0 6146197.0,1163901.0 6144874.0,1160274.0 6141810.0,1162433.0 6134554.0,1168722.0 6128275.0,1172897.0 6127710.0,1175910.0 6121801.0,1169135.0 6117789.0,1170381.0 6114875.0,1164715.0 6111213.0,1168686.0 6106658.0,1175324.0 6107066.0,1177911.0 6109856.0,1182246.0 6105577.0,1180256.0 6096485.0,1173562.0 6088828.0,1176478.0 6086334.0,1193164.0 6083876.0,1190373.0 6079505.0,1183548.0 6076443.0,1183755.0 6068439.0,1188281.0 6067524.0,1196826.0 6061810.0,1209242.0 6057430.0,1210610.0 6054235.0,1221376.0 6050136.0,1221646.0 6056536.0,1224377.0 6061299.0,1225618.0 6068574.0,1229809.0 6072152.0,1228158.0 6078400.0,1232811.0 6083356.0,1233466.0 6095728.0,1232225.0 6105798.0))",
            ],
            [
                "54",
                "MEURTHE-ET-MOSELLE",
                "SRID=2154;POLYGON ((879041.0 6935896.0,878534.0 6930925.0,883576.0 6926040.0,891117.0 6929633.0,895087.0 6927281.0,898652.0 6915853.0,898091.0 6905220.0,901547.0 6903348.0,900172.0 6898682.0,901739.0 6893315.0,905859.0 6891045.0,906433.0 6884047.0,905066.0 6875501.0,901302.0 6871865.0,904125.0 6862116.0,899528.0 6852809.0,902927.0 6847494.0,903561.0 6837915.0,900379.0 6832469.0,904895.0 6830283.0,904250.0 6825381.0,910921.0 6826770.0,919362.0 6809623.0,930831.0 6810526.0,935203.0 6815546.0,963830.0 6819154.0,964951.0 6823820.0,973656.0 6818945.0,982282.0 6817771.0,987769.0 6820181.0,994239.0 6827289.0,1004385.0 6831654.0,1001023.0 6834020.0,993487.0 6842033.0,983189.0 6843093.0,976380.0 6847597.0,971773.0 6847764.0,969100.0 6851558.0,964692.0 6852206.0,961206.0 6856322.0,946451.0 6858744.0,945024.0 6864515.0,939656.0 6875317.0,929417.0 6875078.0,928151.0 6878713.0,922735.0 6879575.0,922708.0 6883240.0,914442.0 6889764.0,914011.0 6893894.0,920671.0 6900380.0,917676.0 6905219.0,920628.0 6907653.0,912688.0 6923499.0,913390.0 6932141.0,909643.0 6936903.0,902225.0 6942685.0,896580.0 6941163.0,892512.0 6942531.0,879041.0 6935896.0))",
            ],
            [
                "61",
                "ORNE",
                "SRID=2154;POLYGON ((510545.0 6875400.0,504730.0 6874732.0,500558.0 6877307.0,491678.0 6873174.0,489675.0 6876299.0,484257.0 6870962.0,475607.0 6865852.0,469104.0 6863978.0,457511.0 6867107.0,454384.0 6863198.0,449827.0 6868751.0,446005.0 6869054.0,427244.0 6861949.0,417723.0 6857101.0,420581.0 6852284.0,423498.0 6841841.0,421619.0 6835816.0,414934.0 6829326.0,422197.0 6821752.0,429868.0 6822252.0,437568.0 6825109.0,441174.0 6828584.0,446687.0 6829012.0,451256.0 6826715.0,457920.0 6827997.0,463434.0 6833996.0,466087.0 6830999.0,467262.0 6822174.0,474394.0 6821359.0,473893.0 6813452.0,477803.0 6815005.0,482552.0 6813147.0,486746.0 6818925.0,500193.0 6823412.0,505117.0 6820071.0,506061.0 6806938.0,513744.0 6803794.0,517130.0 6797243.0,528051.0 6796772.0,531913.0 6790043.0,536374.0 6790515.0,538862.0 6792254.0,534094.0 6803079.0,535921.0 6806758.0,543224.0 6808364.0,547706.0 6812952.0,549859.0 6826656.0,541484.0 6833537.0,539112.0 6843338.0,533024.0 6847407.0,536389.0 6850906.0,533488.0 6856087.0,524600.0 6861683.0,520512.0 6866728.0,513552.0 6867418.0,508448.0 6870995.0,510545.0 6875400.0))",
            ],
            [
                "01",
                "AIN",
                "SRID=2154;POLYGON ((877344.0 6596683.0,869949.0 6598870.0,868758.0 6603264.0,857422.0 6600366.0,848718.0 6603737.0,845229.0 6595067.0,845050.0 6590960.0,839484.0 6574938.0,837322.0 6565642.0,838741.0 6561678.0,835220.0 6556428.0,834501.0 6551198.0,835850.0 6543054.0,833933.0 6540287.0,844536.0 6535588.0,849404.0 6524528.0,863140.0 6525920.0,870291.0 6521483.0,876089.0 6523611.0,879159.0 6530984.0,882529.0 6534232.0,888996.0 6528631.0,888123.0 6525941.0,897998.0 6515860.0,904449.0 6504924.0,909413.0 6509006.0,910338.0 6515974.0,915868.0 6518199.0,916332.0 6528631.0,919315.0 6541572.0,917441.0 6547210.0,916992.0 6555432.0,918731.0 6560168.0,928176.0 6563414.0,933670.0 6575392.0,940629.0 6577110.0,938817.0 6580823.0,943610.0 6590224.0,935280.0 6595262.0,929573.0 6589336.0,923919.0 6580132.0,919460.0 6577537.0,909869.0 6577050.0,908880.0 6582354.0,903737.0 6585593.0,895736.0 6577631.0,890444.0 6576892.0,887558.0 6582363.0,882486.0 6586333.0,882664.0 6589574.0,877221.0 6593352.0,877344.0 6596683.0))",
            ],
            [
                "09",
                "ARIEGE",
                "SRID=2154;POLYGON ((524704.0 6194181.0,530246.0 6189977.0,542336.0 6189236.0,549247.0 6180805.0,554894.0 6182516.0,562658.0 6181937.0,567864.0 6177510.0,571419.0 6168649.0,580902.0 6173997.0,585134.0 6170835.0,592180.0 6170254.0,600206.0 6164532.0,607482.0 6165290.0,615529.0 6169131.0,617954.0 6174066.0,631545.0 6174170.0,632373.0 6176261.0,622733.0 6184536.0,614361.0 6182470.0,610538.0 6185966.0,608402.0 6195450.0,617137.0 6197372.0,617210.0 6214637.0,613663.0 6217624.0,614442.0 6225039.0,604330.0 6228108.0,595072.0 6233132.0,596256.0 6236985.0,593467.0 6242482.0,589272.0 6240503.0,582028.0 6242918.0,575081.0 6235814.0,572065.0 6240985.0,565565.0 6247682.0,561407.0 6244405.0,567825.0 6236309.0,562910.0 6233771.0,555809.0 6233248.0,554118.0 6225953.0,547328.0 6230443.0,541984.0 6228895.0,540236.0 6224348.0,535770.0 6220735.0,537386.0 6214080.0,535012.0 6210452.0,526458.0 6208824.0,522873.0 6204718.0,524704.0 6194181.0))",
            ],
            [
                "19",
                "CORREZE",
                "SRID=2154;POLYGON ((563452.0 6484264.0,563844.0 6479160.0,568750.0 6477311.0,560988.0 6465186.0,564865.0 6461779.0,566113.0 6450433.0,573095.0 6446142.0,577774.0 6436765.0,584718.0 6439628.0,593751.0 6437105.0,601475.0 6429196.0,607209.0 6426078.0,613933.0 6431618.0,626129.0 6431248.0,631663.0 6432186.0,628772.0 6440050.0,634831.0 6442812.0,638218.0 6451518.0,636846.0 6458269.0,642886.0 6465907.0,649118.0 6470007.0,651369.0 6479623.0,656321.0 6476249.0,659915.0 6480065.0,661594.0 6486680.0,662264.0 6494997.0,658322.0 6500286.0,662164.0 6504560.0,663288.0 6509261.0,660507.0 6515469.0,656101.0 6511235.0,649366.0 6512420.0,648450.0 6509221.0,637278.0 6511373.0,635791.0 6515072.0,631053.0 6514297.0,623634.0 6517796.0,614305.0 6511565.0,612121.0 6507862.0,605337.0 6509707.0,593766.0 6498788.0,587429.0 6495459.0,581471.0 6497412.0,576059.0 6493313.0,571080.0 6486618.0,566212.0 6489282.0,563452.0 6484264.0))",
            ],
            [
                "68",
                "HAUT-RHIN",
                "SRID=2154;POLYGON ((987691.0 6753958.0,989189.0 6749828.0,1000830.0 6745745.0,1003510.0 6737902.0,1000706.0 6731961.0,1006958.0 6729298.0,1010786.0 6719537.0,1014326.0 6713511.0,1019985.0 6711034.0,1024064.0 6712992.0,1031730.0 6713160.0,1039126.0 6720266.0,1038581.0 6725392.0,1044459.0 6729657.0,1044908.0 6732411.0,1039238.0 6738821.0,1038337.0 6743276.0,1040672.0 6747502.0,1039113.0 6752662.0,1040418.0 6763108.0,1044697.0 6773634.0,1040564.0 6779861.0,1040408.0 6789869.0,1036067.0 6790258.0,1032222.0 6793924.0,1032428.0 6798669.0,1022638.0 6802981.0,1016850.0 6809125.0,1011125.0 6809400.0,1006708.0 6801985.0,1001795.0 6789636.0,998205.0 6776671.0,993983.0 6773739.0,991355.0 6761730.0,993060.0 6757264.0,987691.0 6753958.0))",
            ],
            [
                "37",
                "INDRE-ET-LOIRE",
                "SRID=2154;POLYGON ((573297.0 6677558.0,569696.0 6685244.0,565759.0 6689706.0,561058.0 6687382.0,557051.0 6690388.0,558309.0 6696538.0,557303.0 6702930.0,559271.0 6706788.0,552945.0 6716389.0,555366.0 6719856.0,552256.0 6724799.0,543743.0 6727862.0,539386.0 6732046.0,530153.0 6735215.0,521086.0 6735350.0,515591.0 6731294.0,509057.0 6729569.0,502971.0 6722018.0,491931.0 6726763.0,489539.0 6719725.0,490772.0 6714971.0,487846.0 6706491.0,479254.0 6691029.0,476861.0 6677880.0,478404.0 6673399.0,482922.0 6672972.0,485608.0 6667284.0,494947.0 6665028.0,494833.0 6656131.0,505157.0 6650870.0,510389.0 6653999.0,517389.0 6653506.0,515158.0 6658631.0,524608.0 6655240.0,525272.0 6647330.0,531658.0 6641492.0,533123.0 6635020.0,537221.0 6629765.0,546519.0 6631001.0,551779.0 6655211.0,553982.0 6659068.0,560408.0 6661557.0,568878.0 6661167.0,571950.0 6667671.0,576079.0 6670370.0,573297.0 6677558.0))",
            ],
            [
                "59",
                "NORD",
                "SRID=2154;POLYGON ((634422.0 7101577.0,636514.0 7100652.0,642453.0 7087769.0,644454.0 7079622.0,653390.0 7071778.0,658064.0 7064147.0,664277.0 7059477.0,673807.0 7057943.0,679720.0 7059405.0,683642.0 7063001.0,688698.0 7062196.0,686184.0 7056263.0,687641.0 7047582.0,692820.0 7044918.0,697493.0 7046164.0,701478.0 7042709.0,702680.0 7038239.0,699507.0 7031355.0,712383.0 7015916.0,711164.0 7009522.0,706855.0 7002888.0,706470.0 6995042.0,712391.0 6990404.0,716534.0 6992565.0,720100.0 6990781.0,725313.0 6993104.0,735248.0 6991264.0,739058.0 6995179.0,744014.0 6992056.0,751253.0 6997000.0,753505.0 6995276.0,766237.0 6992385.0,770359.0 6988977.0,778060.0 6986162.0,781905.0 6987282.0,783321.0 6995122.0,788006.0 6997129.0,785882.0 7004302.0,780654.0 7004663.0,782919.0 7012216.0,787237.0 7018342.0,781127.0 7020183.0,773958.0 7027731.0,768979.0 7028494.0,763439.0 7026158.0,760772.0 7028536.0,753265.0 7028386.0,749524.0 7024442.0,746894.0 7030603.0,747241.0 7039722.0,743565.0 7044070.0,733656.0 7048580.0,726572.0 7043892.0,720348.0 7047849.0,717610.0 7060148.0,718286.0 7067127.0,713527.0 7069761.0,710740.0 7076212.0,704337.0 7075998.0,695621.0 7071968.0,692807.0 7066387.0,686789.0 7068929.0,680050.0 7079722.0,674224.0 7079651.0,671748.0 7084186.0,674131.0 7094505.0,670178.0 7102078.0,667909.0 7110430.0,659576.0 7106814.0,654175.0 7107325.0,637372.0 7101244.0,634422.0 7101577.0))",
            ],
            [
                "90",
                "TERRITOIRE DE BELFORT",
                "SRID=2154;POLYGON ((1010786.0 6719537.0,1006958.0 6729298.0,1000706.0 6731961.0,1003510.0 6737902.0,1000830.0 6745745.0,989189.0 6749828.0,987691.0 6753958.0,986052.0 6752778.0,981470.0 6745308.0,983826.0 6731782.0,986155.0 6724947.0,993651.0 6723596.0,994087.0 6717743.0,996902.0 6711079.0,1001194.0 6713400.0,999772.0 6717889.0,1007028.0 6717766.0,1010786.0 6719537.0))",
            ],
            [
                "44",
                "LOIRE-ATLANTIQUE",
                "SRID=2154;POLYGON ((382163.0 6750361.0,374291.0 6753124.0,371672.0 6756673.0,356172.0 6751743.0,351165.0 6744974.0,342268.0 6743932.0,335469.0 6745297.0,327477.0 6743723.0,317487.0 6738014.0,315995.0 6726944.0,300067.0 6720583.0,288997.0 6719519.0,282806.0 6712695.0,283678.0 6703214.0,288393.0 6698809.0,292251.0 6700736.0,299211.0 6695249.0,308160.0 6699576.0,309828.0 6691500.0,308860.0 6686791.0,304084.0 6683183.0,316935.0 6678247.0,322009.0 6670666.0,324590.0 6666698.0,332678.0 6659222.0,338731.0 6658583.0,343129.0 6653969.0,353671.0 6649968.0,357453.0 6652400.0,354064.0 6663454.0,354394.0 6667534.0,359840.0 6669393.0,361112.0 6656907.0,367588.0 6659427.0,367645.0 6668175.0,374065.0 6668782.0,376108.0 6673611.0,385082.0 6667087.0,387784.0 6670618.0,379298.0 6676338.0,379159.0 6679552.0,384839.0 6683588.0,382659.0 6691801.0,378391.0 6691949.0,374867.0 6698071.0,375470.0 6701871.0,385609.0 6704471.0,396890.0 6703794.0,402393.0 6705897.0,401401.0 6717774.0,387234.0 6720426.0,386462.0 6727467.0,395905.0 6725901.0,398982.0 6728603.0,389301.0 6732485.0,386987.0 6740963.0,381255.0 6745617.0,382163.0 6750361.0))",
            ],
            [
                "89",
                "YONNE",
                "SRID=2154;POLYGON ((698236.0 6718784.0,701928.0 6717598.0,707666.0 6720847.0,709181.0 6715638.0,715400.0 6713642.0,717731.0 6709895.0,723118.0 6710529.0,726085.0 6708066.0,729904.0 6712131.0,736733.0 6710509.0,738638.0 6714270.0,743712.0 6710994.0,743701.0 6707332.0,751168.0 6705240.0,753904.0 6700965.0,759265.0 6699206.0,773240.0 6698003.0,773484.0 6692940.0,783517.0 6693799.0,780393.0 6701310.0,784360.0 6705398.0,783952.0 6713331.0,788376.0 6717645.0,791050.0 6725986.0,795163.0 6731989.0,794312.0 6737086.0,799827.0 6740411.0,799053.0 6750471.0,794318.0 6750026.0,796594.0 6759156.0,789480.0 6763963.0,783028.0 6759096.0,767353.0 6760249.0,763413.0 6765164.0,759917.0 6778325.0,755033.0 6785741.0,749678.0 6782304.0,746161.0 6791892.0,745765.0 6796957.0,736893.0 6807760.0,730707.0 6810078.0,727042.0 6808060.0,712422.0 6807964.0,703668.0 6806647.0,703237.0 6796855.0,700383.0 6789702.0,695265.0 6784783.0,702192.0 6781427.0,703759.0 6774663.0,706580.0 6772621.0,709585.0 6763406.0,703743.0 6756785.0,700769.0 6756036.0,701782.0 6742907.0,695135.0 6740319.0,689262.0 6740069.0,689391.0 6734632.0,694231.0 6731133.0,695341.0 6722058.0,698236.0 6718784.0))",
            ],
            [
                "35",
                "ILLE-ET-VILAINE",
                "SRID=2154;MULTIPOLYGON (((330825.0 6841252.0,328251.0 6849310.0,322500.0 6846053.0,325749.0 6841751.0,330825.0 6841252.0)),((399495.0 6830885.0,389634.0 6835155.0,384742.0 6834496.0,376536.0 6826525.0,368413.0 6830443.0,366767.0 6839135.0,363309.0 6845999.0,348952.0 6844300.0,343084.0 6846084.0,341341.0 6849649.0,342875.0 6855953.0,334395.0 6854417.0,329772.0 6850320.0,334969.0 6837949.0,337450.0 6835570.0,332923.0 6813386.0,328273.0 6809495.0,325505.0 6811765.0,320973.0 6806998.0,315234.0 6806646.0,311879.0 6798427.0,306966.0 6794650.0,310549.0 6787938.0,306739.0 6782705.0,309516.0 6779524.0,317014.0 6776765.0,320890.0 6769878.0,317839.0 6765781.0,322365.0 6758359.0,318803.0 6749864.0,315562.0 6748257.0,317487.0 6738014.0,327477.0 6743723.0,335469.0 6745297.0,342268.0 6743932.0,351165.0 6744974.0,356172.0 6751743.0,371672.0 6756673.0,374291.0 6753124.0,382163.0 6750361.0,382932.0 6754022.0,386941.0 6760260.0,390140.0 6770978.0,394099.0 6773357.0,400197.0 6773697.0,400465.0 6781914.0,398626.0 6784333.0,395852.0 6803336.0,400321.0 6810723.0,398130.0 6822559.0,399495.0 6830885.0)))",
            ],
            [
                "40",
                "LANDES",
                "SRID=2154;POLYGON ((334283.0 6280551.0,338238.0 6281381.0,342731.0 6276517.0,352961.0 6276001.0,362964.0 6280741.0,367753.0 6276986.0,377063.0 6275535.0,385124.0 6280151.0,394475.0 6281218.0,399714.0 6278404.0,403447.0 6281078.0,412501.0 6278002.0,421554.0 6283529.0,424830.0 6280287.0,433057.0 6279053.0,438084.0 6281592.0,439499.0 6295895.0,442698.0 6298315.0,443572.0 6313646.0,440195.0 6315550.0,444807.0 6320573.0,453303.0 6321029.0,461632.0 6315722.0,465239.0 6317398.0,465465.0 6324803.0,464468.0 6326808.0,467874.0 6336236.0,470769.0 6340294.0,462757.0 6341305.0,459734.0 6343570.0,449759.0 6344226.0,449164.0 6352477.0,445091.0 6357381.0,442465.0 6350467.0,438523.0 6349285.0,429214.0 6351421.0,430077.0 6359927.0,426389.0 6364119.0,419635.0 6366255.0,418928.0 6369127.0,411174.0 6373203.0,411314.0 6378206.0,403228.0 6378937.0,393973.0 6376334.0,388231.0 6379327.0,381182.0 6379048.0,383562.0 6383958.0,375548.0 6389853.0,373686.0 6386677.0,361774.0 6383396.0,355175.0 6347840.0,348748.0 6322487.0,342546.0 6300215.0,341177.0 6292691.0,334283.0 6280551.0))",
            ],
            [
                "29",
                "FINISTERE",
                "SRID=2154;POLYGON ((210124.0 6860562.0,210319.0 6864435.0,197918.0 6867491.0,195168.0 6863087.0,188759.0 6861699.0,187283.0 6866983.0,171676.0 6866983.0,165007.0 6863478.0,159513.0 6866951.0,150836.0 6862294.0,143559.0 6862620.0,137993.0 6858007.0,130421.0 6856362.0,126410.0 6849458.0,124277.0 6841317.0,126191.0 6836271.0,137035.0 6831319.0,151215.0 6836632.0,149516.0 6831882.0,159712.0 6829829.0,158800.0 6824711.0,152925.0 6822802.0,150196.0 6824902.0,139593.0 6825317.0,139209.0 6819312.0,147794.0 6818873.0,158225.0 6812964.0,159803.0 6806301.0,156741.0 6801688.0,151961.0 6804475.0,143250.0 6802653.0,129762.0 6802135.0,125302.0 6798484.0,144750.0 6790824.0,150552.0 6779953.0,149596.0 6769606.0,162294.0 6768615.0,164959.0 6774152.0,171525.0 6775493.0,174013.0 6772980.0,183941.0 6774809.0,184280.0 6770949.0,191411.0 6764941.0,196633.0 6766198.0,200244.0 6762976.0,211251.0 6761104.0,212687.0 6770001.0,221788.0 6771592.0,223352.0 6780867.0,216607.0 6782805.0,211608.0 6786141.0,205220.0 6785800.0,202166.0 6798131.0,202658.0 6804638.0,212675.0 6807535.0,216996.0 6817941.0,214652.0 6824074.0,215204.0 6828740.0,213034.0 6834627.0,212655.0 6842190.0,216761.0 6846809.0,210382.0 6855067.0,210124.0 6860562.0))",
            ],
            [
                "74",
                "HAUTE-SAVOIE",
                "SRID=2154;POLYGON ((995359.0 6526975.0,996263.0 6533312.0,1005620.0 6535079.0,1009539.0 6537663.0,1013275.0 6543845.0,1010939.0 6550631.0,1005414.0 6557665.0,1000587.0 6561265.0,1000913.0 6565514.0,994423.0 6565990.0,993170.0 6574229.0,997429.0 6583180.0,990846.0 6588853.0,991547.0 6595136.0,985884.0 6596474.0,972312.0 6594423.0,960663.0 6587846.0,955674.0 6591075.0,952150.0 6588701.0,949250.0 6580383.0,953939.0 6574878.0,949136.0 6572391.0,944956.0 6566962.0,928176.0 6563414.0,918731.0 6560168.0,916992.0 6555432.0,917441.0 6547210.0,919315.0 6541572.0,921730.0 6540986.0,922988.0 6530552.0,926213.0 6526897.0,936560.0 6520059.0,946066.0 6522280.0,948121.0 6516633.0,952091.0 6514710.0,959117.0 6516128.0,962862.0 6525460.0,965836.0 6528299.0,969073.0 6537583.0,971940.0 6540371.0,975690.0 6531451.0,979688.0 6528135.0,984284.0 6528734.0,988618.0 6520489.0,995359.0 6526975.0))",
            ],
            [
                "60",
                "OISE",
                "SRID=2154;POLYGON ((605624.0 6904387.0,608283.0 6898554.0,612180.0 6899061.0,618689.0 6896449.0,626847.0 6897876.0,633020.0 6901508.0,645465.0 6895048.0,649761.0 6898738.0,652314.0 6895981.0,659205.0 6894147.0,670084.0 6886723.0,673222.0 6889902.0,680633.0 6884542.0,700622.0 6887964.0,705248.0 6890863.0,710189.0 6894765.0,704672.0 6899225.0,701957.0 6908433.0,698137.0 6911415.0,706929.0 6919738.0,706805.0 6926038.0,711648.0 6928031.0,706939.0 6934901.0,709520.0 6938240.0,707064.0 6950845.0,708546.0 6956332.0,693916.0 6955962.0,685089.0 6950779.0,685504.0 6946842.0,677528.0 6947426.0,676176.0 6942514.0,669006.0 6944292.0,664208.0 6949037.0,654712.0 6950974.0,645659.0 6956103.0,636565.0 6954687.0,623025.0 6958366.0,620154.0 6956108.0,612314.0 6962826.0,605401.0 6955866.0,607933.0 6953359.0,606321.0 6945902.0,609123.0 6937659.0,607205.0 6935073.0,610545.0 6930338.0,606642.0 6924066.0,609871.0 6919444.0,610931.0 6911811.0,606128.0 6907968.0,605624.0 6904387.0))",
            ],
            [
                "95",
                "VAL-D'OISE",
                "SRID=2154;POLYGON ((598361.0 6887345.0,603102.0 6887292.0,606678.0 6883543.0,614076.0 6886919.0,622312.0 6880731.0,628641.0 6878089.0,633062.0 6879807.0,641836.0 6872490.0,641404.0 6867928.0,648071.0 6872567.0,653619.0 6875101.0,660416.0 6872923.0,667303.0 6878971.0,670084.0 6886723.0,659205.0 6894147.0,652314.0 6895981.0,649761.0 6898738.0,645465.0 6895048.0,633020.0 6901508.0,626847.0 6897876.0,618689.0 6896449.0,612180.0 6899061.0,608283.0 6898554.0,605624.0 6904387.0,603501.0 6902160.0,601892.0 6893098.0,598361.0 6887345.0))",
            ],
            [
                "58",
                "NIEVRE",
                "SRID=2154;POLYGON ((783517.0 6693799.0,773484.0 6692940.0,773240.0 6698003.0,759265.0 6699206.0,753904.0 6700965.0,751168.0 6705240.0,743701.0 6707332.0,743712.0 6710994.0,738638.0 6714270.0,736733.0 6710509.0,729904.0 6712131.0,726085.0 6708066.0,723118.0 6710529.0,717731.0 6709895.0,715400.0 6713642.0,709181.0 6715638.0,707666.0 6720847.0,701928.0 6717598.0,698236.0 6718784.0,693556.0 6718403.0,690565.0 6713347.0,694642.0 6704915.0,690449.0 6694237.0,698745.0 6684384.0,698614.0 6680189.0,702129.0 6669867.0,701762.0 6662486.0,705753.0 6657660.0,706033.0 6650549.0,703828.0 6645606.0,705186.0 6641947.0,702446.0 6632753.0,703745.0 6628663.0,716475.0 6620334.0,720608.0 6624106.0,726499.0 6620539.0,733164.0 6623625.0,737251.0 6617690.0,742042.0 6624120.0,748049.0 6627896.0,756196.0 6628301.0,760920.0 6622686.0,770503.0 6626941.0,775685.0 6631211.0,781064.0 6632682.0,780490.0 6638662.0,783308.0 6642195.0,778932.0 6646959.0,779000.0 6654397.0,781374.0 6662136.0,778810.0 6664936.0,780471.0 6669516.0,784602.0 6669828.0,789554.0 6672918.0,791663.0 6673495.0,793165.0 6678355.0,789098.0 6683996.0,785899.0 6682517.0,783517.0 6693799.0))",
            ],
            [
                "21",
                "COTE-D'OR",
                "SRID=2154;POLYGON ((871408.0 6655745.0,875449.0 6660099.0,876191.0 6666228.0,881002.0 6667371.0,884880.0 6674426.0,887407.0 6682465.0,888032.0 6690633.0,890265.0 6692353.0,884919.0 6701062.0,880595.0 6713705.0,884206.0 6713509.0,887785.0 6718944.0,886108.0 6726069.0,882147.0 6728546.0,878352.0 6725366.0,868188.0 6726357.0,863148.0 6730266.0,858300.0 6729814.0,848455.0 6733791.0,846031.0 6742315.0,848388.0 6746302.0,846087.0 6753627.0,838226.0 6763382.0,833316.0 6764154.0,833398.0 6769005.0,827043.0 6770243.0,817962.0 6771080.0,816397.0 6764598.0,808147.0 6762855.0,797692.0 6763119.0,796594.0 6759156.0,794318.0 6750026.0,799053.0 6750471.0,799827.0 6740411.0,794312.0 6737086.0,795163.0 6731989.0,791050.0 6725986.0,788376.0 6717645.0,783952.0 6713331.0,784360.0 6705398.0,780393.0 6701310.0,783517.0 6693799.0,785899.0 6682517.0,789098.0 6683996.0,793165.0 6678355.0,791663.0 6673495.0,795506.0 6668991.0,806631.0 6665548.0,806754.0 6662035.0,813434.0 6659755.0,823470.0 6650227.0,831500.0 6648015.0,855755.0 6655507.0,860161.0 6652754.0,871408.0 6655745.0))",
            ],
            [
                "91",
                "ESSONNE",
                "SRID=2154;POLYGON ((643163.0 6853168.0,634691.0 6849194.0,632440.0 6843248.0,627800.0 6838438.0,627504.0 6829048.0,623768.0 6826369.0,620311.0 6818025.0,620852.0 6812073.0,624251.0 6811501.0,625387.0 6798948.0,639308.0 6801806.0,653275.0 6801114.0,655721.0 6802434.0,657768.0 6807009.0,665496.0 6812431.0,663371.0 6815578.0,663045.0 6825117.0,666363.0 6833836.0,665649.0 6839786.0,668472.0 6843626.0,663488.0 6848458.0,653706.0 6846856.0,650056.0 6850064.0,643163.0 6853168.0))",
            ],
            [
                "79",
                "DEUX-SEVRES",
                "SRID=2154;POLYGON ((483517.0 6558927.0,485043.0 6563684.0,480502.0 6565882.0,477460.0 6571967.0,478920.0 6578170.0,482897.0 6584792.0,479925.0 6587264.0,475179.0 6582497.0,472141.0 6584899.0,472081.0 6590232.0,468300.0 6594579.0,467690.0 6607234.0,472374.0 6614809.0,467588.0 6622657.0,470952.0 6628365.0,469757.0 6639127.0,471018.0 6649618.0,465537.0 6662685.0,464624.0 6667352.0,458546.0 6672434.0,454238.0 6672319.0,442005.0 6668948.0,434893.0 6670550.0,429925.0 6668493.0,429262.0 6663802.0,424993.0 6661094.0,417889.0 6660618.0,413368.0 6662854.0,404251.0 6660135.0,408792.0 6655192.0,411920.0 6644974.0,417892.0 6640888.0,415662.0 6636435.0,420740.0 6628764.0,421344.0 6621760.0,423543.0 6619698.0,424018.0 6609992.0,422851.0 6601758.0,420470.0 6597142.0,428213.0 6593481.0,426574.0 6590996.0,411453.0 6585116.0,411065.0 6578554.0,415606.0 6575464.0,420640.0 6566176.0,426299.0 6566639.0,429269.0 6562335.0,437311.0 6559539.0,446458.0 6558600.0,459784.0 6545825.0,464645.0 6548283.0,465641.0 6555184.0,469589.0 6554692.0,473907.0 6559092.0,483517.0 6558927.0))",
            ],
            [
                "22",
                "COTES-D'ARMOR",
                "SRID=2154;POLYGON ((306966.0 6794650.0,311879.0 6798427.0,315234.0 6806646.0,320973.0 6806998.0,325505.0 6811765.0,328273.0 6809495.0,332923.0 6813386.0,337450.0 6835570.0,334969.0 6837949.0,330825.0 6841252.0,325749.0 6841751.0,322500.0 6846053.0,319331.0 6843417.0,315059.0 6845536.0,309156.0 6855461.0,296913.0 6849790.0,284640.0 6841250.0,280881.0 6840740.0,271227.0 6848399.0,271155.0 6854763.0,262910.0 6863924.0,263482.0 6867351.0,257346.0 6869777.0,251930.0 6880323.0,243322.0 6881073.0,228138.0 6874463.0,222446.0 6879145.0,216642.0 6872989.0,215941.0 6861279.0,210124.0 6860562.0,210382.0 6855067.0,216761.0 6846809.0,212655.0 6842190.0,213034.0 6834627.0,215204.0 6828740.0,214652.0 6824074.0,216996.0 6817941.0,212675.0 6807535.0,229439.0 6804532.0,233945.0 6800703.0,242780.0 6802066.0,246074.0 6807146.0,252150.0 6805897.0,270150.0 6795768.0,279762.0 6794931.0,277875.0 6787107.0,280665.0 6785525.0,285132.0 6789099.0,291749.0 6798375.0,298204.0 6799128.0,300637.0 6793781.0,306966.0 6794650.0))",
            ],
            [
                "03",
                "ALLIER",
                "SRID=2154;POLYGON ((702446.0 6632753.0,696943.0 6633749.0,686837.0 6626145.0,682775.0 6624336.0,677474.0 6626628.0,669145.0 6615318.0,670500.0 6605989.0,664479.0 6602292.0,660370.0 6603761.0,650317.0 6601560.0,645179.0 6595086.0,644784.0 6591412.0,647921.0 6581264.0,653217.0 6581299.0,659880.0 6575828.0,662729.0 6571178.0,666451.0 6560450.0,672252.0 6557694.0,679424.0 6569309.0,685369.0 6566281.0,688886.0 6572856.0,695157.0 6571452.0,693029.0 6567076.0,697819.0 6557998.0,712873.0 6551781.0,728730.0 6550656.0,732386.0 6552810.0,735860.0 6546571.0,745523.0 6547324.0,753779.0 6537018.0,754888.0 6541809.0,761084.0 6541876.0,763887.0 6544360.0,762385.0 6549859.0,763504.0 6554575.0,760949.0 6561975.0,762003.0 6573092.0,769267.0 6575508.0,775913.0 6580395.0,775079.0 6589273.0,776586.0 6596649.0,773476.0 6599308.0,768312.0 6598303.0,763922.0 6603795.0,761463.0 6602522.0,756931.0 6607772.0,753291.0 6618069.0,748734.0 6623209.0,748049.0 6627896.0,742042.0 6624120.0,737251.0 6617690.0,733164.0 6623625.0,726499.0 6620539.0,720608.0 6624106.0,716475.0 6620334.0,703745.0 6628663.0,702446.0 6632753.0))",
            ],
            [
                "17",
                "CHARENTE-MARITIME",
                "SRID=2154;MULTIPOLYGON (((365341.0 6575902.0,359213.0 6576771.0,352445.0 6583031.0,350494.0 6577212.0,356155.0 6576636.0,364082.0 6571051.0,365341.0 6575902.0)),((373352.0 6542832.0,371342.0 6552252.0,366346.0 6552808.0,362447.0 6556836.0,360591.0 6548506.0,369260.0 6539881.0,371124.0 6531592.0,374437.0 6534213.0,375330.0 6540510.0,373352.0 6542832.0)),((464807.0 6459164.0,461242.0 6465553.0,455660.0 6465791.0,456356.0 6470307.0,447267.0 6474282.0,443202.0 6478722.0,445861.0 6484044.0,444696.0 6489309.0,446521.0 6493231.0,442913.0 6501478.0,436951.0 6506668.0,434607.0 6512022.0,434480.0 6521530.0,445866.0 6528260.0,449713.0 6524677.0,455132.0 6526680.0,458386.0 6534878.0,457303.0 6539406.0,459784.0 6545825.0,446458.0 6558600.0,437311.0 6559539.0,429269.0 6562335.0,426299.0 6566639.0,420640.0 6566176.0,415606.0 6575464.0,411065.0 6578554.0,411453.0 6585116.0,404775.0 6589452.0,397324.0 6586760.0,391500.0 6591809.0,382360.0 6587238.0,383479.0 6581738.0,376439.0 6576760.0,374243.0 6571617.0,381511.0 6566597.0,386552.0 6553761.0,382858.0 6551653.0,385303.0 6547012.0,378912.0 6532887.0,370510.0 6529071.0,370474.0 6520657.0,379564.0 6513624.0,387626.0 6509256.0,386164.0 6505245.0,399796.0 6489042.0,404682.0 6481482.0,406100.0 6476140.0,418478.0 6475494.0,421098.0 6472770.0,431214.0 6470295.0,433418.0 6457450.0,437492.0 6457585.0,444096.0 6451365.0,452009.0 6448234.0,457280.0 6451647.0,460931.0 6449393.0,464807.0 6459164.0)))",
            ],
            [
                "15",
                "CANTAL",
                "SRID=2154;POLYGON ((728488.0 6430309.0,727352.0 6435060.0,723408.0 6437470.0,725628.0 6444038.0,722648.0 6446835.0,717445.0 6463649.0,709251.0 6464988.0,708104.0 6472781.0,701310.0 6465307.0,695974.0 6467752.0,693859.0 6474045.0,688449.0 6477003.0,677684.0 6475835.0,672750.0 6482640.0,661594.0 6486680.0,659915.0 6480065.0,656321.0 6476249.0,651369.0 6479623.0,649118.0 6470007.0,642886.0 6465907.0,636846.0 6458269.0,638218.0 6451518.0,634831.0 6442812.0,628772.0 6440050.0,631663.0 6432186.0,626129.0 6431248.0,628463.0 6419614.0,634482.0 6410441.0,633003.0 6406356.0,634129.0 6393565.0,637122.0 6391031.0,637228.0 6394175.0,646639.0 6396959.0,655192.0 6393469.0,664849.0 6402561.0,665404.0 6408608.0,668313.0 6410487.0,668604.0 6416079.0,676829.0 6423158.0,679353.0 6426925.0,684359.0 6419403.0,688126.0 6419157.0,690477.0 6411547.0,694820.0 6408897.0,693924.0 6403282.0,698547.0 6393953.0,704864.0 6413115.0,707862.0 6414941.0,708330.0 6420849.0,714401.0 6418301.0,719705.0 6424147.0,728488.0 6430309.0))",
            ],
            [
                "34",
                "HERAULT",
                "SRID=2154;POLYGON ((664821.0 6258302.0,662679.0 6249784.0,667653.0 6244475.0,681495.0 6239871.0,686427.0 6247043.0,700353.0 6246775.0,700385.0 6243263.0,711963.0 6238657.0,716336.0 6238907.0,719561.0 6234874.0,727933.0 6241307.0,734945.0 6243544.0,741504.0 6241707.0,748880.0 6250885.0,753675.0 6255020.0,764523.0 6260540.0,773373.0 6269062.0,781738.0 6273121.0,788998.0 6273432.0,792922.0 6276955.0,796379.0 6284647.0,792244.0 6293431.0,780634.0 6301895.0,773726.0 6310049.0,766790.0 6307842.0,766255.0 6313712.0,763184.0 6318967.0,758340.0 6319159.0,750088.0 6313306.0,746263.0 6307559.0,742673.0 6306434.0,734096.0 6312602.0,728786.0 6312824.0,722102.0 6311077.0,716344.0 6301672.0,704815.0 6303628.0,704898.0 6288229.0,698819.0 6289943.0,694796.0 6288406.0,693221.0 6284557.0,680178.0 6279485.0,676690.0 6282993.0,671212.0 6283521.0,668935.0 6274250.0,672394.0 6269695.0,672444.0 6264623.0,668090.0 6259189.0,664821.0 6258302.0))",
            ],
            [
                "26",
                "DROME",
                "SRID=2154;POLYGON ((921863.0 6404787.0,918546.0 6403480.0,907889.0 6409384.0,894862.0 6413405.0,895949.0 6427870.0,895595.0 6439026.0,892767.0 6444271.0,888053.0 6440277.0,871457.0 6445038.0,871909.0 6454823.0,870728.0 6463360.0,866406.0 6463235.0,860939.0 6470947.0,855768.0 6473591.0,847361.0 6468209.0,841110.0 6468164.0,842390.0 6453321.0,844782.0 6435636.0,848816.0 6428161.0,844069.0 6414766.0,839715.0 6410394.0,841041.0 6396655.0,835764.0 6388411.0,834538.0 6384016.0,835151.0 6374038.0,832713.0 6371581.0,831614.0 6360351.0,840525.0 6360052.0,843837.0 6356928.0,844895.0 6349809.0,864358.0 6358713.0,871547.0 6356009.0,872115.0 6350341.0,890550.0 6347548.0,890601.0 6342463.0,894810.0 6342254.0,899978.0 6338355.0,903520.0 6340766.0,905908.0 6346585.0,911050.0 6344481.0,913873.0 6347227.0,914428.0 6355637.0,911254.0 6355549.0,909816.0 6362305.0,898744.0 6362932.0,892505.0 6372493.0,899815.0 6380077.0,907085.0 6377469.0,909000.0 6384874.0,906293.0 6386082.0,910174.0 6394503.0,921214.0 6398819.0,921863.0 6404787.0),(850837.0 6364673.0,852761.0 6369494.0,856829.0 6372215.0,860545.0 6368019.0,860544.0 6360615.0,857850.0 6357360.0,850729.0 6357929.0,850837.0 6364673.0))",
            ],
            [
                "66",
                "PYRENEES-ORIENTALES",
                "SRID=2154;POLYGON ((600206.0 6164532.0,597209.0 6163462.0,595443.0 6155896.0,604042.0 6154257.0,614139.0 6147692.0,616327.0 6140765.0,624388.0 6140739.0,630462.0 6147428.0,638840.0 6149005.0,653442.0 6143379.0,657322.0 6137875.0,662029.0 6137190.0,665163.0 6139863.0,672907.0 6137962.0,673207.0 6145058.0,679658.0 6147303.0,683451.0 6146537.0,686936.0 6150974.0,703357.0 6152588.0,707042.0 6147292.0,714275.0 6148346.0,710994.0 6157024.0,704080.0 6161154.0,702907.0 6175403.0,703560.0 6193187.0,693222.0 6198384.0,688989.0 6202113.0,682753.0 6199641.0,678721.0 6193157.0,675246.0 6192375.0,659825.0 6194610.0,655189.0 6193206.0,644930.0 6193342.0,647326.0 6181831.0,644388.0 6178927.0,631545.0 6174170.0,617954.0 6174066.0,615529.0 6169131.0,607482.0 6165290.0,600206.0 6164532.0))",
            ],
            [
                "73",
                "SAVOIE",
                "SRID=2154;POLYGON ((956276.0 6452799.0,964422.0 6450656.0,967061.0 6446025.0,974349.0 6445704.0,973771.0 6449910.0,985382.0 6452122.0,989157.0 6455721.0,995952.0 6458223.0,1002558.0 6454919.0,1011443.0 6464355.0,1024403.0 6470318.0,1021887.0 6478062.0,1027167.0 6487344.0,1021485.0 6490016.0,1020210.0 6493869.0,1012252.0 6497350.0,1011518.0 6512378.0,1006337.0 6512917.0,997830.0 6518696.0,995359.0 6526975.0,988618.0 6520489.0,984284.0 6528734.0,979688.0 6528135.0,975690.0 6531451.0,971940.0 6540371.0,969073.0 6537583.0,965836.0 6528299.0,962862.0 6525460.0,959117.0 6516128.0,952091.0 6514710.0,948121.0 6516633.0,946066.0 6522280.0,936560.0 6520059.0,926213.0 6526897.0,922988.0 6530552.0,921730.0 6540986.0,919315.0 6541572.0,916332.0 6528631.0,915868.0 6518199.0,910338.0 6515974.0,909413.0 6509006.0,904449.0 6504924.0,913763.0 6489603.0,917457.0 6486189.0,925224.0 6482705.0,931624.0 6492445.0,938381.0 6486658.0,943964.0 6486985.0,948557.0 6482085.0,949441.0 6473761.0,945461.0 6470305.0,945165.0 6465401.0,950505.0 6456663.0,956276.0 6452799.0))",
            ],
            [
                "05",
                "HAUTES-ALPES",
                "SRID=2154;POLYGON ((921863.0 6404787.0,921214.0 6398819.0,910174.0 6394503.0,906293.0 6386082.0,909000.0 6384874.0,907085.0 6377469.0,899815.0 6380077.0,892505.0 6372493.0,898744.0 6362932.0,909816.0 6362305.0,911254.0 6355549.0,914428.0 6355637.0,913873.0 6347227.0,920148.0 6349530.0,930231.0 6349978.0,925339.0 6357350.0,932421.0 6356788.0,935206.0 6370624.0,944316.0 6377139.0,950982.0 6378672.0,957118.0 6369997.0,959705.0 6373500.0,957182.0 6379131.0,967103.0 6386021.0,971476.0 6380340.0,983401.0 6378221.0,988952.0 6378656.0,992592.0 6389297.0,999315.0 6394909.0,1004568.0 6397351.0,1010207.0 6403290.0,1012913.0 6402904.0,1015781.0 6406977.0,1022960.0 6406318.0,1016213.0 6418043.0,1016501.0 6423604.0,1010607.0 6425833.0,1004832.0 6424533.0,995855.0 6430156.0,996598.0 6437292.0,994575.0 6442256.0,989294.0 6442329.0,985382.0 6452122.0,973771.0 6449910.0,974349.0 6445704.0,967061.0 6446025.0,964422.0 6450656.0,956276.0 6452799.0,953909.0 6450690.0,952342.0 6439924.0,961377.0 6439340.0,964872.0 6432532.0,965006.0 6422921.0,960775.0 6424797.0,956742.0 6422339.0,947667.0 6423241.0,941569.0 6417648.0,939410.0 6420031.0,933177.0 6416064.0,930672.0 6410433.0,925560.0 6409806.0,921863.0 6404787.0))",
            ],
            [
                "84",
                "VAUCLUSE",
                "SRID=2154;MULTIPOLYGON (((850837.0 6364673.0,850729.0 6357929.0,857850.0 6357360.0,860544.0 6360615.0,860545.0 6368019.0,856829.0 6372215.0,852761.0 6369494.0,850837.0 6364673.0)),((839658.0 6315433.0,848847.0 6314233.0,858049.0 6310039.0,863255.0 6305296.0,865136.0 6300908.0,876282.0 6295340.0,879627.0 6296831.0,886796.0 6295631.0,896706.0 6289935.0,904218.0 6287715.0,910307.0 6287877.0,921881.0 6295602.0,922160.0 6296144.0,913516.0 6306489.0,907367.0 6306820.0,909386.0 6316209.0,901642.0 6319541.0,903879.0 6328807.0,900470.0 6332559.0,899978.0 6338355.0,894810.0 6342254.0,890601.0 6342463.0,890550.0 6347548.0,872115.0 6350341.0,871547.0 6356009.0,864358.0 6358713.0,844895.0 6349809.0,843837.0 6356928.0,840525.0 6360052.0,831614.0 6360351.0,831641.0 6353746.0,837656.0 6344658.0,836689.0 6335330.0,843231.0 6331183.0,847769.0 6322554.0,839658.0 6315433.0)))",
            ],
            [
                "36",
                "INDRE",
                "SRID=2154;POLYGON ((636090.0 6591904.0,634893.0 6595681.0,638969.0 6598575.0,635550.0 6606712.0,637665.0 6611745.0,634340.0 6622075.0,628673.0 6627353.0,632500.0 6630848.0,627496.0 6637025.0,633457.0 6642556.0,629301.0 6648616.0,631131.0 6657674.0,627981.0 6660408.0,627833.0 6667741.0,621646.0 6669974.0,615265.0 6667454.0,607114.0 6670785.0,612309.0 6675948.0,612147.0 6680536.0,602149.0 6685865.0,593597.0 6687211.0,582631.0 6683116.0,573297.0 6677558.0,576079.0 6670370.0,571950.0 6667671.0,568878.0 6661167.0,560408.0 6661557.0,553982.0 6659068.0,551779.0 6655211.0,546519.0 6631001.0,537221.0 6629765.0,541431.0 6623495.0,538906.0 6616112.0,542426.0 6611026.0,547958.0 6609437.0,557842.0 6602380.0,558128.0 6596023.0,562773.0 6594026.0,559931.0 6588729.0,569564.0 6587075.0,573702.0 6590223.0,578129.0 6584256.0,586530.0 6592902.0,595863.0 6588324.0,602234.0 6588456.0,609355.0 6592908.0,622684.0 6592821.0,630016.0 6590287.0,636090.0 6591904.0))",
            ],
            [
                "2B",
                "HAUTE-CORSE",
                "SRID=2154;POLYGON ((1232225.0 6105798.0,1232233.0 6116272.0,1242213.0 6134033.0,1241272.0 6154177.0,1238247.0 6164499.0,1238682.0 6169952.0,1236764.0 6182904.0,1228823.0 6195229.0,1228376.0 6197858.0,1231051.0 6211355.0,1228846.0 6218876.0,1227050.0 6231255.0,1223421.0 6233783.0,1216996.0 6231337.0,1218749.0 6222752.0,1215986.0 6213431.0,1218915.0 6209217.0,1219580.0 6202912.0,1215962.0 6195537.0,1212393.0 6200184.0,1205077.0 6201621.0,1198634.0 6198671.0,1193909.0 6190462.0,1183050.0 6187935.0,1176939.0 6184145.0,1176781.0 6180877.0,1165934.0 6173994.0,1165800.0 6162888.0,1161943.0 6162734.0,1159342.0 6158599.0,1164950.0 6158109.0,1180116.0 6152978.0,1187662.0 6146432.0,1199675.0 6142105.0,1202519.0 6133762.0,1206639.0 6131576.0,1210743.0 6122769.0,1215715.0 6123336.0,1217754.0 6104291.0,1226359.0 6102880.0,1232225.0 6105798.0))",
            ],
            [
                "87",
                "HAUTE-VIENNE",
                "SRID=2154;POLYGON ((563452.0 6484264.0,566212.0 6489282.0,571080.0 6486618.0,576059.0 6493313.0,581471.0 6497412.0,587429.0 6495459.0,593766.0 6498788.0,605337.0 6509707.0,612121.0 6507862.0,614305.0 6511565.0,612524.0 6515422.0,613074.0 6522626.0,604752.0 6527760.0,597279.0 6527024.0,591561.0 6529605.0,592200.0 6538029.0,586335.0 6540289.0,587795.0 6549437.0,580656.0 6565605.0,574730.0 6569689.0,580236.0 6579624.0,578129.0 6584256.0,573702.0 6590223.0,569564.0 6587075.0,559931.0 6588729.0,556218.0 6586207.0,548271.0 6584464.0,546474.0 6577615.0,538896.0 6578287.0,530127.0 6570272.0,531964.0 6561069.0,531290.0 6552122.0,539507.0 6547743.0,540666.0 6541823.0,534383.0 6537804.0,527825.0 6527023.0,522669.0 6525452.0,522412.0 6520738.0,515635.0 6515544.0,526849.0 6509996.0,524801.0 6504583.0,529342.0 6499739.0,539039.0 6503445.0,546900.0 6501981.0,553144.0 6489340.0,563452.0 6484264.0))",
            ],
            [
                "85",
                "VENDEE",
                "SRID=2154;MULTIPOLYGON (((297360.0 6667914.0,299985.0 6664525.0,303823.0 6669495.0,298725.0 6671705.0,297360.0 6667914.0)),((322009.0 6670666.0,318317.0 6668787.0,315194.0 6662103.0,307861.0 6656132.0,308108.0 6649020.0,322518.0 6633220.0,328569.0 6623483.0,331126.0 6610513.0,333817.0 6610276.0,344797.0 6600884.0,354269.0 6598459.0,356701.0 6592204.0,364357.0 6592471.0,376108.0 6582708.0,376887.0 6588202.0,382360.0 6587238.0,391500.0 6591809.0,397324.0 6586760.0,404775.0 6589452.0,411453.0 6585116.0,426574.0 6590996.0,428213.0 6593481.0,420470.0 6597142.0,422851.0 6601758.0,424018.0 6609992.0,423543.0 6619698.0,421344.0 6621760.0,420740.0 6628764.0,415662.0 6636435.0,417892.0 6640888.0,411920.0 6644974.0,408792.0 6655192.0,404251.0 6660135.0,401283.0 6663962.0,392012.0 6664073.0,385082.0 6667087.0,376108.0 6673611.0,374065.0 6668782.0,367645.0 6668175.0,367588.0 6659427.0,361112.0 6656907.0,359840.0 6669393.0,354394.0 6667534.0,354064.0 6663454.0,357453.0 6652400.0,353671.0 6649968.0,343129.0 6653969.0,338731.0 6658583.0,332678.0 6659222.0,324590.0 6666698.0,322009.0 6670666.0)))",
            ],
            [
                "83",
                "VAR",
                "SRID=2154;POLYGON ((917346.0 6234793.0,919352.0 6230892.0,929076.0 6227424.0,928534.0 6223947.0,932969.0 6220583.0,939545.0 6227616.0,947016.0 6224540.0,954550.0 6225038.0,959301.0 6228480.0,965861.0 6230140.0,974387.0 6227034.0,975697.0 6233209.0,984286.0 6234176.0,989472.0 6238682.0,995722.0 6237173.0,997536.0 6239863.0,998568.0 6249133.0,997443.0 6253468.0,1002933.0 6264260.0,1012590.0 6265313.0,1018256.0 6272482.0,1014132.0 6274778.0,1015523.0 6285590.0,1006552.0 6288390.0,1003290.0 6292496.0,1002326.0 6300425.0,992638.0 6305621.0,983574.0 6307147.0,974774.0 6305117.0,974848.0 6301646.0,970413.0 6298787.0,958836.0 6305328.0,956283.0 6301072.0,944763.0 6293054.0,933734.0 6296912.0,923991.0 6299127.0,922160.0 6296144.0,921881.0 6295602.0,926823.0 6291811.0,925792.0 6288611.0,917893.0 6286245.0,916541.0 6283087.0,920209.0 6276225.0,918385.0 6268519.0,922861.0 6263349.0,917403.0 6259253.0,924245.0 6244827.0,918110.0 6241136.0,917346.0 6234793.0))",
            ],
            [
                "94",
                "VAL-DE-MARNE",
                "SRID=2154;POLYGON ((670056.0 6856451.0,662997.0 6862431.0,657169.0 6861180.0,650942.0 6857646.0,650056.0 6850064.0,653706.0 6846856.0,663488.0 6848458.0,668472.0 6843626.0,671600.0 6851283.0,670056.0 6856451.0))",
            ],
            [
                "92",
                "HAUTS-DE-SEINE",
                "SRID=2154;POLYGON ((650942.0 6857646.0,645325.0 6859675.0,643644.0 6863501.0,650140.0 6866932.0,648071.0 6872567.0,641404.0 6867928.0,637864.0 6864035.0,637702.0 6857774.0,643163.0 6853168.0,650056.0 6850064.0,650942.0 6857646.0))",
            ],
            [
                "48",
                "LOZERE",
                "SRID=2154;POLYGON ((698547.0 6393953.0,706639.0 6384441.0,705449.0 6378272.0,710800.0 6372878.0,709537.0 6364934.0,712305.0 6356606.0,709994.0 6353946.0,718362.0 6347498.0,728598.0 6344387.0,729879.0 6341376.0,735189.0 6336775.0,750700.0 6336169.0,750995.0 6342037.0,754256.0 6342872.0,763780.0 6336809.0,768987.0 6337162.0,776174.0 6341769.0,775968.0 6350322.0,773621.0 6356674.0,775941.0 6359276.0,770571.0 6365836.0,775211.0 6367175.0,779411.0 6373918.0,775042.0 6386528.0,771844.0 6388592.0,768276.0 6405343.0,758530.0 6415778.0,752669.0 6414624.0,752090.0 6419191.0,746937.0 6419760.0,746579.0 6414955.0,737614.0 6413026.0,732994.0 6422485.0,732563.0 6427378.0,728488.0 6430309.0,719705.0 6424147.0,714401.0 6418301.0,708330.0 6420849.0,707862.0 6414941.0,704864.0 6413115.0,698547.0 6393953.0))",
            ],
            [
                "13",
                "BOUCHES-DU-RHONE",
                "SRID=2154;POLYGON ((799607.0 6263119.0,825918.0 6262030.0,828657.0 6259471.0,826719.0 6253810.0,834804.0 6251115.0,842728.0 6251679.0,850515.0 6249931.0,851283.0 6257962.0,859395.0 6260541.0,865618.0 6249711.0,881792.0 6250642.0,887411.0 6254047.0,891677.0 6249845.0,890480.0 6245406.0,892188.0 6237089.0,906247.0 6238345.0,911635.0 6232742.0,917346.0 6234793.0,918110.0 6241136.0,924245.0 6244827.0,917403.0 6259253.0,922861.0 6263349.0,918385.0 6268519.0,920209.0 6276225.0,916541.0 6283087.0,917893.0 6286245.0,925792.0 6288611.0,926823.0 6291811.0,921881.0 6295602.0,910307.0 6287877.0,904218.0 6287715.0,896706.0 6289935.0,886796.0 6295631.0,879627.0 6296831.0,876282.0 6295340.0,865136.0 6300908.0,863255.0 6305296.0,858049.0 6310039.0,848847.0 6314233.0,839658.0 6315433.0,831988.0 6308980.0,833168.0 6302217.0,828463.0 6288899.0,819908.0 6290041.0,815212.0 6281222.0,813903.0 6274579.0,800175.0 6267290.0,799607.0 6263119.0),(869889.0 6258065.0,866899.0 6258272.0,866104.0 6264876.0,862374.0 6265459.0,862969.0 6272152.0,870516.0 6271879.0,874819.0 6259107.0,869889.0 6258065.0))",
            ],
            [
                "75",
                "PARIS",
                "SRID=2154;POLYGON ((650942.0 6857646.0,657169.0 6861180.0,654926.0 6867065.0,650140.0 6866932.0,643644.0 6863501.0,645325.0 6859675.0,650942.0 6857646.0))",
            ],
            [
                "93",
                "SEINE-SAINT-DENIS",
                "SRID=2154;POLYGON ((670056.0 6856451.0,667928.0 6865519.0,670882.0 6870004.0,667303.0 6878971.0,660416.0 6872923.0,653619.0 6875101.0,648071.0 6872567.0,650140.0 6866932.0,654926.0 6867065.0,657169.0 6861180.0,662997.0 6862431.0,670056.0 6856451.0))",
            ],
        ],
    },
    4: {
        "geolayer": geolayer_attributes_to_force_only_forced,
        "return_value": [
            [
                586,
                [5879, 8557],
                8789.98,
                [89798.3654, 8757.0],
                None,
                datetime.date(2020, 3, 31),
                "18:41:04",
                b"\x00\x00\x00\x00\x04\x00\x00\x00\x02\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01?\xf0\x00\x00\x00\x00\x00\x00?\xf0\x00\x00\x00\x00\x00\x00",
                True,
                None,
                None,
            ],
            [
                1466,
                [987, 2345],
                8789.0,
                [2.0, 5.0],
                "salut",
                None,
                "11:22:10.000999",
                b"\x00\x00\x00\x00\x01@\xef\xf3k\n=p\xa4@\xbd\xe6\x8b\x02\x0cI\xba",
                False,
                ["hi", "mister"],
                datetime.datetime(2020, 3, 31, 11, 22, 10, 999),
            ],
            [
                149,
                [987, 2345],
                8789.0,
                [2.0, 5.0],
                "2020-03-31 11:22:10.000999",
                None,
                "11:22:10.000999",
                b"\x00\x00\x00\x00\x01@\xef\xf3k\n=p\xa4@\xbd\xe6\x8b\x02\x0cI\xba",
                True,
                ["hi", "mister"],
                datetime.datetime(2020, 3, 31, 11, 22, 10, 999),
            ],
        ],
    },
}

method_execute_batch_parameters = {
    0: {

    }
}


def test_all():

    if import_psycopg2_success is True:
        # fields_metadata_to_create_table_fields_structure_parameters
        print(
            test_function(
                fields_metadata_to_create_table_fields_structure,
                fields_metadata_to_create_table_fields_structure_parameters,
            )
        )

        # geolayer_to_postgres_parameters
        print(test_function(geolayer_to_postgres, geolayer_to_postgres_parameters))

        # geometry_ref_to_geometry_field_structure
        print(
            test_function(
                geometry_ref_to_geometry_field_structure,
                geometry_ref_to_geometry_field_structure_parameters,
            )
        )

        # format_to_posgresq_values
        print(
            test_function(
                format_to_posgresq_values, format_to_posgresq_values_parameters
            )
        )


if __name__ == "__main__":
    test_all()
