#!/usr/bin/env python
# -*- coding:utf-8 -*-
__author__ = 'bee'

from django.conf.urls import include, url
from . import views

app_name = 'bee_django_referral'

urlpatterns = [
    url(r'^test$', views.test, name='test'),
    url(r'^$', views.ActivityList.as_view(), name='index'),
    url(r'^activity/list/$', views.ActivityList.as_view(), name='activity_list'),
    url(r'^activity/detail/(?P<pk>[0-9]+)$', views.ActivityDetail.as_view(), name='activity_detail'),
    url(r'^activity/add/$', views.ActivityCreate.as_view(), name='activity_add'),
    url(r'^activity/update/(?P<pk>[0-9]+)/$', views.ActivityUpdate.as_view(), name='activity_update'),
    url(r'^activity/qrcode/upload/(?P<pk>[0-9]+)/$', views.ActivityQrcodeUpload.as_view(),
        name='activity_qrcode_upload'),
    url(r'^activity/qrcode/update/(?P<pk>[0-9]+)/$', views.ActivityQrcodeUpdate.as_view(),
        name='activity_qrcode_update'),

    # 用户活动页

    url(r'^user/activity/detail/(?P<user_id>[0-9]+)/(?P<pk>[0-9]+)/$', views.UserActivityDetail.as_view(),
        name='user_activity_detail'),
    # 新用户注册页
    url(r'^preuser/reg/(?P<activity_id>[0-9]+)/$', views.PreuserReg.as_view(),
        name='preuser_reg'),

]
