[![@wq/app][logo]][docs]

**@wq/app** provides a configuration-driven JavaScript application controller to facilitate the creation of complete mobile web apps for viewing and submitting field data.   @wq/app is the highest-level module in [wq.app], and brings together a number of lower-level modules and wq conventions into an integrated API.  @wq/app is primarily intended for use as a client for [wq.db], but can be customized for use with any REST service.

The specific concepts leveraged by @wq/app include:

 * A specific [URL structure][url-structure] that is observed by both the application itself and its REST API.
 * A client-side URL router ([@wq/router]) and page renderer ([@wq/react] + [@wq/material])
 * A model-driven, `localForage`-backed cache of REST API responses ([@wq/model]), with an offline-capable outbox to sync form submissions back to the server ([@wq/outbox]).
 * A [wq configuration object][config] generated by the URL router on the server, that describes the available routes and underlying models.
 * An optional [authentication][auth] endpoint provided by the REST API, including CSRF tokens to prevent cross-site attacks.
 * A simple [plugin API][plugins] to facilitate adding optional functionality such as interactive [maps][@wq/map] or even a fully custom data model (via plugin hooks).

### [Documentation][docs]

[**Installation**][installation]
&bull;
[Project Layout][project-layout]
&bull;
[**API**][api]
&bull;
[**Configuration**][configuration]
&bull;
[**Plugins**][plugins]
&bull;
[**Methods**][methods]

[logo]: https://wq.io/images/@wq/app.svg
[docs]: https://wq.io/@wq/app
[installation]: https://wq.io/@wq/app#installation
[project-layout]: https://wq.io/@wq/app#project-layout
[api]: https://wq.io/@wq/app#api
[configuration]: https://wq.io/@wq/app#configuration
[plugins]: https://wq.io/plugins/
[methods]: https://wq.io/@wq/app#methods

[wq.app]: https://wq.io/wq.app/
[wq.db]: https://wq.io/wq.db/
[@wq/store]: https://wq.io/@wq/store
[@wq/model]: https://wq.io/@wq/model
[@wq/router]: https://wq.io/@wq/router
[@wq/outbox]: https://wq.io/@wq/outbox
[@wq/react]: https://wq.io/@wq/react
[@wq/material]: https://wq.io/@wq/material
[@wq/map]: https://wq.io/@wq/map
[url-structure]: https://wq.io/wq.db/url-structure
[config]: https://wq.io/config
[auth]: https://wq.io/wq.db/auth
