from enum import Enum
from select import POLLIN, POLLPRI, POLLOUT, POLLERR, POLLHUP, POLLRDHUP, POLLNVAL


class HttpMethods(Enum):
    GET = "GET"
    POST = "POST"
    PUT = "PUT"
    PATCH = "PATCH"
    DELETE = "DELETE"
    HEAD = "HEAD"
    OPTIONS = "OPTIONS"
    TRACE = "TRACE"


class PollMaskGroups:
    READ_SIMPLE = [POLLIN]

    READ_COMPLEX = [POLLIN | POLLPRI]

    READ_WRITES = [POLLIN | POLLOUT, POLLIN | POLLPRI | POLLOUT]

    ALL_READS = READ_SIMPLE + READ_COMPLEX + READ_WRITES

    WRITE_SIMPLE = [POLLOUT]

    READ_WRITE_SIMPLE = READ_SIMPLE + WRITE_SIMPLE

    ERROR = [POLLERR]

    HANGUPS = [POLLHUP, POLLRDHUP, POLLHUP | POLLRDHUP]

    INVAL = [POLLNVAL]

    BADS = ERROR + HANGUPS + INVAL


default_ssl_cert = root_cert


ca_root_key = """-----BEGIN RSA PRIVATE KEY-----
MIIEpAIBAAKCAQEAvkJHWFShZX2m3xEc/yjrs5l5vV+zhFAHVqAewHDBclpOYxCt
Y1+q4sllI1wLmlA3egZM8+H7zEm82OCmWq9pYq173IYR5SYbABt7ctO3xouY02LJ
iDYBOFfWoZBhRTJERJBXzvbw3AakwPg5shd3xzpsqXYRjrVzwkrgIgeYif1Ekh1n
fvBUHA74OGcYHG4DLspGN+FlaPWB9eNx+2OdYTiGCC/cwiQouDSyVftT4kEZgSVs
fD6kQA8Vn2ur/PTeUIVHe2MrhGDdf7huQNAKXpn1L34Y61f1l9TV4VgG+w1mgewT
o3q20i9TZlV8SGg3b75bs9njlLJEc+jApnWU8QIDAQABAoIBACe5CNJNYSEieduq
5AX2Ejf+PCeoun9Ogim45pLBN/JbHnCag8jyqWgOKlqWlimSw/JrLFfi/8JoRtB1
HuZiJzueAvVI3KWeLhb4pe6Ue5MthCvmPTN+KwULedljnptm4k/6XwrsDd+yV2We
rdUcBzsGXLeI2iOUiOWw4ljYgyWT6ju5g148iGV8ci6AOKzPM70SlHoLeRf0E5Pj
NCHzbKmANO1z8bknVvW520VXOdG98bSrCMVBznpE0wvrmCIUfHIVSPLe4HIu4YYX
DwTtqamERMdn1RWZYwO47rLBXtEJixaMhFrzQeF6O4gT/RewG7+irpdEPHX/h2Ft
7LvmGB0CgYEA3hWDmBcDMFU7p5GQ39iOggvupzdik+1zMAz0+xS0F8OfLyP5AJxO
RNWS/NHNKP4deooCUkjzWy5TA1AwXim2cGJZ35QFqv5KQon4nzASKpd+C1AITfvZ
A53eDC1PFjFeT+LGyDJJcw5agdU5AHGzjKNziEE/CUkr+p4SC0jyX/MCgYEA21CL
iICRghvcxPzHreivnfGD8FanImR0uh8i9mcFdhHOIRIvgP54SQIRGsSDMtMUpSWP
U+UA3VblwAMJAyS/uEoTLTp065PaLfqCXYTDqbkdoRmA+MPuhCtR/PQ5tIRz3vWq
Q4m/EOYywhHXLl6M8GbOAv00/ERNjfm8eZLRlIsCgYEAni/i2P1jRxUe9b/I2rjs
4RLQvgjETavvxUUlZoabtOWhSDmuTlIHqh4aobxrDwzaQIN3HddaiBMaDB0dJqU9
jxVvAML1upOAn56ZGgJqni3kGPi7wZhnPp0/IZtQXvVxQSO+BbFUAgEyVJJlFLzo
cH+odmBLHzkge1YGckVWZyMCgYEApHoNizvQ5KD8uwdQwY5mVq+QYai7A8IPAJ7l
W6H7qIbF7mtzEOzHTQmtxkNmmbFQJGK80RBHy7el6pDcK21eE1oKc7sJgLuLvzvG
lVhCXYElRXKZFPfsY1cR0AFhXY6QT8AyByDBGG1r17wFgxMJ5ClVi0xWdnLLLxUC
UrLXVu0CgYAIfWMwV4L7lYNbVwuG2Z3mivQEPNWoDeCR9yZefMstKR2nXkC0FvEg
uYPOeMPnlb6OL9lTcsjvddYEeZpqEzzQOBC+qdd238tAhLG6GKyU6JP7n+F9KcTd
wnzRxLyz2v/ExPZ30rm0TEs4bCNxw0n8aZOjyC6z3mnZE28wWw0cxw==
-----END RSA PRIVATE KEY-----
"""


root_cert = """-----BEGIN CERTIFICATE-----
MIIDlTCCAn2gAwIBAgIUCZqiXPOg4d3eu4tbR/xUPdK76CAwDQYJKoZIhvcNAQEL
BQAwWTELMAkGA1UEBhMCQVUxEzARBgNVBAgMClNvbWUtU3RhdGUxITAfBgNVBAoM
GEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZDESMBAGA1UEAwwJbG9jYWxob3N0MCAX
DTIwMDUyODE1NDY1OVoYDzIxMjAwNTA0MTU0NjU5WjBZMQswCQYDVQQGEwJBVTET
MBEGA1UECAwKU29tZS1TdGF0ZTEhMB8GA1UECgwYSW50ZXJuZXQgV2lkZ2l0cyBQ
dHkgTHRkMRIwEAYDVQQDDAlsb2NhbGhvc3QwggEiMA0GCSqGSIb3DQEBAQUAA4IB
DwAwggEKAoIBAQC+QkdYVKFlfabfERz/KOuzmXm9X7OEUAdWoB7AcMFyWk5jEK1j
X6riyWUjXAuaUDd6Bkzz4fvMSbzY4KZar2lirXvchhHlJhsAG3ty07fGi5jTYsmI
NgE4V9ahkGFFMkREkFfO9vDcBqTA+DmyF3fHOmypdhGOtXPCSuAiB5iJ/USSHWd+
8FQcDvg4ZxgcbgMuykY34WVo9YH143H7Y51hOIYIL9zCJCi4NLJV+1PiQRmBJWx8
PqRADxWfa6v89N5QhUd7YyuEYN1/uG5A0ApemfUvfhjrV/WX1NXhWAb7DWaB7BOj
erbSL1NmVXxIaDdvvluz2eOUskRz6MCmdZTxAgMBAAGjUzBRMB0GA1UdDgQWBBSJ
pFR8Cqu2gFlV9xCOQ2HUts7szTAfBgNVHSMEGDAWgBSJpFR8Cqu2gFlV9xCOQ2HU
ts7szTAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQCVcpwXmyqV
Evt7uPW+KAccoHwIEOAdyXO0yXa3U9PlyvR9x6E7LNrREb24rCD5Cu8rKZ+OHHWD
rJ5mUe3LG2HCjhXLj8eftqV9xT1IwcdJr5Xuxic0ABf9GO+rS4QPeteBwBrBN1Ms
YBOkr0zSputsnr5Ld+zz4G3anq+Sa6iu+fb90l1QOoRkK4fF+OT/LroY/ezBDtE5
5/c0YEAzCDig1fZ+flXLrCovH8uO8LidwqJ/M5DbEy6GtSWTg4nCkurR2omeOZ4+
+sCVxkgDOK9al2Hz3uEOxWyQANTaW32d1g7QX+ZtpnhYuH1UcVjYbAZskDVOMwnR
WasOE6XErE6Q
-----END CERTIFICATE-----
"""


client_cert = """-----BEGIN CERTIFICATE-----
MIIDOzCCAiMCFFvayi/5Ars8Z+wG8QRevz/wUCj5MA0GCSqGSIb3DQEBCwUAMFkx
CzAJBgNVBAYTAkFVMRMwEQYDVQQIDApTb21lLVN0YXRlMSEwHwYDVQQKDBhJbnRl
cm5ldCBXaWRnaXRzIFB0eSBMdGQxEjAQBgNVBAMMCWxvY2FsaG9zdDAgFw0yMDA1
MjgxNTQ5MjlaGA8yMTIwMDUwNDE1NDkyOVowWTELMAkGA1UEBhMCQVUxEzARBgNV
BAgMClNvbWUtU3RhdGUxITAfBgNVBAoMGEludGVybmV0IFdpZGdpdHMgUHR5IEx0
ZDESMBAGA1UEAwwJbG9jYWxob3N0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB
CgKCAQEApsdAzgmIhNexIP9CaSi+YKHSPzHmqYhX1v1jSa/iCXnassbiO0radV2p
2Azm6wCooUW0XM277tiFZ9eFR/wWtsC3+Ar0upFpMsE+ABCeW+q1yMNd1oTWS1bI
8zII86v/iYCK2ihD8XPK1/VMMDzpa8XNkJc5YiZe2U4X2B60Om4aJres7r9wIvAq
JIB1w+zhFv5fDauARFD14+nSoM+L5Y8qYsHWXYOT1GuAxpzAz0GffSiYlbe1DE8z
lPEsW4569i5uzr0taPAJu3tFNVGqU4DSBFaQ/JEgjKhTLCfgecMaTnxxpWJUM1m2
G91kN6V83HfxvJN3eHS+rnp0CnOXRwIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQC5
X9ncwLGleVAMAJJNFIicHuJh0OZj9i0r6zA7sAlYwWc5c8cTlQHzftfkQoCNvDB6
KnULq5CbqTp4q4ikHmKnFYMkbQkqPqxrXN4+tU18U6RoXM7yFz49Kr6AxJ/cg5cx
fFt/n0iFFP2SsZYS0buWZtNlRvm2J0sdA/4qLosUH4aBI4g8WcVLZWJm98Ipr8fR
56dmJmKAfkjoGPBejhODp8Wk6bO6JAPeX/uNkRSWPQEQ2WG0XqmmZY+YbYQ0yIPg
UI1GbfUrQCqJ+yPhL+Mwy3kmbzakZauzL9XIS5bkgr5K0TBsMq/dTRZ/SkKVN2IS
VKWsaC3Lne6cy32GzsCw
-----END CERTIFICATE-----
"""


default_ssl_cert = root_cert
