"""
@author  : MG
@Time    : 2020/11/12 10:04
@File    : constants.py
@contact : mmmaaaggg@163.com
@desc    : 用于保存部分公共常数
"""
import collections
from datetime import time

# 记录每个合约乘数的dict
SYMBOL_SIZE_DIC = {
    "CU": 5.0,
    "ZC": 100.0,
    "PP": 5.0,
    "V": 5.0,
    "C": 10.0,
    "SN": 1.0,
    "AL": 5.0,
    "P": 10.0,
    "IC": 200.0,
    "ZN": 5.0,
    "L": 5.0,
    "RB": 10.0,
    "M": 10.0,
    "T": 10000.0,
    "SR": 10.0,
    "CS": 10.0,
    "IH": 300.0,
    "CF": 5.0,
    "JM": 60.0,
    "TA": 5.0,
    "ME": 50.0,
    "RU": 10.0,
    "A": 10.0,
    "PB": 5.0,
    "B": 10.0,
    "OI": 10.0,
    "FG": 20.0,
    "JD": 10.0,
    "AU": 1000.0,
    "AG": 15.0,
    "RO": 5.0,
    "TF": 10000.0,
    "Y": 10.0,
    "TC": 200.0,
    "NI": 1.0,
    "BU": 10.0,
    "J": 100.0,
    "TS": 20000.0,
    "HC": 10.0,
    "SC": 1000.0,
    "IF": 300.0,
    "MA": 10.0,
    "RM": 10.0,
    "I": 100.0
}

# 记录每个合约每天分钟数的dict
SYMBOL_MINUTES_COUNT_DIC = collections.defaultdict(
    lambda: 350, [
        ('RB', 350),
        ('I', 380),
        ('HC', 350),
    ])

_INSTRUMENT_TRADE_TIME_PAIR_DIC = {
    "IF": ["9:30:00", "15:00:00"],
    "IC": ["9:30:00", "15:00:00"],
    "IH": ["9:30:00", "15:00:00"],
    "T": ["9:30:00", "15:15:00"],
    "AU": ["21:00:00", "2:30:00"],
    "AG": ["21:00:00", "2:30:00"],
    "CU": ["21:00:00", "1:00:00"],
    "AL": ["21:00:00", "1:00:00"],
    "ZN": ["21:00:00", "1:00:00"],
    "PB": ["21:00:00", "1:00:00"],
    "NI": ["21:00:00", "1:00:00"],
    "SN": ["21:00:00", "1:00:00"],
    "RB": ["21:00:00", "23:00:00"],
    "I": ["21:00:00", "23:00:00"],
    "HC": ["21:00:00", "23:00:00"],
    "SS": ["21:00:00", "1:00:00"],
    "SF": ["9:00:00", "15:00:00"],
    "SM": ["9:00:00", "15:00:00"],
    "JM": ["21:00:00", "23:00:00"],
    "J": ["21:00:00", "23:00:00"],
    "ZC": ["21:00:00", "23:00:00"],
    "FG": ["21:00:00", "23:00:00"],
    "SP": ["21:00:00", "23:00:00"],
    "FU": ["21:00:00", "23:00:00"],
    "LU": ["21:00:00", "23:00:00"],
    "SC": ["21:00:00", "2:30:00"],
    "BU": ["21:00:00", "23:00:00"],
    "PG": ["21:00:00", "23:00:00"],
    "RU": ["21:00:00", "23:00:00"],
    "NR": ["21:00:00", "23:00:00"],
    "L": ["21:00:00", "23:00:00"],
    "TA": ["21:00:00", "23:00:00"],
    "V": ["21:00:00", "23:00:00"],
    "EG": ["21:00:00", "23:00:00"],
    "MA": ["21:00:00", "23:00:00"],
    "PP": ["21:00:00", "23:00:00"],
    "EB": ["21:00:00", "23:00:00"],
    "UR": ["9:00:00", "15:00:00"],
    "SA": ["21:00:00", "23:00:00"],
    "C": ["21:00:00", "23:00:00"],
    "A": ["21:00:00", "23:00:00"],
    "CS": ["21:00:00", "23:00:00"],
    "B": ["21:00:00", "23:00:00"],
    "M": ["21:00:00", "23:00:00"],
    "Y": ["21:00:00", "23:00:00"],
    "RM": ["21:00:00", "23:00:00"],
    "OI": ["21:00:00", "23:00:00"],
    "P": ["21:00:00", "23:00:00"],
    "CF": ["21:00:00", "23:00:00"],
    "SR": ["21:00:00", "23:00:00"],
    "JD": ["9:00:00", "15:00:00"],
    "AP": ["9:00:00", "15:00:00"],
    "CJ": ["9:00:00", "15:00:00"]
}
INSTRUMENT_TRADE_TIME_PAIR_DIC = {
    key: [
        time(*[int(_) for _ in values[0].split(':')]),
        time(*[int(_) for _ in values[1].split(':')]),
    ]
    for key, values in _INSTRUMENT_TRADE_TIME_PAIR_DIC.items()}
