"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const logs_generated_1 = require("./logs.generated");
/**
 * Define a Log Stream in a Log Group
 */
class LogStream extends core_1.Resource {
    /**
     * Import an existing LogGroup
     */
    static fromLogStreamName(scope, id, logStreamName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.logStreamName = logStreamName;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.logStreamName,
        });
        const resource = new logs_generated_1.CfnLogStream(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            logStreamName: this.physicalName,
        });
        resource.applyRemovalPolicy(props.removalPolicy);
        this.logStreamName = this.getResourceNameAttribute(resource.ref);
    }
}
exports.LogStream = LogStream;
//# sourceMappingURL=data:application/json;base64,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