"use strict";
const assert_1 = require("@aws-cdk/assert");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'simple destination'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const role = new iam.Role(stack, 'Role', {
            assumedBy: new iam.ServicePrincipal('logs.us-east-2.amazonaws.com')
        });
        // WHEN
        new lib_1.CrossAccountDestination(stack, 'Dest', {
            destinationName: 'MyDestination',
            role,
            targetArn: 'arn:bogus'
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::Destination', {
            DestinationName: 'MyDestination',
            RoleArn: { "Fn::GetAtt": ["Role1ABCC5F0", "Arn"] },
            TargetArn: 'arn:bogus',
        }));
        test.done();
    },
    'add policy to destination'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const role = new iam.Role(stack, 'Role', {
            assumedBy: new iam.ServicePrincipal('logs.us-east-2.amazonaws.com')
        });
        const dest = new lib_1.CrossAccountDestination(stack, 'Dest', {
            destinationName: 'MyDestination',
            role,
            targetArn: 'arn:bogus'
        });
        // WHEN
        dest.addToPolicy(new iam.PolicyStatement({
            actions: ['logs:TalkToMe']
        }));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Logs::Destination', (props) => {
            const pol = JSON.parse(props.DestinationPolicy);
            return pol.Statement[0].Action === 'logs:TalkToMe';
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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