"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGeneratorIgnoreFile = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const projen_1 = require("projen");
/**
 * Represents an .openapi-generator-ignore file
 * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/customization.md#ignore-file-format
 */
class OpenApiGeneratorIgnoreFile extends projen_1.IgnoreFile {
    constructor(project) {
        super(project, ".openapi-generator-ignore");
        // We should always use the projen .gitignore since projen manages the build, and therefore the ignored build
        // artifacts
        this.addPatterns(".gitignore");
    }
}
exports.OpenApiGeneratorIgnoreFile = OpenApiGeneratorIgnoreFile;
//# sourceMappingURL=data:application/json;base64,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