import { ClientLanguage } from "../../languages";
/**
 * Enum for generator directories for non-client generators
 */
export declare enum NonClientGeneratorDirectory {
    DOCS = "docs"
}
/**
 * Generator directory for openapi generation containing templates, config etc.
 */
export declare type GeneratorDirectory = ClientLanguage | NonClientGeneratorDirectory;
/**
 * Options for generating client code or docs using OpenAPI Generator CLI
 */
export interface GenerationOptions {
    /**
     * The OpenAPI generator to use to generate the code/docs
     */
    readonly generator: string;
    /**
     * The directory to use for OpenAPI generation
     */
    readonly generatorDirectory: GeneratorDirectory;
    /**
     * The path of the OpenAPI spec to generate the client for
     */
    readonly specPath: string;
    /**
     * The directory in which the generated code should be output
     */
    readonly outputPath: string;
    /**
     * Additional properties to pass to the generate cli
     */
    readonly additionalProperties?: {
        [key: string]: string;
    };
}
/**
 * Generate client code or docs by invoking the root generate script
 */
export declare const invokeOpenApiGenerator: (options: GenerationOptions) => void;
