import { Project } from "projen";
import { ClientLanguage } from "../languages";
import { GeneratedJavaClientProjectOptions } from "./generated-java-client-project";
import { GeneratedPythonClientProjectOptions } from "./generated-python-client-project";
import { GeneratedTypescriptClientProjectOptions } from "./generated-typescript-client-project";
declare type CommonProjectOptions = "specPath" | "name" | "outdir" | "moduleName" | "artifactId" | "groupId";
/**
 * Options for generating clients
 */
export interface GenerateClientProjectsOptions {
    /**
     * The parent project for the generated clients
     */
    readonly parent: Project;
    /**
     * The name of the api package, used to infer client names unless overrides are specified
     */
    readonly parentPackageName: string;
    /**
     * The directory in which to generate code for all clients
     */
    readonly generatedCodeDir: string;
    /**
     * Path to the parsed spec file
     * We use the parsed spec such that refs are resolved to support multi-file specs
     */
    readonly parsedSpecPath: string;
    /**
     * Options for the typescript client project.
     * These will override any inferred properties (such as the package name).
     */
    readonly typescriptOptions: Omit<GeneratedTypescriptClientProjectOptions, CommonProjectOptions>;
    /**
     * Options for the python client project
     * These will override any inferred properties (such as the package name).
     */
    readonly pythonOptions: Omit<GeneratedPythonClientProjectOptions, CommonProjectOptions>;
    /**
     * Options for the java client project
     * These will override any inferred properties (such as the package name).
     */
    readonly javaOptions: Omit<GeneratedJavaClientProjectOptions, CommonProjectOptions>;
}
/**
 * Generate API clients in the given languages
 * @param languages the languages to generate clients for
 * @param options options for the projects to be created
 */
export declare const generateClientProjects: (languages: Set<ClientLanguage>, options: GenerateClientProjectsOptions) => {
    [language: string]: Project;
};
export {};
