# CFM-ID Python Package

This package is a Python wrapper to use CFM-ID : https://cfmid.wishartlab.com

> CFM-ID provides a method for accurately and efficiently identifying metabolites
> in spectra generated by electrospray tandem mass spectrometry (ESI-MS/MS).
> The program uses Competitive Fragmentation Modeling to produce a probabilistic generative model
> for the MS/MS fragmentation process and machine learning techniques to adapt the model parameters from data.

This package is under devopment and work only for `cfm-predict` of the CFM-ID version 2.0.

## Install

```bash
pip install cfm-id
```

## Usage

```python
from cfm_id import CfmId

cfm_id = CfmId("/path/to/cfm_id/folder")
cfm_id.predict("O=C1OC(CO)C(O)=C1O")
```

The default output format is a list of MatchMS [`Spectrum`](https://matchms.readthedocs.io/en/latest/api/matchms.Spectrum.html),
including a "merged" spectrum of the 3 energies.

You can specify the CFM-ID raw text format export with the `raw_format` param :

```python
cfm_id.predict("O=C1OC(CO)C(O)=C1O", raw_format=True)
```

## Environment variable

You can also use environment variable `CFMID_PATH` rather than path argument.

```bash
export CFMID_PATH=path/to/cfm_id/folder
```

```python
from cfm_id import CfmId

cfm_id = CfmId()
```

## Param and config files

By default `CfmId` will use `param_output.log` and `param_config.txt` files
located at the root of the cfm_id folder as respectively param and config files.

You can specify anoter files location at instantiation with local path as ist of string :

```python
from cfm_id import CfmId

cfm_id = CfmId(
    "/path/to/cfm_id/folder",
    param=["param", "param_output0_neg.log"], conf=["conf", "param_config_neg.txt"]
)
```

In this example, the `cfm_id` instance will use `/path/to/cfm_id/folder/param/param_output0_neg.log`
as param file.

## Use Docker image

You can use a Docker image for CFM-ID rather than local files by using `CfmIdDocker` class.

```python
from cfm_id import CfmIdDocker

cfm_id = CfmIdDocker("myrepo/image_name:tag")
```

In the Docker image, `cfm-predict` has to be in the PATH environment variable
and `param_output.log` and `param_config.txt` files must be located at the working directory.

You can also use environment variable `CFMID_IMAGE` rather than path argument.

```bash
export CFMID_IMAGE=myrepo/image_name:tag
```

```python
from cfm_id import CfmIdDocker

cfm_id = CfmIdDocker()
```
