# -*- coding: utf-8 -*-
# Generated by Django 1.10.1 on 2016-11-25 11:04
from __future__ import unicode_literals

from django.db import migrations, models


def set_taken_year(apps, schema_editor):
    """
    Sets the `taken_year` value on every Photo.
    """
    Photo = apps.get_model("flickr", "Photo")
    for row in Photo.objects.all():
        if row.taken_time:
            row.taken_year = row.taken_time.year
            row.save()


class Migration(migrations.Migration):

    dependencies = [
        ("flickr", "0021_photo_post_year"),
    ]

    operations = [
        migrations.AddField(
            model_name="photo",
            name="taken_year",
            field=models.PositiveSmallIntegerField(
                blank=True,
                db_index=True,
                help_text="Set automatically on save",
                null=True,
            ),
        ),
        migrations.RunPython(set_taken_year, reverse_code=migrations.RunPython.noop),
    ]
