import { Resource, ResourceProps } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { AuthorizationType } from './method';
import { IRestApi } from './restapi';
/**
 * Base class for all custom authorizers.
 *
 * @stability stable
 */
export declare abstract class Authorizer extends Resource implements IAuthorizer {
    /**
     * Return whether the given object is an Authorizer.
     *
     * @stability stable
     */
    static isAuthorizer(x: any): x is Authorizer;
    /**
     * The authorizer ID.
     *
     * @stability stable
     */
    abstract readonly authorizerId: string;
    /**
     * The authorization type of this authorizer.
     *
     * @stability stable
     */
    readonly authorizationType?: AuthorizationType;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ResourceProps);
    /**
     * Called when the authorizer is used from a specific REST API.
     * @internal
     */
    abstract _attachToApi(restApi: IRestApi): void;
}
/**
 * Represents an API Gateway authorizer.
 *
 * @stability stable
 */
export interface IAuthorizer {
    /**
     * The authorizer ID.
     *
     * @stability stable
     * @attribute true
     */
    readonly authorizerId: string;
    /**
     * The authorization type of this authorizer.
     *
     * @stability stable
     */
    readonly authorizationType?: AuthorizationType;
}
