"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitySource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents an identity source.
 *
 * The source can be specified either as a literal value (e.g: `Auth`) which
 * cannot be blank, or as an unresolved string token.
 *
 * @stability stable
 */
class IdentitySource {
    /**
     * Provides a properly formatted header identity source.
     *
     * @param headerName the name of the header the `IdentitySource` will represent.
     * @returns a header identity source.
     * @stability stable
     */
    static header(headerName) {
        return IdentitySource.toString(headerName, 'method.request.header');
    }
    /**
     * Provides a properly formatted query string identity source.
     *
     * @param queryString the name of the query string the `IdentitySource` will represent.
     * @returns a query string identity source.
     * @stability stable
     */
    static queryString(queryString) {
        return IdentitySource.toString(queryString, 'method.request.querystring');
    }
    /**
     * Provides a properly formatted API Gateway stage variable identity source.
     *
     * @param stageVariable the name of the stage variable the `IdentitySource` will represent.
     * @returns an API Gateway stage variable identity source.
     * @stability stable
     */
    static stageVariable(stageVariable) {
        return IdentitySource.toString(stageVariable, 'stageVariables');
    }
    /**
     * Provides a properly formatted request context identity source.
     *
     * @param context the name of the context variable the `IdentitySource` will represent.
     * @returns a request context identity source.
     * @stability stable
     */
    static context(context) {
        return IdentitySource.toString(context, 'context');
    }
    static toString(source, type) {
        if (!source.trim()) {
            throw new Error('IdentitySources must be a non-empty string.');
        }
        return `${type}.${source}`;
    }
}
exports.IdentitySource = IdentitySource;
_a = JSII_RTTI_SYMBOL_1;
IdentitySource[_a] = { fqn: "@aws-cdk/aws-apigateway.IdentitySource", version: "1.93.0" };
//# sourceMappingURL=data:application/json;base64,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