"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DrdsInstance = exports.DrdsInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const drds_generated_1 = require("./drds.generated");
Object.defineProperty(exports, "DrdsInstanceProperty", { enumerable: true, get: function () { return drds_generated_1.RosDrdsInstance; } });
/**
 * A ROS resource type:  `ALIYUN::DRDS::DrdsInstance`
 */
class DrdsInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::DRDS::DrdsInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDrdsInstance = new drds_generated_1.RosDrdsInstance(this, id, {
            description: props.description,
            zoneId: props.zoneId,
            resourceGroupId: props.resourceGroupId,
            pricingCycle: props.pricingCycle,
            instanceSeries: props.instanceSeries,
            quantity: props.quantity,
            specification: props.specification,
            duration: props.duration,
            payType: props.payType,
            vswitchId: props.vswitchId,
            type: props.type,
            mySqlVersion: props.mySqlVersion === undefined || props.mySqlVersion === null ? '5' : props.mySqlVersion,
            vpcId: props.vpcId,
            isAutoRenew: props.isAutoRenew,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDrdsInstance;
        this.attrDrdsInstanceId = rosDrdsInstance.attrDrdsInstanceId;
        this.attrInternetEndpoint = rosDrdsInstance.attrInternetEndpoint;
        this.attrIntranetEndpoint = rosDrdsInstance.attrIntranetEndpoint;
        this.attrOrderId = rosDrdsInstance.attrOrderId;
    }
}
exports.DrdsInstance = DrdsInstance;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHJkc2luc3RhbmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZHJkc2luc3RhbmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDhDQUE4QztBQUM5QyxxREFBbUQ7QUFFdkIscUdBRm5CLGdDQUFlLE9BRXdCO0FBbUZoRDs7R0FFRztBQUNILE1BQWEsWUFBYSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBMkIxQzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXdCLEVBQUUsbUNBQTJDLElBQUk7UUFDbkgsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLGVBQWUsR0FBRyxJQUFJLGdDQUFlLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNuRCxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDbEMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztZQUN0QixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWSxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsWUFBWSxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsWUFBWTtZQUN4RyxLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7WUFDbEIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtTQUNuQixFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLGVBQWUsQ0FBQztRQUNoQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsZUFBZSxDQUFDLGtCQUFrQixDQUFDO1FBQzdELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxlQUFlLENBQUMsb0JBQW9CLENBQUM7UUFDakUsSUFBSSxDQUFDLG9CQUFvQixHQUFHLGVBQWUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRSxJQUFJLENBQUMsV0FBVyxHQUFHLGVBQWUsQ0FBQyxXQUFXLENBQUM7SUFDbkQsQ0FBQztDQUNKO0FBNURELG9DQTREQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc0RyZHNJbnN0YW5jZSB9IGZyb20gJy4vZHJkcy5nZW5lcmF0ZWQnO1xuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXG5leHBvcnQgeyBSb3NEcmRzSW5zdGFuY2UgYXMgRHJkc0luc3RhbmNlUHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OkRSRFM6OkRyZHNJbnN0YW5jZWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEcmRzSW5zdGFuY2VQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkZXNjcmlwdGlvbjogRGVzY3JpcHRpb24gb2YgdGhlIERSRFMgaW5zdGFuY2UsIDItMTI4IGNoYXJhY3RlcnNcbiAgICAgKi9cbiAgICByZWFkb25seSBkZXNjcmlwdGlvbjogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaW5zdGFuY2VTZXJpZXM6IGRyZHMuc24xLjRjOGcgU3RhcnRlciBFZGl0aW9uOyBkcmRzLnNuMS44YzE2ZyBTdGFuZGFyZCBFZGl0aW9uOyBkcmRzLnNuMS4xNmMzMmcgQnVzaW5lc3MgRWRpdGlvbjsgZHJkcy5zbjEuMzJjNjRnIFVsdGltYXRlIEVkaXRpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBpbnN0YW5jZVNlcmllczogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcGF5VHlwZTogRm9yIHRoZSB0eXBlIG9mIHBheW1lbnQsIHNlZSBcIlBheW1lbnQgVHlwZSBQYXJhbWV0ZXIgVGFibGVcIlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBheVR5cGU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHF1YW50aXR5OiBQdXJjaGFzZSBxdWFudGl0eVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHF1YW50aXR5OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzcGVjaWZpY2F0aW9uOiBUaGUgZXhhbXBsZSBzcGVjaWZpY2F0aW9uLCBmb3IgZXhhbXBsZSwgZHJkcy5zbjEuNGM4Zy44QzE2RywgY29uc2lzdHMgb2YgdGhlIERSRFMgaW5zdGFuY2Ugc2VyaWVzIChkcmRzLnNuMS40YzhnKSBwbHVzIGEgc3BlY2lmaWMgZXhhbXBsZSBzcGVjaWZpY2F0aW9uICg4QzE2RykuIEZvciB0aGUgRFJEUyBpbnN0YW5jZSBzcGVjaWZpY2F0aW9uIHZhbHVlIHJhbmdlLCBzZWU6IERpc3RyaWJ1dGVkIFJlbGF0aW9uYWwgRGF0YWJhc2UgU2VydmljZSBTcGVjaWZpY2F0aW9ucyBhbmQgUHJpY2luZ1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHNwZWNpZmljYXRpb246IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHR5cGU6IEluc3RhbmNlIHR5cGUsIGluc3RhbmNlIHR5cGUgMCAtIHNoYXJlZCBpbnN0YW5jZSAxIC0gZXhjbHVzaXZlIGluc3RhbmNlLCBpbiBhZGRpdGlvbiwgdGhpcyBwYXJhbWV0ZXIgY2FuIGFsc28gcGFzcyBQUklWQVRFIGFuZCBQVUJMSUMgdG8gcmVwcmVzZW50IGV4Y2x1c2l2ZSBpbnN0YW5jZSBhbmQgc2hhcmVkIGluc3RhbmNlIHJlc3BlY3RpdmVseVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHR5cGU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHpvbmVJZDogQXZhaWxhYmlsaXR5IHpvbmUsIGFuIGF2YWlsYWJsZSB6b25lIGJlbG9uZ3MgdG8gYSBjZXJ0YWluIHpvbmUsIHN1Y2ggYXMgSGFuZ3pob3UgQXZhaWxhYmlsaXR5IFpvbmUgQSAoY24taGFuZ3pob3UtYSkgYmVsb25ncyB0byB0aGUgcmVnaW9uIEhhbmd6aG91IChjbi1oYW5nemhvdSlcbiAgICAgKi9cbiAgICByZWFkb25seSB6b25lSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGR1cmF0aW9uOiBUaGUgbnVtYmVyIG9mIGN5Y2xlcyBvcmRlcmVkLiBXaGVuIFByaWNpbmdDeWNsZT15ZWFyLCB0aGUgdmFsdWUgaXMgMS0zOyB3aGVuIFByaWNpbmdDeWNsZT1tb250aCwgdGhlIHZhbHVlIGlzIDEtOS4gVGhlIHBhcmFtZXRlciB0YWtlcyBlZmZlY3Qgd2hlbiB0aGUgcGF5bWVudCB0eXBlIGlzIGRyZHNQcmUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZHVyYXRpb24/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBpc0F1dG9SZW5ldzogV2hldGhlciB0byByZW5ldyB0aGUgZmVlIGF1dG9tYXRpY2FsbHksIGlmIGl0IGlzIHB1cmNoYXNlZCBvbiBhIG1vbnRobHkgYmFzaXMsIGl0IHdpbGwgYXV0b21hdGljYWxseSByZW5ldyBmb3Igb25lIG1vbnRoLCBhbmQgaWYgaXQgaXMgcHVyY2hhc2VkIG9uIGFuIGFubnVhbCBiYXNpcywgaXQgd2lsbCBhdXRvbWF0aWNhbGx5IHJlbmV3IGZvciBvbmUgeWVhci4gVGhlIHBhcmFtZXRlciB0YWtlcyBlZmZlY3Qgd2hlbiB0aGUgcGF5bWVudCB0eXBlIGlzIGRyZHNQcmUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgaXNBdXRvUmVuZXc/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbXlTcWxWZXJzaW9uOiBUaGUgTXlTUUwgcHJvdG9jb2wgdmVyc2lvbiBzdXBwb3J0ZWQgYnkgRFJEUy4gVmFsaWQgdmFsdWVzOiA1IGFuZCA4LiBEZWZhdWx0IHZhbHVlOiA1LiBUaGlzIHBhcmFtZXRlciBpcyB2YWxpZCBvbmx5IHdoZW4gdGhlIHByaW1hcnkgaW5zdGFuY2UgaXMgY3JlYXRlZC4gVGhlIHJlYWQtb25seSBpbnN0YW5jZSBpcyB0aGUgc2FtZSBhcyB0aGUgcHJpbWFyeSBpbnN0YW5jZSBieSBkZWZhdWx0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG15U3FsVmVyc2lvbj86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHByaWNpbmdDeWNsZTogVGhlIHVuaXQgb2YgdGhlIG9yZGVyIHBlcmlvZCwgeWVhcjogeWVhciwgbW9udGg6IG1vbnRoLiBUaGUgcGFyYW1ldGVyIHRha2VzIGVmZmVjdCB3aGVuIHRoZSBwYXltZW50IHR5cGUgaXMgZHJkc1ByZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBwcmljaW5nQ3ljbGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSByZXNvdXJjZUdyb3VwSWQ6IFJlc291cmNlIGdyb3VwIGlkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlc291cmNlR3JvdXBJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHRhZ3M6IFRhZ3MgdG8gYXR0YWNoIHRvIGluc3RhbmNlLiBNYXggc3VwcG9ydCAyMCB0YWdzIHRvIGFkZCBkdXJpbmcgY3JlYXRlIGluc3RhbmNlLiBFYWNoIHRhZyB3aXRoIHR3byBwcm9wZXJ0aWVzIEtleSBhbmQgVmFsdWUsIGFuZCBLZXkgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IFJvc0RyZHNJbnN0YW5jZS5UYWdzUHJvcGVydHlbXTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHZwY0lkOiBWaXJ0dWFsIHByaXZhdGUgbmV0d29yayBJRCwgbXVzdCBiZSBzcGVjaWZpZWQgd2hlbiBjcmVhdGluZyBhIERSRFMgZm9yIFZQQyBuZXR3b3JrIHR5cGVcbiAgICAgKi9cbiAgICByZWFkb25seSB2cGNJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHZzd2l0Y2hJZDogVmlydHVhbCBzd2l0Y2ggSUQsIG11c3QgYmUgc3BlY2lmaWVkIHdoZW4gY3JlYXRpbmcgYSBEUkRTIGZvciBWUEMgbmV0d29yayB0eXBlXG4gICAgICovXG4gICAgcmVhZG9ubHkgdnN3aXRjaElkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xufVxuXG4vKipcbiAqIEEgUk9TIHJlc291cmNlIHR5cGU6ICBgQUxJWVVOOjpEUkRTOjpEcmRzSW5zdGFuY2VgXG4gKi9cbmV4cG9ydCBjbGFzcyBEcmRzSW5zdGFuY2UgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIERyZHNJbnN0YW5jZUlkOiBpbnN0YW5jZSBpZFxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRHJkc0luc3RhbmNlSWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBJbnRlcm5ldEVuZHBvaW50OiBQdWJsaWMgZW5kcG9pbnRcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckludGVybmV0RW5kcG9pbnQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBJbnRyYW5ldEVuZHBvaW50OiBWUEMgZW5kcG9pbnRcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckludHJhbmV0RW5kcG9pbnQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBPcmRlcklkOiBvcmRlciBudW1iZXJcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ck9yZGVySWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpEUkRTOjpEcmRzSW5zdGFuY2VgLlxuICAgICAqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERyZHNJbnN0YW5jZVByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgICAgIGNvbnN0IHJvc0RyZHNJbnN0YW5jZSA9IG5ldyBSb3NEcmRzSW5zdGFuY2UodGhpcywgaWQsICB7XG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogcHJvcHMuZGVzY3JpcHRpb24sXG4gICAgICAgICAgICB6b25lSWQ6IHByb3BzLnpvbmVJZCxcbiAgICAgICAgICAgIHJlc291cmNlR3JvdXBJZDogcHJvcHMucmVzb3VyY2VHcm91cElkLFxuICAgICAgICAgICAgcHJpY2luZ0N5Y2xlOiBwcm9wcy5wcmljaW5nQ3ljbGUsXG4gICAgICAgICAgICBpbnN0YW5jZVNlcmllczogcHJvcHMuaW5zdGFuY2VTZXJpZXMsXG4gICAgICAgICAgICBxdWFudGl0eTogcHJvcHMucXVhbnRpdHksXG4gICAgICAgICAgICBzcGVjaWZpY2F0aW9uOiBwcm9wcy5zcGVjaWZpY2F0aW9uLFxuICAgICAgICAgICAgZHVyYXRpb246IHByb3BzLmR1cmF0aW9uLFxuICAgICAgICAgICAgcGF5VHlwZTogcHJvcHMucGF5VHlwZSxcbiAgICAgICAgICAgIHZzd2l0Y2hJZDogcHJvcHMudnN3aXRjaElkLFxuICAgICAgICAgICAgdHlwZTogcHJvcHMudHlwZSxcbiAgICAgICAgICAgIG15U3FsVmVyc2lvbjogcHJvcHMubXlTcWxWZXJzaW9uID09PSB1bmRlZmluZWQgfHwgcHJvcHMubXlTcWxWZXJzaW9uID09PSBudWxsID8gJzUnIDogcHJvcHMubXlTcWxWZXJzaW9uLFxuICAgICAgICAgICAgdnBjSWQ6IHByb3BzLnZwY0lkLFxuICAgICAgICAgICAgaXNBdXRvUmVuZXc6IHByb3BzLmlzQXV0b1JlbmV3LFxuICAgICAgICAgICAgdGFnczogcHJvcHMudGFncyxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NEcmRzSW5zdGFuY2U7XG4gICAgICAgIHRoaXMuYXR0ckRyZHNJbnN0YW5jZUlkID0gcm9zRHJkc0luc3RhbmNlLmF0dHJEcmRzSW5zdGFuY2VJZDtcbiAgICAgICAgdGhpcy5hdHRySW50ZXJuZXRFbmRwb2ludCA9IHJvc0RyZHNJbnN0YW5jZS5hdHRySW50ZXJuZXRFbmRwb2ludDtcbiAgICAgICAgdGhpcy5hdHRySW50cmFuZXRFbmRwb2ludCA9IHJvc0RyZHNJbnN0YW5jZS5hdHRySW50cmFuZXRFbmRwb2ludDtcbiAgICAgICAgdGhpcy5hdHRyT3JkZXJJZCA9IHJvc0RyZHNJbnN0YW5jZS5hdHRyT3JkZXJJZDtcbiAgICB9XG59XG4iXX0=