import * as certmgr from '@aws-cdk/aws-certificatemanager';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as rds from '@aws-cdk/aws-rds';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface KeyCloadProps {
    /**
     * VPC for the workload.
     *
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * ACM certificate ARN to import.
     *
     * @stability stable
     */
    readonly certificateArn: string;
    /**
     * Create a bastion host for debugging or trouble-shooting.
     *
     * @default false
     * @stability stable
     */
    readonly bastion?: boolean;
    /**
     * Number of keycloak node in the cluster.
     *
     * @default 1
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * VPC public subnets for ALB.
     *
     * @default - VPC public subnets
     * @stability stable
     */
    readonly publicSubnets?: ec2.SubnetSelection;
    /**
     * VPC private subnets for keycloak service.
     *
     * @default - VPC private subnets
     * @stability stable
     */
    readonly privateSubnets?: ec2.SubnetSelection;
    /**
     * VPC subnets for database.
     *
     * @default - VPC isolated subnets
     * @stability stable
     */
    readonly databaseSubnets?: ec2.SubnetSelection;
}
/**
 * @stability stable
 */
export declare class KeyCloak extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly db?: Database;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: KeyCloadProps);
    /**
     * @stability stable
     */
    addDatabase(): Database;
    /**
     * @stability stable
     */
    addKeyCloakContainerService(props: ContainerServiceProps): ContainerService;
    private _generateKeycloakSecret;
}
/**
 * @stability stable
 */
export interface DatabaseProps {
    /**
     * The VPC for the database.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * VPC public subnets for ALB.
     *
     * @stability stable
     */
    readonly publicSubnets?: ec2.SubnetSelection;
    /**
     * VPC subnets for database.
     *
     * @stability stable
     */
    readonly databaseSubnets?: ec2.SubnetSelection;
    /**
     * The database instance type.
     *
     * @stability stable
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * The database instance engine.
     *
     * @stability stable
     */
    readonly engine?: rds.IInstanceEngine;
}
/**
 * @stability stable
 */
export declare class Database extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly dbinstance: rds.DatabaseInstance;
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly clusterEndpointHostname: string;
    /**
     * @stability stable
     */
    readonly clusterIdentifier: string;
    /**
     * @stability stable
     */
    readonly secret: secretsmanager.ISecret;
    private readonly _mysqlListenerPort;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DatabaseProps);
}
/**
 * @stability stable
 */
export interface ContainerServiceProps {
    /**
     * The VPC for the service.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * VPC subnets for keycloak service.
     *
     * @stability stable
     */
    readonly privateSubnets?: ec2.SubnetSelection;
    /**
     * VPC public subnets for ALB.
     *
     * @stability stable
     */
    readonly publicSubnets?: ec2.SubnetSelection;
    /**
     * The RDS database for the service.
     *
     * @stability stable
     */
    readonly database: Database;
    /**
     * The secrets manager secret for the keycloak.
     *
     * @stability stable
     */
    readonly keycloakSecret: secretsmanager.ISecret;
    /**
     * The ACM certificate.
     *
     * @stability stable
     */
    readonly certificate: certmgr.ICertificate;
    /**
     * Whether to create the bastion host.
     *
     * @default false
     * @stability stable
     */
    readonly bastion?: boolean;
    /**
     * Whether to enable the ECS service deployment circuit breaker.
     *
     * @default false
     * @stability stable
     */
    readonly circuitBreaker?: boolean;
    /**
     * Number of keycloak node in the cluster.
     *
     * @default 1
     * @stability stable
     */
    readonly nodeCount?: number;
}
/**
 * @stability stable
 */
export declare class ContainerService extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly service: ecs.FargateService;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: ContainerServiceProps);
}
