# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from .bigquery import (
    BigQueryConnectionSpec,
    BigQueryRoutineSpec,
    CloudSqlBigQueryConnectionSpec,
)
from .common import IntegratedSystem, PersonalDetails
from .data_source import DataSource, StorageProperties
from .datacatalog import (
    BusinessContext,
    Contacts,
    CreateEntryGroupRequest,
    CreateEntryRequest,
    CreateTagRequest,
    CreateTagTemplateFieldRequest,
    CreateTagTemplateRequest,
    DatabaseTableSpec,
    DataSourceConnectionSpec,
    DeleteEntryGroupRequest,
    DeleteEntryRequest,
    DeleteTagRequest,
    DeleteTagTemplateFieldRequest,
    DeleteTagTemplateRequest,
    Entry,
    EntryGroup,
    EntryOverview,
    EntryType,
    FilesetSpec,
    GetEntryGroupRequest,
    GetEntryRequest,
    GetTagTemplateRequest,
    ListEntriesRequest,
    ListEntriesResponse,
    ListEntryGroupsRequest,
    ListEntryGroupsResponse,
    ListTagsRequest,
    ListTagsResponse,
    LookupEntryRequest,
    ModifyEntryContactsRequest,
    ModifyEntryOverviewRequest,
    RenameTagTemplateFieldEnumValueRequest,
    RenameTagTemplateFieldRequest,
    RoutineSpec,
    SearchCatalogRequest,
    SearchCatalogResponse,
    StarEntryRequest,
    StarEntryResponse,
    UnstarEntryRequest,
    UnstarEntryResponse,
    UpdateEntryGroupRequest,
    UpdateEntryRequest,
    UpdateTagRequest,
    UpdateTagTemplateFieldRequest,
    UpdateTagTemplateRequest,
)
from .dataplex_spec import (
    DataplexExternalTable,
    DataplexFilesetSpec,
    DataplexSpec,
    DataplexTableSpec,
)
from .gcs_fileset_spec import GcsFilesetSpec, GcsFileSpec
from .physical_schema import PhysicalSchema
from .policytagmanager import (
    CreatePolicyTagRequest,
    CreateTaxonomyRequest,
    DeletePolicyTagRequest,
    DeleteTaxonomyRequest,
    GetPolicyTagRequest,
    GetTaxonomyRequest,
    ListPolicyTagsRequest,
    ListPolicyTagsResponse,
    ListTaxonomiesRequest,
    ListTaxonomiesResponse,
    PolicyTag,
    Taxonomy,
    UpdatePolicyTagRequest,
    UpdateTaxonomyRequest,
)
from .policytagmanagerserialization import (
    CrossRegionalSource,
    ExportTaxonomiesRequest,
    ExportTaxonomiesResponse,
    ImportTaxonomiesRequest,
    ImportTaxonomiesResponse,
    InlineSource,
    ReplaceTaxonomyRequest,
    SerializedPolicyTag,
    SerializedTaxonomy,
)
from .schema import ColumnSchema, Schema
from .search import SearchCatalogResult, SearchResultType
from .table_spec import (
    BigQueryDateShardedSpec,
    BigQueryTableSpec,
    TableSourceType,
    TableSpec,
    ViewSpec,
)
from .tags import FieldType, Tag, TagField, TagTemplate, TagTemplateField
from .timestamps import SystemTimestamps
from .usage import UsageSignal, UsageStats

__all__ = (
    "BigQueryConnectionSpec",
    "BigQueryRoutineSpec",
    "CloudSqlBigQueryConnectionSpec",
    "PersonalDetails",
    "IntegratedSystem",
    "DataSource",
    "StorageProperties",
    "BusinessContext",
    "Contacts",
    "CreateEntryGroupRequest",
    "CreateEntryRequest",
    "CreateTagRequest",
    "CreateTagTemplateFieldRequest",
    "CreateTagTemplateRequest",
    "DatabaseTableSpec",
    "DataSourceConnectionSpec",
    "DeleteEntryGroupRequest",
    "DeleteEntryRequest",
    "DeleteTagRequest",
    "DeleteTagTemplateFieldRequest",
    "DeleteTagTemplateRequest",
    "Entry",
    "EntryGroup",
    "EntryOverview",
    "FilesetSpec",
    "GetEntryGroupRequest",
    "GetEntryRequest",
    "GetTagTemplateRequest",
    "ListEntriesRequest",
    "ListEntriesResponse",
    "ListEntryGroupsRequest",
    "ListEntryGroupsResponse",
    "ListTagsRequest",
    "ListTagsResponse",
    "LookupEntryRequest",
    "ModifyEntryContactsRequest",
    "ModifyEntryOverviewRequest",
    "RenameTagTemplateFieldEnumValueRequest",
    "RenameTagTemplateFieldRequest",
    "RoutineSpec",
    "SearchCatalogRequest",
    "SearchCatalogResponse",
    "StarEntryRequest",
    "StarEntryResponse",
    "UnstarEntryRequest",
    "UnstarEntryResponse",
    "UpdateEntryGroupRequest",
    "UpdateEntryRequest",
    "UpdateTagRequest",
    "UpdateTagTemplateFieldRequest",
    "UpdateTagTemplateRequest",
    "EntryType",
    "DataplexExternalTable",
    "DataplexFilesetSpec",
    "DataplexSpec",
    "DataplexTableSpec",
    "GcsFilesetSpec",
    "GcsFileSpec",
    "PhysicalSchema",
    "CreatePolicyTagRequest",
    "CreateTaxonomyRequest",
    "DeletePolicyTagRequest",
    "DeleteTaxonomyRequest",
    "GetPolicyTagRequest",
    "GetTaxonomyRequest",
    "ListPolicyTagsRequest",
    "ListPolicyTagsResponse",
    "ListTaxonomiesRequest",
    "ListTaxonomiesResponse",
    "PolicyTag",
    "Taxonomy",
    "UpdatePolicyTagRequest",
    "UpdateTaxonomyRequest",
    "CrossRegionalSource",
    "ExportTaxonomiesRequest",
    "ExportTaxonomiesResponse",
    "ImportTaxonomiesRequest",
    "ImportTaxonomiesResponse",
    "InlineSource",
    "ReplaceTaxonomyRequest",
    "SerializedPolicyTag",
    "SerializedTaxonomy",
    "ColumnSchema",
    "Schema",
    "SearchCatalogResult",
    "SearchResultType",
    "BigQueryDateShardedSpec",
    "BigQueryTableSpec",
    "TableSpec",
    "ViewSpec",
    "TableSourceType",
    "FieldType",
    "Tag",
    "TagField",
    "TagTemplate",
    "TagTemplateField",
    "SystemTimestamps",
    "UsageSignal",
    "UsageStats",
)
