# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.11.3826
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from lusid_asyncio.configuration import Configuration


class QuoteAccessMetadataRuleId(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
      required_map (dict): The key is attribute name
                           and the value is whether it is 'required' or 'optional'.
    """
    openapi_types = {
        'provider': 'str',
        'price_source': 'str',
        'instrument_id': 'str',
        'instrument_id_type': 'str',
        'quote_type': 'str',
        'field': 'str'
    }

    attribute_map = {
        'provider': 'provider',
        'price_source': 'priceSource',
        'instrument_id': 'instrumentId',
        'instrument_id_type': 'instrumentIdType',
        'quote_type': 'quoteType',
        'field': 'field'
    }

    required_map = {
        'provider': 'optional',
        'price_source': 'optional',
        'instrument_id': 'optional',
        'instrument_id_type': 'optional',
        'quote_type': 'optional',
        'field': 'optional'
    }

    def __init__(self, provider=None, price_source=None, instrument_id=None, instrument_id_type=None, quote_type=None, field=None, local_vars_configuration=None):  # noqa: E501
        """QuoteAccessMetadataRuleId - a model defined in OpenAPI"
        
        :param provider:  The platform or vendor that provided the quote, e.g. 'DataScope', 'LUSID' etc.
        :type provider: str
        :param price_source:  The source or originator of the quote, e.g. a bank or financial institution.
        :type price_source: str
        :param instrument_id:  The value of the instrument identifier that uniquely identifies the instrument that the quote is for, e.g. 'BBG00JX0P539'.
        :type instrument_id: str
        :param instrument_id_type:  The type of instrument identifier used to uniquely identify the instrument that the quote is for, e.g. 'Figi'.
        :type instrument_id_type: str
        :param quote_type:  The type of the quote. This allows for quotes other than prices e.g. rates or spreads to be used.
        :type quote_type: str
        :param field:  The field of the quote e.g. bid, mid, ask etc. This should be consistent across a time series of quotes. The allowed values are dependant on the specified Provider.
        :type field: str

        """  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._provider = None
        self._price_source = None
        self._instrument_id = None
        self._instrument_id_type = None
        self._quote_type = None
        self._field = None
        self.discriminator = None

        self.provider = provider
        self.price_source = price_source
        self.instrument_id = instrument_id
        self.instrument_id_type = instrument_id_type
        self.quote_type = quote_type
        self.field = field

    @property
    def provider(self):
        """Gets the provider of this QuoteAccessMetadataRuleId.  # noqa: E501

        The platform or vendor that provided the quote, e.g. 'DataScope', 'LUSID' etc.  # noqa: E501

        :return: The provider of this QuoteAccessMetadataRuleId.  # noqa: E501
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """Sets the provider of this QuoteAccessMetadataRuleId.

        The platform or vendor that provided the quote, e.g. 'DataScope', 'LUSID' etc.  # noqa: E501

        :param provider: The provider of this QuoteAccessMetadataRuleId.  # noqa: E501
        :type provider: str
        """
        if (self.local_vars_configuration.client_side_validation and
                provider is not None and len(provider) > 100):
            raise ValueError("Invalid value for `provider`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                provider is not None and len(provider) < 0):
            raise ValueError("Invalid value for `provider`, length must be greater than or equal to `0`")  # noqa: E501

        self._provider = provider

    @property
    def price_source(self):
        """Gets the price_source of this QuoteAccessMetadataRuleId.  # noqa: E501

        The source or originator of the quote, e.g. a bank or financial institution.  # noqa: E501

        :return: The price_source of this QuoteAccessMetadataRuleId.  # noqa: E501
        :rtype: str
        """
        return self._price_source

    @price_source.setter
    def price_source(self, price_source):
        """Sets the price_source of this QuoteAccessMetadataRuleId.

        The source or originator of the quote, e.g. a bank or financial institution.  # noqa: E501

        :param price_source: The price_source of this QuoteAccessMetadataRuleId.  # noqa: E501
        :type price_source: str
        """
        if (self.local_vars_configuration.client_side_validation and
                price_source is not None and len(price_source) > 256):
            raise ValueError("Invalid value for `price_source`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                price_source is not None and len(price_source) < 0):
            raise ValueError("Invalid value for `price_source`, length must be greater than or equal to `0`")  # noqa: E501

        self._price_source = price_source

    @property
    def instrument_id(self):
        """Gets the instrument_id of this QuoteAccessMetadataRuleId.  # noqa: E501

        The value of the instrument identifier that uniquely identifies the instrument that the quote is for, e.g. 'BBG00JX0P539'.  # noqa: E501

        :return: The instrument_id of this QuoteAccessMetadataRuleId.  # noqa: E501
        :rtype: str
        """
        return self._instrument_id

    @instrument_id.setter
    def instrument_id(self, instrument_id):
        """Sets the instrument_id of this QuoteAccessMetadataRuleId.

        The value of the instrument identifier that uniquely identifies the instrument that the quote is for, e.g. 'BBG00JX0P539'.  # noqa: E501

        :param instrument_id: The instrument_id of this QuoteAccessMetadataRuleId.  # noqa: E501
        :type instrument_id: str
        """
        if (self.local_vars_configuration.client_side_validation and
                instrument_id is not None and len(instrument_id) > 256):
            raise ValueError("Invalid value for `instrument_id`, length must be less than or equal to `256`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                instrument_id is not None and len(instrument_id) < 0):
            raise ValueError("Invalid value for `instrument_id`, length must be greater than or equal to `0`")  # noqa: E501

        self._instrument_id = instrument_id

    @property
    def instrument_id_type(self):
        """Gets the instrument_id_type of this QuoteAccessMetadataRuleId.  # noqa: E501

        The type of instrument identifier used to uniquely identify the instrument that the quote is for, e.g. 'Figi'.  # noqa: E501

        :return: The instrument_id_type of this QuoteAccessMetadataRuleId.  # noqa: E501
        :rtype: str
        """
        return self._instrument_id_type

    @instrument_id_type.setter
    def instrument_id_type(self, instrument_id_type):
        """Sets the instrument_id_type of this QuoteAccessMetadataRuleId.

        The type of instrument identifier used to uniquely identify the instrument that the quote is for, e.g. 'Figi'.  # noqa: E501

        :param instrument_id_type: The instrument_id_type of this QuoteAccessMetadataRuleId.  # noqa: E501
        :type instrument_id_type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                instrument_id_type is not None and len(instrument_id_type) > 50):
            raise ValueError("Invalid value for `instrument_id_type`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                instrument_id_type is not None and len(instrument_id_type) < 0):
            raise ValueError("Invalid value for `instrument_id_type`, length must be greater than or equal to `0`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                instrument_id_type is not None and not re.search(r'^[a-zA-Z]*$', instrument_id_type)):  # noqa: E501
            raise ValueError(r"Invalid value for `instrument_id_type`, must be a follow pattern or equal to `/^[a-zA-Z]*$/`")  # noqa: E501

        self._instrument_id_type = instrument_id_type

    @property
    def quote_type(self):
        """Gets the quote_type of this QuoteAccessMetadataRuleId.  # noqa: E501

        The type of the quote. This allows for quotes other than prices e.g. rates or spreads to be used.  # noqa: E501

        :return: The quote_type of this QuoteAccessMetadataRuleId.  # noqa: E501
        :rtype: str
        """
        return self._quote_type

    @quote_type.setter
    def quote_type(self, quote_type):
        """Sets the quote_type of this QuoteAccessMetadataRuleId.

        The type of the quote. This allows for quotes other than prices e.g. rates or spreads to be used.  # noqa: E501

        :param quote_type: The quote_type of this QuoteAccessMetadataRuleId.  # noqa: E501
        :type quote_type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                quote_type is not None and len(quote_type) > 50):
            raise ValueError("Invalid value for `quote_type`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                quote_type is not None and len(quote_type) < 0):
            raise ValueError("Invalid value for `quote_type`, length must be greater than or equal to `0`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                quote_type is not None and not re.search(r'^[a-zA-Z]*$', quote_type)):  # noqa: E501
            raise ValueError(r"Invalid value for `quote_type`, must be a follow pattern or equal to `/^[a-zA-Z]*$/`")  # noqa: E501

        self._quote_type = quote_type

    @property
    def field(self):
        """Gets the field of this QuoteAccessMetadataRuleId.  # noqa: E501

        The field of the quote e.g. bid, mid, ask etc. This should be consistent across a time series of quotes. The allowed values are dependant on the specified Provider.  # noqa: E501

        :return: The field of this QuoteAccessMetadataRuleId.  # noqa: E501
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """Sets the field of this QuoteAccessMetadataRuleId.

        The field of the quote e.g. bid, mid, ask etc. This should be consistent across a time series of quotes. The allowed values are dependant on the specified Provider.  # noqa: E501

        :param field: The field of this QuoteAccessMetadataRuleId.  # noqa: E501
        :type field: str
        """
        if (self.local_vars_configuration.client_side_validation and
                field is not None and len(field) > 2048):
            raise ValueError("Invalid value for `field`, length must be less than or equal to `2048`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                field is not None and len(field) < 0):
            raise ValueError("Invalid value for `field`, length must be greater than or equal to `0`")  # noqa: E501

        self._field = field

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QuoteAccessMetadataRuleId):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QuoteAccessMetadataRuleId):
            return True

        return self.to_dict() != other.to_dict()
