"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
/*
 * Stack verification steps:
 * - Deploy with `--no-clean`
 * - Verify that the CloudFormation stack outputs have the following values:
 *   - Ref: "MyPhysicalReflectBack"
 *   - GetAtt.Attribute1: "foo"
 *   - GetAtt.Attribute2: 1234
 */
const core_1 = require("@aws-cdk/core");
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const resourceType = 'Custom::Reflect';
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, resourceType, {
            codeDirectory: `${__dirname}/core-custom-resource-provider-fixture`,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
        });
        const cr = new core_1.CustomResource(this, 'MyResource', {
            resourceType,
            serviceToken,
            properties: {
                physicalResourceId: 'MyPhysicalReflectBack',
                attributes: {
                    Attribute1: 'foo',
                    Attribute2: 1234,
                },
            },
        });
        new core_1.CfnOutput(this, 'Ref', { value: cr.ref });
        new core_1.CfnOutput(this, 'GetAtt.Attribute1', { value: core_1.Token.asString(cr.getAtt('Attribute1')) });
        new core_1.CfnOutput(this, 'GetAtt.Attribute2', { value: core_1.Token.asString(cr.getAtt('Attribute2')) });
    }
}
const app = new core_1.App();
new TestStack(app, 'custom-resource-test');
app.synth();
//# sourceMappingURL=data:application/json;base64,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