import { Test } from 'nodeunit';
declare const _default: {
    'resource dependencies': {
        'between two resources in a top-level stack'(test: Test): void;
        'resource in nested stack depends on a resource in the parent stack': {
            'construct dependency'(test: Test): void;
            'resource dependency'(test: Test): void;
        };
        'resource in nested stack depends on a resource in a grandparent stack': {
            'construct dependency'(test: Test): void;
            'resource dependency'(test: Test): void;
        };
        'resource in parent stack depends on resource in nested stack': {
            'construct dependency'(test: Test): void;
            'resource dependency'(test: Test): void;
        };
        'resource in grantparent stack depends on resource in nested stack': {
            'construct dependency'(test: Test): void;
            'resource dependency'(test: Test): void;
        };
        'resource in sibling stack depends on a resource in nested stack': {
            'construct dependency'(test: Test): void;
            'resource dependency'(test: Test): void;
        };
        'resource in nested stack depends on a resource in sibling stack': {
            'construct dependency'(test: Test): void;
            'resource dependency'(test: Test): void;
        };
        'resource in nested stack depends on a resource in nested sibling stack': {
            'construct dependency'(test: Test): void;
            'resource dependency'(test: Test): void;
        };
    };
    'stack dependencies': {
        'top level stack depends on itself'(test: Test): void;
        'nested stack depends on itself'(test: Test): void;
        'nested stack cannot depend on any of its parents'(test: Test): void;
        'any parent stack is by definition dependent on the nested stack so dependency is ignored'(test: Test): void;
        'sibling nested stacks transfer to resources'(test: Test): void;
        'nested stack depends on a deeply nested stack'(test: Test): void;
        'deeply nested stack depends on a parent nested stack'(test: Test): void;
        'top-level stack depends on a nested stack within a sibling'(test: Test): void;
        'nested stack within a sibling depends on top-level stack'(test: Test): void;
    };
};
export = _default;
