import { DOMWidgetModel, DOMWidgetView, ISerializers, WidgetModel, WidgetView } from '@jupyter-widgets/base';
import '../css/widget.css';
import 'tippy.js/themes/material.css';
export declare class NodeModel extends WidgetModel {
    defaults(): {
        _model_name: string;
        _model_module: any;
        _model_module_version: any;
        _view_name: string;
        _view_module: any;
        _view_module_version: any;
        group: string;
        removed: boolean;
        selected: boolean;
        selectable: boolean;
        locked: boolean;
        grabbed: boolean;
        grabbable: boolean;
        classes: string;
        data: {};
        position: {};
        _view_count: number;
    };
    static model_name: string;
    static model_module: any;
    static model_module_version: any;
    static view_name: string;
    static view_module: any;
    static view_module_version: any;
}
export declare class EdgeModel extends WidgetModel {
    defaults(): {
        _model_name: string;
        _model_module: any;
        _model_module_version: any;
        _view_name: string;
        _view_module: any;
        _view_module_version: any;
        group: string;
        removed: boolean;
        selected: boolean;
        selectable: boolean;
        locked: boolean;
        grabbed: boolean;
        grabbable: boolean;
        classes: string;
        data: {};
        position: {};
        _view_count: number;
    };
    static model_name: string;
    static model_module: any;
    static model_module_version: any;
    static view_name: string;
    static view_module: any;
    static view_module_version: any;
}
export declare class GraphModel extends WidgetModel {
    defaults(): {
        _model_name: string;
        _model_module: any;
        _model_module_version: any;
        nodes: never[];
        edges: never[];
        _view_module: string;
        _view_name: string;
        _view_module_version: string;
        _view_count: number;
    };
    static serializers: ISerializers;
    static model_module: any;
    static model_module_version: any;
    converts_dict(): any[];
}
export declare class CytoscapeModel extends DOMWidgetModel {
    defaults(): any;
    static serializers: ISerializers;
    static model_name: string;
    static model_module: any;
    static model_module_version: any;
    static view_name: string;
    static view_module: any;
    static view_module_version: any;
}
export declare class NodeView extends WidgetView {
    cytoscapeView: any;
    private cyId;
    constructor(params: any);
    private _updateClasses;
    valueChanged(): void;
}
export declare class EdgeView extends WidgetView {
    cytoscapeView: any;
    private cyId;
    constructor(params: any);
    private _updateClasses;
    valueChanged(): void;
}
export declare class CytoscapeView extends DOMWidgetView {
    cytoscape_obj: any;
    is_rendered: boolean;
    nodeViews: any;
    edgeViews: any;
    monitored: any;
    render(): void;
    value_changed(): void;
    listenForUserEvents(): void;
    init_render(): void;
    private _updateMinZoom;
    private _updateMaxZoom;
    private _updateZoomingEnabled;
    private _updateUserZoomingEnabled;
    private _updatePanningEnabled;
    private _updateUserPanningEnabled;
    private _updateBoxSelectionEnabled;
    private _updateSelectionType;
    private _updateAutolock;
    private _updateAutoUngrabify;
    private _updateAutoUnselectify;
    private _updateLayout;
    private _updateStyle;
    private _resize;
    addNodeModel(NodeModel: any): Promise<DOMWidgetView>;
    removeNodeView(nodeView: any): void;
    addEdgeModel(EdgeModel: any): Promise<DOMWidgetView>;
    removeEdgeView(edgeView: any): void;
}
