"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
// tslint:disable-next-line:max-line-length
function renderAmazonLinuxUserData(scope, clusterName, spotFleet, options = {}) {
    const stack = core_1.Stack.of(scope);
    // determine logical id of ASG so we can signal cloudformation
    // const cfn = spotFleet.node.defaultChild as autoscaling.CfnAutoScalingGroup;
    // const asgLogicalId = cfn.logicalId;
    const spotFleetLogicalId = spotFleet.node.id;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${options.useMaxPods === undefined ? true : options.useMaxPods}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    // const lifecycleLabel = autoScalingGroup.spotPrice ? LifecycleLabel.SPOT : LifecycleLabel.ON_DEMAND;
    const lifecycleLabel = LifecycleLabel.SPOT;
    // const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const withTaints = '--register-with-taints=spotInstance=true:PreferNoSchedule';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${spotFleetLogicalId} --region ${stack.region}`,
    ];
}
exports.renderAmazonLinuxUserData = renderAmazonLinuxUserData;
/**
 * The lifecycle label for node selector
 */
var LifecycleLabel;
(function (LifecycleLabel) {
    /**
     * on-demand instances
     */
    LifecycleLabel["ON_DEMAND"] = "OnDemand";
    /**
     * spot instances
     */
    LifecycleLabel["SPOT"] = "Ec2Spot";
})(LifecycleLabel = exports.LifecycleLabel || (exports.LifecycleLabel = {}));
//# sourceMappingURL=data:application/json;base64,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