'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.fitsViewerRendererFactory = exports.FitsViewerWidget = exports.FITS_MIME_TYPE = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _widgets = require('@phosphor/widgets');

var _fireflyApiAccess = require('firefly-api-access');

var _b64ToBlob = require('b64-to-blob');

var _b64ToBlob2 = _interopRequireDefault(_b64ToBlob);

var _coreutils = require('@jupyterlab/coreutils');

var _FireflyCommonUtils = require('./FireflyCommonUtils.js');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var FITS_MIME_TYPE = exports.FITS_MIME_TYPE = 'application/fits';

var ERROR_MSG_CONT = 'Make sure you set the firefly URL in your jupyter_notebook_config.py. \n                For example- \'c.Firefly.url= http://some.firefly.url/firefly\'';

/**
 * The class name added to the extension.
 */
var CLASS_NAME = 'jp-OutputWidgetFITS';

var fireflyURL = (0, _FireflyCommonUtils.addFirefly)();

var idCounter = 0;

/**
 * A widget for rendering FITS.
 */

var FitsViewerWidget = exports.FitsViewerWidget = function (_Widget) {
    _inherits(FitsViewerWidget, _Widget);

    /**
     * Construct a new output widget.
     */
    function FitsViewerWidget(options) {
        _classCallCheck(this, FitsViewerWidget);

        var _this = _possibleConstructorReturn(this, (FitsViewerWidget.__proto__ || Object.getPrototypeOf(FitsViewerWidget)).call(this, { node: createNode(options.resolver._session.name) }));

        _this._mimeType = options.mimeType;
        _this.addClass(CLASS_NAME);
        _this.filename = options.resolver._session.name;
        idCounter++;
        _this.plotId = _this.filename + '-' + idCounter;
        _this.loaded = false;
        return _this;
    }

    /**
     * Render FITS into this widget's node.
     */


    _createClass(FitsViewerWidget, [{
        key: 'renderModel',
        value: function renderModel(model) {
            var _this2 = this;

            var _window = window,
                getFireflyAPI = _window.getFireflyAPI;


            if (this.loaded) {
                return getFireflyAPI().then(function (firefly) {
                    return firefly.action.dispatchChangeActivePlotView(_this2.plotId);
                });
            }

            return getFireflyAPI().then(function (firefly) {
                return loadFileToServer(model.data[FITS_MIME_TYPE], _this2.filename, firefly);
            }).then(function (response) {
                return response.text();
            }).then(function (text) {
                var _text$split = text.split('::::'),
                    _text$split2 = _slicedToArray(_text$split, 2),
                    status = _text$split2[0],
                    cacheKey = _text$split2[1];

                showImage(cacheKey, _this2.plotId, _this2.filename, firefly);
                _this2.loaded = true;
            }).catch(function (e) {
                throw new Error(e.message + '. ' + ERROR_MSG_CONT);
            });
        }
    }, {
        key: 'dispose',
        value: function dispose() {
            var _this3 = this;

            return window.getFireflyAPI().then(function (firefly) {
                return firefly.action.dispatchDeletePlotView({ plotId: _this3.plotId, holdWcsMatch: true });
            });
        }
    }]);

    return FitsViewerWidget;
}(_widgets.Widget);

/**
 * A mime renderer factory for FITS data.
 */


var fitsViewerRendererFactory = exports.fitsViewerRendererFactory = {
    safe: true,
    mimeTypes: [FITS_MIME_TYPE],
    createRenderer: function createRenderer(options) {
        console.log('creating FitsViewerWidget '); //*** DEBUG
        return new FitsViewerWidget(options);
    }
};

// for adding a second extension for a mime type - does not work yet in Jupyter Lab
// --- https://github.com/jupyterlab/jupyterlab/issues/5381
// export const fitsViewerRendererFactory2 = {
//     safe: true,
//     mimeTypes: [FITS_MIME_TYPE],
//     createRenderer: options => {
//         console.log('creating FitsViewerWidget 2'); //*** DEBUG
//         return new FitsViewerWidget (options);
//     }
// };


function loadFileToServer(fileData, filename, firefly) {
    var _firefly$util = firefly.util,
        fetchUrl = _firefly$util.fetchUrl,
        ServerParams = _firefly$util.ServerParams;

    var UL_URL = fireflyURL + '/sticky/CmdSrv?' + ServerParams.COMMAND + '=' + ServerParams.UPLOAD + '&filename=' + filename;
    var fitsBlob = (0, _b64ToBlob2.default)(fileData);
    var options = {
        method: 'multipart',
        params: {
            filename: filename,
            type: 'FITS',
            file: fitsBlob
        }
    };
    return fetchUrl(UL_URL, options);
}

function showImage(cacheKey, plotId, filename, firefly) {
    var req = {
        type: 'FILE',
        FILE: cacheKey,
        plotId: plotId,
        plotGroupId: 'JUPLAB',
        title: filename
    };
    var ui = firefly.ui,
        util = firefly.util,
        action = firefly.action;
    var _util$image = util.image,
        IMAGE = _util$image.IMAGE,
        NewPlotMode = _util$image.NewPlotMode;
    var dispatchPlotImage = action.dispatchPlotImage,
        dispatchAddViewer = action.dispatchAddViewer;

    dispatchAddViewer(filename, NewPlotMode.create_replace.key, IMAGE);
    util.renderDOM(filename, ui.ApiFullDisplay, { viewerId: filename });
    dispatchPlotImage({
        plotId: plotId,
        viewerId: filename,
        wpRequest: req,
        pvOptions: {
            userCanDeletePlots: false
        }
    });
}

function createNode(filename) {
    var node = document.createElement('div');
    node.id = filename;
    // const tmpElement=  document.createElement('div');
    // tmpElement.innerHTML= '<div>I am here</div>';
    // node.appendChild(tmpElement);
    return node;
}