# Generated by Django 2.0.4 on 2018-08-23 07:44

from django.db import migrations, models
import django.db.models.deletion
import kallisticore.models.trial
import kallisticore.utils.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Experiment',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=150, unique=True)),
                ('description', models.TextField(blank=True)),
                ('steps', kallisticore.utils.fields.ListField(default=[])),
                ('parameters', kallisticore.utils.fields.DictField(default={})),
            ],
            options={
                'verbose_name': 'Experiment',
            },
        ),
        migrations.CreateModel(
            name='Trial',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('status', models.CharField(default='Scheduled', max_length=20, validators=[kallisticore.models.trial.validate_trial_status])),
                ('executed_at', models.DateTimeField(blank=True, null=True)),
                ('experiment', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='kallisticore.Experiment')),
            ],
        ),
    ]
