#!/usr/bin/env python3
#
# GlobalChem - FDA List Six
#
# -------------------------

class FDAListSix(object):

    def __init__(self):

        self.name = 'fda_list_six'

    @staticmethod
    def get_smiles():

        smiles = {
            'aluminum powder': '[Al]',
            'annatto': 'CC(=CC=CC=C(C)C=CC=C(C)C=CC(=O)O)C=CC=C(C)C=CC(=O)O',
            'bismuth citrate': '',
            'bismuth oxychloride': 'O=[Bi].Cl',
            'Bronze powder': '[Cu].[Sn]',
            'caramel': '*',
            'carmine': 'CC1=C2C(=CC(=C1C(=O)O)O)C(=O)C3=C(C2=O)C(=C(C(=C3O)O)C4C(C(C(C(O4)CO)O)O)O)O',
            'beta-carotene': 'CC1=C(C(CCC1)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2=C(CCCC2(C)C)C)C)C',
            'chromium hydroxide green': 'O.O.[O-2].[O-2].[O-2].[Cr+3].[Cr+3]',
            'chromium oxide greens': '[O-2].[O-2].[O-2].[Cr+3].[Cr+3]',
            'copper, metallic powder ': '[Cu]',
            'dihydroxyacetone': 'C(C(=O)CO)O',
            'disodium edta-copper': 'C(CN(CC(=O)[O-])CC(=O)[O-])N(CC(=O)[O-])CC(=O)[O-].[Na+].[Na+].[Cu+2]',
            'ferric ammonium ferrocyanide': '[C-]#N.[C-]#N.[C-]#N.[C-]#N.[C-]#N.[C-]#N.[NH4+].[Fe+2].[Fe+3]',
            'ferric ferrocyanide': '[C-]#N.[C-]#N.[C-]#N.[C-]#N.[C-]#N.[C-]#N.[Fe+3].[Fe+3]',
            'guaiazulene': 'CC1=C2C=CC(=C2C=C(C=C1)C(C)C)C',
            'guanine': 'C1=NC2=C(N1)C(=O)NC(=N2)N',
            'henna': 'C1=CC=C2C(=C1)C(=CC(=O)C2=O)O',
            'iron oxides': 'O=[Fe]O[Fe]=O',
            'luminescent zinc sulfide': 'S=[Zn]',
            'manganese violet': '[NH4+].[O-]P(=O)([O-])OP(=O)([O-])[O-].[Mn+3]',
            'mica': '[O-2].O=[Al]O[Al]=O.O=[Si]=O.[K+].[K+]',
            'potassium sodium copper chlorophyllin': 'CCC1=C(C2=NC1=CC3=C(C(=C([N-]3)C(=C4C(C(C(=N4)C=C5C(=C(C(=C2)[N-]5)C=C)C)C)CCC(=O)[O-])CC(=O)[O-])C(=O)[O-])C)C.[Na+].[Na+].[Na+].[Cu+2]',
            'pyrophyllite': 'O[Si](=O)[O-].O[Si](=O)[O-].[Al+2]',
            'silver': '[Ag]',
            'silver nitrate': '[N+](=O)([O-])[O-].[Ag+]',
            'titanium dioxide': 'O=[Ti]=O',
            'ultramarines': '[O-][Si]([O-])([O-])[O-].[O-][Si]([O-])([O-])[O-].[O-][Si]([O-])([O-])[O-].[O-][Si]([O-])([O-])[O-].[O-][Si]([O-])([O-])[O-].[O-][Si]([O-])([O-])[O-].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Al+3].[Al+3].[Al+3].[Al+3].[Al+3].[Al+3].[S-]S[S-]',
            'zinc oxide': 'O=[Zn]',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'aluminum powder': '[Al]',
            'annatto': '[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6](=[#8])-[#8])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6](=[#8])-[#8]',
            'bismuth citrate': '',
            'bismuth oxychloride': '[#8]=[Bi].[#17]',
            'bronze powder': '[Cu].[Sn]',
            'caramel': '[#0]',
            'carmine': '[#6]-[#6]1:[#6]2:[#6](:[#6]:[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8])-[#6](=[#8])-[#6]1:[#6](-[#6]-2=[#8]):[#6](:[#6](:[#6](:[#6]:1-[#8])-[#8])-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'beta-carotene': '[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1=[#6](-[#6]-[#6]-[#6]-[#6]-1(-[#6])-[#6])-[#6])-[#6])-[#6]',
            'chromium hydroxide green': '[#8].[#8].[#8-2].[#8-2].[#8-2].[Cr+3].[Cr+3]',
            'chromium oxide greens': '[#8-2].[#8-2].[#8-2].[Cr+3].[Cr+3]',
            'copper, metallic powder ': '[Cu]',
            'dihydroxyacetone': '[#6](-[#6](=[#8])-[#6]-[#8])-[#8]',
            'disodium edta-copper': '[#6](-[#6]-[#7](-[#6]-[#6](=[#8])-[#8-])-[#6]-[#6](=[#8])-[#8-])-[#7](-[#6]-[#6](=[#8])-[#8-])-[#6]-[#6](=[#8])-[#8-].[Na+].[Na+].[Cu+2]',
            'ferric ammonium ferrocyanide': '[#6-]#[#7].[#6-]#[#7].[#6-]#[#7].[#6-]#[#7].[#6-]#[#7].[#6-]#[#7].[#7H4+].[Fe+2].[Fe+3]',
            'ferric ferrocyanide': '[#6-]#[#7].[#6-]#[#7].[#6-]#[#7].[#6-]#[#7].[#6-]#[#7].[#6-]#[#7].[Fe+3].[Fe+3]',
            'guaiazulene': '[#6]-[#6]1:[#6]2:[#6]:[#6]:[#6](:[#6]-2:[#6]:[#6](:[#6]:[#6]:1)-[#6](-[#6])-[#6])-[#6]',
            'guanine': '[#6]1:[#7]:[#6]2:[#6](:[#7H]:1):[#6](=[#8]):[#7H]:[#6](:[#7]:2)-[#7]',
            'henna': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1)-[#6](=[#6]-[#6](=[#8])-[#6]-2=[#8])-[#8]',
            'iron oxides': '[#8]=[Fe]-[#8]-[Fe]=[#8]',
            'luminescent zinc sulfide': '[#16]=[Zn]',
            'manganese violet': '[#7H4+].[#8-]-[#15](=[#8])(-[#8-])-[#8]-[#15](=[#8])(-[#8-])-[#8-].[Mn+3]',
            'mica': '[#8-2].[#8]=[Al]-[#8]-[Al]=[#8].[#8]=[Si]=[#8].[K+].[K+]',
            'potassium sodium copper chlorophyllin': '[#6]-[#6]-[#6]1=[#6](-[#6]2:[#7]:[#6]-1:[#6]:[#6]1:[#6](:[#6](:[#6](:[#7-]:1):[#6](:[#6]1-[#6](-[#6](-[#6](:[#7]:1):[#6]:[#6]1:[#6](:[#6](:[#6](:[#6]:2):[#7-]:1)-[#6]=[#6])-[#6])-[#6])-[#6]-[#6]-[#6](=[#8])-[#8-])-[#6]-[#6](=[#8])-[#8-])-[#6](=[#8])-[#8-])-[#6])-[#6].[Na+].[Na+].[Na+].[Cu+2]',
            'pyrophyllite': '[#8]-[Si](=[#8])-[#8-].[#8]-[Si](=[#8])-[#8-].[Al+2]',
            'silver': '[Ag]',
            'silver nitrate': '[#7+](=[#8])(-[#8-])-[#8-].[Ag+]',
            'titanium dioxide': '[#8]=[Ti]=[#8]',
            'ultramarines': '[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Al+3].[Al+3].[Al+3].[Al+3].[Al+3].[Al+3].[#16-]-[#16]-[#16-]',
            'zinc oxide': '[#8]=[Zn]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'aluminum powder': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'annatto': '00000000000000000000000000000001010000000000000000000001000000000000000000000000000000000010000000000000000000000000000000000000000000000010000000000000000000100000000000000100000000100000000000000000000000100000000000001000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000100000000000000000000000000000001000000000010000000000000000000000000000000100000000000000000000000000100000000000001001000',
            'bismuth citrate': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'bismuth oxychloride': '00100000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'Bronze powder': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'caramel': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'carmine': '00000000000001000000000000000000011000000000000010000000000000001010000100110000100000000000000000100000000000001000000000000000000000000010000010000000000000100000000000000000000010000010000000000000001000000011000000000010000010100100000000000000000010000000000000100000000100000000000000000001000000000000100000110000000000000000000001010000000000001000100000010000000000000000010001000100000000000000000010000000000000000000000010000000000100000100100010000101000000000000000000000000101010000000000000010000',
            'beta-carotene': '00001000000000000000000000000001010010001000000000000001000000000000000000000000000000000010000000000000001000000000000000000000001000000010000000000000000000000000000000000100000000100010000000000000001000100000000000000000000000000000000000000000001000000001000010000000000000000000000000010001000000000000000000000000000101000000000000000000000000000000100000000000000000000000000000000000000000000000000000000010000011000000000010000000010010000000000000000000000000000000000000000000000100000000100001000000',
            'chromium hydroxide green': '00000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'chromium oxide greens': '00000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'copper, metallic powder ': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'dihydroxyacetone': '00000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000010000001000000000000000000000000000000000000000000000000001000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'disodium edta-copper': '00010000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000010000001000000000000000000001000000000000000000000010000000000001100000000000000000000000000000000000000000000000100000000000000001000010000000000000000000001000000000010000000000000000000000000000000000000000000000000000000000000010000000000010000100000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'ferric ammonium ferrocyanide': '00000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000100000000000000000000000000000000000000000000000000000000000000001',
            'ferric ferrocyanide': '00000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000001',
            'guaiazulene': '01000000000000000000000000000000010000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000100000000000010000000000000000010000000000000000000000000001000000000000000000000000000000000000000000000000000001000000000000001000000000000000000000000000000000100000000000000000001000100000000001000100000010101000000000000000001000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000',
            'guanine': '10000000000000000000000000000000000000000000000000010000000000000000000000000000000000001010000000000000000000000000000000000000000000000010000000010000000000000000000000000000000000000100000100000000010000000100000000000000000000000000001000000000000000000000000000000000000000000000000000000010000000000000000000110001001000000000001001000000000000000000100000000000000000000010000000000000000000000100000000000000000000000000100001000000000000000000000000000000000000000000100000000000000000000000000000101000',
            'henna': '01000000000000000000000000000000000000000000000000000000000000001010000000000000000010000000000000000000000000000000000000000100010000000010000000000000000000000000000000000001000000000000000000000000000000000000001000000000000000000001000000000000000000000000000000000000000000000000001000000001000000000000000000100000000000000000000001000000000000001000100000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000100000001000000000001000000000000000000000000000000000000001',
            'iron oxides': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000001000000000000000000010000000000000000000000000000000000000000000010000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000',
            'luminescent zinc sulfide': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'manganese violet': '00000000000000010000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000001000000000000000000000000000000000000010000010010001000000100000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000010000000000000000000000000',
            'mica': '10000000000000000000000000000000000000000000100000000000000000000000000000000100000100000000000000000000000000000000001000000000000000000010000000000000000000000000001000000001000000010000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000',
            'potassium sodium copper chlorophyllin': '00000000000001000000000000001000110000001000000000100000000000010000010000100000100000000001000000000000010001000000000000100000000000000010001000000100000000000000000000000000010000100010010000000010001100010000001000000001000100000101000000000000100010000001000100000001010000000000110000000011000000010010000000000001100001000000000101010010000000110000100000010000000000000010010000000000000010000000000000000000000000000000100010000010000000000000000000000000010010000000100100000000000000000110000000010000',
            'pyrophyllite': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000001000000000000000000000000000010000000000000000000000000000000000000000000000001000000000000000000000000000000001000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000',
            'silver': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'silver nitrate': '00000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'titanium dioxide': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000001000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'ultramarines': '00000000000000000000000000000000001000000000000000000000100000000000000000010000000000000000000100000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000010000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000',
            'zinc oxide': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010010000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
        }

        return bit_vector