import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the zone in which this record set will reside.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#managed_zone DnsRecordSet#managed_zone}
     *
     * @stability stable
     */
    readonly managedZone: string;
    /**
     * The DNS name this record set will apply to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#name DnsRecordSet#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#project DnsRecordSet#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The string data for the records in this record set whose meaning depends on the DNS type.
     *
     * For TXT record, if the string data contains spaces, add surrounding \" if you don't want your string to get split on spaces. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add \"\" inside the Terraform configuration string (e.g. "first255characters\"\"morecharacters").
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#rrdatas DnsRecordSet#rrdatas}
     *
     * @stability stable
     */
    readonly rrdatas: string[];
    /**
     * The time-to-live of this record set (seconds).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#ttl DnsRecordSet#ttl}
     *
     * @stability stable
     */
    readonly ttl?: number;
    /**
     * The DNS record set type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html#type DnsRecordSet#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html google_dns_record_set}.
 *
 * @stability stable
 */
export declare class DnsRecordSet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_record_set.html google_dns_record_set} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsRecordSetConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _managedZone?;
    /**
     * @stability stable
     */
    get managedZone(): string;
    /**
     * @stability stable
     */
    set managedZone(value: string);
    /**
     * @stability stable
     */
    get managedZoneInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _rrdatas?;
    /**
     * @stability stable
     */
    get rrdatas(): string[];
    /**
     * @stability stable
     */
    set rrdatas(value: string[]);
    /**
     * @stability stable
     */
    get rrdatasInput(): string[] | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number;
    /**
     * @stability stable
     */
    set ttl(value: number);
    /**
     * @stability stable
     */
    resetTtl(): void;
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
