import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PubsubSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * This value is the maximum time after a subscriber receives a message before the subscriber should acknowledge the message.
     *
     * After message
     * delivery but before the ack deadline expires and before the message is
     * acknowledged, it is an outstanding message and will not be delivered
     * again during that time (on a best-effort basis).
     *
     * For pull subscriptions, this value is used as the initial value for
     * the ack deadline. To override this value for a given message, call
     * subscriptions.modifyAckDeadline with the corresponding ackId if using
     * pull. The minimum custom deadline you can specify is 10 seconds. The
     * maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     *
     * For push delivery, this value is also used to set the request timeout
     * for the call to the push endpoint.
     *
     * If the subscriber never acknowledges the message, the Pub/Sub system
     * will eventually redeliver the message.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#ack_deadline_seconds PubsubSubscription#ack_deadline_seconds}
     *
     * @stability stable
     */
    readonly ackDeadlineSeconds?: number;
    /**
     * If 'true', messages published with the same orderingKey in PubsubMessage will be delivered to the subscribers in the order in which they are received by the Pub/Sub system.
     *
     * Otherwise, they
     * may be delivered in any order.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#enable_message_ordering PubsubSubscription#enable_message_ordering}
     *
     * @stability stable
     */
    readonly enableMessageOrdering?: boolean | cdktf.IResolvable;
    /**
     * The subscription only delivers the messages that match the filter.
     *
     * Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
     * by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
     * you can't modify the filter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#filter PubsubSubscription#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * A set of key/value label pairs to assign to this Subscription.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#labels PubsubSubscription#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * How long to retain unacknowledged messages in the subscription's backlog, from the moment a message is published.
     *
     * If
     * retainAckedMessages is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a
     * subscriptions.seek can be done. Defaults to 7 days. Cannot be more
     * than 7 days ('"604800s"') or less than 10 minutes ('"600s"').
     *
     * A duration in seconds with up to nine fractional digits, terminated
     * by 's'. Example: '"600.5s"'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#message_retention_duration PubsubSubscription#message_retention_duration}
     *
     * @stability stable
     */
    readonly messageRetentionDuration?: string;
    /**
     * Name of the subscription.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#name PubsubSubscription#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#project PubsubSubscription#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Indicates whether to retain acknowledged messages.
     *
     * If 'true', then
     * messages are not expunged from the subscription's backlog, even if
     * they are acknowledged, until they fall out of the
     * messageRetentionDuration window.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#retain_acked_messages PubsubSubscription#retain_acked_messages}
     *
     * @stability stable
     */
    readonly retainAckedMessages?: boolean | cdktf.IResolvable;
    /**
     * A reference to a Topic resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#topic PubsubSubscription#topic}
     *
     * @stability stable
     */
    readonly topic: string;
    /**
     * dead_letter_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#dead_letter_policy PubsubSubscription#dead_letter_policy}
     *
     * @stability stable
     */
    readonly deadLetterPolicy?: PubsubSubscriptionDeadLetterPolicy;
    /**
     * expiration_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#expiration_policy PubsubSubscription#expiration_policy}
     *
     * @stability stable
     */
    readonly expirationPolicy?: PubsubSubscriptionExpirationPolicy;
    /**
     * push_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#push_config PubsubSubscription#push_config}
     *
     * @stability stable
     */
    readonly pushConfig?: PubsubSubscriptionPushConfig;
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#retry_policy PubsubSubscription#retry_policy}
     *
     * @stability stable
     */
    readonly retryPolicy?: PubsubSubscriptionRetryPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#timeouts PubsubSubscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PubsubSubscriptionTimeouts;
}
/**
 * @stability stable
 */
export interface PubsubSubscriptionDeadLetterPolicy {
    /**
     * The name of the topic to which dead letter messages should be published. Format is 'projects/{project}/topics/{topic}'.
     *
     * The Cloud Pub/Sub service account associated with the enclosing subscription's
     * parent project (i.e.,
     * service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Publish() to this topic.
     *
     * The operation will fail if the topic does not exist.
     * Users should ensure that there is a subscription attached to this topic
     * since messages published to a topic with no subscriptions are lost.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#dead_letter_topic PubsubSubscription#dead_letter_topic}
     *
     * @stability stable
     */
    readonly deadLetterTopic?: string;
    /**
     * The maximum number of delivery attempts for any message. The value must be between 5 and 100.
     *
     * The number of delivery attempts is defined as 1 + (the sum of number of
     * NACKs and number of times the acknowledgement deadline has been exceeded for the message).
     *
     * A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
     * client libraries may automatically extend ack_deadlines.
     *
     * This field will be honored on a best effort basis.
     *
     * If this parameter is 0, a default value of 5 is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#max_delivery_attempts PubsubSubscription#max_delivery_attempts}
     *
     * @stability stable
     */
    readonly maxDeliveryAttempts?: number;
}
export declare function pubsubSubscriptionDeadLetterPolicyToTerraform(struct?: PubsubSubscriptionDeadLetterPolicyOutputReference | PubsubSubscriptionDeadLetterPolicy): any;
/**
 * @stability stable
 */
export declare class PubsubSubscriptionDeadLetterPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubSubscriptionDeadLetterPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubSubscriptionDeadLetterPolicy | undefined);
    private _deadLetterTopic?;
    /**
     * @stability stable
     */
    get deadLetterTopic(): string;
    /**
     * @stability stable
     */
    set deadLetterTopic(value: string);
    /**
     * @stability stable
     */
    resetDeadLetterTopic(): void;
    /**
     * @stability stable
     */
    get deadLetterTopicInput(): string | undefined;
    private _maxDeliveryAttempts?;
    /**
     * @stability stable
     */
    get maxDeliveryAttempts(): number;
    /**
     * @stability stable
     */
    set maxDeliveryAttempts(value: number);
    /**
     * @stability stable
     */
    resetMaxDeliveryAttempts(): void;
    /**
     * @stability stable
     */
    get maxDeliveryAttemptsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface PubsubSubscriptionExpirationPolicy {
    /**
     * Specifies the "time-to-live" duration for an associated resource.
     *
     * The
     * resource expires if it is not active for a period of ttl.
     * If ttl is not set, the associated resource never expires.
     * A duration in seconds with up to nine fractional digits, terminated by 's'.
     * Example - "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#ttl PubsubSubscription#ttl}
     *
     * @stability stable
     */
    readonly ttl: string;
}
export declare function pubsubSubscriptionExpirationPolicyToTerraform(struct?: PubsubSubscriptionExpirationPolicyOutputReference | PubsubSubscriptionExpirationPolicy): any;
/**
 * @stability stable
 */
export declare class PubsubSubscriptionExpirationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubSubscriptionExpirationPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubSubscriptionExpirationPolicy | undefined);
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): string;
    /**
     * @stability stable
     */
    set ttl(value: string);
    /**
     * @stability stable
     */
    get ttlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PubsubSubscriptionPushConfigOidcToken {
    /**
     * Audience to be used when generating OIDC token.
     *
     * The audience claim
     * identifies the recipients that the JWT is intended for. The audience
     * value is a single case-sensitive string. Having multiple values (array)
     * for the audience field is not supported. More info about the OIDC JWT
     * token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
     * Note: if not specified, the Push endpoint URL will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#audience PubsubSubscription#audience}
     *
     * @stability stable
     */
    readonly audience?: string;
    /**
     * Service account email to be used for generating the OIDC token.
     *
     * The caller (for subscriptions.create, subscriptions.patch, and
     * subscriptions.modifyPushConfig RPCs) must have the
     * iam.serviceAccounts.actAs permission for the service account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#service_account_email PubsubSubscription#service_account_email}
     *
     * @stability stable
     */
    readonly serviceAccountEmail: string;
}
export declare function pubsubSubscriptionPushConfigOidcTokenToTerraform(struct?: PubsubSubscriptionPushConfigOidcTokenOutputReference | PubsubSubscriptionPushConfigOidcToken): any;
/**
 * @stability stable
 */
export declare class PubsubSubscriptionPushConfigOidcTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubSubscriptionPushConfigOidcToken | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubSubscriptionPushConfigOidcToken | undefined);
    private _audience?;
    /**
     * @stability stable
     */
    get audience(): string;
    /**
     * @stability stable
     */
    set audience(value: string);
    /**
     * @stability stable
     */
    resetAudience(): void;
    /**
     * @stability stable
     */
    get audienceInput(): string | undefined;
    private _serviceAccountEmail?;
    /**
     * @stability stable
     */
    get serviceAccountEmail(): string;
    /**
     * @stability stable
     */
    set serviceAccountEmail(value: string);
    /**
     * @stability stable
     */
    get serviceAccountEmailInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PubsubSubscriptionPushConfig {
    /**
     * Endpoint configuration attributes.
     *
     * Every endpoint has a set of API supported attributes that can
     * be used to control different aspects of the message delivery.
     *
     * The currently supported attribute is x-goog-version, which you
     * can use to change the format of the pushed message. This
     * attribute indicates the version of the data expected by
     * the endpoint. This controls the shape of the pushed message
     * (i.e., its fields and metadata). The endpoint version is
     * based on the version of the Pub/Sub API.
     *
     * If not present during the subscriptions.create call,
     * it will default to the version of the API used to make
     * such call. If not present during a subscriptions.modifyPushConfig
     * call, its value will not be changed. subscriptions.get
     * calls will always return a valid version, even if the
     * subscription was created without this attribute.
     *
     * The possible values for this attribute are:
     *
     * - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
     * - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#attributes PubsubSubscription#attributes}
     *
     * @stability stable
     */
    readonly attributes?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A URL locating the endpoint to which messages should be pushed. For example, a Webhook endpoint might use "https://example.com/push".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#push_endpoint PubsubSubscription#push_endpoint}
     *
     * @stability stable
     */
    readonly pushEndpoint: string;
    /**
     * oidc_token block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#oidc_token PubsubSubscription#oidc_token}
     *
     * @stability stable
     */
    readonly oidcToken?: PubsubSubscriptionPushConfigOidcToken;
}
export declare function pubsubSubscriptionPushConfigToTerraform(struct?: PubsubSubscriptionPushConfigOutputReference | PubsubSubscriptionPushConfig): any;
/**
 * @stability stable
 */
export declare class PubsubSubscriptionPushConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubSubscriptionPushConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubSubscriptionPushConfig | undefined);
    private _attributes?;
    /**
     * @stability stable
     */
    get attributes(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set attributes(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAttributes(): void;
    /**
     * @stability stable
     */
    get attributesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _pushEndpoint?;
    /**
     * @stability stable
     */
    get pushEndpoint(): string;
    /**
     * @stability stable
     */
    set pushEndpoint(value: string);
    /**
     * @stability stable
     */
    get pushEndpointInput(): string | undefined;
    private _oidcToken;
    /**
     * @stability stable
     */
    get oidcToken(): PubsubSubscriptionPushConfigOidcTokenOutputReference;
    /**
     * @stability stable
     */
    putOidcToken(value: PubsubSubscriptionPushConfigOidcToken): void;
    /**
     * @stability stable
     */
    resetOidcToken(): void;
    /**
     * @stability stable
     */
    get oidcTokenInput(): PubsubSubscriptionPushConfigOidcToken | undefined;
}
/**
 * @stability stable
 */
export interface PubsubSubscriptionRetryPolicy {
    /**
     * The maximum delay between consecutive deliveries of a given message.
     *
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#maximum_backoff PubsubSubscription#maximum_backoff}
     *
     * @stability stable
     */
    readonly maximumBackoff?: string;
    /**
     * The minimum delay between consecutive deliveries of a given message.
     *
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#minimum_backoff PubsubSubscription#minimum_backoff}
     *
     * @stability stable
     */
    readonly minimumBackoff?: string;
}
export declare function pubsubSubscriptionRetryPolicyToTerraform(struct?: PubsubSubscriptionRetryPolicyOutputReference | PubsubSubscriptionRetryPolicy): any;
/**
 * @stability stable
 */
export declare class PubsubSubscriptionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubSubscriptionRetryPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubSubscriptionRetryPolicy | undefined);
    private _maximumBackoff?;
    /**
     * @stability stable
     */
    get maximumBackoff(): string;
    /**
     * @stability stable
     */
    set maximumBackoff(value: string);
    /**
     * @stability stable
     */
    resetMaximumBackoff(): void;
    /**
     * @stability stable
     */
    get maximumBackoffInput(): string | undefined;
    private _minimumBackoff?;
    /**
     * @stability stable
     */
    get minimumBackoff(): string;
    /**
     * @stability stable
     */
    set minimumBackoff(value: string);
    /**
     * @stability stable
     */
    resetMinimumBackoff(): void;
    /**
     * @stability stable
     */
    get minimumBackoffInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PubsubSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#create PubsubSubscription#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#delete PubsubSubscription#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html#update PubsubSubscription#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function pubsubSubscriptionTimeoutsToTerraform(struct?: PubsubSubscriptionTimeoutsOutputReference | PubsubSubscriptionTimeouts): any;
/**
 * @stability stable
 */
export declare class PubsubSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubSubscriptionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html google_pubsub_subscription}.
 *
 * @stability stable
 */
export declare class PubsubSubscription extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription.html google_pubsub_subscription} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PubsubSubscriptionConfig);
    private _ackDeadlineSeconds?;
    /**
     * @stability stable
     */
    get ackDeadlineSeconds(): number;
    /**
     * @stability stable
     */
    set ackDeadlineSeconds(value: number);
    /**
     * @stability stable
     */
    resetAckDeadlineSeconds(): void;
    /**
     * @stability stable
     */
    get ackDeadlineSecondsInput(): number | undefined;
    private _enableMessageOrdering?;
    /**
     * @stability stable
     */
    get enableMessageOrdering(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableMessageOrdering(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableMessageOrdering(): void;
    /**
     * @stability stable
     */
    get enableMessageOrderingInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _messageRetentionDuration?;
    /**
     * @stability stable
     */
    get messageRetentionDuration(): string;
    /**
     * @stability stable
     */
    set messageRetentionDuration(value: string);
    /**
     * @stability stable
     */
    resetMessageRetentionDuration(): void;
    /**
     * @stability stable
     */
    get messageRetentionDurationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get path(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _retainAckedMessages?;
    /**
     * @stability stable
     */
    get retainAckedMessages(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set retainAckedMessages(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRetainAckedMessages(): void;
    /**
     * @stability stable
     */
    get retainAckedMessagesInput(): boolean | cdktf.IResolvable | undefined;
    private _topic?;
    /**
     * @stability stable
     */
    get topic(): string;
    /**
     * @stability stable
     */
    set topic(value: string);
    /**
     * @stability stable
     */
    get topicInput(): string | undefined;
    private _deadLetterPolicy;
    /**
     * @stability stable
     */
    get deadLetterPolicy(): PubsubSubscriptionDeadLetterPolicyOutputReference;
    /**
     * @stability stable
     */
    putDeadLetterPolicy(value: PubsubSubscriptionDeadLetterPolicy): void;
    /**
     * @stability stable
     */
    resetDeadLetterPolicy(): void;
    /**
     * @stability stable
     */
    get deadLetterPolicyInput(): PubsubSubscriptionDeadLetterPolicy | undefined;
    private _expirationPolicy;
    /**
     * @stability stable
     */
    get expirationPolicy(): PubsubSubscriptionExpirationPolicyOutputReference;
    /**
     * @stability stable
     */
    putExpirationPolicy(value: PubsubSubscriptionExpirationPolicy): void;
    /**
     * @stability stable
     */
    resetExpirationPolicy(): void;
    /**
     * @stability stable
     */
    get expirationPolicyInput(): PubsubSubscriptionExpirationPolicy | undefined;
    private _pushConfig;
    /**
     * @stability stable
     */
    get pushConfig(): PubsubSubscriptionPushConfigOutputReference;
    /**
     * @stability stable
     */
    putPushConfig(value: PubsubSubscriptionPushConfig): void;
    /**
     * @stability stable
     */
    resetPushConfig(): void;
    /**
     * @stability stable
     */
    get pushConfigInput(): PubsubSubscriptionPushConfig | undefined;
    private _retryPolicy;
    /**
     * @stability stable
     */
    get retryPolicy(): PubsubSubscriptionRetryPolicyOutputReference;
    /**
     * @stability stable
     */
    putRetryPolicy(value: PubsubSubscriptionRetryPolicy): void;
    /**
     * @stability stable
     */
    resetRetryPolicy(): void;
    /**
     * @stability stable
     */
    get retryPolicyInput(): PubsubSubscriptionRetryPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PubsubSubscriptionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PubsubSubscriptionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PubsubSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
