from typing import overload
import abc
import typing

import System
import System.Collections
import System.Collections.Generic
import System.Collections.Immutable

System_Collections_Immutable_ImmutableArray = typing.Any
System_Collections_Immutable_ImmutableHashSet_Enumerator = typing.Any
System_Collections_Immutable_ImmutableList_Enumerator = typing.Any
System_Collections_Immutable_ImmutableSortedSet_Enumerator = typing.Any

System_Collections_Immutable_IImmutableDictionary_TKey = typing.TypeVar("System_Collections_Immutable_IImmutableDictionary_TKey")
System_Collections_Immutable_IImmutableDictionary_TValue = typing.TypeVar("System_Collections_Immutable_IImmutableDictionary_TValue")
System_Collections_Immutable_IImmutableList_T = typing.TypeVar("System_Collections_Immutable_IImmutableList_T")
System_Collections_Immutable_IImmutableQueue_T = typing.TypeVar("System_Collections_Immutable_IImmutableQueue_T")
System_Collections_Immutable_IImmutableSet_T = typing.TypeVar("System_Collections_Immutable_IImmutableSet_T")
System_Collections_Immutable_IImmutableStack_T = typing.TypeVar("System_Collections_Immutable_IImmutableStack_T")
System_Collections_Immutable_ImmutableArray_Create_T = typing.TypeVar("System_Collections_Immutable_ImmutableArray_Create_T")
System_Collections_Immutable_ImmutableArray_CreateRange_TArg = typing.TypeVar("System_Collections_Immutable_ImmutableArray_CreateRange_TArg")
System_Collections_Immutable_ImmutableArray_BinarySearch_T = typing.TypeVar("System_Collections_Immutable_ImmutableArray_BinarySearch_T")
System_Collections_Immutable_ImmutableArray_T = typing.TypeVar("System_Collections_Immutable_ImmutableArray_T")
System_Collections_Immutable_ImmutableArray_ToImmutableArray_T = typing.TypeVar("System_Collections_Immutable_ImmutableArray_ToImmutableArray_T")
System_Collections_Immutable_ImmutableArray_CreateRange_T = typing.TypeVar("System_Collections_Immutable_ImmutableArray_CreateRange_T")
System_Collections_Immutable_ImmutableArray_CreateRange_TResult = typing.TypeVar("System_Collections_Immutable_ImmutableArray_CreateRange_TResult")
System_Collections_Immutable_ImmutableArray_CreateRange_TSource = typing.TypeVar("System_Collections_Immutable_ImmutableArray_CreateRange_TSource")
System_Collections_Immutable_ImmutableArray_ToImmutableArray_TSource = typing.TypeVar("System_Collections_Immutable_ImmutableArray_ToImmutableArray_TSource")
System_Collections_Immutable_ImmutableArray_AddRange_TDerived = typing.TypeVar("System_Collections_Immutable_ImmutableArray_AddRange_TDerived")
System_Collections_Immutable_ImmutableArray_OfType_TResult = typing.TypeVar("System_Collections_Immutable_ImmutableArray_OfType_TResult")
System_Collections_Immutable_ImmutableArray_CastUp_TDerived = typing.TypeVar("System_Collections_Immutable_ImmutableArray_CastUp_TDerived")
System_Collections_Immutable_ImmutableArray_CastArray_TOther = typing.TypeVar("System_Collections_Immutable_ImmutableArray_CastArray_TOther")
System_Collections_Immutable_ImmutableArray_As_TOther = typing.TypeVar("System_Collections_Immutable_ImmutableArray_As_TOther")
System_Collections_Immutable_ImmutableArray_AddRange_Builder_TDerived = typing.TypeVar("System_Collections_Immutable_ImmutableArray_AddRange_Builder_TDerived")
System_Collections_Immutable_ImmutableDictionary_Contains_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_Contains_TKey")
System_Collections_Immutable_ImmutableDictionary_Contains_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_Contains_TValue")
System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TValue")
System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TKey")
System_Collections_Immutable_ImmutableDictionary_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_TValue")
System_Collections_Immutable_ImmutableDictionary_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_TKey")
System_Collections_Immutable_ImmutableDictionary_Create_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_Create_TKey")
System_Collections_Immutable_ImmutableDictionary_Create_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_Create_TValue")
System_Collections_Immutable_ImmutableDictionary_CreateRange_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_CreateRange_TKey")
System_Collections_Immutable_ImmutableDictionary_CreateRange_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_CreateRange_TValue")
System_Collections_Immutable_ImmutableDictionary_CreateBuilder_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_CreateBuilder_TKey")
System_Collections_Immutable_ImmutableDictionary_CreateBuilder_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_CreateBuilder_TValue")
System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey")
System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue")
System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource = typing.TypeVar("System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource")
System_Collections_Immutable_ImmutableHashSet_Create_T = typing.TypeVar("System_Collections_Immutable_ImmutableHashSet_Create_T")
System_Collections_Immutable_ImmutableHashSet_T = typing.TypeVar("System_Collections_Immutable_ImmutableHashSet_T")
System_Collections_Immutable_ImmutableHashSet_CreateRange_T = typing.TypeVar("System_Collections_Immutable_ImmutableHashSet_CreateRange_T")
System_Collections_Immutable_ImmutableHashSet_CreateBuilder_T = typing.TypeVar("System_Collections_Immutable_ImmutableHashSet_CreateBuilder_T")
System_Collections_Immutable_ImmutableHashSet_ToImmutableHashSet_TSource = typing.TypeVar("System_Collections_Immutable_ImmutableHashSet_ToImmutableHashSet_TSource")
System_Collections_Immutable_ImmutableInterlocked_Update_T = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_Update_T")
System_Collections_Immutable_ImmutableInterlocked_Update_TArg = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_Update_TArg")
System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue")
System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TKey")
System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TArg = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TArg")
System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue")
System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TKey")
System_Collections_Immutable_ImmutableInterlocked_TryAdd_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_TryAdd_TKey")
System_Collections_Immutable_ImmutableInterlocked_TryAdd_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_TryAdd_TValue")
System_Collections_Immutable_ImmutableInterlocked_TryUpdate_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_TryUpdate_TKey")
System_Collections_Immutable_ImmutableInterlocked_TryUpdate_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_TryUpdate_TValue")
System_Collections_Immutable_ImmutableInterlocked_TryRemove_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_TryRemove_TKey")
System_Collections_Immutable_ImmutableInterlocked_Push_T = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_Push_T")
System_Collections_Immutable_ImmutableInterlocked_Enqueue_T = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_Enqueue_T")
System_Collections_Immutable_ImmutableInterlocked_InterlockedExchange_T = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_InterlockedExchange_T")
System_Collections_Immutable_ImmutableInterlocked_InterlockedCompareExchange_T = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_InterlockedCompareExchange_T")
System_Collections_Immutable_ImmutableInterlocked_InterlockedInitialize_T = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_InterlockedInitialize_T")
System_Collections_Immutable_ImmutableInterlocked_TryRemove_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_TryRemove_TValue")
System_Collections_Immutable_ImmutableInterlocked_TryPop_T = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_TryPop_T")
System_Collections_Immutable_ImmutableInterlocked_TryDequeue_T = typing.TypeVar("System_Collections_Immutable_ImmutableInterlocked_TryDequeue_T")
System_Collections_Immutable_ImmutableList_Create_T = typing.TypeVar("System_Collections_Immutable_ImmutableList_Create_T")
System_Collections_Immutable_ImmutableList_Replace_T = typing.TypeVar("System_Collections_Immutable_ImmutableList_Replace_T")
System_Collections_Immutable_ImmutableList_Remove_T = typing.TypeVar("System_Collections_Immutable_ImmutableList_Remove_T")
System_Collections_Immutable_ImmutableList_IndexOf_T = typing.TypeVar("System_Collections_Immutable_ImmutableList_IndexOf_T")
System_Collections_Immutable_ImmutableList_LastIndexOf_T = typing.TypeVar("System_Collections_Immutable_ImmutableList_LastIndexOf_T")
System_Collections_Immutable_ImmutableList_T = typing.TypeVar("System_Collections_Immutable_ImmutableList_T")
System_Collections_Immutable_ImmutableList_CreateRange_T = typing.TypeVar("System_Collections_Immutable_ImmutableList_CreateRange_T")
System_Collections_Immutable_ImmutableList_ToImmutableList_TSource = typing.TypeVar("System_Collections_Immutable_ImmutableList_ToImmutableList_TSource")
System_Collections_Immutable_ImmutableList_RemoveRange_T = typing.TypeVar("System_Collections_Immutable_ImmutableList_RemoveRange_T")
System_Collections_Immutable_ImmutableList_ConvertAll_TOutput = typing.TypeVar("System_Collections_Immutable_ImmutableList_ConvertAll_TOutput")
System_Collections_Immutable_ImmutableList_ConvertAll_Builder_TOutput = typing.TypeVar("System_Collections_Immutable_ImmutableList_ConvertAll_Builder_TOutput")
System_Collections_Immutable_ImmutableQueue_Create_T = typing.TypeVar("System_Collections_Immutable_ImmutableQueue_Create_T")
System_Collections_Immutable_ImmutableQueue_T = typing.TypeVar("System_Collections_Immutable_ImmutableQueue_T")
System_Collections_Immutable_ImmutableQueue_CreateRange_T = typing.TypeVar("System_Collections_Immutable_ImmutableQueue_CreateRange_T")
System_Collections_Immutable_ImmutableQueue_Dequeue_T = typing.TypeVar("System_Collections_Immutable_ImmutableQueue_Dequeue_T")
System_Collections_Immutable_ImmutableSortedDictionary_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_TValue")
System_Collections_Immutable_ImmutableSortedDictionary_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_TKey")
System_Collections_Immutable_ImmutableSortedDictionary_Create_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_Create_TKey")
System_Collections_Immutable_ImmutableSortedDictionary_Create_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_Create_TValue")
System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TKey")
System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TValue")
System_Collections_Immutable_ImmutableSortedDictionary_CreateBuilder_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_CreateBuilder_TKey")
System_Collections_Immutable_ImmutableSortedDictionary_CreateBuilder_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_CreateBuilder_TValue")
System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey")
System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue")
System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource = typing.TypeVar("System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource")
System_Collections_Immutable_ImmutableSortedSet_T = typing.TypeVar("System_Collections_Immutable_ImmutableSortedSet_T")
System_Collections_Immutable_ImmutableSortedSet_Create_T = typing.TypeVar("System_Collections_Immutable_ImmutableSortedSet_Create_T")
System_Collections_Immutable_ImmutableSortedSet_CreateRange_T = typing.TypeVar("System_Collections_Immutable_ImmutableSortedSet_CreateRange_T")
System_Collections_Immutable_ImmutableSortedSet_CreateBuilder_T = typing.TypeVar("System_Collections_Immutable_ImmutableSortedSet_CreateBuilder_T")
System_Collections_Immutable_ImmutableSortedSet_ToImmutableSortedSet_TSource = typing.TypeVar("System_Collections_Immutable_ImmutableSortedSet_ToImmutableSortedSet_TSource")
System_Collections_Immutable_ImmutableStack_Create_T = typing.TypeVar("System_Collections_Immutable_ImmutableStack_Create_T")
System_Collections_Immutable_ImmutableStack_T = typing.TypeVar("System_Collections_Immutable_ImmutableStack_T")
System_Collections_Immutable_ImmutableStack_CreateRange_T = typing.TypeVar("System_Collections_Immutable_ImmutableStack_CreateRange_T")
System_Collections_Immutable_ImmutableStack_Pop_T = typing.TypeVar("System_Collections_Immutable_ImmutableStack_Pop_T")


class IImmutableDictionary(typing.Generic[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue], System.Collections.Generic.IReadOnlyDictionary[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue], metaclass=abc.ABCMeta):
    """An immutable key-value dictionary."""

    def Add(self, key: System_Collections_Immutable_IImmutableDictionary_TKey, value: System_Collections_Immutable_IImmutableDictionary_TValue) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue]:
        """
        Adds the specified key and value to the dictionary.
        
        :param key: The key of the entry to add.
        :param value: The value of the entry to add.
        :returns: The new dictionary containing the additional key-value pair.
        """
        ...

    def AddRange(self, pairs: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue]]) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue]:
        """
        Adds the specified key-value pairs to the dictionary.
        
        :param pairs: The pairs.
        :returns: The new dictionary containing the additional key-value pairs.
        """
        ...

    def Clear(self) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue]:
        """Gets an empty dictionary with equivalent ordering and key/value comparison rules."""
        ...

    def Contains(self, pair: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue]) -> bool:
        """
        Determines whether this dictionary contains the specified key-value pair.
        
        :param pair: The key value pair.
        :returns: true if this dictionary contains the key-value pair; otherwise, false.
        """
        ...

    def Remove(self, key: System_Collections_Immutable_IImmutableDictionary_TKey) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue]:
        """
        Removes the specified key from the dictionary with its associated value.
        
        :param key: The key to remove.
        :returns: A new dictionary with the matching entry removed; or this instance if the key is not in the dictionary.
        """
        ...

    def RemoveRange(self, keys: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableDictionary_TKey]) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue]:
        """
        Removes the specified keys from the dictionary with their associated values.
        
        :param keys: The keys to remove.
        :returns: A new dictionary with those keys removed; or this instance if those keys are not in the dictionary.
        """
        ...

    def SetItem(self, key: System_Collections_Immutable_IImmutableDictionary_TKey, value: System_Collections_Immutable_IImmutableDictionary_TValue) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue]:
        """
        Sets the specified key and value to the dictionary, possibly overwriting an existing value for the given key.
        
        :param key: The key of the entry to add.
        :param value: The value of the entry to add.
        :returns: The new dictionary containing the additional key-value pair.
        """
        ...

    def SetItems(self, items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue]]) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_IImmutableDictionary_TKey, System_Collections_Immutable_IImmutableDictionary_TValue]:
        """
        Applies a given set of key=value pairs to an immutable dictionary, replacing any conflicting keys in the resulting dictionary.
        
        :param items: The key=value pairs to set on the dictionary.  Any keys that conflict with existing keys will overwrite the previous values.
        :returns: An immutable dictionary.
        """
        ...

    def TryGetKey(self, equalKey: System_Collections_Immutable_IImmutableDictionary_TKey, actualKey: typing.Optional[System_Collections_Immutable_IImmutableDictionary_TKey]) -> typing.Union[bool, System_Collections_Immutable_IImmutableDictionary_TKey]:
        """
        Searches the dictionary for a given key and returns the equal key it finds, if any.
        
        :param equalKey: The key to search for.
        :param actualKey: The key from the dictionary that the search found, or  if the search yielded no match.
        :returns: A value indicating whether the search was successful.
        """
        ...


class IImmutableList(typing.Generic[System_Collections_Immutable_IImmutableList_T], System.Collections.Generic.IReadOnlyList[System_Collections_Immutable_IImmutableList_T], metaclass=abc.ABCMeta):
    """A list of elements that can only be modified by creating a new instance of the list."""

    def Add(self, value: System_Collections_Immutable_IImmutableList_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Adds the specified value to this list.
        
        :param value: The value to add.
        :returns: A new list with the element added.
        """
        ...

    def AddRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableList_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Adds the specified values to this list.
        
        :param items: The values to add.
        :returns: A new list with the elements added.
        """
        ...

    def Clear(self) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """Gets an empty list that retains the same sort semantics that this instance has."""
        ...

    def IndexOf(self, item: System_Collections_Immutable_IImmutableList_T, index: int, count: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_IImmutableList_T]) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        first occurrence within the range of elements in the ImmutableList{T}
        that starts at the specified index and contains the specified number of elements.
        
        :param item: The object to locate in the ImmutableList{T}. The value can be null for reference types.
        :param index: The zero-based starting index of the search. 0 (zero) is valid in an empty list.
        :param count: The number of elements in the section to search.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: The zero-based index of the first occurrence of item within the range of elements in the ImmutableList{T} that starts at index and contains count number of elements, if found; otherwise, -1.
        """
        ...

    def Insert(self, index: int, element: System_Collections_Immutable_IImmutableList_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Inserts the specified value at the specified index.
        
        :param index: The index at which to insert the value.
        :param element: The element to insert.
        :returns: The new immutable list.
        """
        ...

    def InsertRange(self, index: int, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableList_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Inserts the specified values at the specified index.
        
        :param index: The index at which to insert the value.
        :param items: The elements to insert.
        :returns: The new immutable list.
        """
        ...

    def LastIndexOf(self, item: System_Collections_Immutable_IImmutableList_T, index: int, count: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_IImmutableList_T]) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        last occurrence within the range of elements in the ImmutableList{T}
        that contains the specified number of elements and ends at the specified
        index.
        
        :param item: The object to locate in the ImmutableList{T}. The value can be null for reference types.
        :param index: The starting position of the search. The search proceeds from  toward the beginning of this instance.
        :param count: The number of elements in the section to search.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: The zero-based index of the last occurrence of  within the range of elements in the ImmutableList{T} that contains  number of elements and ends at , if found; otherwise, -1.
        """
        ...

    def Remove(self, value: System_Collections_Immutable_IImmutableList_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_IImmutableList_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Removes the specified value from this list.
        
        :param value: The value to remove.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: A new list with the element removed, or this list if the element is not in this list.
        """
        ...

    def RemoveAll(self, match: typing.Callable[[System_Collections_Immutable_IImmutableList_T], bool]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Removes all the elements that match the conditions defined by the specified
        predicate.
        
        :param match: The Predicate{T} delegate that defines the conditions of the elements to remove.
        :returns: The new list.
        """
        ...

    def RemoveAt(self, index: int) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Removes the element at the specified index.
        
        :param index: The index.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableList_T], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_IImmutableList_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Removes the specified values from this list.
        
        :param items: The items to remove if matches are found in this list.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, index: int, count: int) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Removes the specified values from this list.
        
        :param index: The starting index to begin removal.
        :param count: The number of elements to remove.
        :returns: A new list with the elements removed.
        """
        ...

    def Replace(self, oldValue: System_Collections_Immutable_IImmutableList_T, newValue: System_Collections_Immutable_IImmutableList_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_IImmutableList_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Replaces the first equal element in the list with the specified element.
        
        :param oldValue: The element to replace.
        :param newValue: The element to replace the old element with.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: The new list -- even if the value being replaced is equal to the new value for that position.
        """
        ...

    def SetItem(self, index: int, value: System_Collections_Immutable_IImmutableList_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_IImmutableList_T]:
        """
        Replaces an element in the list at a given position with the specified element.
        
        :param index: The position in the list of the element to replace.
        :param value: The element to replace the old element with.
        :returns: The new list -- even if the value being replaced is equal to the new value for that position.
        """
        ...


class IImmutableQueue(typing.Generic[System_Collections_Immutable_IImmutableQueue_T], metaclass=abc.ABCMeta):
    """An immutable queue."""

    @property
    @abc.abstractmethod
    def IsEmpty(self) -> bool:
        """Gets a value indicating whether this is the empty queue."""
        ...

    def Clear(self) -> System.Collections.Immutable.IImmutableQueue[System_Collections_Immutable_IImmutableQueue_T]:
        """Gets an empty queue."""
        ...

    def Dequeue(self) -> System.Collections.Immutable.IImmutableQueue[System_Collections_Immutable_IImmutableQueue_T]:
        """
        Returns a queue that is missing the front element.
        
        :returns: A queue; never null.
        """
        ...

    def Enqueue(self, value: System_Collections_Immutable_IImmutableQueue_T) -> System.Collections.Immutable.IImmutableQueue[System_Collections_Immutable_IImmutableQueue_T]:
        """
        Adds an element to the back of the queue.
        
        :param value: The value.
        :returns: The new queue.
        """
        ...

    def Peek(self) -> System_Collections_Immutable_IImmutableQueue_T:
        """
        Gets the element at the front of the queue.
        
        :returns: The element at the front of the queue.
        """
        ...


class IImmutableSet(typing.Generic[System_Collections_Immutable_IImmutableSet_T], System.Collections.Generic.IReadOnlyCollection[System_Collections_Immutable_IImmutableSet_T], metaclass=abc.ABCMeta):
    """A set of elements that can only be modified by creating a new instance of the set."""

    def Add(self, value: System_Collections_Immutable_IImmutableSet_T) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_IImmutableSet_T]:
        """
        Adds the specified value to this set.
        
        :param value: The value to add.
        :returns: A new set with the element added, or this set if the element is already in this set.
        """
        ...

    def Clear(self) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_IImmutableSet_T]:
        """Gets an empty set that retains the same sort or unordered semantics that this instance has."""
        ...

    def Contains(self, value: System_Collections_Immutable_IImmutableSet_T) -> bool:
        """
        Determines whether this set contains the specified value.
        
        :param value: The value.
        :returns: true if the set contains the specified value; otherwise, false.
        """
        ...

    def Except(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_IImmutableSet_T]:
        """
        Removes a given set of items from this set.
        
        :param other: The items to remove from this set.
        :returns: The new set with the items removed; or the original set if none of the items were in the set.
        """
        ...

    def Intersect(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_IImmutableSet_T]:
        """
        Produces a set that contains elements that exist in both this set and the specified set.
        
        :param other: The set to intersect with this one.
        :returns: A new set that contains any elements that exist in both sets.
        """
        ...

    def IsProperSubsetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableSet_T]) -> bool:
        """
        Determines whether the current set is a proper (strict) subset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a correct subset of other; otherwise, false.
        """
        ...

    def IsProperSupersetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableSet_T]) -> bool:
        """
        Determines whether the current set is a proper superset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a correct superset of other; otherwise, false.
        """
        ...

    def IsSubsetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableSet_T]) -> bool:
        """
        Determines whether a set is a subset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a subset of other; otherwise, false.
        """
        ...

    def IsSupersetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableSet_T]) -> bool:
        """
        Determines whether the current set is a superset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a superset of other; otherwise, false.
        """
        ...

    def Overlaps(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableSet_T]) -> bool:
        """
        Determines whether the current set overlaps with the specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set and other share at least one common element; otherwise, false.
        """
        ...

    def Remove(self, value: System_Collections_Immutable_IImmutableSet_T) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_IImmutableSet_T]:
        """
        Removes the specified value from this set.
        
        :param value: The value to remove.
        :returns: A new set with the element removed, or this set if the element is not in this set.
        """
        ...

    def SetEquals(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableSet_T]) -> bool:
        """
        Checks whether a given sequence of items entirely describe the contents of this set.
        
        :param other: The sequence of items to check against this set.
        :returns: A value indicating whether the sets are equal.
        """
        ...

    def SymmetricExcept(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_IImmutableSet_T]:
        """
        Produces a set that contains elements either in this set or a given sequence, but not both.
        
        :param other: The other sequence of items.
        :returns: The new set.
        """
        ...

    def TryGetValue(self, equalValue: System_Collections_Immutable_IImmutableSet_T, actualValue: typing.Optional[System_Collections_Immutable_IImmutableSet_T]) -> typing.Union[bool, System_Collections_Immutable_IImmutableSet_T]:
        """
        Searches the set for a given value and returns the equal value it finds, if any.
        
        :param equalValue: The value to search for.
        :param actualValue: The value from the set that the search found, or  if the search yielded no match.
        :returns: A value indicating whether the search was successful.
        """
        ...

    def Union(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_IImmutableSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_IImmutableSet_T]:
        """
        Adds a given set of items to this set.
        
        :param other: The items to add.
        :returns: The new set with the items added; or the original set if all the items were already in the set.
        """
        ...


class IImmutableStack(typing.Generic[System_Collections_Immutable_IImmutableStack_T], metaclass=abc.ABCMeta):
    """An immutable stack."""

    @property
    @abc.abstractmethod
    def IsEmpty(self) -> bool:
        """Gets a value indicating whether this is the empty stack."""
        ...

    def Clear(self) -> System.Collections.Immutable.IImmutableStack[System_Collections_Immutable_IImmutableStack_T]:
        """Gets an empty stack."""
        ...

    def Peek(self) -> System_Collections_Immutable_IImmutableStack_T:
        """Gets the element on the top of the stack."""
        ...

    def Pop(self) -> System.Collections.Immutable.IImmutableStack[System_Collections_Immutable_IImmutableStack_T]:
        """
        Pops the top element off the stack.
        
        :returns: The new stack; never null.
        """
        ...

    def Push(self, value: System_Collections_Immutable_IImmutableStack_T) -> System.Collections.Immutable.IImmutableStack[System_Collections_Immutable_IImmutableStack_T]:
        """
        Pushes an element onto a stack and returns the new stack.
        
        :param value: The element to push onto the stack.
        :returns: The new stack.
        """
        ...


class ImmutableArray(typing.Generic[System_Collections_Immutable_ImmutableArray_T], System.Collections.Generic.IList[System_Collections_Immutable_ImmutableArray_T], System.IEquatable[System_Collections_Immutable_ImmutableArray], System.Collections.IList, System.Collections.Immutable.IImmutableArray, System.Collections.IStructuralComparable, System.Collections.IStructuralEquatable, System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T], typing.Iterable[System_Collections_Immutable_ImmutableArray_T]):
    """A readonly array with O(1) indexable lookup time."""

    class Builder(System.Object, System.Collections.Generic.IList[System_Collections_Immutable_ImmutableArray_T], System.Collections.Generic.IReadOnlyList[System_Collections_Immutable_ImmutableArray_T], typing.Iterable[System_Collections_Immutable_ImmutableArray_T]):
        """
        A writable array accessor that can be converted into an ImmutableArray{T}
        instance without allocating memory.
        """

        @property
        def Capacity(self) -> int:
            """
            Get and sets the length of the internal array.  When set the internal array is
            reallocated to the given capacity if it is not already the specified length.
            """
            ...

        @Capacity.setter
        def Capacity(self, value: int):
            """
            Get and sets the length of the internal array.  When set the internal array is
            reallocated to the given capacity if it is not already the specified length.
            """
            ...

        @property
        def Count(self) -> int:
            """Gets or sets the length of the builder."""
            ...

        @Count.setter
        def Count(self, value: int):
            """Gets or sets the length of the builder."""
            ...

        @property
        def IsReadOnly(self) -> bool:
            """Gets a value indicating whether the ICollection{T} is read-only."""
            ...

        def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableArray_T:
            """
            Gets or sets the element at the specified index.
            
            :param index: The index.
            """
            ...

        def __setitem__(self, index: int, value: System_Collections_Immutable_ImmutableArray_T) -> None:
            """
            Gets or sets the element at the specified index.
            
            :param index: The index.
            """
            ...

        def Add(self, item: System_Collections_Immutable_ImmutableArray_T) -> None:
            """
            Adds an item to the ICollection{T}.
            
            :param item: The object to add to the ICollection{T}.
            """
            ...

        @overload
        def AddRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items.
            """
            ...

        @overload
        def AddRange(self, *items: System_Collections_Immutable_ImmutableArray_T) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items.
            """
            ...

        @overload
        def AddRange(self, items: typing.List[System_Collections_Immutable_ImmutableArray_AddRange_Builder_TDerived]) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items.
            """
            ...

        @overload
        def AddRange(self, items: typing.List[System_Collections_Immutable_ImmutableArray_T], length: int) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items.
            :param length: The number of elements from the source array to add.
            """
            ...

        @overload
        def AddRange(self, items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items.
            """
            ...

        @overload
        def AddRange(self, items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T], length: int) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items.
            :param length: The number of elements from the source array to add.
            """
            ...

        @overload
        def AddRange(self, items: System.ReadOnlySpan[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items to add at the end of the array.
            """
            ...

        @overload
        def AddRange(self, items: System.ReadOnlySpan[System_Collections_Immutable_ImmutableArray_AddRange_Builder_TDerived]) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items to add at the end of the array.
            """
            ...

        @overload
        def AddRange(self, items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_AddRange_Builder_TDerived]) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items to add at the end of the array.
            """
            ...

        @overload
        def AddRange(self, items: System.Collections.Immutable.ImmutableArray.Builder) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items to add at the end of the array.
            """
            ...

        @overload
        def AddRange(self, items: System.Collections.Immutable.ImmutableArray.Builder) -> None:
            """
            Adds the specified items to the end of the array.
            
            :param items: The items to add at the end of the array.
            """
            ...

        def Clear(self) -> None:
            """Removes all items from the ICollection{T}."""
            ...

        def Contains(self, item: System_Collections_Immutable_ImmutableArray_T) -> bool:
            """
            Determines whether the ICollection{T} contains a specific value.
            
            :param item: The object to locate in the ICollection{T}.
            :returns: true if  is found in the ICollection{T}; otherwise, false.
            """
            ...

        @overload
        def CopyTo(self, array: typing.List[System_Collections_Immutable_ImmutableArray_T], index: int) -> None:
            """
            Copies the current contents to the specified array.
            
            :param array: The array to copy to.
            :param index: The starting index of the target array.
            """
            ...

        @overload
        def CopyTo(self, destination: typing.List[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Copies the contents of this array to the specified array.
            
            :param destination: The array to copy to.
            """
            ...

        @overload
        def CopyTo(self, sourceIndex: int, destination: typing.List[System_Collections_Immutable_ImmutableArray_T], destinationIndex: int, length: int) -> None:
            """
            Copies the contents of this array to the specified array.
            
            :param sourceIndex: The index into this collection of the first element to copy.
            :param destination: The array to copy to.
            :param destinationIndex: The index into the destination array to which the first copied element is written.
            :param length: The number of elements to copy.
            """
            ...

        @overload
        def CopyTo(self, destination: System.Span[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Copies the current contents to the specified Span{T}.
            
            :param destination: The Span{T} to copy to.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableArray_T]:
            """
            Returns an enumerator for the contents of the array.
            
            :returns: An enumerator.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableArray_T]:
            """
            Returns an enumerator for the contents of the array.
            
            :returns: An enumerator.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.IEnumerator:
            """
            Returns an enumerator for the contents of the array.
            
            :returns: An enumerator.
            """
            ...

        @overload
        def IndexOf(self, item: System_Collections_Immutable_ImmutableArray_T) -> int:
            """
            Determines the index of a specific item in the IList{T}.
            
            :param item: The object to locate in the IList{T}.
            :returns: The index of  if found in the list; otherwise, -1.
            """
            ...

        @overload
        def IndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int) -> int:
            """
            Searches the array for the specified item.
            
            :param item: The item to search for.
            :param startIndex: The index at which to begin the search.
            :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
            """
            ...

        @overload
        def IndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int, count: int) -> int:
            """
            Searches the array for the specified item.
            
            :param item: The item to search for.
            :param startIndex: The index at which to begin the search.
            :param count: The number of elements to search.
            :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
            """
            ...

        @overload
        def IndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int, count: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> int:
            """
            Searches the array for the specified item.
            
            :param item: The item to search for.
            :param startIndex: The index at which to begin the search.
            :param count: The number of elements to search.
            :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
            :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
            """
            ...

        @overload
        def IndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> int:
            """
            Searches the array for the specified item.
            
            :param item: The item to search for.
            :param startIndex: The index at which to begin the search.
            :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
            :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
            """
            ...

        def Insert(self, index: int, item: System_Collections_Immutable_ImmutableArray_T) -> None:
            """
            Inserts an item to the IList{T} at the specified index.
            
            :param index: The zero-based index at which  should be inserted.
            :param item: The object to insert into the IList{T}.
            """
            ...

        @overload
        def InsertRange(self, index: int, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Inserts the specified values at the specified index.
            
            :param index: The index at which to insert the value.
            :param items: The elements to insert.
            """
            ...

        @overload
        def InsertRange(self, index: int, items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Inserts the specified values at the specified index.
            
            :param index: The index at which to insert the value.
            :param items: The elements to insert.
            """
            ...

        def ItemRef(self, index: int) -> typing.Any:
            """
            Gets a read-only reference to the element at the specified index.
            
            :param index: The index.
            """
            ...

        @overload
        def LastIndexOf(self, item: System_Collections_Immutable_ImmutableArray_T) -> int:
            """
            Searches the array for the specified item in reverse.
            
            :param item: The item to search for.
            :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
            """
            ...

        @overload
        def LastIndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int) -> int:
            """
            Searches the array for the specified item in reverse.
            
            :param item: The item to search for.
            :param startIndex: The index at which to begin the search.
            :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
            """
            ...

        @overload
        def LastIndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int, count: int) -> int:
            """
            Searches the array for the specified item in reverse.
            
            :param item: The item to search for.
            :param startIndex: The index at which to begin the search.
            :param count: The number of elements to search.
            :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
            """
            ...

        @overload
        def LastIndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int, count: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> int:
            """
            Searches the array for the specified item in reverse.
            
            :param item: The item to search for.
            :param startIndex: The index at which to begin the search.
            :param count: The number of elements to search.
            :param equalityComparer: The equality comparer to use in the search.
            :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
            """
            ...

        def MoveToImmutable(self) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
            """
            Extracts the internal array as an ImmutableArray{T} and replaces it
            with a zero length array.
            """
            ...

        @overload
        def Remove(self, element: System_Collections_Immutable_ImmutableArray_T) -> bool:
            """
            Removes the first occurrence of the specified element from the builder.
            If no match is found, the builder remains unchanged.
            
            :param element: The element.
            :returns: A value indicating whether the specified element was found and removed from the collection.
            """
            ...

        @overload
        def Remove(self, element: System_Collections_Immutable_ImmutableArray_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> bool:
            """
            Removes the first occurrence of the specified element from the builder.
            If no match is found, the builder remains unchanged.
            
            :param element: The element to remove.
            :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
            :returns: A value indicating whether the specified element was found and removed from the collection.
            """
            ...

        def RemoveAll(self, match: typing.Callable[[System_Collections_Immutable_ImmutableArray_T], bool]) -> None:
            """
            Removes all the elements that match the conditions defined by the specified
            predicate.
            
            :param match: The Predicate{T} delegate that defines the conditions of the elements to remove.
            """
            ...

        def RemoveAt(self, index: int) -> None:
            """
            Removes the IList{T} item at the specified index.
            
            :param index: The zero-based index of the item to remove.
            """
            ...

        @overload
        def RemoveRange(self, index: int, length: int) -> None:
            """
            Removes the specified values from this list.
            
            :param index: The 0-based index into the array for the element to omit from the returned array.
            :param length: The number of elements to remove.
            """
            ...

        @overload
        def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Removes the specified values from this list.
            
            :param items: The items to remove if matches are found in this list.
            """
            ...

        @overload
        def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Removes the specified values from this list.
            
            :param items: The items to remove if matches are found in this list.
            :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
            """
            ...

        @overload
        def Replace(self, oldValue: System_Collections_Immutable_ImmutableArray_T, newValue: System_Collections_Immutable_ImmutableArray_T) -> None:
            """
            Replaces the first equal element in the list with the specified element.
            
            :param oldValue: The element to replace.
            :param newValue: The element to replace the old element with.
            """
            ...

        @overload
        def Replace(self, oldValue: System_Collections_Immutable_ImmutableArray_T, newValue: System_Collections_Immutable_ImmutableArray_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Replaces the first equal element in the list with the specified element.
            
            :param oldValue: The element to replace.
            :param newValue: The element to replace the old element with.
            :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
            """
            ...

        def Reverse(self) -> None:
            """Reverses the order of elements in the collection."""
            ...

        @overload
        def Sort(self) -> None:
            """Sorts the array."""
            ...

        @overload
        def Sort(self, comparison: typing.Callable[[System_Collections_Immutable_ImmutableArray_T, System_Collections_Immutable_ImmutableArray_T], int]) -> None:
            """
            Sorts the elements in the entire array using
            the specified Comparison{T}.
            
            :param comparison: The Comparison{T} to use when comparing elements.
            """
            ...

        @overload
        def Sort(self, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Sorts the array.
            
            :param comparer: The comparer to use in sorting. If null, the default comparer is used.
            """
            ...

        @overload
        def Sort(self, index: int, count: int, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableArray_T]) -> None:
            """
            Sorts the array.
            
            :param index: The index of the first element to consider in the sort.
            :param count: The number of elements to include in the sort.
            :param comparer: The comparer to use in sorting. If null, the default comparer is used.
            """
            ...

        def ToArray(self) -> typing.List[System_Collections_Immutable_ImmutableArray_T]:
            """Creates a new array with the current contents of this Builder."""
            ...

        def ToImmutable(self) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
            """
            Returns an immutable copy of the current contents of this collection.
            
            :returns: An immutable array.
            """
            ...

    class Enumerator:
        """An array enumerator."""

        @property
        def Current(self) -> System_Collections_Immutable_ImmutableArray_T:
            """Gets the currently enumerated value."""
            ...

        def MoveNext(self) -> bool:
            """
            Advances to the next value to be enumerated.
            
            :returns: true if another item exists in the array; false otherwise.
            """
            ...

    TwoElementArray: typing.List[int] = ...
    """A two element array useful for throwing exceptions the way LINQ does."""

    @property
    def IsReadOnly(self) -> bool:
        """Gets a value indicating whether this instance is read only."""
        ...

    @property
    def Count(self) -> int:
        """Gets the number of array in the collection."""
        ...

    @property
    def IsFixedSize(self) -> bool:
        """Gets a value indicating whether this instance is fixed size."""
        ...

    @property
    def IsSynchronized(self) -> bool:
        """See the ICollection interface."""
        ...

    @property
    def SyncRoot(self) -> System.Object:
        """Gets the sync root."""
        ...

    Empty: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T] = ...

    @property
    def array(self) -> typing.List[System_Collections_Immutable_ImmutableArray_T]:
        ...

    @property
    def IsEmpty(self) -> bool:
        """Gets a value indicating whether this collection is empty."""
        ...

    @property
    def Length(self) -> int:
        """Gets the number of elements in the array."""
        ...

    @property
    def IsDefault(self) -> bool:
        """Gets a value indicating whether this struct was initialized without an actual array instance."""
        ...

    @property
    def IsDefaultOrEmpty(self) -> bool:
        """Gets a value indicating whether this struct is empty or uninitialized."""
        ...

    @property
    def Array(self) -> System.Array:
        """Gets an untyped reference to the array."""
        ...

    @overload
    def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableArray_T:
        """
        Gets or sets the element at the specified index in the read-only list.
        
        :param index: The zero-based index of the element to get.
        :returns: The element at the specified index in the read-only list.
        """
        ...

    @overload
    def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableArray_T:
        """
        Gets the element at the specified index.
        
        :param index: The index.
        :returns: The element.
        """
        ...

    @overload
    def __getitem__(self, index: int) -> typing.Any:
        """
        Gets or sets the object at the specified index.
        
        :param index: The index.
        """
        ...

    @overload
    def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableArray_T:
        ...

    @overload
    def __setitem__(self, index: int, value: System_Collections_Immutable_ImmutableArray_T) -> None:
        """
        Gets or sets the element at the specified index in the read-only list.
        
        :param index: The zero-based index of the element to get.
        :returns: The element at the specified index in the read-only list.
        """
        ...

    @overload
    def __setitem__(self, index: int, value: typing.Any) -> None:
        """
        Gets or sets the object at the specified index.
        
        :param index: The index.
        """
        ...

    @overload
    def Add(self, item: System_Collections_Immutable_ImmutableArray_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Returns a new array with the specified value inserted at the end.
        
        :param item: The item to insert at the end of the array.
        :returns: A new array.
        """
        ...

    @overload
    def Add(self, item: System_Collections_Immutable_ImmutableArray_T) -> None:
        ...

    @overload
    def Add(self, value: System_Collections_Immutable_ImmutableArray_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    @overload
    def Add(self, value: typing.Any) -> int:
        """
        Adds an item to the IList.
        
        :param value: The object to add to the IList.
        :returns: The position into which the new element was inserted, or -1 to indicate that the item was not inserted into the collection,.
        """
        ...

    @overload
    def AddRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Adds the specified values to this list.
        
        :param items: The values to add.
        :returns: A new list with the elements added.
        """
        ...

    @overload
    def AddRange(self, items: typing.List[System_Collections_Immutable_ImmutableArray_T], length: int) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Adds the specified items to the end of the array.
        
        :param items: The values to add.
        :param length: The number of elements from the source array to add.
        :returns: A new list with the elements added.
        """
        ...

    @overload
    def AddRange(self, items: typing.List[System_Collections_Immutable_ImmutableArray_AddRange_TDerived]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Adds the specified items to the end of the array.
        
        :param items: The values to add.
        :returns: A new list with the elements added.
        """
        ...

    @overload
    def AddRange(self, items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T], length: int) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Adds the specified items to the end of the array.
        
        :param items: The values to add.
        :param length: The number of elements from the source array to add.
        :returns: A new list with the elements added.
        """
        ...

    @overload
    def AddRange(self, items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_AddRange_TDerived]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Adds the specified items to the end of the array.
        
        :param items: The values to add.
        :returns: A new list with the elements added.
        """
        ...

    @overload
    def AddRange(self, items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Adds the specified values to this list.
        
        :param items: The values to add.
        :returns: A new list with the elements added.
        """
        ...

    @overload
    def AddRange(self, items: System.ReadOnlySpan[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Adds the specified values to this list.
        
        :param items: The values to add.
        :returns: A new list with the elements added.
        """
        ...

    @overload
    def AddRange(self, *items: System_Collections_Immutable_ImmutableArray_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Adds the specified values to this list.
        
        :param items: The values to add.
        :returns: A new list with the elements added.
        """
        ...

    @overload
    def AddRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    def As(self) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_As_TOther]:
        """
        Creates an immutable array for this array, cast to a different element type.
        
        :returns: A struct typed for the base element type. If the cast fails, an instance is returned whose IsDefault property returns true.
        """
        ...

    def AsMemory(self) -> System.ReadOnlyMemory[System_Collections_Immutable_ImmutableArray_T]:
        ...

    @overload
    def AsSpan(self) -> System.ReadOnlySpan[System_Collections_Immutable_ImmutableArray_T]:
        ...

    @overload
    def AsSpan(self, start: int, length: int) -> System.ReadOnlySpan[System_Collections_Immutable_ImmutableArray_T]:
        """
        Creates a ReadOnlySpan{T} over the portion of current ImmutableArray{T} beginning at a specified position for a specified length.
        
        :param start: The index at which to begin the span.
        :param length: The number of items in the span.
        :returns: The ReadOnlySpan{T} representation of the ImmutableArray{T}.
        """
        ...

    @overload
    def AsSpan(self, range: System.Range) -> System.ReadOnlySpan[System_Collections_Immutable_ImmutableArray_T]:
        """
        Creates a ReadOnlySpan{T} over the portion of current ImmutableArray{T} based on specified
        
        :param range: Range in current ImmutableArray{T}.
        :returns: The ReadOnlySpan{T} representation of the ImmutableArray{T}.
        """
        ...

    @staticmethod
    @overload
    def BinarySearch(array: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_BinarySearch_T], value: System_Collections_Immutable_ImmutableArray_BinarySearch_T) -> int:
        """
        Searches an entire one-dimensional sorted ImmutableArray{T} for a specific element,
        using the IComparable{T} generic interface implemented by each element
        of the ImmutableArray{T} and by the specified object.
        
        :param array: The sorted, one-dimensional array to search.
        :param value: The object to search for.
        :returns: The index of the specified  in the specified array, if  is found. If  is not found and  is less than one or more elements in array, a negative number which is the bitwise complement of the index of the first element that is larger than . If  is not found and  is greater than any of the elements in array, a negative number which is the bitwise complement of (the index of the last element plus 1).
        """
        ...

    @staticmethod
    @overload
    def BinarySearch(array: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_BinarySearch_T], value: System_Collections_Immutable_ImmutableArray_BinarySearch_T, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableArray_BinarySearch_T]) -> int:
        """
        Searches an entire one-dimensional sorted ImmutableArray{T} for a value using
        the specified IComparer{T} generic interface.
        
        :param array: The sorted, one-dimensional array to search.
        :param value: The object to search for.
        :param comparer: The IComparer{T} implementation to use when comparing elements; or null to use the IComparable{T} implementation of each element.
        :returns: The index of the specified  in the specified array, if  is found. If  is not found and  is less than one or more elements in array, a negative number which is the bitwise complement of the index of the first element that is larger than . If  is not found and  is greater than any of the elements in array, a negative number which is the bitwise complement of (the index of the last element plus 1).
        """
        ...

    @staticmethod
    @overload
    def BinarySearch(array: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_BinarySearch_T], index: int, length: int, value: System_Collections_Immutable_ImmutableArray_BinarySearch_T) -> int:
        """
        Searches a range of elements in a one-dimensional sorted ImmutableArray{T} for
        a value, using the IComparable{T} generic interface implemented by
        each element of the ImmutableArray{T} and by the specified value.
        
        :param array: The sorted, one-dimensional array to search.
        :param index: The starting index of the range to search.
        :param length: The length of the range to search.
        :param value: The object to search for.
        :returns: The index of the specified  in the specified , if  is found. If  is not found and  is less than one or more elements in , a negative number which is the bitwise complement of the index of the first element that is larger than . If  is not found and  is greater than any of the elements in , a negative number which is the bitwise complement of (the index of the last element plus 1).
        """
        ...

    @staticmethod
    @overload
    def BinarySearch(array: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_BinarySearch_T], index: int, length: int, value: System_Collections_Immutable_ImmutableArray_BinarySearch_T, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableArray_BinarySearch_T]) -> int:
        """
        Searches a range of elements in a one-dimensional sorted ImmutableArray{T} for
        a value, using the specified IComparer{T} generic
        interface.
        
        :param array: The sorted, one-dimensional array to search.
        :param index: The starting index of the range to search.
        :param length: The length of the range to search.
        :param value: The object to search for.
        :param comparer: The IComparer{T} implementation to use when comparing elements; or null to use the IComparable{T} implementation of each element.
        :returns: The index of the specified  in the specified , if  is found. If  is not found and  is less than one or more elements in , a negative number which is the bitwise complement of the index of the first element that is larger than . If  is not found and  is greater than any of the elements in , a negative number which is the bitwise complement of (the index of the last element plus 1).
        """
        ...

    def CastArray(self) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CastArray_TOther]:
        """
        Initializes a new instance of the ImmutableArray{T} struct by casting the underlying
        array to an array of type .
        """
        ...

    @staticmethod
    def CastUp(items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CastUp_TDerived]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Initializes a new instance of the ImmutableArray{T} struct based on the contents
        of an existing instance, allowing a covariant static cast to efficiently reuse the existing array.
        
        :param items: The array to initialize the array with. No copy is made.
        """
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """Returns an empty array."""
        ...

    @overload
    def Clear(self) -> None:
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    @overload
    def Clear(self) -> None:
        """Removes all items from the ICollection{T}."""
        ...

    def CompareTo(self, other: typing.Any, comparer: System.Collections.IComparer) -> int:
        """
        Determines whether the current collection object precedes, occurs in the
        same position as, or follows another object in the sort order.
        
        :param other: The object to compare with the current instance.
        :param comparer: An object that compares members of the current collection object with the corresponding members of other.
        :returns: An integer that indicates the relationship of the current collection object to other.
        """
        ...

    @overload
    def Contains(self, item: System_Collections_Immutable_ImmutableArray_T) -> bool:
        """
        Determines whether the specified item exists in the array.
        
        :param item: The item to search for.
        :returns: true if an equal value was found in the array; false otherwise.
        """
        ...

    @overload
    def Contains(self, value: typing.Any) -> bool:
        """
        Determines whether the IList contains a specific value.
        
        :param value: The object to locate in the IList.
        :returns: true if the object is found in the IList; otherwise, false.
        """
        ...

    @overload
    def CopyTo(self, destination: System.Span[System_Collections_Immutable_ImmutableArray_T]) -> None:
        """
        Copies the elements of current ImmutableArray{T} to an Span{T}.
        
        :param destination: The Span{T} that is the destination of the elements copied from current ImmutableArray{T}.
        """
        ...

    @overload
    def CopyTo(self, array: System.Array, index: int) -> None:
        """
        Copies the elements of the ICollection to an Array, starting at a particular Array index.
        
        :param array: The one-dimensional Array that is the destination of the elements copied from ICollection. The Array must have zero-based indexing.
        :param index: The zero-based index in  at which copying begins.
        """
        ...

    @overload
    def CopyTo(self, destination: typing.List[System_Collections_Immutable_ImmutableArray_T]) -> None:
        """
        Copies the contents of this array to the specified array.
        
        :param destination: The array to copy to.
        """
        ...

    @overload
    def CopyTo(self, destination: typing.List[System_Collections_Immutable_ImmutableArray_T], destinationIndex: int) -> None:
        """
        Copies the contents of this array to the specified array.
        
        :param destination: The array to copy to.
        :param destinationIndex: The index into the destination array to which the first copied element is written.
        """
        ...

    @overload
    def CopyTo(self, sourceIndex: int, destination: typing.List[System_Collections_Immutable_ImmutableArray_T], destinationIndex: int, length: int) -> None:
        """
        Copies the contents of this array to the specified array.
        
        :param sourceIndex: The index into this collection of the first element to copy.
        :param destination: The array to copy to.
        :param destinationIndex: The index into the destination array to which the first copied element is written.
        :param length: The number of elements to copy.
        """
        ...

    @staticmethod
    @overload
    def Create() -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T]:
        """
        Creates an empty ImmutableArray{T}.
        
        :returns: An empty array.
        """
        ...

    @staticmethod
    @overload
    def Create(item: System_Collections_Immutable_ImmutableArray_Create_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T]:
        """
        Creates an ImmutableArray{T} with the specified element as its only member.
        
        :param item: The element to store in the array.
        :returns: A 1-element immutable array containing the specified item.
        """
        ...

    @staticmethod
    @overload
    def Create(item1: System_Collections_Immutable_ImmutableArray_Create_T, item2: System_Collections_Immutable_ImmutableArray_Create_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T]:
        """
        Creates an ImmutableArray{T} with the specified elements.
        
        :param item1: The first element to store in the array.
        :param item2: The second element to store in the array.
        :returns: A 2-element immutable array containing the specified items.
        """
        ...

    @staticmethod
    @overload
    def Create(item1: System_Collections_Immutable_ImmutableArray_Create_T, item2: System_Collections_Immutable_ImmutableArray_Create_T, item3: System_Collections_Immutable_ImmutableArray_Create_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T]:
        """
        Creates an ImmutableArray{T} with the specified elements.
        
        :param item1: The first element to store in the array.
        :param item2: The second element to store in the array.
        :param item3: The third element to store in the array.
        :returns: A 3-element immutable array containing the specified items.
        """
        ...

    @staticmethod
    @overload
    def Create(item1: System_Collections_Immutable_ImmutableArray_Create_T, item2: System_Collections_Immutable_ImmutableArray_Create_T, item3: System_Collections_Immutable_ImmutableArray_Create_T, item4: System_Collections_Immutable_ImmutableArray_Create_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T]:
        """
        Creates an ImmutableArray{T} with the specified elements.
        
        :param item1: The first element to store in the array.
        :param item2: The second element to store in the array.
        :param item3: The third element to store in the array.
        :param item4: The fourth element to store in the array.
        :returns: A 4-element immutable array containing the specified items.
        """
        ...

    @staticmethod
    @overload
    def Create(items: System.ReadOnlySpan[System_Collections_Immutable_ImmutableArray_Create_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T]:
        """
        Creates an ImmutableArray{T} with the specified elements.
        
        :param items: The elements to store in the array.
        :returns: An immutable array containing the specified items.
        """
        ...

    @staticmethod
    @overload
    def Create(items: System.Span[System_Collections_Immutable_ImmutableArray_Create_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T]:
        """
        Creates an ImmutableArray{T} with the specified elements.
        
        :param items: The elements to store in the array.
        :returns: An immutable array containing the specified items.
        """
        ...

    @staticmethod
    @overload
    def Create(*items: System_Collections_Immutable_ImmutableArray_Create_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T]:
        """
        Creates an ImmutableArray{T} with the specified elements.
        
        :param items: The elements to store in the array.
        :returns: An immutable array containing the specified items.
        """
        ...

    @staticmethod
    @overload
    def Create(items: typing.List[System_Collections_Immutable_ImmutableArray_Create_T], start: int, length: int) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T]:
        """
        Initializes a new instance of the ImmutableArray{T} struct.
        
        :param items: The array to initialize the array with. A defensive copy is made.
        :param start: The index of the first element in the source array to include in the resulting array.
        :param length: The number of elements from the source array to include in the resulting array.
        """
        ...

    @staticmethod
    @overload
    def Create(items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T], start: int, length: int) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_Create_T]:
        """
        Initializes a new instance of the ImmutableArray{T} struct.
        
        :param items: The array to initialize the array with. The selected array segment may be copied into a new array.
        :param start: The index of the first element in the source array to include in the resulting array.
        :param length: The number of elements from the source array to include in the resulting array.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder() -> System.Collections.Immutable.ImmutableArray.Builder:
        """
        Initializes a new instance of the ImmutableArray{T}.Builder class.
        
        :returns: A new builder.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder(initialCapacity: int) -> System.Collections.Immutable.ImmutableArray.Builder:
        """
        Initializes a new instance of the ImmutableArray{T}.Builder class.
        
        :param initialCapacity: The size of the initial array backing the builder.
        :returns: A new builder.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_CreateRange_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CreateRange_T]:
        """
        Creates an ImmutableArray{T} populated with the contents of the specified sequence.
        
        :param items: The elements to store in the array.
        :returns: An immutable array.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CreateRange_TSource], selector: typing.Callable[[System_Collections_Immutable_ImmutableArray_CreateRange_TSource], System_Collections_Immutable_ImmutableArray_CreateRange_TResult]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CreateRange_TResult]:
        """
        Initializes a new instance of the ImmutableArray{T} struct.
        
        :param items: The source array to initialize the resulting array with.
        :param selector: The function to apply to each element from the source array.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CreateRange_TSource], start: int, length: int, selector: typing.Callable[[System_Collections_Immutable_ImmutableArray_CreateRange_TSource], System_Collections_Immutable_ImmutableArray_CreateRange_TResult]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CreateRange_TResult]:
        """
        Initializes a new instance of the ImmutableArray{T} struct.
        
        :param items: The source array to initialize the resulting array with.
        :param start: The index of the first element in the source array to include in the resulting array.
        :param length: The number of elements from the source array to include in the resulting array.
        :param selector: The function to apply to each element from the source array included in the resulting array.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CreateRange_TSource], selector: typing.Callable[[System_Collections_Immutable_ImmutableArray_CreateRange_TSource, System_Collections_Immutable_ImmutableArray_CreateRange_TArg], System_Collections_Immutable_ImmutableArray_CreateRange_TResult], arg: System_Collections_Immutable_ImmutableArray_CreateRange_TArg) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CreateRange_TResult]:
        """
        Initializes a new instance of the ImmutableArray{T} struct.
        
        :param items: The source array to initialize the resulting array with.
        :param selector: The function to apply to each element from the source array.
        :param arg: An argument to be passed to the selector mapping function.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CreateRange_TSource], start: int, length: int, selector: typing.Callable[[System_Collections_Immutable_ImmutableArray_CreateRange_TSource, System_Collections_Immutable_ImmutableArray_CreateRange_TArg], System_Collections_Immutable_ImmutableArray_CreateRange_TResult], arg: System_Collections_Immutable_ImmutableArray_CreateRange_TArg) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_CreateRange_TResult]:
        """
        Initializes a new instance of the ImmutableArray{T} struct.
        
        :param items: The source array to initialize the resulting array with.
        :param start: The index of the first element in the source array to include in the resulting array.
        :param length: The number of elements from the source array to include in the resulting array.
        :param selector: The function to apply to each element from the source array included in the resulting array.
        :param arg: An argument to be passed to the selector mapping function.
        """
        ...

    @overload
    def Equals(self, other: typing.Any, comparer: System.Collections.IEqualityComparer) -> bool:
        """
        Determines whether an object is structurally equal to the current instance.
        
        :param other: The object to compare with the current instance.
        :param comparer: An object that determines whether the current instance and other are equal.
        :returns: true if the two objects are equal; otherwise, false.
        """
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Determines whether the specified object is equal to this instance.
        
        :param obj: The object to compare with this instance.
        :returns: true if the specified object is equal to this instance; otherwise, false.
        """
        ...

    @overload
    def Equals(self, other: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]) -> bool:
        """
        Indicates whether the current object is equal to another object of the same type.
        
        :param other: An object to compare with this object.
        :returns: true if the current object is equal to the  parameter; otherwise, false.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Immutable.ImmutableArray.Enumerator:
        """
        Returns an enumerator for the contents of the array.
        
        :returns: An enumerator.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableArray_T]:
        """
        Returns an enumerator for the contents of the array.
        
        :returns: An enumerator.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        """
        Returns an enumerator for the contents of the array.
        
        :returns: An enumerator.
        """
        ...

    @overload
    def GetHashCode(self, comparer: System.Collections.IEqualityComparer) -> int:
        """
        Returns a hash code for the current instance.
        
        :param comparer: An object that computes the hash code of the current object.
        :returns: The hash code for the current instance.
        """
        ...

    @overload
    def GetHashCode(self) -> int:
        """
        Returns a hash code for this instance.
        
        :returns: A hash code for this instance, suitable for use in hashing algorithms and data structures like a hash table.
        """
        ...

    @overload
    def IndexOf(self, item: System_Collections_Immutable_ImmutableArray_T) -> int:
        """
        Searches the array for the specified item.
        
        :param item: The item to search for.
        :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
        """
        ...

    @overload
    def IndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> int:
        """
        Searches the array for the specified item.
        
        :param item: The item to search for.
        :param startIndex: The index at which to begin the search.
        :param equalityComparer: The equality comparer to use in the search.
        :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
        """
        ...

    @overload
    def IndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int) -> int:
        """
        Searches the array for the specified item.
        
        :param item: The item to search for.
        :param startIndex: The index at which to begin the search.
        :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
        """
        ...

    @overload
    def IndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int, count: int) -> int:
        """
        Searches the array for the specified item.
        
        :param item: The item to search for.
        :param startIndex: The index at which to begin the search.
        :param count: The number of elements to search.
        :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
        """
        ...

    @overload
    def IndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int, count: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> int:
        """
        Searches the array for the specified item.
        
        :param item: The item to search for.
        :param startIndex: The index at which to begin the search.
        :param count: The number of elements to search.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
        """
        ...

    @overload
    def IndexOf(self, value: typing.Any) -> int:
        """
        Determines the index of a specific item in the IList.
        
        :param value: The object to locate in the IList.
        :returns: The index of  if found in the list; otherwise, -1.
        """
        ...

    @overload
    def Insert(self, index: int, item: System_Collections_Immutable_ImmutableArray_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Returns a new array with the specified value inserted at the specified position.
        
        :param index: The 0-based index into the array at which the new item should be added.
        :param item: The item to insert at the start of the array.
        :returns: A new array.
        """
        ...

    @overload
    def Insert(self, index: int, item: System_Collections_Immutable_ImmutableArray_T) -> None:
        ...

    @overload
    def Insert(self, index: int, element: System_Collections_Immutable_ImmutableArray_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    @overload
    def Insert(self, index: int, value: typing.Any) -> None:
        """
        Inserts an item to the IList at the specified index.
        
        :param index: The zero-based index at which  should be inserted.
        :param value: The object to insert into the IList.
        """
        ...

    @overload
    def InsertRange(self, index: int, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Inserts the specified values at the specified index.
        
        :param index: The index at which to insert the value.
        :param items: The elements to insert.
        :returns: The new immutable collection.
        """
        ...

    @overload
    def InsertRange(self, index: int, items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Inserts the specified values at the specified index.
        
        :param index: The index at which to insert the value.
        :param items: The elements to insert.
        :returns: The new immutable collection.
        """
        ...

    @overload
    def InsertRange(self, index: int, items: typing.List[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Inserts the specified values at the specified index.
        
        :param index: The index at which to insert the value.
        :param items: The elements to insert.
        :returns: The new immutable collection.
        """
        ...

    @overload
    def InsertRange(self, index: int, items: System.ReadOnlySpan[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Inserts the specified values at the specified index.
        
        :param index: The index at which to insert the value.
        :param items: The elements to insert.
        :returns: The new immutable collection.
        """
        ...

    @overload
    def InsertRange(self, index: int, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    def ItemRef(self, index: int) -> typing.Any:
        """
        Gets a read-only reference to the element at the specified index in the read-only list.
        
        :param index: The zero-based index of the element to get a reference to.
        :returns: A read-only reference to the element at the specified index in the read-only list.
        """
        ...

    @overload
    def LastIndexOf(self, item: System_Collections_Immutable_ImmutableArray_T) -> int:
        """
        Searches the array for the specified item in reverse.
        
        :param item: The item to search for.
        :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
        """
        ...

    @overload
    def LastIndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int) -> int:
        """
        Searches the array for the specified item in reverse.
        
        :param item: The item to search for.
        :param startIndex: The index at which to begin the search.
        :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
        """
        ...

    @overload
    def LastIndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int, count: int) -> int:
        """
        Searches the array for the specified item in reverse.
        
        :param item: The item to search for.
        :param startIndex: The index at which to begin the search.
        :param count: The number of elements to search.
        :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
        """
        ...

    @overload
    def LastIndexOf(self, item: System_Collections_Immutable_ImmutableArray_T, startIndex: int, count: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> int:
        """
        Searches the array for the specified item in reverse.
        
        :param item: The item to search for.
        :param startIndex: The index at which to begin the search.
        :param count: The number of elements to search.
        :param equalityComparer: The equality comparer to use in the search.
        :returns: The 0-based index into the array where the item was found; or -1 if it could not be found.
        """
        ...

    def OfType(self) -> System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_OfType_TResult]:
        """
        Filters the elements of this array to those assignable to the specified type.
        
        :returns: An IEnumerable{T} that contains elements from the input sequence of type TResult.
        """
        ...

    @overload
    def Remove(self, item: System_Collections_Immutable_ImmutableArray_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Returns an array with the first occurrence of the specified element removed from the array.
        If no match is found, the current array is returned.
        
        :param item: The item to remove.
        :returns: The new array.
        """
        ...

    @overload
    def Remove(self, item: System_Collections_Immutable_ImmutableArray_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Returns an array with the first occurrence of the specified element removed from the array.
        If no match is found, the current array is returned.
        
        :param item: The item to remove.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: The new array.
        """
        ...

    @overload
    def Remove(self, item: System_Collections_Immutable_ImmutableArray_T) -> bool:
        ...

    @overload
    def Remove(self, value: System_Collections_Immutable_ImmutableArray_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    @overload
    def Remove(self, value: typing.Any) -> None:
        """
        Removes the first occurrence of a specific object from the IList.
        
        :param value: The object to remove from the IList.
        """
        ...

    @overload
    def RemoveAll(self, match: typing.Callable[[System_Collections_Immutable_ImmutableArray_T], bool]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Removes all the elements that match the conditions defined by the specified
        predicate.
        
        :param match: The Predicate{T} delegate that defines the conditions of the elements to remove.
        :returns: The new list.
        """
        ...

    @overload
    def RemoveAll(self, match: typing.Callable[[System_Collections_Immutable_ImmutableArray_T], bool]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    @overload
    def RemoveAt(self, index: int) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Returns an array with the element at the specified position removed.
        
        :param index: The 0-based index into the array for the element to omit from the returned array.
        :returns: The new array.
        """
        ...

    @overload
    def RemoveAt(self, index: int) -> None:
        ...

    @overload
    def RemoveAt(self, index: int) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    @overload
    def RemoveAt(self, index: int) -> None:
        """
        Removes the IList{T} item at the specified index.
        
        :param index: The zero-based index of the item to remove.
        """
        ...

    @overload
    def RemoveRange(self, index: int, length: int) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Returns an array with the elements at the specified position removed.
        
        :param index: The 0-based index into the array for the element to omit from the returned array.
        :param length: The number of elements to remove.
        :returns: The new array.
        """
        ...

    @overload
    def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Removes the specified values from this list.
        
        :param items: The items to remove if matches are found in this list.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Removes the specified values from this list.
        
        :param items: The items to remove if matches are found in this list.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Removes the specified values from this list.
        
        :param items: The items to remove if matches are found in this list.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, items: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Removes the specified values from this list.
        
        :param items: The items to remove if matches are found in this list.
        :param equalityComparer: The equality comparer to use in the search.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, items: System.ReadOnlySpan[System_Collections_Immutable_ImmutableArray_T], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T] = None) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Removes the specified values from this list.
        
        :param items: The items to remove if matches are found in this list.
        :param equalityComparer: The equality comparer to use in the search.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, items: typing.List[System_Collections_Immutable_ImmutableArray_T], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T] = None) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Removes the specified values from this list.
        
        :param items: The items to remove if matches are found in this list.
        :param equalityComparer: The equality comparer to use in the search.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_T], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    @overload
    def RemoveRange(self, index: int, count: int) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    @overload
    def Replace(self, oldValue: System_Collections_Immutable_ImmutableArray_T, newValue: System_Collections_Immutable_ImmutableArray_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Replaces the first equal element in the list with the specified element.
        
        :param oldValue: The element to replace.
        :param newValue: The element to replace the old element with.
        :returns: The new list -- even if the value being replaced is equal to the new value for that position.
        """
        ...

    @overload
    def Replace(self, oldValue: System_Collections_Immutable_ImmutableArray_T, newValue: System_Collections_Immutable_ImmutableArray_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Replaces the first equal element in the list with the specified element.
        
        :param oldValue: The element to replace.
        :param newValue: The element to replace the old element with.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: The new list -- even if the value being replaced is equal to the new value for that position.
        """
        ...

    @overload
    def Replace(self, oldValue: System_Collections_Immutable_ImmutableArray_T, newValue: System_Collections_Immutable_ImmutableArray_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    @overload
    def SetItem(self, index: int, item: System_Collections_Immutable_ImmutableArray_T) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Returns an array with the item at the specified position replaced.
        
        :param index: The index of the item to replace.
        :param item: The new item.
        :returns: The new array.
        """
        ...

    @overload
    def SetItem(self, index: int, value: System_Collections_Immutable_ImmutableArray_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableArray_T]:
        """See IImmutableList{T}"""
        ...

    def Slice(self, start: int, length: int) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Forms a slice out of the current ImmutableArray{T} starting at a specified index for a specified length.
        
        :param start: The index at which to begin this slice.
        :param length: The desired length for the slice.
        :returns: A ImmutableArray{T} that consists of length elements from the current ImmutableArray{T} starting at start.
        """
        ...

    @overload
    def Sort(self) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """Returns a sorted instance of this array."""
        ...

    @overload
    def Sort(self, comparison: typing.Callable[[System_Collections_Immutable_ImmutableArray_T, System_Collections_Immutable_ImmutableArray_T], int]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Sorts the elements in the entire ImmutableArray{T} using
        the specified Comparison{T}.
        
        :param comparison: The Comparison{T} to use when comparing elements.
        :returns: The sorted list.
        """
        ...

    @overload
    def Sort(self, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Returns a sorted instance of this array.
        
        :param comparer: The comparer to use in sorting. If null, the default comparer is used.
        """
        ...

    @overload
    def Sort(self, index: int, count: int, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_T]:
        """
        Returns a sorted instance of this array.
        
        :param index: The index of the first element to consider in the sort.
        :param count: The number of elements to include in the sort.
        :param comparer: The comparer to use in sorting. If null, the default comparer is used.
        """
        ...

    def ToBuilder(self) -> System.Collections.Immutable.ImmutableArray.Builder:
        """
        Returns a builder that is populated with the same contents as this array.
        
        :returns: The new builder.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableArray(items: System.ReadOnlySpan[System_Collections_Immutable_ImmutableArray_ToImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_ToImmutableArray_T]:
        """
        Produce an immutable array of contents from specified elements.
        
        :param items: The elements to store in the array.
        :returns: An immutable array containing the specified items.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableArray(items: System.Span[System_Collections_Immutable_ImmutableArray_ToImmutableArray_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_ToImmutableArray_T]:
        """
        Produce an immutable array of contents from specified elements.
        
        :param items: The elements to store in the array.
        :returns: An immutable array containing the specified items.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableArray(items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableArray_ToImmutableArray_TSource]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_ToImmutableArray_TSource]:
        """
        Enumerates a sequence exactly once and produces an immutable array of its contents.
        
        :param items: The sequence to enumerate.
        :returns: An immutable array containing the specified items.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableArray(builder: System.Collections.Immutable.ImmutableArray.Builder) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableArray_ToImmutableArray_TSource]:
        """
        Returns an immutable copy of the current contents of the builder's collection.
        
        :param builder: The builder to create the immutable array from.
        :returns: An immutable array containing the specified items from .
        """
        ...


class ImmutableDictionary(typing.Generic[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue], System.Object, System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue], System.Collections.Immutable.IImmutableDictionaryInternal[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue], System.Collections.Generic.IHashKeyCollection[System_Collections_Immutable_ImmutableDictionary_TKey], System.Collections.Generic.IDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue], System.Collections.IDictionary, typing.Iterable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]]):
    """An immutable unordered dictionary implementation."""

    class Builder(System.Object, System.Collections.Generic.IDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue], System.Collections.Generic.IReadOnlyDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue], System.Collections.IDictionary, typing.Iterable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]]):
        """
        A dictionary that mutates with little or no memory allocations,
        can produce and/or build on immutable dictionary instances very efficiently.
        """

        @property
        def KeyComparer(self) -> System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_TKey]:
            """Gets or sets the key comparer."""
            ...

        @KeyComparer.setter
        def KeyComparer(self, value: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_TKey]):
            """Gets or sets the key comparer."""
            ...

        @property
        def ValueComparer(self) -> System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_TValue]:
            """Gets or sets the value comparer."""
            ...

        @ValueComparer.setter
        def ValueComparer(self, value: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_TValue]):
            """Gets or sets the value comparer."""
            ...

        @property
        def Count(self) -> int:
            ...

        @property
        def IsReadOnly(self) -> bool:
            """Gets a value indicating whether the ICollection{T} is read-only."""
            ...

        @property
        def Keys(self) -> System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_TKey]:
            """See IReadOnlyDictionary{TKey, TValue}"""
            ...

        @property
        def Values(self) -> System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_TValue]:
            """See IReadOnlyDictionary{TKey, TValue}"""
            ...

        @property
        def IsFixedSize(self) -> bool:
            ...

        @property
        def SyncRoot(self) -> System.Object:
            ...

        @property
        def IsSynchronized(self) -> bool:
            """Gets a value indicating whether access to the ICollection is synchronized (thread safe)."""
            ...

        @property
        def Version(self) -> int:
            ...

        @overload
        def __getitem__(self, key: typing.Any) -> typing.Any:
            """
            Gets or sets the element with the specified key.
            
            :param key: The key.
            """
            ...

        @overload
        def __getitem__(self, key: System_Collections_Immutable_ImmutableDictionary_TKey) -> System_Collections_Immutable_ImmutableDictionary_TValue:
            """
            Gets or sets the element with the specified key.
            
            :returns: The element with the specified key.
            """
            ...

        @overload
        def __setitem__(self, key: typing.Any, value: typing.Any) -> None:
            """
            Gets or sets the element with the specified key.
            
            :param key: The key.
            """
            ...

        @overload
        def __setitem__(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, value: System_Collections_Immutable_ImmutableDictionary_TValue) -> None:
            """
            Gets or sets the element with the specified key.
            
            :returns: The element with the specified key.
            """
            ...

        @overload
        def Add(self, key: typing.Any, value: typing.Any) -> None:
            ...

        @overload
        def Add(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, value: System_Collections_Immutable_ImmutableDictionary_TValue) -> None:
            ...

        @overload
        def Add(self, item: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]) -> None:
            """
            Adds an item to the ICollection{T}.
            
            :param item: The object to add to the ICollection{T}.
            """
            ...

        def AddRange(self, items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]]) -> None:
            ...

        def Clear(self) -> None:
            """Removes all items from the ICollection{T}."""
            ...

        @overload
        def Contains(self, key: typing.Any) -> bool:
            """
            Determines whether the IDictionary object contains an element with the specified key.
            
            :param key: The key to locate in the IDictionary object.
            :returns: true if the IDictionary contains an element with the key; otherwise, false.
            """
            ...

        @overload
        def Contains(self, item: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]) -> bool:
            """
            Determines whether the ICollection{T} contains a specific value.
            
            :param item: The object to locate in the ICollection{T}.
            :returns: true if  is found in the ICollection{T}; otherwise, false.
            """
            ...

        def ContainsKey(self, key: System_Collections_Immutable_ImmutableDictionary_TKey) -> bool:
            """
            Determines whether the IDictionary{TKey, TValue} contains an element with the specified key.
            
            :param key: The key to locate in the IDictionary{TKey, TValue}.
            :returns: true if the IDictionary{TKey, TValue} contains an element with the key; otherwise, false.
            """
            ...

        def ContainsValue(self, value: System_Collections_Immutable_ImmutableDictionary_TValue) -> bool:
            """
            Determines whether the ImmutableDictionary{TKey, TValue}
            contains an element with the specified value.
            
            :param value: The value to locate in the ImmutableDictionary{TKey, TValue}. The value can be null for reference types.
            :returns: true if the ImmutableDictionary{TKey, TValue} contains an element with the specified value; otherwise, false.
            """
            ...

        @overload
        def CopyTo(self, array: System.Array, arrayIndex: int) -> None:
            ...

        @overload
        def CopyTo(self, array: typing.List[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]], arrayIndex: int) -> None:
            """See the ICollection{T} interface."""
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.IDictionaryEnumerator:
            """
            Returns an IDictionaryEnumerator object for the IDictionary object.
            
            :returns: An IDictionaryEnumerator object for the IDictionary object.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Immutable.ImmutableDictionary.Enumerator:
            """
            Returns an enumerator that iterates through the collection.
            
            :returns: A IEnumerator{T} that can be used to iterate through the collection.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]]:
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.IEnumerator:
            """
            Returns an enumerator that iterates through a collection.
            
            :returns: An IEnumerator object that can be used to iterate through the collection.
            """
            ...

        @overload
        def GetValueOrDefault(self, key: System_Collections_Immutable_ImmutableDictionary_TKey) -> System_Collections_Immutable_ImmutableDictionary_TValue:
            """
            Gets the value for a given key if a matching key exists in the dictionary.
            
            :param key: The key to search for.
            :returns: The value for the key, or the default value of type TValue if no matching key was found.
            """
            ...

        @overload
        def GetValueOrDefault(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, defaultValue: System_Collections_Immutable_ImmutableDictionary_TValue) -> System_Collections_Immutable_ImmutableDictionary_TValue:
            """
            Gets the value for a given key if a matching key exists in the dictionary.
            
            :param key: The key to search for.
            :param defaultValue: The default value to return if no matching key is found in the dictionary.
            :returns: The value for the key, or  if no matching key was found.
            """
            ...

        @overload
        def Remove(self, key: typing.Any) -> None:
            """
            Removes the element with the specified key from the IDictionary object.
            
            :param key: The key of the element to remove.
            """
            ...

        @overload
        def Remove(self, key: System_Collections_Immutable_ImmutableDictionary_TKey) -> bool:
            """
            Removes the element with the specified key from the IDictionary{TKey, TValue}.
            
            :param key: The key of the element to remove.
            :returns: true if the element is successfully removed; otherwise, false.  This method also returns false if  was not found in the original IDictionary{TKey, TValue}.
            """
            ...

        @overload
        def Remove(self, item: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]) -> bool:
            ...

        def RemoveRange(self, keys: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_TKey]) -> None:
            """
            Removes any entries from the dictionaries with keys that match those found in the specified sequence.
            
            :param keys: The keys for entries to remove from the dictionary.
            """
            ...

        def ToImmutable(self) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
            """
            Creates an immutable dictionary based on the contents of this instance.
            
            :returns: An immutable map.
            """
            ...

        def TryGetKey(self, equalKey: System_Collections_Immutable_ImmutableDictionary_TKey, actualKey: typing.Optional[System_Collections_Immutable_ImmutableDictionary_TKey]) -> typing.Union[bool, System_Collections_Immutable_ImmutableDictionary_TKey]:
            """See the IImmutableDictionary{TKey, TValue} interface."""
            ...

        def TryGetValue(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, value: typing.Optional[System_Collections_Immutable_ImmutableDictionary_TValue]) -> typing.Union[bool, System_Collections_Immutable_ImmutableDictionary_TValue]:
            """
            Gets the value associated with the specified key.
            
            :param key: The key whose value to get.
            :param value: When this method returns, the value associated with the specified key, if the key is found; otherwise, the default value of the type TValue. This parameter is passed uninitialized.
            :returns: true if the object that implements IDictionary{TKey, TValue} contains an element with the specified key; otherwise, false.
            """
            ...

    class Enumerator:
        """Enumerates the contents of the collection in an allocation-free manner."""

        @property
        def Current(self) -> System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
            """Gets the current element."""
            ...

        def Dispose(self) -> None:
            """Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources."""
            ...

        def MoveNext(self) -> bool:
            """
            Advances the enumerator to the next element of the collection.
            
            :returns: true if the enumerator was successfully advanced to the next element; false if the enumerator has passed the end of the collection.
            """
            ...

        def Reset(self) -> None:
            """Sets the enumerator to its initial position, which is before the first element in the collection."""
            ...

    Empty: System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue] = ...
    """An empty immutable dictionary with default equality comparers."""

    @property
    def Count(self) -> int:
        """Gets the number of elements in this collection."""
        ...

    @property
    def IsEmpty(self) -> bool:
        """Gets a value indicating whether this instance is empty."""
        ...

    @property
    def KeyComparer(self) -> System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_TKey]:
        """Gets the key comparer."""
        ...

    @property
    def ValueComparer(self) -> System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_TValue]:
        """Gets the value comparer used to determine whether values are equal."""
        ...

    @property
    def Keys(self) -> System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_TKey]:
        """Gets the keys in the map."""
        ...

    @property
    def Values(self) -> System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_TValue]:
        """Gets the values in the map."""
        ...

    @property
    def IsReadOnly(self) -> bool:
        ...

    @property
    def IsFixedSize(self) -> bool:
        ...

    @property
    def Root(self) -> System.Collections.Immutable.SortedInt32KeyNode[System.Collections.Immutable.ImmutableDictionary.HashBucket]:
        ...

    @property
    def SyncRoot(self) -> System.Object:
        ...

    @property
    def IsSynchronized(self) -> bool:
        """Gets a value indicating whether access to the ICollection is synchronized (thread safe)."""
        ...

    @overload
    def __getitem__(self, key: System_Collections_Immutable_ImmutableDictionary_TKey) -> System_Collections_Immutable_ImmutableDictionary_TValue:
        """Gets the TValue with the specified key."""
        ...

    @overload
    def __getitem__(self, key: System_Collections_Immutable_ImmutableDictionary_TKey) -> System_Collections_Immutable_ImmutableDictionary_TValue:
        """Gets or sets the TValue with the specified key."""
        ...

    @overload
    def __getitem__(self, key: typing.Any) -> typing.Any:
        """
        Gets or sets the element with the specified key.
        
        :param key: The key.
        """
        ...

    @overload
    def __setitem__(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, value: System_Collections_Immutable_ImmutableDictionary_TValue) -> None:
        """Gets or sets the TValue with the specified key."""
        ...

    @overload
    def __setitem__(self, key: typing.Any, value: typing.Any) -> None:
        """
        Gets or sets the element with the specified key.
        
        :param key: The key.
        """
        ...

    @overload
    def Add(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, value: System_Collections_Immutable_ImmutableDictionary_TValue) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def Add(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, value: System_Collections_Immutable_ImmutableDictionary_TValue) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        ...

    @overload
    def Add(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, value: System_Collections_Immutable_ImmutableDictionary_TValue) -> None:
        ...

    @overload
    def Add(self, item: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]) -> None:
        ...

    @overload
    def Add(self, key: typing.Any, value: typing.Any) -> None:
        ...

    @overload
    def AddRange(self, pairs: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def AddRange(self, pairs: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]]) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface"""
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        ...

    @overload
    def Clear(self) -> None:
        ...

    @overload
    def Clear(self) -> None:
        """Clears this instance."""
        ...

    @staticmethod
    @overload
    def Contains(map: System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_Contains_TKey, System_Collections_Immutable_ImmutableDictionary_Contains_TValue], key: System_Collections_Immutable_ImmutableDictionary_Contains_TKey, value: System_Collections_Immutable_ImmutableDictionary_Contains_TValue) -> bool:
        """
        Determines whether this map contains the specified key-value pair.
        
        :param map: The map to search.
        :param key: The key to check for.
        :param value: The value to check for on a matching key, if found.
        :returns: true if this map contains the key-value pair; otherwise, false.
        """
        ...

    @overload
    def Contains(self, pair: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]) -> bool:
        """
        Determines whether [contains] [the specified key value pair].
        
        :param pair: The key value pair.
        :returns: true if [contains] [the specified key value pair]; otherwise, false.
        """
        ...

    @overload
    def Contains(self, key: typing.Any) -> bool:
        """
        Determines whether the IDictionary object contains an element with the specified key.
        
        :param key: The key to locate in the IDictionary object.
        :returns: true if the IDictionary contains an element with the key; otherwise, false.
        """
        ...

    def ContainsKey(self, key: System_Collections_Immutable_ImmutableDictionary_TKey) -> bool:
        """
        Determines whether the specified key contains key.
        
        :param key: The key.
        :returns: true if the specified key contains key; otherwise, false.
        """
        ...

    def ContainsValue(self, value: System_Collections_Immutable_ImmutableDictionary_TValue) -> bool:
        """
        Determines whether the ImmutableDictionary{TKey, TValue}
        contains an element with the specified value.
        
        :param value: The value to locate in the ImmutableDictionary{TKey, TValue}. The value can be null for reference types.
        :returns: true if the ImmutableDictionary{TKey, TValue} contains an element with the specified value; otherwise, false.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]], arrayIndex: int) -> None:
        ...

    @overload
    def CopyTo(self, array: System.Array, arrayIndex: int) -> None:
        ...

    @staticmethod
    @overload
    def Create() -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_Create_TKey, System_Collections_Immutable_ImmutableDictionary_Create_TValue]:
        """
        Returns an empty collection.
        
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_Create_TKey]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_Create_TKey, System_Collections_Immutable_ImmutableDictionary_Create_TValue]:
        """
        Returns an empty collection with the specified key comparer.
        
        :param keyComparer: The key comparer.
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_Create_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_Create_TValue]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_Create_TKey, System_Collections_Immutable_ImmutableDictionary_Create_TValue]:
        """
        Returns an empty collection with the specified comparers.
        
        :param keyComparer: The key comparer.
        :param valueComparer: The value comparer.
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder() -> System.Collections.Immutable.ImmutableDictionary.Builder:
        """
        Creates a new immutable dictionary builder.
        
        :returns: The new builder.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder(keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_CreateBuilder_TKey]) -> System.Collections.Immutable.ImmutableDictionary.Builder:
        """
        Creates a new immutable dictionary builder.
        
        :param keyComparer: The key comparer.
        :returns: The new builder.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder(keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_CreateBuilder_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_CreateBuilder_TValue]) -> System.Collections.Immutable.ImmutableDictionary.Builder:
        """
        Creates a new immutable dictionary builder.
        
        :param keyComparer: The key comparer.
        :param valueComparer: The value comparer.
        :returns: The new builder.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableDictionary_CreateRange_TValue]]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableDictionary_CreateRange_TValue]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_CreateRange_TKey], items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableDictionary_CreateRange_TValue]]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableDictionary_CreateRange_TValue]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param keyComparer: The key comparer.
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_CreateRange_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_CreateRange_TValue], items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableDictionary_CreateRange_TValue]]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableDictionary_CreateRange_TValue]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param keyComparer: The key comparer.
        :param valueComparer: The value comparer.
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Immutable.ImmutableDictionary.Enumerator:
        """
        Returns an enumerator that iterates through the collection.
        
        :returns: A IEnumerator{T} that can be used to iterate through the collection.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.IDictionaryEnumerator:
        """
        Returns an IDictionaryEnumerator object for the IDictionary object.
        
        :returns: An IDictionaryEnumerator object for the IDictionary object.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]]:
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        ...

    @staticmethod
    @overload
    def GetValueOrDefault(dictionary: System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TKey, System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TValue], key: System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TKey) -> System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TValue:
        """
        Gets the value for a given key if a matching key exists in the dictionary.
        
        :param dictionary: The dictionary to retrieve the value from.
        :param key: The key to search for.
        :returns: The value for the key, or the default value of type TValue if no matching key was found.
        """
        ...

    @staticmethod
    @overload
    def GetValueOrDefault(dictionary: System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TKey, System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TValue], key: System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TKey, defaultValue: System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TValue) -> System_Collections_Immutable_ImmutableDictionary_GetValueOrDefault_TValue:
        """
        Gets the value for a given key if a matching key exists in the dictionary.
        
        :param dictionary: The dictionary to retrieve the value from.
        :param key: The key to search for.
        :param defaultValue: The default value to return if no matching key is found in the dictionary.
        :returns: The value for the key, or  if no matching key was found.
        """
        ...

    @overload
    def Remove(self, key: System_Collections_Immutable_ImmutableDictionary_TKey) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def Remove(self, key: System_Collections_Immutable_ImmutableDictionary_TKey) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface"""
        ...

    @overload
    def Remove(self, key: System_Collections_Immutable_ImmutableDictionary_TKey) -> bool:
        """
        Removes the element with the specified key from the IDictionary{TKey, TValue}.
        
        :param key: The key of the element to remove.
        :returns: true if the element is successfully removed; otherwise, false.  This method also returns false if  was not found in the original IDictionary{TKey, TValue}.
        """
        ...

    @overload
    def Remove(self, item: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]) -> bool:
        ...

    @overload
    def Remove(self, key: typing.Any) -> None:
        """
        Removes the element with the specified key from the IDictionary object.
        
        :param key: The key of the element to remove.
        """
        ...

    @overload
    def RemoveRange(self, keys: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_TKey]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def RemoveRange(self, keys: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_TKey]) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface"""
        ...

    @overload
    def SetItem(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, value: System_Collections_Immutable_ImmutableDictionary_TValue) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def SetItem(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, value: System_Collections_Immutable_ImmutableDictionary_TValue) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface"""
        ...

    @overload
    def SetItems(self, items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """
        Applies a given set of key=value pairs to an immutable dictionary, replacing any conflicting keys in the resulting dictionary.
        
        :param items: The key=value pairs to set on the map.  Any keys that conflict with existing keys will overwrite the previous values.
        :returns: An immutable dictionary.
        """
        ...

    @overload
    def SetItems(self, items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]]) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """
        Applies a given set of key=value pairs to an immutable dictionary, replacing any conflicting keys in the resulting dictionary.
        
        :param items: The key=value pairs to set on the map.  Any keys that conflict with existing keys will overwrite the previous values.
        :returns: An immutable dictionary.
        """
        ...

    def ToBuilder(self) -> System.Collections.Immutable.ImmutableDictionary.Builder:
        ...

    @staticmethod
    @overload
    def ToImmutableDictionary(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], keySelector: typing.Callable[[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey], elementSelector: typing.Callable[[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue], keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]:
        """
        Constructs an immutable dictionary based on some transformation of a sequence.
        
        :param source: The sequence to enumerate to generate the map.
        :param keySelector: The function that will produce the key for the map from each sequence element.
        :param elementSelector: The function that will produce the value for the map from each sequence element.
        :param keyComparer: The key comparer to use for the map.
        :param valueComparer: The value comparer to use for the map.
        :returns: The immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableDictionary(builder: System.Collections.Immutable.ImmutableDictionary.Builder) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]:
        """
        Returns an immutable copy of the current contents of the builder's collection.
        
        :param builder: The builder to create the immutable dictionary from.
        :returns: An immutable dictionary.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableDictionary(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], keySelector: typing.Callable[[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey], elementSelector: typing.Callable[[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue], keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]:
        """
        Constructs an immutable dictionary based on some transformation of a sequence.
        
        :param source: The sequence to enumerate to generate the map.
        :param keySelector: The function that will produce the key for the map from each sequence element.
        :param elementSelector: The function that will produce the value for the map from each sequence element.
        :param keyComparer: The key comparer to use for the map.
        :returns: The immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableDictionary(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], keySelector: typing.Callable[[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource]:
        """
        Constructs an immutable dictionary based on some transformation of a sequence.
        
        :param source: The sequence to enumerate to generate the map.
        :param keySelector: The function that will produce the key for the map from each sequence element.
        :returns: The immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableDictionary(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], keySelector: typing.Callable[[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey], keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource]:
        """
        Constructs an immutable dictionary based on some transformation of a sequence.
        
        :param source: The sequence to enumerate to generate the map.
        :param keySelector: The function that will produce the key for the map from each sequence element.
        :param keyComparer: The key comparer to use for the map.
        :returns: The immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableDictionary(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], keySelector: typing.Callable[[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey], elementSelector: typing.Callable[[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TSource], System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]:
        """
        Constructs an immutable dictionary based on some transformation of a sequence.
        
        :param source: The sequence to enumerate to generate the map.
        :param keySelector: The function that will produce the key for the map from each sequence element.
        :param elementSelector: The function that will produce the value for the map from each sequence element.
        :returns: The immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableDictionary(source: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]], keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]:
        """
        Creates an immutable dictionary given a sequence of key=value pairs.
        
        :param source: The sequence of key=value pairs.
        :param keyComparer: The key comparer to use when building the immutable map.
        :param valueComparer: The value comparer to use for the immutable map.
        :returns: An immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableDictionary(source: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]], keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]:
        """
        Creates an immutable dictionary given a sequence of key=value pairs.
        
        :param source: The sequence of key=value pairs.
        :param keyComparer: The key comparer to use when building the immutable map.
        :returns: An immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableDictionary(source: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_ToImmutableDictionary_TValue]:
        """
        Creates an immutable dictionary given a sequence of key=value pairs.
        
        :param source: The sequence of key=value pairs.
        :returns: An immutable map.
        """
        ...

    def TryGetKey(self, equalKey: System_Collections_Immutable_ImmutableDictionary_TKey, actualKey: typing.Optional[System_Collections_Immutable_ImmutableDictionary_TKey]) -> typing.Union[bool, System_Collections_Immutable_ImmutableDictionary_TKey]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    def TryGetValue(self, key: System_Collections_Immutable_ImmutableDictionary_TKey, value: typing.Optional[System_Collections_Immutable_ImmutableDictionary_TValue]) -> typing.Union[bool, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def WithComparers(self, keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_TValue]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def WithComparers(self, keyComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableDictionary_TKey]) -> System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableDictionary_TKey, System_Collections_Immutable_ImmutableDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...


class ImmutableHashSet(typing.Generic[System_Collections_Immutable_ImmutableHashSet_T], System.Object, System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableHashSet_T], System.Collections.Generic.IHashKeyCollection[System_Collections_Immutable_ImmutableHashSet_T], System.Collections.Generic.ISet[System_Collections_Immutable_ImmutableHashSet_T], System.Collections.Immutable.IStrongEnumerable[System_Collections_Immutable_ImmutableHashSet_T, System_Collections_Immutable_ImmutableHashSet_Enumerator], typing.Iterable[System_Collections_Immutable_ImmutableHashSet_T]):
    """An immutable unordered hash set implementation."""

    class Builder(System.Object, System.Collections.Generic.IReadOnlyCollection[System_Collections_Immutable_ImmutableHashSet_T], System.Collections.Generic.ISet[System_Collections_Immutable_ImmutableHashSet_T], typing.Iterable[System_Collections_Immutable_ImmutableHashSet_T]):
        """
        A hash set that mutates with little or no memory allocations,
        can produce and/or build on immutable hash set instances very efficiently.
        """

        @property
        def Count(self) -> int:
            ...

        @property
        def IsReadOnly(self) -> bool:
            """Gets a value indicating whether the ICollection{T} is read-only."""
            ...

        @property
        def KeyComparer(self) -> System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableHashSet_T]:
            ...

        @KeyComparer.setter
        def KeyComparer(self, value: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableHashSet_T]):
            ...

        @property
        def Version(self) -> int:
            """Gets the current version of the contents of this builder."""
            ...

        @overload
        def Add(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> bool:
            ...

        @overload
        def Add(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> None:
            ...

        def Clear(self) -> None:
            """Removes all items from the ICollection{T}."""
            ...

        def Contains(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> bool:
            """
            Determines whether the ICollection{T} contains a specific value.
            
            :param item: The object to locate in the ICollection{T}.
            :returns: true if  is found in the ICollection{T}; otherwise, false.
            """
            ...

        def CopyTo(self, array: typing.List[System_Collections_Immutable_ImmutableHashSet_T], arrayIndex: int) -> None:
            """See the ICollection{T} interface."""
            ...

        def ExceptWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> None:
            """
            Removes all elements in the specified collection from the current set.
            
            :param other: The collection of items to remove from the set.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Immutable.ImmutableHashSet.Enumerator:
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableHashSet_T]:
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.IEnumerator:
            """
            Returns an enumerator that iterates through a collection.
            
            :returns: An IEnumerator object that can be used to iterate through the collection.
            """
            ...

        def IntersectWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> None:
            """
            Modifies the current set so that it contains only elements that are also in a specified collection.
            
            :param other: The collection to compare to the current set.
            """
            ...

        def IsProperSubsetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
            """
            Determines whether the current set is a proper (strict) subset of a specified collection.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set is a correct subset of other; otherwise, false.
            """
            ...

        def IsProperSupersetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
            """
            Determines whether the current set is a proper (strict) superset of a specified collection.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set is a superset of other; otherwise, false.
            """
            ...

        def IsSubsetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
            """
            Determines whether the current set is a subset of a specified collection.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set is a subset of other; otherwise, false.
            """
            ...

        def IsSupersetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
            """
            Determines whether the current set is a superset of a specified collection.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set is a superset of other; otherwise, false.
            """
            ...

        def Overlaps(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
            """
            Determines whether the current set overlaps with the specified collection.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set and other share at least one common element; otherwise, false.
            """
            ...

        def Remove(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> bool:
            """
            Removes the first occurrence of a specific object from the ICollection{T}.
            
            :param item: The object to remove from the ICollection{T}.
            :returns: true if  was successfully removed from the ICollection{T}; otherwise, false. This method also returns false if  is not found in the original ICollection{T}.
            """
            ...

        def SetEquals(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
            """
            Determines whether the current set and the specified collection contain the same elements.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set is equal to other; otherwise, false.
            """
            ...

        def SymmetricExceptWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> None:
            """
            Modifies the current set so that it contains only elements that are present either in the current set or in the specified collection, but not both.
            
            :param other: The collection to compare to the current set.
            """
            ...

        def ToImmutable(self) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_T]:
            """
            Creates an immutable hash set based on the contents of this instance.
            
            :returns: An immutable set.
            """
            ...

        def TryGetValue(self, equalValue: System_Collections_Immutable_ImmutableHashSet_T, actualValue: typing.Optional[System_Collections_Immutable_ImmutableHashSet_T]) -> typing.Union[bool, System_Collections_Immutable_ImmutableHashSet_T]:
            """
            Searches the set for a given value and returns the equal value it finds, if any.
            
            :param equalValue: The value for which to search.
            :param actualValue: The value from the set that the search found, or the original value if the search yielded no match.
            :returns: A value indicating whether the search was successful.
            """
            ...

        def UnionWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> None:
            """
            Modifies the current set so that it contains all elements that are present in both the current set and in the specified collection.
            
            :param other: The collection to compare to the current set.
            """
            ...

    class Enumerator(System.Collections.Immutable.IStrongEnumerator[System_Collections_Immutable_ImmutableHashSet_T]):
        """Enumerates the contents of the collection in an allocation-free manner."""

        @property
        def Current(self) -> System_Collections_Immutable_ImmutableHashSet_T:
            """Gets the current element."""
            ...

        def Dispose(self) -> None:
            """Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources."""
            ...

        def MoveNext(self) -> bool:
            """
            Advances the enumerator to the next element of the collection.
            
            :returns: true if the enumerator was successfully advanced to the next element; false if the enumerator has passed the end of the collection.
            """
            ...

        def Reset(self) -> None:
            """Sets the enumerator to its initial position, which is before the first element in the collection."""
            ...

    Empty: System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_T] = ...
    """An empty immutable hash set with the default comparer for T."""

    @property
    def Count(self) -> int:
        """See the IImmutableSet{T} interface."""
        ...

    @property
    def IsEmpty(self) -> bool:
        """See the IImmutableSet{T} interface."""
        ...

    @property
    def KeyComparer(self) -> System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableHashSet_T]:
        ...

    @property
    def SyncRoot(self) -> System.Object:
        ...

    @property
    def IsSynchronized(self) -> bool:
        """See the ICollection interface."""
        ...

    @property
    def Root(self) -> System.Collections.Immutable.IBinaryTree:
        ...

    @property
    def IsReadOnly(self) -> bool:
        ...

    @overload
    def Add(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Add(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableHashSet_T]:
        ...

    @overload
    def Add(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> bool:
        ...

    @overload
    def Add(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> None:
        """See the IList{T} interface."""
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableHashSet_T]:
        ...

    @overload
    def Clear(self) -> None:
        """See the ICollection{T} interface."""
        ...

    def Contains(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> bool:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def CopyTo(self, array: typing.List[System_Collections_Immutable_ImmutableHashSet_T], arrayIndex: int) -> None:
        """See the ICollection{T} interface."""
        ...

    @overload
    def CopyTo(self, array: System.Array, arrayIndex: int) -> None:
        ...

    @staticmethod
    @overload
    def Create() -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_Create_T]:
        """
        Returns an empty collection.
        
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableHashSet_Create_T]) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_Create_T]:
        """
        Returns an empty collection.
        
        :param equalityComparer: The equality comparer.
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(item: System_Collections_Immutable_ImmutableHashSet_Create_T) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified item.
        
        :param item: The item to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableHashSet_Create_T], item: System_Collections_Immutable_ImmutableHashSet_Create_T) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified item.
        
        :param equalityComparer: The equality comparer.
        :param item: The item to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(*items: System_Collections_Immutable_ImmutableHashSet_Create_T) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableHashSet_Create_T], *items: System_Collections_Immutable_ImmutableHashSet_Create_T) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param equalityComparer: The equality comparer.
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder() -> System.Collections.Immutable.ImmutableHashSet.Builder:
        """
        Creates a new immutable hash set builder.
        
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder(equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableHashSet_CreateBuilder_T]) -> System.Collections.Immutable.ImmutableHashSet.Builder:
        """
        Creates a new immutable hash set builder.
        
        :param equalityComparer: The equality comparer.
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_CreateRange_T]) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_CreateRange_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableHashSet_CreateRange_T], items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_CreateRange_T]) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_CreateRange_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param equalityComparer: The equality comparer.
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @overload
    def Except(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Except(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    def ExceptWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> None:
        """See ISet{T}"""
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Immutable.ImmutableHashSet.Enumerator:
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableHashSet_T]:
        """Returns an enumerator that iterates through the collection."""
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        ...

    @overload
    def Intersect(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Intersect(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    def IntersectWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> None:
        """See ISet{T}"""
        ...

    def IsProperSubsetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
        """
        Determines whether the current set is a property (strict) subset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a correct subset of ; otherwise, false.
        """
        ...

    def IsProperSupersetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
        """
        Determines whether the current set is a correct superset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a correct superset of ; otherwise, false.
        """
        ...

    def IsSubsetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
        """
        Determines whether a set is a subset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a subset of ; otherwise, false.
        """
        ...

    def IsSupersetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
        """
        Determines whether the current set is a superset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a superset of ; otherwise, false.
        """
        ...

    def Overlaps(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
        """
        Determines whether the current set overlaps with the specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set and  share at least one common element; otherwise, false.
        """
        ...

    @overload
    def Remove(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Remove(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Remove(self, item: System_Collections_Immutable_ImmutableHashSet_T) -> bool:
        """See the IList{T} interface."""
        ...

    def SetEquals(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> bool:
        """
        Checks whether a given sequence of items entirely describe the contents of this set.
        
        :param other: The sequence of items to check against this set.
        :returns: A value indicating whether the sets are equal.
        """
        ...

    @overload
    def SymmetricExcept(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """
        Produces a set that contains elements either in this set or a given sequence, but not both.
        
        :param other: The other sequence of items.
        :returns: The new set.
        """
        ...

    @overload
    def SymmetricExcept(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """
        Produces a set that contains elements either in this set or a given sequence, but not both.
        
        :param other: The other sequence of items.
        :returns: The new set.
        """
        ...

    def SymmetricExceptWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> None:
        """See ISet{T}"""
        ...

    def ToBuilder(self) -> System.Collections.Immutable.ImmutableHashSet.Builder:
        ...

    @staticmethod
    @overload
    def ToImmutableHashSet(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_ToImmutableHashSet_TSource], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableHashSet_ToImmutableHashSet_TSource]) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_ToImmutableHashSet_TSource]:
        """
        Enumerates a sequence exactly once and produces an immutable set of its contents.
        
        :param source: The sequence to enumerate.
        :param equalityComparer: The equality comparer to use for initializing and adding members to the hash set.
        :returns: An immutable set.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableHashSet(builder: System.Collections.Immutable.ImmutableHashSet.Builder) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_ToImmutableHashSet_TSource]:
        """
        Returns an immutable copy of the current contents of the builder's collection.
        
        :param builder: The builder to create the immutable set from.
        :returns: An immutable set.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableHashSet(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_ToImmutableHashSet_TSource]) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_ToImmutableHashSet_TSource]:
        """
        Enumerates a sequence exactly once and produces an immutable set of its contents.
        
        :param source: The sequence to enumerate.
        :returns: An immutable set.
        """
        ...

    def TryGetValue(self, equalValue: System_Collections_Immutable_ImmutableHashSet_T, actualValue: typing.Optional[System_Collections_Immutable_ImmutableHashSet_T]) -> typing.Union[bool, System_Collections_Immutable_ImmutableHashSet_T]:
        """
        Searches the set for a given value and returns the equal value it finds, if any.
        
        :param equalValue: The value to search for.
        :param actualValue: The value from the set that the search found, or the original value if the search yielded no match.
        :returns: A value indicating whether the search was successful.
        """
        ...

    @overload
    def Union(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Union(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    def UnionWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableHashSet_T]) -> None:
        """See ISet{T}"""
        ...

    def WithComparer(self, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableHashSet_T]) -> System.Collections.Immutable.ImmutableHashSet[System_Collections_Immutable_ImmutableHashSet_T]:
        """See the IImmutableSet{T} interface."""
        ...


class ImmutableStack(typing.Generic[System_Collections_Immutable_ImmutableStack_T], System.Object, System.Collections.Immutable.IImmutableStack[System_Collections_Immutable_ImmutableStack_T], typing.Iterable[System_Collections_Immutable_ImmutableStack_T]):
    """An immutable stack."""

    class Enumerator:
        """Enumerates a stack with no memory allocations."""

        @property
        def Current(self) -> System_Collections_Immutable_ImmutableStack_T:
            """Gets the current element."""
            ...

        def MoveNext(self) -> bool:
            """
            Moves to the first or next element.
            
            :returns: A value indicating whether there are any more elements.
            """
            ...

    Empty: System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableStack_T]
    """Gets the empty stack, upon which all stacks are built."""

    @property
    def IsEmpty(self) -> bool:
        """Gets a value indicating whether this instance is empty."""
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableStack_T]:
        """Gets the empty stack, upon which all stacks are built."""
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.IImmutableStack[System_Collections_Immutable_ImmutableStack_T]:
        """Gets an empty stack."""
        ...

    @staticmethod
    @overload
    def Create() -> System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableStack_Create_T]:
        """
        Returns an empty collection.
        
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(item: System_Collections_Immutable_ImmutableStack_Create_T) -> System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableStack_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified item.
        
        :param item: The item to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(*items: System_Collections_Immutable_ImmutableStack_Create_T) -> System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableStack_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    def CreateRange(items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableStack_CreateRange_T]) -> System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableStack_CreateRange_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Immutable.ImmutableStack.Enumerator:
        """
        Returns an enumerator that iterates through the collection.
        
        :returns: An Enumerator that can be used to iterate through the collection.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableStack_T]:
        """
        Returns an enumerator that iterates through the collection.
        
        :returns: A IEnumerator{T} that can be used to iterate through the collection.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        """
        Returns an enumerator that iterates through a collection.
        
        :returns: An IEnumerator object that can be used to iterate through the collection.
        """
        ...

    def Peek(self) -> System_Collections_Immutable_ImmutableStack_T:
        """
        Gets the element on the top of the stack.
        
        :returns: The element on the top of the stack.
        """
        ...

    def PeekRef(self) -> typing.Any:
        """
        Gets a read-only reference to the element on the top of the stack.
        
        :returns: A read-only reference to the element on the top of the stack.
        """
        ...

    @staticmethod
    @overload
    def Pop(stack: System.Collections.Immutable.IImmutableStack[System_Collections_Immutable_ImmutableStack_Pop_T], value: typing.Optional[System_Collections_Immutable_ImmutableStack_Pop_T]) -> typing.Union[System.Collections.Immutable.IImmutableStack[System_Collections_Immutable_ImmutableStack_Pop_T], System_Collections_Immutable_ImmutableStack_Pop_T]:
        """
        Pops the top element off the stack.
        
        :param stack: The stack to modify.
        :param value: The value that was removed from the stack.
        :returns: A stack; never null.
        """
        ...

    @overload
    def Pop(self) -> System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableStack_T]:
        """
        Returns a stack that lacks the top element on this stack.
        
        :returns: A stack; never null.
        """
        ...

    @overload
    def Pop(self, value: typing.Optional[System_Collections_Immutable_ImmutableStack_T]) -> typing.Union[System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableStack_T], System_Collections_Immutable_ImmutableStack_T]:
        """
        Pops the top element off the stack.
        
        :param value: The value that was removed from the stack.
        :returns: A stack; never null.
        """
        ...

    @overload
    def Pop(self) -> System.Collections.Immutable.IImmutableStack[System_Collections_Immutable_ImmutableStack_T]:
        """
        Returns a stack that lacks the top element on this stack.
        
        :returns: A stack; never null.
        """
        ...

    @overload
    def Push(self, value: System_Collections_Immutable_ImmutableStack_T) -> System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableStack_T]:
        """
        Pushes an element onto a stack and returns the new stack.
        
        :param value: The element to push onto the stack.
        :returns: The new stack.
        """
        ...

    @overload
    def Push(self, value: System_Collections_Immutable_ImmutableStack_T) -> System.Collections.Immutable.IImmutableStack[System_Collections_Immutable_ImmutableStack_T]:
        """
        Pushes an element onto a stack and returns the new stack.
        
        :param value: The element to push onto the stack.
        :returns: The new stack.
        """
        ...


class ImmutableQueue(typing.Generic[System_Collections_Immutable_ImmutableQueue_T], System.Object, System.Collections.Immutable.IImmutableQueue[System_Collections_Immutable_ImmutableQueue_T], typing.Iterable[System_Collections_Immutable_ImmutableQueue_T]):
    """An immutable queue."""

    class Enumerator:
        """A memory allocation-free enumerator of ImmutableQueue{T}."""

        @property
        def Current(self) -> System_Collections_Immutable_ImmutableQueue_T:
            """The current element."""
            ...

        def MoveNext(self) -> bool:
            """
            Advances enumeration to the next element.
            
            :returns: A value indicating whether there is another element in the enumeration.
            """
            ...

    @property
    def IsEmpty(self) -> bool:
        """Gets a value indicating whether this instance is empty."""
        ...

    Empty: System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableQueue_T]
    """Gets the empty queue."""

    @overload
    def Clear(self) -> System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableQueue_T]:
        """Gets the empty queue."""
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.IImmutableQueue[System_Collections_Immutable_ImmutableQueue_T]:
        """Gets an empty queue."""
        ...

    @staticmethod
    @overload
    def Create() -> System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableQueue_Create_T]:
        """
        Returns an empty collection.
        
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(item: System_Collections_Immutable_ImmutableQueue_Create_T) -> System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableQueue_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified item.
        
        :param item: The item to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(*items: System_Collections_Immutable_ImmutableQueue_Create_T) -> System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableQueue_Create_T]:
        """
        Creates a new immutable queue from the specified items.
        
        :param items: The array to copy items from.
        :returns: The new immutable queue.
        """
        ...

    @staticmethod
    def CreateRange(items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableQueue_CreateRange_T]) -> System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableQueue_CreateRange_T]:
        """
        Creates a new immutable queue from the specified items.
        
        :param items: The enumerable to copy items from.
        :returns: The new immutable queue.
        """
        ...

    @staticmethod
    @overload
    def Dequeue(queue: System.Collections.Immutable.IImmutableQueue[System_Collections_Immutable_ImmutableQueue_Dequeue_T], value: typing.Optional[System_Collections_Immutable_ImmutableQueue_Dequeue_T]) -> typing.Union[System.Collections.Immutable.IImmutableQueue[System_Collections_Immutable_ImmutableQueue_Dequeue_T], System_Collections_Immutable_ImmutableQueue_Dequeue_T]:
        """
        Retrieves the item at the head of the queue, and returns a queue with the head element removed.
        
        :param queue: The queue to dequeue from.
        :param value: Receives the value from the head of the queue.
        :returns: The new queue with the head element removed.
        """
        ...

    @overload
    def Dequeue(self) -> System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableQueue_T]:
        """
        Returns a queue that is missing the front element.
        
        :returns: A queue; never null.
        """
        ...

    @overload
    def Dequeue(self, value: typing.Optional[System_Collections_Immutable_ImmutableQueue_T]) -> typing.Union[System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableQueue_T], System_Collections_Immutable_ImmutableQueue_T]:
        """
        Retrieves the item at the head of the queue, and returns a queue with the head element removed.
        
        :param value: Receives the value from the head of the queue.
        :returns: The new queue with the head element removed.
        """
        ...

    @overload
    def Dequeue(self) -> System.Collections.Immutable.IImmutableQueue[System_Collections_Immutable_ImmutableQueue_T]:
        """
        Returns a queue that is missing the front element.
        
        :returns: A queue; never null.
        """
        ...

    @overload
    def Enqueue(self, value: System_Collections_Immutable_ImmutableQueue_T) -> System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableQueue_T]:
        """
        Adds an element to the back of the queue.
        
        :param value: The value.
        :returns: The new queue.
        """
        ...

    @overload
    def Enqueue(self, value: System_Collections_Immutable_ImmutableQueue_T) -> System.Collections.Immutable.IImmutableQueue[System_Collections_Immutable_ImmutableQueue_T]:
        """
        Adds an element to the back of the queue.
        
        :param value: The value.
        :returns: The new queue.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Immutable.ImmutableQueue.Enumerator:
        """
        Returns an enumerator that iterates through the collection.
        
        :returns: An Enumerator that can be used to iterate through the collection.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableQueue_T]:
        """
        Returns an enumerator that iterates through the collection.
        
        :returns: A IEnumerator{T} that can be used to iterate through the collection.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        """
        Returns an enumerator that iterates through a collection.
        
        :returns: An IEnumerator object that can be used to iterate through the collection.
        """
        ...

    def Peek(self) -> System_Collections_Immutable_ImmutableQueue_T:
        """Gets the element at the front of the queue."""
        ...

    def PeekRef(self) -> typing.Any:
        """Gets a read-only reference to the element at the front of the queue."""
        ...


class ImmutableInterlocked(System.Object):
    """Contains interlocked exchange mechanisms for immutable collections."""

    @staticmethod
    @overload
    def AddOrUpdate(location: System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TKey, System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue], key: System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TKey, addValueFactory: typing.Callable[[System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TKey], System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue], updateValueFactory: typing.Callable[[System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TKey, System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue], System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue]) -> System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue:
        """
        Obtains the value from a dictionary after having added it or updated an existing entry.
        
        :param location: The variable or field to atomically update if the specified  is not in the dictionary.
        :param key: The key for the value to add or update.
        :param addValueFactory: The function that receives the key and returns a new value to add to the dictionary when no value previously exists.
        :param updateValueFactory: The function that receives the key and prior value and returns the new value with which to update the dictionary.
        :returns: The added or updated value.
        """
        ...

    @staticmethod
    @overload
    def AddOrUpdate(location: System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TKey, System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue], key: System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TKey, addValue: System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue, updateValueFactory: typing.Callable[[System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TKey, System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue], System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue]) -> System_Collections_Immutable_ImmutableInterlocked_AddOrUpdate_TValue:
        """
        Obtains the value from a dictionary after having added it or updated an existing entry.
        
        :param location: The variable or field to atomically update if the specified  is not in the dictionary.
        :param key: The key for the value to add or update.
        :param addValue: The value to use if no previous value exists.
        :param updateValueFactory: The function that receives the key and prior value and returns the new value with which to update the dictionary.
        :returns: The added or updated value.
        """
        ...

    @staticmethod
    def Enqueue(location: System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableInterlocked_Enqueue_T], value: System_Collections_Immutable_ImmutableInterlocked_Enqueue_T) -> None:
        """
        Atomically enqueues an element to the tail of a queue.
        
        :param location: The variable or field to atomically update.
        :param value: The value to enqueue.
        """
        ...

    @staticmethod
    @overload
    def GetOrAdd(location: System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TKey, System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue], key: System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TKey, valueFactory: typing.Callable[[System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TKey, System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TArg], System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue], factoryArgument: System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TArg) -> System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue:
        ...

    @staticmethod
    @overload
    def GetOrAdd(location: System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TKey, System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue], key: System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TKey, valueFactory: typing.Callable[[System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TKey], System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue]) -> System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue:
        """
        Obtains the value for the specified key from a dictionary, or adds a new value to the dictionary where the key did not previously exist.
        
        :param location: The variable or field to atomically update if the specified  is not in the dictionary.
        :param key: The key for the value to retrieve or add.
        :param valueFactory: The function to execute to obtain the value to insert into the dictionary if the key is not found. This delegate will not be invoked more than once.
        :returns: The value obtained from the dictionary or  if it was not present.
        """
        ...

    @staticmethod
    @overload
    def GetOrAdd(location: System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TKey, System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue], key: System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TKey, value: System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue) -> System_Collections_Immutable_ImmutableInterlocked_GetOrAdd_TValue:
        """
        Obtains the value for the specified key from a dictionary, or adds a new value to the dictionary where the key did not previously exist.
        
        :param location: The variable or field to atomically update if the specified  is not in the dictionary.
        :param key: The key for the value to retrieve or add.
        :param value: The value to add to the dictionary if one is not already present.
        :returns: The value obtained from the dictionary or  if it was not present.
        """
        ...

    @staticmethod
    def InterlockedCompareExchange(location: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_InterlockedCompareExchange_T], value: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_InterlockedCompareExchange_T], comparand: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_InterlockedCompareExchange_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_InterlockedCompareExchange_T]:
        """
        Assigns a field or variable containing an immutable array to the specified value
        if it is currently equal to another specified value. Returns the previous value.
        
        :param location: The field or local variable to change.
        :param value: The new value to assign.
        :param comparand: The value to check equality for before assigning.
        :returns: The prior value at the specified .
        """
        ...

    @staticmethod
    def InterlockedExchange(location: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_InterlockedExchange_T], value: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_InterlockedExchange_T]) -> System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_InterlockedExchange_T]:
        ...

    @staticmethod
    def InterlockedInitialize(location: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_InterlockedInitialize_T], value: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_InterlockedInitialize_T]) -> bool:
        """
        Assigns a field or variable containing an immutable array to the specified value
        if it is has not yet been initialized.
        
        :param location: The field or local variable to change.
        :param value: The new value to assign.
        :returns: True if the field was assigned the specified value; false if it was previously initialized.
        """
        ...

    @staticmethod
    def Push(location: System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableInterlocked_Push_T], value: System_Collections_Immutable_ImmutableInterlocked_Push_T) -> None:
        """
        Pushes a new element onto a stack.
        
        :param location: The variable or field to atomically update.
        :param value: The value to push.
        """
        ...

    @staticmethod
    def TryAdd(location: System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableInterlocked_TryAdd_TKey, System_Collections_Immutable_ImmutableInterlocked_TryAdd_TValue], key: System_Collections_Immutable_ImmutableInterlocked_TryAdd_TKey, value: System_Collections_Immutable_ImmutableInterlocked_TryAdd_TValue) -> bool:
        """
        Adds the specified key and value to the dictionary if no colliding key already exists in the dictionary.
        
        :param location: The variable or field to atomically update if the specified  is not in the dictionary.
        :param key: The key to add, if is not already defined in the dictionary.
        :param value: The value to add.
        :returns: true if the key was not previously set in the dictionary and the value was set; false otherwise.
        """
        ...

    @staticmethod
    def TryDequeue(location: System.Collections.Immutable.ImmutableQueue[System_Collections_Immutable_ImmutableInterlocked_TryDequeue_T], value: typing.Optional[System_Collections_Immutable_ImmutableInterlocked_TryDequeue_T]) -> typing.Union[bool, System_Collections_Immutable_ImmutableInterlocked_TryDequeue_T]:
        ...

    @staticmethod
    def TryPop(location: System.Collections.Immutable.ImmutableStack[System_Collections_Immutable_ImmutableInterlocked_TryPop_T], value: typing.Optional[System_Collections_Immutable_ImmutableInterlocked_TryPop_T]) -> typing.Union[bool, System_Collections_Immutable_ImmutableInterlocked_TryPop_T]:
        ...

    @staticmethod
    def TryRemove(location: System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableInterlocked_TryRemove_TKey, System_Collections_Immutable_ImmutableInterlocked_TryRemove_TValue], key: System_Collections_Immutable_ImmutableInterlocked_TryRemove_TKey, value: typing.Optional[System_Collections_Immutable_ImmutableInterlocked_TryRemove_TValue]) -> typing.Union[bool, System_Collections_Immutable_ImmutableInterlocked_TryRemove_TValue]:
        """
        Removes an entry from the dictionary with the specified key if it is defined and returns its value.
        
        :param location: The variable or field to atomically update if the specified  is not in the dictionary.
        :param key: The key to remove.
        :param value: Receives the value from the pre-existing entry, if one exists.
        :returns: true if the key was found and removed; false otherwise.
        """
        ...

    @staticmethod
    def TryUpdate(location: System.Collections.Immutable.ImmutableDictionary[System_Collections_Immutable_ImmutableInterlocked_TryUpdate_TKey, System_Collections_Immutable_ImmutableInterlocked_TryUpdate_TValue], key: System_Collections_Immutable_ImmutableInterlocked_TryUpdate_TKey, newValue: System_Collections_Immutable_ImmutableInterlocked_TryUpdate_TValue, comparisonValue: System_Collections_Immutable_ImmutableInterlocked_TryUpdate_TValue) -> bool:
        """
        Sets the specified key to the given value if the key already is set to a specific value.
        
        :param location: The variable or field to atomically update if the specified  is not in the dictionary.
        :param key: The key to update.
        :param newValue: The new value to set.
        :param comparisonValue: The value that must already be set in the dictionary in order for the update to succeed.
        :returns: true if the key and comparison value were present in the dictionary and the update was made; false otherwise.
        """
        ...

    @staticmethod
    @overload
    def Update(location: System_Collections_Immutable_ImmutableInterlocked_Update_T, transformer: typing.Callable[[System_Collections_Immutable_ImmutableInterlocked_Update_T], System_Collections_Immutable_ImmutableInterlocked_Update_T]) -> bool:
        """
        Mutates a value in-place with optimistic locking transaction semantics
        via a specified transformation function.
        The transformation is retried as many times as necessary to win the optimistic locking race.
        
        :param location: The variable or field to be changed, which may be accessed by multiple threads.
        :param transformer: A function that mutates the value. This function should be side-effect free, as it may run multiple times when races occur with other threads.
        :returns: true if the location's value is changed by applying the result of the  function; false if the location's value remained the same because the last invocation of  returned the existing value.
        """
        ...

    @staticmethod
    @overload
    def Update(location: System_Collections_Immutable_ImmutableInterlocked_Update_T, transformer: typing.Callable[[System_Collections_Immutable_ImmutableInterlocked_Update_T, System_Collections_Immutable_ImmutableInterlocked_Update_TArg], System_Collections_Immutable_ImmutableInterlocked_Update_T], transformerArgument: System_Collections_Immutable_ImmutableInterlocked_Update_TArg) -> bool:
        """
        Mutates a value in-place with optimistic locking transaction semantics
        via a specified transformation function.
        The transformation is retried as many times as necessary to win the optimistic locking race.
        
        :param location: The variable or field to be changed, which may be accessed by multiple threads.
        :param transformer: A function that mutates the value. This function should be side-effect free, as it may run multiple times when races occur with other threads.
        :param transformerArgument: The argument to pass to .
        :returns: true if the location's value is changed by applying the result of the  function; false if the location's value remained the same because the last invocation of  returned the existing value.
        """
        ...

    @staticmethod
    @overload
    def Update(location: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_Update_T], transformer: typing.Callable[[System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_Update_T]], System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_Update_T]]) -> bool:
        """
        Mutates an immutable array in-place with optimistic locking transaction semantics
        via a specified transformation function.
        The transformation is retried as many times as necessary to win the optimistic locking race.
        
        :param location: The immutable array to be changed.
        :param transformer: A function that produces the new array from the old. This function should be side-effect free, as it may run multiple times when races occur with other threads.
        :returns: true if the location's value is changed by applying the result of the  function; false if the location's value remained the same because the last invocation of  returned the existing value.
        """
        ...

    @staticmethod
    @overload
    def Update(location: System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_Update_T], transformer: typing.Callable[[System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_Update_T], System_Collections_Immutable_ImmutableInterlocked_Update_TArg], System.Collections.Immutable.ImmutableArray[System_Collections_Immutable_ImmutableInterlocked_Update_T]], transformerArgument: System_Collections_Immutable_ImmutableInterlocked_Update_TArg) -> bool:
        """
        Mutates an immutable array in-place with optimistic locking transaction semantics
        via a specified transformation function.
        The transformation is retried as many times as necessary to win the optimistic locking race.
        
        :param location: The immutable array to be changed.
        :param transformer: A function that produces the new array from the old. This function should be side-effect free, as it may run multiple times when races occur with other threads.
        :param transformerArgument: The argument to pass to .
        :returns: true if the location's value is changed by applying the result of the  function; false if the location's value remained the same because the last invocation of  returned the existing value.
        """
        ...


class ImmutableList(typing.Generic[System_Collections_Immutable_ImmutableList_T], System.Object, System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T], System.Collections.Generic.IList[System_Collections_Immutable_ImmutableList_T], System.Collections.IList, System.Collections.Immutable.IOrderedCollection[System_Collections_Immutable_ImmutableList_T], System.Collections.Immutable.IImmutableListQueries[System_Collections_Immutable_ImmutableList_T], System.Collections.Immutable.IStrongEnumerable[System_Collections_Immutable_ImmutableList_T, System_Collections_Immutable_ImmutableList_Enumerator], typing.Iterable[System_Collections_Immutable_ImmutableList_T]):
    """An immutable list implementation."""

    class Builder(System.Object, System.Collections.Generic.IList[System_Collections_Immutable_ImmutableList_T], System.Collections.IList, System.Collections.Immutable.IOrderedCollection[System_Collections_Immutable_ImmutableList_T], System.Collections.Immutable.IImmutableListQueries[System_Collections_Immutable_ImmutableList_T], typing.Iterable[System_Collections_Immutable_ImmutableList_T]):
        """
        A list that mutates with little or no memory allocations,
        can produce and/or build on immutable list instances very efficiently.
        """

        @property
        def Count(self) -> int:
            ...

        @property
        def IsReadOnly(self) -> bool:
            """Gets a value indicating whether this instance is read-only."""
            ...

        @property
        def Version(self) -> int:
            ...

        @property
        def Root(self) -> System.Collections.Immutable.ImmutableList.Node:
            """Gets or sets the root node that represents the data in this collection."""
            ...

        @Root.setter
        def Root(self, value: System.Collections.Immutable.ImmutableList.Node):
            """Gets or sets the root node that represents the data in this collection."""
            ...

        @property
        def IsFixedSize(self) -> bool:
            """Gets a value indicating whether the IList has a fixed size."""
            ...

        @property
        def IsSynchronized(self) -> bool:
            """Gets a value indicating whether access to the ICollection is synchronized (thread safe)."""
            ...

        @property
        def SyncRoot(self) -> System.Object:
            """Gets an object that can be used to synchronize access to the ICollection."""
            ...

        @overload
        def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableList_T:
            ...

        @overload
        def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableList_T:
            """Gets the element in the collection at a given index."""
            ...

        @overload
        def __getitem__(self, index: int) -> typing.Any:
            """
            Gets or sets the object at the specified index.
            
            :param index: The index.
            """
            ...

        @overload
        def __setitem__(self, index: int, value: System_Collections_Immutable_ImmutableList_T) -> None:
            ...

        @overload
        def __setitem__(self, index: int, value: typing.Any) -> None:
            """
            Gets or sets the object at the specified index.
            
            :param index: The index.
            """
            ...

        @overload
        def Add(self, item: System_Collections_Immutable_ImmutableList_T) -> None:
            """See IList{T}"""
            ...

        @overload
        def Add(self, value: typing.Any) -> int:
            ...

        def AddRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T]) -> None:
            ...

        @overload
        def BinarySearch(self, item: System_Collections_Immutable_ImmutableList_T) -> int:
            """
            Searches the entire sorted System.Collections.Generic.List<T> for an element
            using the default comparer and returns the zero-based index of the element.
            
            :param item: The object to locate. The value can be null for reference types.
            :returns: The zero-based index of item in the sorted System.Collections.Generic.List<T>, if item is found; otherwise, a negative number that is the bitwise complement of the index of the next element that is larger than item or, if there is no larger element, the bitwise complement of System.Collections.Generic.List<T>.Count.
            """
            ...

        @overload
        def BinarySearch(self, item: System_Collections_Immutable_ImmutableList_T, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableList_T]) -> int:
            """
            Searches the entire sorted System.Collections.Generic.List<T> for an element
             using the specified comparer and returns the zero-based index of the element.
            
            :param item: The object to locate. The value can be null for reference types.
            :param comparer: The System.Collections.Generic.IComparer<T> implementation to use when comparing elements.-or-null to use the default comparer System.Collections.Generic.Comparer<T>.Default.
            :returns: The zero-based index of item in the sorted System.Collections.Generic.List<T>, if item is found; otherwise, a negative number that is the bitwise complement of the index of the next element that is larger than item or, if there is no larger element, the bitwise complement of System.Collections.Generic.List<T>.Count.
            """
            ...

        @overload
        def BinarySearch(self, index: int, count: int, item: System_Collections_Immutable_ImmutableList_T, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableList_T]) -> int:
            """
            Searches a range of elements in the sorted System.Collections.Generic.List<T>
            for an element using the specified comparer and returns the zero-based index
            of the element.
            
            :param index: The zero-based starting index of the range to search.
            :param count: The length of the range to search.
            :param item: The object to locate. The value can be null for reference types.
            :param comparer: The System.Collections.Generic.IComparer<T> implementation to use when comparing elements, or null to use the default comparer System.Collections.Generic.Comparer<T>.Default.
            :returns: The zero-based index of item in the sorted System.Collections.Generic.List<T>, if item is found; otherwise, a negative number that is the bitwise complement of the index of the next element that is larger than item or, if there is no larger element, the bitwise complement of System.Collections.Generic.List<T>.Count.
            """
            ...

        @overload
        def Clear(self) -> None:
            """See IList{T}"""
            ...

        @overload
        def Clear(self) -> None:
            """Clears this instance."""
            ...

        @overload
        def Contains(self, item: System_Collections_Immutable_ImmutableList_T) -> bool:
            """See IList{T}"""
            ...

        @overload
        def Contains(self, value: typing.Any) -> bool:
            """
            Determines whether the IList contains a specific value.
            
            :param value: The object to locate in the IList.
            :returns: true if the object is found in the IList; otherwise, false.
            """
            ...

        def ConvertAll(self, converter: typing.Callable[[System_Collections_Immutable_ImmutableList_T], System_Collections_Immutable_ImmutableList_ConvertAll_Builder_TOutput]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_ConvertAll_Builder_TOutput]:
            """
            Converts the elements in the current ImmutableList<T> to
            another type, and returns a list containing the converted elements.
            
            :param converter: A System.Converter<TInput,TOutput> delegate that converts each element from one type to another type.
            :returns: A ImmutableList<T> of the target type containing the converted elements from the current ImmutableList<T>.
            """
            ...

        @overload
        def CopyTo(self, array: typing.List[System_Collections_Immutable_ImmutableList_T]) -> None:
            """
            Copies the entire ImmutableList<T> to a compatible one-dimensional
            array, starting at the beginning of the target array.
            
            :param array: The one-dimensional System.Array that is the destination of the elements copied from ImmutableList<T>. The System.Array must have zero-based indexing.
            """
            ...

        @overload
        def CopyTo(self, array: typing.List[System_Collections_Immutable_ImmutableList_T], arrayIndex: int) -> None:
            """
            Copies the entire ImmutableList<T> to a compatible one-dimensional
            array, starting at the specified index of the target array.
            
            :param array: The one-dimensional System.Array that is the destination of the elements copied from ImmutableList<T>. The System.Array must have zero-based indexing.
            :param arrayIndex: The zero-based index in array at which copying begins.
            """
            ...

        @overload
        def CopyTo(self, index: int, array: typing.List[System_Collections_Immutable_ImmutableList_T], arrayIndex: int, count: int) -> None:
            """
            Copies a range of elements from the ImmutableList<T> to
            a compatible one-dimensional array, starting at the specified index of the
            target array.
            
            :param index: The zero-based index in the source ImmutableList<T> at which copying begins.
            :param array: The one-dimensional System.Array that is the destination of the elements copied from ImmutableList<T>. The System.Array must have zero-based indexing.
            :param arrayIndex: The zero-based index in array at which copying begins.
            :param count: The number of elements to copy.
            """
            ...

        @overload
        def CopyTo(self, array: System.Array, arrayIndex: int) -> None:
            ...

        def Exists(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> bool:
            """
            Determines whether the ImmutableList<T> contains elements
            that match the conditions defined by the specified predicate.
            
            :param match: The System.Predicate<T> delegate that defines the conditions of the elements to search for.
            :returns: true if the ImmutableList<T> contains one or more elements that match the conditions defined by the specified predicate; otherwise, false.
            """
            ...

        def Find(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> System_Collections_Immutable_ImmutableList_T:
            """
            Searches for an element that matches the conditions defined by the specified
            predicate, and returns the first occurrence within the entire ImmutableList<T>.
            
            :param match: The System.Predicate<T> delegate that defines the conditions of the element to search for.
            :returns: The first element that matches the conditions defined by the specified predicate, if found; otherwise, the default value for type T.
            """
            ...

        def FindAll(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
            """
            Retrieves all the elements that match the conditions defined by the specified
            predicate.
            
            :param match: The System.Predicate<T> delegate that defines the conditions of the elements to search for.
            :returns: A ImmutableList<T> containing all the elements that match the conditions defined by the specified predicate, if found; otherwise, an empty ImmutableList<T>.
            """
            ...

        @overload
        def FindIndex(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
            """
            Searches for an element that matches the conditions defined by the specified
            predicate, and returns the zero-based index of the first occurrence within
            the entire ImmutableList<T>.
            
            :param match: The System.Predicate<T> delegate that defines the conditions of the element to search for.
            :returns: The zero-based index of the first occurrence of an element that matches the conditions defined by match, if found; otherwise, -1.
            """
            ...

        @overload
        def FindIndex(self, startIndex: int, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
            """
            Searches for an element that matches the conditions defined by the specified
            predicate, and returns the zero-based index of the first occurrence within
            the range of elements in the ImmutableList<T> that extends
            from the specified index to the last element.
            
            :param startIndex: The zero-based starting index of the search.
            :param match: The System.Predicate<T> delegate that defines the conditions of the element to search for.
            :returns: The zero-based index of the first occurrence of an element that matches the conditions defined by match, if found; otherwise, -1.
            """
            ...

        @overload
        def FindIndex(self, startIndex: int, count: int, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
            """
            Searches for an element that matches the conditions defined by the specified
            predicate, and returns the zero-based index of the first occurrence within
            the range of elements in the ImmutableList<T> that starts
            at the specified index and contains the specified number of elements.
            
            :param startIndex: The zero-based starting index of the search.
            :param count: The number of elements in the section to search.
            :param match: The System.Predicate<T> delegate that defines the conditions of the element to search for.
            :returns: The zero-based index of the first occurrence of an element that matches the conditions defined by match, if found; otherwise, -1.
            """
            ...

        def FindLast(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> System_Collections_Immutable_ImmutableList_T:
            """
            Searches for an element that matches the conditions defined by the specified
            predicate, and returns the last occurrence within the entire ImmutableList<T>.
            
            :param match: The System.Predicate<T> delegate that defines the conditions of the element to search for.
            :returns: The last element that matches the conditions defined by the specified predicate, if found; otherwise, the default value for type T.
            """
            ...

        @overload
        def FindLastIndex(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
            """
            Searches for an element that matches the conditions defined by the specified
            predicate, and returns the zero-based index of the last occurrence within
            the entire ImmutableList<T>.
            
            :param match: The System.Predicate<T> delegate that defines the conditions of the element to search for.
            :returns: The zero-based index of the last occurrence of an element that matches the conditions defined by match, if found; otherwise, -1.
            """
            ...

        @overload
        def FindLastIndex(self, startIndex: int, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
            """
            Searches for an element that matches the conditions defined by the specified
            predicate, and returns the zero-based index of the last occurrence within
            the range of elements in the ImmutableList<T> that extends
            from the first element to the specified index.
            
            :param startIndex: The zero-based starting index of the backward search.
            :param match: The System.Predicate<T> delegate that defines the conditions of the element to search for.
            :returns: The zero-based index of the last occurrence of an element that matches the conditions defined by match, if found; otherwise, -1.
            """
            ...

        @overload
        def FindLastIndex(self, startIndex: int, count: int, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
            """
            Searches for an element that matches the conditions defined by the specified
            predicate, and returns the zero-based index of the last occurrence within
            the range of elements in the ImmutableList<T> that contains
            the specified number of elements and ends at the specified index.
            
            :param startIndex: The zero-based starting index of the backward search.
            :param count: The number of elements in the section to search.
            :param match: The System.Predicate<T> delegate that defines the conditions of the element to search for.
            :returns: The zero-based index of the last occurrence of an element that matches the conditions defined by match, if found; otherwise, -1.
            """
            ...

        def ForEach(self, action: typing.Callable[[System_Collections_Immutable_ImmutableList_T], None]) -> None:
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Immutable.ImmutableList.Enumerator:
            """
            Returns an enumerator that iterates through the collection.
            
            :returns: A IEnumerator{T} that can be used to iterate through the collection.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableList_T]:
            """
            Returns an enumerator that iterates through the collection.
            
            :returns: A IEnumerator{T} that can be used to iterate through the collection.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.IEnumerator:
            """
            Returns an enumerator that iterates through the collection.
            
            :returns: A IEnumerator{T} that can be used to iterate through the collection.
            """
            ...

        def GetRange(self, index: int, count: int) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
            """
            Creates a shallow copy of a range of elements in the source ImmutableList<T>.
            
            :param index: The zero-based ImmutableList<T> index at which the range starts.
            :param count: The number of elements in the range.
            :returns: A shallow copy of a range of elements in the source ImmutableList<T>.
            """
            ...

        @overload
        def IndexOf(self, item: System_Collections_Immutable_ImmutableList_T) -> int:
            ...

        @overload
        def IndexOf(self, item: System_Collections_Immutable_ImmutableList_T, index: int) -> int:
            """
            Searches for the specified object and returns the zero-based index of the
            first occurrence within the range of elements in the ImmutableList<T>
            that extends from the specified index to the last element.
            
            :param item: The object to locate in the ImmutableList<T>. The value can be null for reference types.
            :param index: The zero-based starting index of the search. 0 (zero) is valid in an empty list.
            :returns: The zero-based index of the first occurrence of item within the range of elements in the ImmutableList<T> that extends from index to the last element, if found; otherwise, -1.
            """
            ...

        @overload
        def IndexOf(self, item: System_Collections_Immutable_ImmutableList_T, index: int, count: int) -> int:
            """
            Searches for the specified object and returns the zero-based index of the
            first occurrence within the range of elements in the ImmutableList<T>
            that starts at the specified index and contains the specified number of elements.
            
            :param item: The object to locate in the ImmutableList<T>. The value can be null for reference types.
            :param index: The zero-based starting index of the search. 0 (zero) is valid in an empty list.
            :param count: The number of elements in the section to search.
            :returns: The zero-based index of the first occurrence of item within the range of elements in the ImmutableList<T> that starts at index and contains count number of elements, if found; otherwise, -1.
            """
            ...

        @overload
        def IndexOf(self, item: System_Collections_Immutable_ImmutableList_T, index: int, count: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> int:
            """
            Searches for the specified object and returns the zero-based index of the
            first occurrence within the range of elements in the ImmutableList<T>
            that starts at the specified index and contains the specified number of elements.
            
            :param item: The object to locate in the ImmutableList<T>. The value can be null for reference types.
            :param index: The zero-based starting index of the search. 0 (zero) is valid in an empty list.
            :param count: The number of elements in the section to search.
            :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
            :returns: The zero-based index of the first occurrence of item within the range of elements in the ImmutableList<T> that starts at index and contains count number of elements, if found; otherwise, -1.
            """
            ...

        @overload
        def IndexOf(self, value: typing.Any) -> int:
            """
            Determines the index of a specific item in the IList.
            
            :param value: The object to locate in the IList.
            :returns: The index of  if found in the list; otherwise, -1.
            """
            ...

        @overload
        def Insert(self, index: int, item: System_Collections_Immutable_ImmutableList_T) -> None:
            """See IList{T}"""
            ...

        @overload
        def Insert(self, index: int, value: typing.Any) -> None:
            """
            Inserts an item to the IList at the specified index.
            
            :param index: The zero-based index at which  should be inserted.
            :param value: The object to insert into the IList.
            """
            ...

        def InsertRange(self, index: int, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T]) -> None:
            """
            Inserts the elements of a collection into the ImmutableList<T>
            at the specified index.
            
            :param index: The zero-based index at which the new elements should be inserted.
            :param items: The collection whose elements should be inserted into the ImmutableList<T>. The collection itself cannot be null, but it can contain elements that are null, if type T is a reference type.
            """
            ...

        def ItemRef(self, index: int) -> typing.Any:
            """
            Gets a read-only reference to the value for a given index into the list.
            
            :param index: The index of the desired element.
            :returns: A read-only reference to the value at the specified index.
            """
            ...

        @overload
        def LastIndexOf(self, item: System_Collections_Immutable_ImmutableList_T) -> int:
            """
            Searches for the specified object and returns the zero-based index of the
            last occurrence within the range of elements in the ImmutableList<T>
            that contains the specified number of elements and ends at the specified
            index.
            
            :param item: The object to locate in the ImmutableList<T>. The value can be null for reference types.
            :returns: The zero-based index of the last occurrence of item within the range of elements in the ImmutableList<T> that contains count number of elements and ends at index, if found; otherwise, -1.
            """
            ...

        @overload
        def LastIndexOf(self, item: System_Collections_Immutable_ImmutableList_T, startIndex: int) -> int:
            """
            Searches for the specified object and returns the zero-based index of the
            last occurrence within the range of elements in the ImmutableList<T>
            that contains the specified number of elements and ends at the specified
            index.
            
            :param item: The object to locate in the ImmutableList<T>. The value can be null for reference types.
            :param startIndex: The zero-based starting index of the backward search.
            :returns: The zero-based index of the last occurrence of item within the range of elements in the ImmutableList<T> that contains count number of elements and ends at index, if found; otherwise, -1.
            """
            ...

        @overload
        def LastIndexOf(self, item: System_Collections_Immutable_ImmutableList_T, startIndex: int, count: int) -> int:
            """
            Searches for the specified object and returns the zero-based index of the
            last occurrence within the range of elements in the ImmutableList<T>
            that contains the specified number of elements and ends at the specified
            index.
            
            :param item: The object to locate in the ImmutableList<T>. The value can be null for reference types.
            :param startIndex: The zero-based starting index of the backward search.
            :param count: The number of elements in the section to search.
            :returns: The zero-based index of the last occurrence of item within the range of elements in the ImmutableList<T> that contains count number of elements and ends at index, if found; otherwise, -1.
            """
            ...

        @overload
        def LastIndexOf(self, item: System_Collections_Immutable_ImmutableList_T, startIndex: int, count: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> int:
            """
            Searches for the specified object and returns the zero-based index of the
            last occurrence within the range of elements in the ImmutableList<T>
            that contains the specified number of elements and ends at the specified
            index.
            
            :param item: The object to locate in the ImmutableList<T>. The value can be null for reference types.
            :param startIndex: The zero-based starting index of the backward search.
            :param count: The number of elements in the section to search.
            :param equalityComparer: The equality comparer to use in the search.
            :returns: The zero-based index of the last occurrence of item within the range of elements in the ImmutableList<T> that contains count number of elements and ends at index, if found; otherwise, -1.
            """
            ...

        @overload
        def Remove(self, item: System_Collections_Immutable_ImmutableList_T) -> bool:
            """See IList{T}"""
            ...

        @overload
        def Remove(self, item: System_Collections_Immutable_ImmutableList_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> bool:
            """
            Removes the first occurrence matching the specified value from this list.
            
            :param item: The item to remove.
            :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
            """
            ...

        @overload
        def Remove(self, value: typing.Any) -> None:
            """
            Removes the first occurrence of a specific object from the IList.
            
            :param value: The object to remove from the IList.
            """
            ...

        def RemoveAll(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
            """
            Removes all the elements that match the conditions defined by the specified
            predicate.
            
            :param match: The System.Predicate<T> delegate that defines the conditions of the elements to remove.
            :returns: The number of elements removed from the ImmutableList<T>.
            """
            ...

        def RemoveAt(self, index: int) -> None:
            """See IList{T}"""
            ...

        @overload
        def RemoveRange(self, index: int, count: int) -> None:
            """
            Removes the specified range of values from this list.
            
            :param index: The starting index to begin removal.
            :param count: The number of elements to remove.
            """
            ...

        @overload
        def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> None:
            """
            Removes any first occurrences of the specified values from this list.
            
            :param items: The items to remove if matches are found in this list.
            :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
            """
            ...

        @overload
        def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T]) -> None:
            """
            Removes any first occurrences of the specified values from this list.
            
            :param items: The items to remove if matches are found in this list.
            """
            ...

        @overload
        def Replace(self, oldValue: System_Collections_Immutable_ImmutableList_T, newValue: System_Collections_Immutable_ImmutableList_T) -> None:
            """
            Replaces the first equal element in the list with the specified element.
            
            :param oldValue: The element to replace.
            :param newValue: The element to replace the old element with.
            """
            ...

        @overload
        def Replace(self, oldValue: System_Collections_Immutable_ImmutableList_T, newValue: System_Collections_Immutable_ImmutableList_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> None:
            """
            Replaces the first equal element in the list with the specified element.
            
            :param oldValue: The element to replace.
            :param newValue: The element to replace the old element with.
            :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
            """
            ...

        @overload
        def Reverse(self) -> None:
            """Reverses the order of the elements in the entire ImmutableList<T>."""
            ...

        @overload
        def Reverse(self, index: int, count: int) -> None:
            """
            Reverses the order of the elements in the specified range.
            
            :param index: The zero-based starting index of the range to reverse.
            :param count: The number of elements in the range to reverse.
            """
            ...

        @overload
        def Sort(self) -> None:
            """
            Sorts the elements in the entire ImmutableList<T> using
            the default comparer.
            """
            ...

        @overload
        def Sort(self, comparison: typing.Callable[[System_Collections_Immutable_ImmutableList_T, System_Collections_Immutable_ImmutableList_T], int]) -> None:
            """
            Sorts the elements in the entire ImmutableList<T> using
            the specified System.Comparison<T>.
            
            :param comparison: The Comparison{T} to use when comparing elements.
            """
            ...

        @overload
        def Sort(self, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableList_T]) -> None:
            """
            Sorts the elements in the entire ImmutableList<T> using
            the specified comparer.
            
            :param comparer: The IComparer{T} implementation to use when comparing elements, or null to use Comparer{T}.Default.
            """
            ...

        @overload
        def Sort(self, index: int, count: int, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableList_T]) -> None:
            """
            Sorts the elements in a range of elements in ImmutableList<T>
            using the specified comparer.
            
            :param index: The zero-based starting index of the range to sort.
            :param count: The length of the range to sort.
            :param comparer: The IComparer{T} implementation to use when comparing elements, or null to use Comparer{T}.Default.
            """
            ...

        def ToImmutable(self) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
            """
            Creates an immutable list based on the contents of this instance.
            
            :returns: An immutable list.
            """
            ...

        def TrueForAll(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> bool:
            """
            Determines whether every element in the ImmutableList<T>
            matches the conditions defined by the specified predicate.
            
            :param match: The System.Predicate<T> delegate that defines the conditions to check against the elements.
            :returns: true if every element in the ImmutableList<T> matches the conditions defined by the specified predicate; otherwise, false. If the list has no elements, the return value is true.
            """
            ...

    class Enumerator(System.Collections.Immutable.ISecurePooledObjectUser, System.Collections.Immutable.IStrongEnumerator[System_Collections_Immutable_ImmutableList_T]):
        """Enumerates the contents of a binary tree."""

        @property
        def PoolUserId(self) -> int:
            ...

        @property
        def Current(self) -> System_Collections_Immutable_ImmutableList_T:
            """The current element."""
            ...

        def Dispose(self) -> None:
            """Disposes of this enumerator and returns the stack reference to the resource pool."""
            ...

        def MoveNext(self) -> bool:
            """
            Advances enumeration to the next element.
            
            :returns: A value indicating whether there is another element in the enumeration.
            """
            ...

        def Reset(self) -> None:
            """Restarts enumeration."""
            ...

    Empty: System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T] = ...
    """An empty immutable list."""

    @property
    def IsEmpty(self) -> bool:
        ...

    @property
    def Count(self) -> int:
        """See the IImmutableList{T} interface."""
        ...

    @property
    def SyncRoot(self) -> System.Object:
        ...

    @property
    def IsSynchronized(self) -> bool:
        """See the ICollection interface."""
        ...

    @property
    def IsReadOnly(self) -> bool:
        """Gets a value indicating whether the ICollection{T} is read-only."""
        ...

    @property
    def IsFixedSize(self) -> bool:
        """Gets a value indicating whether the IList has a fixed size."""
        ...

    @property
    def Root(self) -> System.Collections.Immutable.ImmutableList.Node:
        """Returns the root Node of the list"""
        ...

    @overload
    def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableList_T:
        ...

    @overload
    def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableList_T:
        ...

    @overload
    def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableList_T:
        """Gets or sets the value at the specified index."""
        ...

    @overload
    def __getitem__(self, index: int) -> typing.Any:
        """
        Gets or sets the object at the specified index.
        
        :param index: The index.
        :returns: The value at the specified index.
        """
        ...

    @overload
    def __setitem__(self, index: int, value: System_Collections_Immutable_ImmutableList_T) -> None:
        """Gets or sets the value at the specified index."""
        ...

    @overload
    def __setitem__(self, index: int, value: typing.Any) -> None:
        """
        Gets or sets the object at the specified index.
        
        :param index: The index.
        :returns: The value at the specified index.
        """
        ...

    @overload
    def Add(self, value: System_Collections_Immutable_ImmutableList_T) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def Add(self, value: System_Collections_Immutable_ImmutableList_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def Add(self, item: System_Collections_Immutable_ImmutableList_T) -> None:
        ...

    @overload
    def Add(self, value: typing.Any) -> int:
        ...

    @overload
    def AddRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def AddRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def BinarySearch(self, item: System_Collections_Immutable_ImmutableList_T) -> int:
        """
        Searches the entire sorted ImmutableList{T} for an element
        using the default comparer and returns the zero-based index of the element.
        
        :param item: The object to locate. The value can be null for reference types.
        :returns: The zero-based index of item in the sorted ImmutableList{T}, if item is found; otherwise, a negative number that is the bitwise complement of the index of the next element that is larger than item or, if there is no larger element, the bitwise complement of ImmutableList{T}.Count.
        """
        ...

    @overload
    def BinarySearch(self, item: System_Collections_Immutable_ImmutableList_T, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableList_T]) -> int:
        """
        Searches the entire sorted ImmutableList{T} for an element
         using the specified comparer and returns the zero-based index of the element.
        
        :param item: The object to locate. The value can be null for reference types.
        :param comparer: The IComparer{T} implementation to use when comparing elements.-or-null to use the default comparer Comparer{T}.Default.
        :returns: The zero-based index of item in the sorted ImmutableList{T}, if item is found; otherwise, a negative number that is the bitwise complement of the index of the next element that is larger than item or, if there is no larger element, the bitwise complement of ImmutableList{T}.Count.
        """
        ...

    @overload
    def BinarySearch(self, index: int, count: int, item: System_Collections_Immutable_ImmutableList_T, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableList_T]) -> int:
        """
        Searches a range of elements in the sorted ImmutableList{T}
        for an element using the specified comparer and returns the zero-based index
        of the element.
        
        :param index: The zero-based starting index of the range to search.
        :param count: The length of the range to search.
        :param item: The object to locate. The value can be null for reference types.
        :param comparer: The IComparer{T} implementation to use when comparing elements, or null to use the default comparer Comparer{T}.Default.
        :returns: The zero-based index of item in the sorted ImmutableList{T}, if item is found; otherwise, a negative number that is the bitwise complement of the index of the next element that is larger than item or, if there is no larger element, the bitwise complement of ImmutableList{T}.Count.
        """
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def Clear(self) -> None:
        """Clears this instance."""
        ...

    @overload
    def Clear(self) -> None:
        """Clears this instance."""
        ...

    @overload
    def Contains(self, value: System_Collections_Immutable_ImmutableList_T) -> bool:
        ...

    @overload
    def Contains(self, value: typing.Any) -> bool:
        """
        Determines whether the IList contains a specific value.
        
        :param value: The object to locate in the IList.
        :returns: true if the object is found in the IList; otherwise, false.
        """
        ...

    def ConvertAll(self, converter: typing.Callable[[System_Collections_Immutable_ImmutableList_T], System_Collections_Immutable_ImmutableList_ConvertAll_TOutput]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_ConvertAll_TOutput]:
        """
        Converts the elements in the current ImmutableList{T} to
        another type, and returns a list containing the converted elements.
        
        :param converter: A Func{T, TResult} delegate that converts each element from one type to another type.
        :returns: A ImmutableList{T} of the target type containing the converted elements from the current ImmutableList{T}.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[System_Collections_Immutable_ImmutableList_T]) -> None:
        """
        Copies the entire ImmutableList{T} to a compatible one-dimensional
        array, starting at the beginning of the target array.
        
        :param array: The one-dimensional Array that is the destination of the elements copied from ImmutableList{T}. The Array must have zero-based indexing.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[System_Collections_Immutable_ImmutableList_T], arrayIndex: int) -> None:
        """
        Copies the entire ImmutableList{T} to a compatible one-dimensional
        array, starting at the specified index of the target array.
        
        :param array: The one-dimensional Array that is the destination of the elements copied from ImmutableList{T}. The Array must have zero-based indexing.
        :param arrayIndex: The zero-based index in array at which copying begins.
        """
        ...

    @overload
    def CopyTo(self, index: int, array: typing.List[System_Collections_Immutable_ImmutableList_T], arrayIndex: int, count: int) -> None:
        """
        Copies a range of elements from the ImmutableList{T} to
        a compatible one-dimensional array, starting at the specified index of the
        target array.
        
        :param index: The zero-based index in the source ImmutableList{T} at which copying begins.
        :param array: The one-dimensional Array that is the destination of the elements copied from ImmutableList{T}. The Array must have zero-based indexing.
        :param arrayIndex: The zero-based index in array at which copying begins.
        :param count: The number of elements to copy.
        """
        ...

    @overload
    def CopyTo(self, array: System.Array, arrayIndex: int) -> None:
        ...

    @staticmethod
    @overload
    def Create() -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_Create_T]:
        """
        Returns an empty collection.
        
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(item: System_Collections_Immutable_ImmutableList_Create_T) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified item.
        
        :param item: The item to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(*items: System_Collections_Immutable_ImmutableList_Create_T) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    def CreateBuilder() -> System.Collections.Immutable.ImmutableList.Builder:
        """
        Creates a new immutable list builder.
        
        :returns: The immutable collection builder.
        """
        ...

    @staticmethod
    def CreateRange(items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_CreateRange_T]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_CreateRange_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    def Exists(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> bool:
        """
        Determines whether the ImmutableList{T} contains elements
        that match the conditions defined by the specified predicate.
        
        :param match: The Predicate{T} delegate that defines the conditions of the elements to search for.
        :returns: true if the ImmutableList{T} contains one or more elements that match the conditions defined by the specified predicate; otherwise, false.
        """
        ...

    def Find(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> System_Collections_Immutable_ImmutableList_T:
        """
        Searches for an element that matches the conditions defined by the specified
        predicate, and returns the first occurrence within the entire ImmutableList{T}.
        
        :param match: The Predicate{T} delegate that defines the conditions of the element to search for.
        :returns: The first element that matches the conditions defined by the specified predicate, if found; otherwise, the default value for type T.
        """
        ...

    def FindAll(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Retrieves all the elements that match the conditions defined by the specified
        predicate.
        
        :param match: The Predicate{T} delegate that defines the conditions of the elements to search for.
        :returns: A ImmutableList{T} containing all the elements that match the conditions defined by the specified predicate, if found; otherwise, an empty ImmutableList{T}.
        """
        ...

    @overload
    def FindIndex(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
        """
        Searches for an element that matches the conditions defined by the specified
        predicate, and returns the zero-based index of the first occurrence within
        the entire ImmutableList{T}.
        
        :param match: The Predicate{T} delegate that defines the conditions of the element to search for.
        :returns: The zero-based index of the first occurrence of an element that matches the conditions defined by , if found; otherwise, -1.
        """
        ...

    @overload
    def FindIndex(self, startIndex: int, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
        """
        Searches for an element that matches the conditions defined by the specified
        predicate, and returns the zero-based index of the first occurrence within
        the range of elements in the ImmutableList{T} that extends
        from the specified index to the last element.
        
        :param startIndex: The zero-based starting index of the search.
        :param match: The Predicate{T} delegate that defines the conditions of the element to search for.
        :returns: The zero-based index of the first occurrence of an element that matches the conditions defined by , if found; otherwise, -1.
        """
        ...

    @overload
    def FindIndex(self, startIndex: int, count: int, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
        """
        Searches for an element that matches the conditions defined by the specified
        predicate, and returns the zero-based index of the first occurrence within
        the range of elements in the ImmutableList{T} that starts
        at the specified index and contains the specified number of elements.
        
        :param startIndex: The zero-based starting index of the search.
        :param count: The number of elements in the section to search.
        :param match: The Predicate{T} delegate that defines the conditions of the element to search for.
        :returns: The zero-based index of the first occurrence of an element that matches the conditions defined by , if found; otherwise, -1.
        """
        ...

    def FindLast(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> System_Collections_Immutable_ImmutableList_T:
        """
        Searches for an element that matches the conditions defined by the specified
        predicate, and returns the last occurrence within the entire ImmutableList{T}.
        
        :param match: The Predicate{T} delegate that defines the conditions of the element to search for.
        :returns: The last element that matches the conditions defined by the specified predicate, if found; otherwise, the default value for type T.
        """
        ...

    @overload
    def FindLastIndex(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
        """
        Searches for an element that matches the conditions defined by the specified
        predicate, and returns the zero-based index of the last occurrence within
        the entire ImmutableList{T}.
        
        :param match: The Predicate{T} delegate that defines the conditions of the element to search for.
        :returns: The zero-based index of the last occurrence of an element that matches the conditions defined by , if found; otherwise, -1.
        """
        ...

    @overload
    def FindLastIndex(self, startIndex: int, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
        """
        Searches for an element that matches the conditions defined by the specified
        predicate, and returns the zero-based index of the last occurrence within
        the range of elements in the ImmutableList{T} that extends
        from the first element to the specified index.
        
        :param startIndex: The zero-based starting index of the backward search.
        :param match: The Predicate{T} delegate that defines the conditions of the element to search for.
        :returns: The zero-based index of the last occurrence of an element that matches the conditions defined by , if found; otherwise, -1.
        """
        ...

    @overload
    def FindLastIndex(self, startIndex: int, count: int, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> int:
        """
        Searches for an element that matches the conditions defined by the specified
        predicate, and returns the zero-based index of the last occurrence within
        the range of elements in the ImmutableList{T} that contains
        the specified number of elements and ends at the specified index.
        
        :param startIndex: The zero-based starting index of the backward search.
        :param count: The number of elements in the section to search.
        :param match: The Predicate{T} delegate that defines the conditions of the element to search for.
        :returns: The zero-based index of the last occurrence of an element that matches the conditions defined by , if found; otherwise, -1.
        """
        ...

    def ForEach(self, action: typing.Callable[[System_Collections_Immutable_ImmutableList_T], None]) -> None:
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableList_T]:
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Immutable.ImmutableList.Enumerator:
        ...

    def GetRange(self, index: int, count: int) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Creates a shallow copy of a range of elements in the source ImmutableList{T}.
        
        :param index: The zero-based ImmutableList{T} index at which the range starts.
        :param count: The number of elements in the range.
        :returns: A shallow copy of a range of elements in the source ImmutableList{T}.
        """
        ...

    @staticmethod
    @overload
    def IndexOf(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_IndexOf_T], item: System_Collections_Immutable_ImmutableList_IndexOf_T) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        first occurrence within the IImmutableList{T}.
        
        :param list: The list to search.
        :param item: The object to locate in the IImmutableList{T}. The value can be null for reference types.
        :returns: The zero-based index of the first occurrence of item within the range of elements in the IImmutableList{T} that extends from index to the last element, if found; otherwise, -1.
        """
        ...

    @staticmethod
    @overload
    def IndexOf(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_IndexOf_T], item: System_Collections_Immutable_ImmutableList_IndexOf_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_IndexOf_T]) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        first occurrence within the IImmutableList{T}.
        
        :param list: The list to search.
        :param item: The object to locate in the IImmutableList{T}. The value can be null for reference types.
        :param equalityComparer: The equality comparer to use in the search.
        :returns: The zero-based index of the first occurrence of item within the range of elements in the IImmutableList{T} that extends from index to the last element, if found; otherwise, -1.
        """
        ...

    @staticmethod
    @overload
    def IndexOf(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_IndexOf_T], item: System_Collections_Immutable_ImmutableList_IndexOf_T, startIndex: int) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        first occurrence within the range of elements in the IImmutableList{T}
        that extends from the specified index to the last element.
        
        :param list: The list to search.
        :param item: The object to locate in the IImmutableList{T}. The value can be null for reference types.
        :param startIndex: The zero-based starting index of the search. 0 (zero) is valid in an empty list.
        :returns: The zero-based index of the first occurrence of item within the range of elements in the IImmutableList{T} that extends from index to the last element, if found; otherwise, -1.
        """
        ...

    @staticmethod
    @overload
    def IndexOf(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_IndexOf_T], item: System_Collections_Immutable_ImmutableList_IndexOf_T, startIndex: int, count: int) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        first occurrence within the range of elements in the IImmutableList{T}
        that extends from the specified index to the last element.
        
        :param list: The list to search.
        :param item: The object to locate in the IImmutableList{T}. The value can be null for reference types.
        :param startIndex: The zero-based starting index of the search. 0 (zero) is valid in an empty list.
        :param count: The number of elements in the section to search.
        :returns: The zero-based index of the first occurrence of item within the range of elements in the IImmutableList{T} that extends from index to the last element, if found; otherwise, -1.
        """
        ...

    @overload
    def IndexOf(self, item: System_Collections_Immutable_ImmutableList_T, index: int, count: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        first occurrence within the range of elements in the ImmutableList{T}
        that starts at the specified index and contains the specified number of elements.
        
        :param item: The object to locate in the ImmutableList{T}. The value can be null for reference types.
        :param index: The zero-based starting index of the search. 0 (zero) is valid in an empty list.
        :param count: The number of elements in the section to search.
        :param equalityComparer: The equality comparer to use in the search.
        :returns: The zero-based index of the first occurrence of  within the range of elements in the ImmutableList{T} that starts at  and contains  number of elements, if found; otherwise, -1.
        """
        ...

    @overload
    def IndexOf(self, value: System_Collections_Immutable_ImmutableList_T) -> int:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def IndexOf(self, value: typing.Any) -> int:
        """
        Determines the index of a specific item in the IList.
        
        :param value: The object to locate in the IList.
        :returns: The index of  if found in the list; otherwise, -1.
        """
        ...

    @overload
    def Insert(self, index: int, item: System_Collections_Immutable_ImmutableList_T) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def Insert(self, index: int, item: System_Collections_Immutable_ImmutableList_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Inserts the specified value at the specified index.
        
        :param index: The index at which to insert the value.
        :param item: The element to add.
        :returns: The new immutable list.
        """
        ...

    @overload
    def Insert(self, index: int, item: System_Collections_Immutable_ImmutableList_T) -> None:
        ...

    @overload
    def Insert(self, index: int, value: typing.Any) -> None:
        """
        Inserts an item to the IList at the specified index.
        
        :param index: The zero-based index at which  should be inserted.
        :param value: The object to insert into the IList.
        """
        ...

    @overload
    def InsertRange(self, index: int, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def InsertRange(self, index: int, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Inserts the specified value at the specified index.
        
        :param index: The index at which to insert the value.
        :param items: The elements to add.
        :returns: The new immutable list.
        """
        ...

    def ItemRef(self, index: int) -> typing.Any:
        """
        Gets a read-only reference to the element of the set at the given index.
        
        :param index: The 0-based index of the element in the set to return.
        :returns: A read-only reference to the element at the given position.
        """
        ...

    @staticmethod
    @overload
    def LastIndexOf(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_LastIndexOf_T], item: System_Collections_Immutable_ImmutableList_LastIndexOf_T) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        last occurrence within the entire IImmutableList{T}.
        
        :param list: The list to search.
        :param item: The object to locate in the IImmutableList{T}. The value can be null for reference types.
        :returns: The zero-based index of the last occurrence of item within the entire the IImmutableList{T}, if found; otherwise, -1.
        """
        ...

    @staticmethod
    @overload
    def LastIndexOf(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_LastIndexOf_T], item: System_Collections_Immutable_ImmutableList_LastIndexOf_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_LastIndexOf_T]) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        last occurrence within the entire IImmutableList{T}.
        
        :param list: The list to search.
        :param item: The object to locate in the IImmutableList{T}. The value can be null for reference types.
        :param equalityComparer: The equality comparer to use in the search.
        :returns: The zero-based index of the last occurrence of item within the entire the IImmutableList{T}, if found; otherwise, -1.
        """
        ...

    @staticmethod
    @overload
    def LastIndexOf(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_LastIndexOf_T], item: System_Collections_Immutable_ImmutableList_LastIndexOf_T, startIndex: int) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        last occurrence within the range of elements in the IImmutableList{T}
        that extends from the first element to the specified index.
        
        :param list: The list to search.
        :param item: The object to locate in the IImmutableList{T}. The value can be null for reference types.
        :param startIndex: The zero-based starting index of the backward search.
        :returns: The zero-based index of the last occurrence of item within the range of elements in the IImmutableList{T} that extends from the first element to index, if found; otherwise, -1.
        """
        ...

    @staticmethod
    @overload
    def LastIndexOf(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_LastIndexOf_T], item: System_Collections_Immutable_ImmutableList_LastIndexOf_T, startIndex: int, count: int) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        last occurrence within the range of elements in the IImmutableList{T}
        that extends from the first element to the specified index.
        
        :param list: The list to search.
        :param item: The object to locate in the IImmutableList{T}. The value can be null for reference types.
        :param startIndex: The zero-based starting index of the backward search.
        :param count: The number of elements in the section to search.
        :returns: The zero-based index of the last occurrence of item within the range of elements in the IImmutableList{T} that extends from the first element to index, if found; otherwise, -1.
        """
        ...

    @overload
    def LastIndexOf(self, item: System_Collections_Immutable_ImmutableList_T, index: int, count: int, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> int:
        """
        Searches for the specified object and returns the zero-based index of the
        last occurrence within the range of elements in the ImmutableList{T}
        that contains the specified number of elements and ends at the specified
        index.
        
        :param item: The object to locate in the ImmutableList{T}. The value can be null for reference types.
        :param index: The zero-based starting index of the backward search.
        :param count: The number of elements in the section to search.
        :param equalityComparer: The equality comparer to use in the search.
        :returns: The zero-based index of the last occurrence of  within the range of elements in the ImmutableList{T} that contains  number of elements and ends at , if found; otherwise, -1.
        """
        ...

    @staticmethod
    @overload
    def Remove(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_Remove_T], value: System_Collections_Immutable_ImmutableList_Remove_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_Remove_T]:
        """
        Removes the specified value from this list.
        
        :param list: The list to search.
        :param value: The value to remove.
        :returns: A new list with the element removed, or this list if the element is not in this list.
        """
        ...

    @overload
    def Remove(self, value: System_Collections_Immutable_ImmutableList_T) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def Remove(self, value: System_Collections_Immutable_ImmutableList_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def Remove(self, value: System_Collections_Immutable_ImmutableList_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def Remove(self, item: System_Collections_Immutable_ImmutableList_T) -> bool:
        """
        Removes the specified item.
        
        :param item: The item.
        :returns: Nothing. An exception is always thrown.
        """
        ...

    @overload
    def Remove(self, value: typing.Any) -> None:
        """
        Removes the first occurrence of a specific object from the IList.
        
        :param value: The object to remove from the IList.
        """
        ...

    @overload
    def RemoveAll(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Removes all the elements that match the conditions defined by the specified
        predicate.
        
        :param match: The Predicate{T} delegate that defines the conditions of the elements to remove.
        :returns: The new list.
        """
        ...

    @overload
    def RemoveAll(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def RemoveAt(self, index: int) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def RemoveAt(self, index: int) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Removes the element at the specified index.
        
        :param index: The index.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveAt(self, index: int) -> None:
        """
        Removes the value at the specified index.
        
        :param index: The index.
        """
        ...

    @overload
    def RemoveAt(self, index: int) -> None:
        """
        Removes the IList item at the specified index.
        
        :param index: The zero-based index of the item to remove.
        """
        ...

    @staticmethod
    @overload
    def RemoveRange(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_RemoveRange_T], items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_RemoveRange_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_RemoveRange_T]:
        """
        Removes the specified values from this list.
        
        :param list: The list to search.
        :param items: The items to remove if matches are found in this list.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, index: int, count: int) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Removes the specified values from this list.
        
        :param index: The starting index to begin removal.
        :param count: The number of elements to remove.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Removes the specified values from this list.
        
        :param items: The items to remove if matches are found in this list.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Removes the specified values from this list.
        
        :param items: The items to remove if matches are found in this list.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: A new list with the elements removed.
        """
        ...

    @overload
    def RemoveRange(self, items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_T], equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def RemoveRange(self, index: int, count: int) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @staticmethod
    @overload
    def Replace(list: System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_Replace_T], oldValue: System_Collections_Immutable_ImmutableList_Replace_T, newValue: System_Collections_Immutable_ImmutableList_Replace_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_Replace_T]:
        """
        Replaces the first equal element in the list with the specified element.
        
        :param list: The list to search.
        :param oldValue: The element to replace.
        :param newValue: The element to replace the old element with.
        :returns: The new list -- even if the value being replaced is equal to the new value for that position.
        """
        ...

    @overload
    def Replace(self, oldValue: System_Collections_Immutable_ImmutableList_T, newValue: System_Collections_Immutable_ImmutableList_T) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def Replace(self, oldValue: System_Collections_Immutable_ImmutableList_T, newValue: System_Collections_Immutable_ImmutableList_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def Replace(self, oldValue: System_Collections_Immutable_ImmutableList_T, newValue: System_Collections_Immutable_ImmutableList_T, equalityComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Replaces an element in the list with the specified element.
        
        :param oldValue: The element to replace.
        :param newValue: The element to replace the old element with.
        :param equalityComparer: The equality comparer to use in the search. If null, EqualityComparer{T}.Default is used.
        :returns: The new list.
        """
        ...

    @overload
    def Reverse(self) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Reverses the order of the elements in the entire ImmutableList{T}.
        
        :returns: The reversed list.
        """
        ...

    @overload
    def Reverse(self, index: int, count: int) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Reverses the order of the elements in the specified range.
        
        :param index: The zero-based starting index of the range to reverse.
        :param count: The number of elements in the range to reverse.
        :returns: The reversed list.
        """
        ...

    @overload
    def SetItem(self, index: int, value: System_Collections_Immutable_ImmutableList_T) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """See the IImmutableList{T} interface."""
        ...

    @overload
    def SetItem(self, index: int, value: System_Collections_Immutable_ImmutableList_T) -> System.Collections.Immutable.IImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Replaces an element in the list at a given position with the specified element.
        
        :param index: The position in the list of the element to replace.
        :param value: The element to replace the old element with.
        :returns: The new list.
        """
        ...

    @overload
    def Sort(self) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Sorts the elements in the entire ImmutableList{T} using
        the default comparer.
        """
        ...

    @overload
    def Sort(self, comparison: typing.Callable[[System_Collections_Immutable_ImmutableList_T, System_Collections_Immutable_ImmutableList_T], int]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Sorts the elements in the entire ImmutableList{T} using
        the specified Comparison{T}.
        
        :param comparison: The Comparison{T} to use when comparing elements.
        :returns: The sorted list.
        """
        ...

    @overload
    def Sort(self, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Sorts the elements in the entire ImmutableList{T} using
        the specified comparer.
        
        :param comparer: The IComparer{T} implementation to use when comparing elements, or null to use the default comparer Comparer{T}.Default.
        :returns: The sorted list.
        """
        ...

    @overload
    def Sort(self, index: int, count: int, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableList_T]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_T]:
        """
        Sorts the elements in a range of elements in ImmutableList{T}
        using the specified comparer.
        
        :param index: The zero-based starting index of the range to sort.
        :param count: The length of the range to sort.
        :param comparer: The IComparer{T} implementation to use when comparing elements, or null to use the default comparer Comparer{T}.Default.
        :returns: The sorted list.
        """
        ...

    def ToBuilder(self) -> System.Collections.Immutable.ImmutableList.Builder:
        ...

    @staticmethod
    @overload
    def ToImmutableList(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableList_ToImmutableList_TSource]) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_ToImmutableList_TSource]:
        """
        Enumerates a sequence exactly once and produces an immutable list of its contents.
        
        :param source: The sequence to enumerate.
        :returns: An immutable list.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableList(builder: System.Collections.Immutable.ImmutableList.Builder) -> System.Collections.Immutable.ImmutableList[System_Collections_Immutable_ImmutableList_ToImmutableList_TSource]:
        """
        Returns an immutable copy of the current contents of the builder's collection.
        
        :param builder: The builder to create the immutable list from.
        :returns: An immutable list.
        """
        ...

    def TrueForAll(self, match: typing.Callable[[System_Collections_Immutable_ImmutableList_T], bool]) -> bool:
        """
        Determines whether every element in the ImmutableList{T}
        matches the conditions defined by the specified predicate.
        
        :param match: The Predicate{T} delegate that defines the conditions to check against the elements.
        :returns: true if every element in the ImmutableList{T} matches the conditions defined by the specified predicate; otherwise, false. If the list has no elements, the return value is true.
        """
        ...


class ImmutableSortedDictionary(typing.Generic[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue], System.Object, System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue], System.Collections.Generic.ISortKeyCollection[System_Collections_Immutable_ImmutableSortedDictionary_TKey], System.Collections.Generic.IDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue], System.Collections.IDictionary, typing.Iterable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]]):
    """An immutable sorted dictionary implementation."""

    class Builder(System.Object, System.Collections.Generic.IDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue], System.Collections.Generic.IReadOnlyDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue], System.Collections.IDictionary, typing.Iterable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]]):
        """
        A sorted dictionary that mutates with little or no memory allocations,
        can produce and/or build on immutable sorted dictionary instances very efficiently.
        """

        @property
        def Keys(self) -> System.Collections.Generic.ICollection[System_Collections_Immutable_ImmutableSortedDictionary_TKey]:
            ...

        @property
        def Values(self) -> System.Collections.Generic.ICollection[System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
            """See IDictionary{TKey, TValue}"""
            ...

        @property
        def Count(self) -> int:
            """Gets the number of elements in this map."""
            ...

        @property
        def IsReadOnly(self) -> bool:
            """Gets a value indicating whether this instance is read-only."""
            ...

        @property
        def Version(self) -> int:
            ...

        @property
        def IsFixedSize(self) -> bool:
            ...

        @property
        def SyncRoot(self) -> System.Object:
            ...

        @property
        def IsSynchronized(self) -> bool:
            """Gets a value indicating whether access to the ICollection is synchronized (thread safe)."""
            ...

        @property
        def KeyComparer(self) -> System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_TKey]:
            """Gets or sets the key comparer."""
            ...

        @KeyComparer.setter
        def KeyComparer(self, value: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_TKey]):
            """Gets or sets the key comparer."""
            ...

        @property
        def ValueComparer(self) -> System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
            """Gets or sets the value comparer."""
            ...

        @ValueComparer.setter
        def ValueComparer(self, value: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableSortedDictionary_TValue]):
            """Gets or sets the value comparer."""
            ...

        @overload
        def __getitem__(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> System_Collections_Immutable_ImmutableSortedDictionary_TValue:
            ...

        @overload
        def __getitem__(self, key: typing.Any) -> typing.Any:
            """
            Gets or sets the element with the specified key.
            
            :param key: The key.
            """
            ...

        @overload
        def __setitem__(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, value: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> None:
            ...

        @overload
        def __setitem__(self, key: typing.Any, value: typing.Any) -> None:
            """
            Gets or sets the element with the specified key.
            
            :param key: The key.
            """
            ...

        @overload
        def Add(self, key: typing.Any, value: typing.Any) -> None:
            ...

        @overload
        def Add(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, value: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> None:
            ...

        @overload
        def Add(self, item: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]) -> None:
            """See IDictionary{TKey, TValue}"""
            ...

        def AddRange(self, items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]]) -> None:
            """
            Removes any entries from the dictionaries with keys that match those found in the specified sequence.
            
            :param items: The keys for entries to remove from the dictionary.
            """
            ...

        def Clear(self) -> None:
            """See IDictionary{TKey, TValue}"""
            ...

        @overload
        def Contains(self, key: typing.Any) -> bool:
            """
            Determines whether the IDictionary object contains an element with the specified key.
            
            :param key: The key to locate in the IDictionary object.
            :returns: true if the IDictionary contains an element with the key; otherwise, false.
            """
            ...

        @overload
        def Contains(self, item: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]) -> bool:
            """See IDictionary{TKey, TValue}"""
            ...

        def ContainsKey(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> bool:
            """See IDictionary{TKey, TValue}"""
            ...

        def ContainsValue(self, value: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> bool:
            ...

        @overload
        def CopyTo(self, array: System.Array, index: int) -> None:
            ...

        @overload
        def CopyTo(self, array: typing.List[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]], arrayIndex: int) -> None:
            """See IDictionary{TKey, TValue}"""
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.IDictionaryEnumerator:
            """
            Returns an IDictionaryEnumerator object for the IDictionary object.
            
            :returns: An IDictionaryEnumerator object for the IDictionary object.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Immutable.ImmutableSortedDictionary.Enumerator:
            """See IDictionary{TKey, TValue}"""
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]]:
            """See IDictionary{TKey, TValue}"""
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.IEnumerator:
            """See IDictionary{TKey, TValue}"""
            ...

        @overload
        def GetValueOrDefault(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> System_Collections_Immutable_ImmutableSortedDictionary_TValue:
            """
            Gets the value for a given key if a matching key exists in the dictionary.
            
            :param key: The key to search for.
            :returns: The value for the key, or the default value for type TValue if no matching key was found.
            """
            ...

        @overload
        def GetValueOrDefault(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, defaultValue: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> System_Collections_Immutable_ImmutableSortedDictionary_TValue:
            """
            Gets the value for a given key if a matching key exists in the dictionary.
            
            :param key: The key to search for.
            :param defaultValue: The default value to return if no matching key is found in the dictionary.
            :returns: The value for the key, or  if no matching key was found.
            """
            ...

        @overload
        def Remove(self, key: typing.Any) -> None:
            """
            Removes the element with the specified key from the IDictionary object.
            
            :param key: The key of the element to remove.
            """
            ...

        @overload
        def Remove(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> bool:
            """See IDictionary{TKey, TValue}"""
            ...

        @overload
        def Remove(self, item: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]) -> bool:
            """See IDictionary{TKey, TValue}"""
            ...

        def RemoveRange(self, keys: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedDictionary_TKey]) -> None:
            """
            Removes any entries from the dictionaries with keys that match those found in the specified sequence.
            
            :param keys: The keys for entries to remove from the dictionary.
            """
            ...

        def ToImmutable(self) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
            """
            Creates an immutable sorted dictionary based on the contents of this instance.
            
            :returns: An immutable map.
            """
            ...

        def TryGetKey(self, equalKey: System_Collections_Immutable_ImmutableSortedDictionary_TKey, actualKey: typing.Optional[System_Collections_Immutable_ImmutableSortedDictionary_TKey]) -> typing.Union[bool, System_Collections_Immutable_ImmutableSortedDictionary_TKey]:
            """See the IImmutableDictionary{TKey, TValue} interface."""
            ...

        def TryGetValue(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, value: typing.Optional[System_Collections_Immutable_ImmutableSortedDictionary_TValue]) -> typing.Union[bool, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
            """See IDictionary{TKey, TValue}"""
            ...

        def ValueRef(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> typing.Any:
            """Returns a read-only reference to the value associated with the provided key."""
            ...

    class Enumerator(System.Collections.Immutable.ISecurePooledObjectUser):
        """Enumerates the contents of a binary tree."""

        @property
        def Current(self) -> System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
            """The current element."""
            ...

        @property
        def PoolUserId(self) -> int:
            ...

        def Dispose(self) -> None:
            """Disposes of this enumerator and returns the stack reference to the resource pool."""
            ...

        def MoveNext(self) -> bool:
            """
            Advances enumeration to the next element.
            
            :returns: A value indicating whether there is another element in the enumeration.
            """
            ...

        def Reset(self) -> None:
            """Restarts enumeration."""
            ...

    Empty: System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue] = ...
    """An empty sorted dictionary with default sort and equality comparers."""

    @property
    def ValueComparer(self) -> System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        ...

    @property
    def IsEmpty(self) -> bool:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @property
    def Count(self) -> int:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @property
    def Keys(self) -> System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedDictionary_TKey]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @property
    def Values(self) -> System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @property
    def IsReadOnly(self) -> bool:
        ...

    @property
    def KeyComparer(self) -> System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_TKey]:
        ...

    @property
    def Root(self) -> System.Collections.Immutable.ImmutableSortedDictionary.Node:
        ...

    @property
    def IsFixedSize(self) -> bool:
        ...

    @property
    def SyncRoot(self) -> System.Object:
        ...

    @property
    def IsSynchronized(self) -> bool:
        """Gets a value indicating whether access to the ICollection is synchronized (thread safe)."""
        ...

    @overload
    def __getitem__(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> System_Collections_Immutable_ImmutableSortedDictionary_TValue:
        ...

    @overload
    def __getitem__(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> System_Collections_Immutable_ImmutableSortedDictionary_TValue:
        ...

    @overload
    def __getitem__(self, key: typing.Any) -> typing.Any:
        """
        Gets or sets the element with the specified key.
        
        :param key: The key.
        """
        ...

    @overload
    def __setitem__(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, value: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> None:
        ...

    @overload
    def __setitem__(self, key: typing.Any, value: typing.Any) -> None:
        """
        Gets or sets the element with the specified key.
        
        :param key: The key.
        """
        ...

    @overload
    def Add(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, value: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def Add(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, value: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        ...

    @overload
    def Add(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, value: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> None:
        ...

    @overload
    def Add(self, item: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]) -> None:
        ...

    @overload
    def Add(self, key: typing.Any, value: typing.Any) -> None:
        ...

    @overload
    def AddRange(self, items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def AddRange(self, pairs: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]]) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def Clear(self) -> None:
        ...

    @overload
    def Clear(self) -> None:
        """Clears this instance."""
        ...

    @overload
    def Contains(self, pair: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]) -> bool:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def Contains(self, key: typing.Any) -> bool:
        """
        Determines whether the IDictionary object contains an element with the specified key.
        
        :param key: The key to locate in the IDictionary object.
        :returns: true if the IDictionary contains an element with the key; otherwise, false.
        """
        ...

    def ContainsKey(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> bool:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    def ContainsValue(self, value: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> bool:
        """
        Determines whether the ImmutableSortedDictionary{TKey, TValue}
        contains an element with the specified value.
        
        :param value: The value to locate in the ImmutableSortedDictionary{TKey, TValue}. The value can be null for reference types.
        :returns: true if the ImmutableSortedDictionary{TKey, TValue} contains an element with the specified value; otherwise, false.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]], arrayIndex: int) -> None:
        ...

    @overload
    def CopyTo(self, array: System.Array, index: int) -> None:
        ...

    @staticmethod
    @overload
    def Create() -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_Create_TKey, System_Collections_Immutable_ImmutableSortedDictionary_Create_TValue]:
        """
        Returns an empty collection.
        
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_Create_TKey]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_Create_TKey, System_Collections_Immutable_ImmutableSortedDictionary_Create_TValue]:
        """
        Returns an empty collection.
        
        :param keyComparer: The key comparer.
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_Create_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableSortedDictionary_Create_TValue]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_Create_TKey, System_Collections_Immutable_ImmutableSortedDictionary_Create_TValue]:
        """
        Returns an empty collection.
        
        :param keyComparer: The key comparer.
        :param valueComparer: The value comparer.
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder() -> System.Collections.Immutable.ImmutableSortedDictionary.Builder:
        """
        Creates a new immutable sorted dictionary builder.
        
        :returns: The immutable collection builder.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder(keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_CreateBuilder_TKey]) -> System.Collections.Immutable.ImmutableSortedDictionary.Builder:
        """
        Creates a new immutable sorted dictionary builder.
        
        :param keyComparer: The key comparer.
        :returns: The immutable collection builder.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder(keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_CreateBuilder_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableSortedDictionary_CreateBuilder_TValue]) -> System.Collections.Immutable.ImmutableSortedDictionary.Builder:
        """
        Creates a new immutable sorted dictionary builder.
        
        :param keyComparer: The key comparer.
        :param valueComparer: The value comparer.
        :returns: The immutable collection builder.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TValue]]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TValue]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TKey], items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TValue]]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TValue]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param keyComparer: The key comparer.
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TValue], items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TValue]]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TKey, System_Collections_Immutable_ImmutableSortedDictionary_CreateRange_TValue]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param keyComparer: The key comparer.
        :param valueComparer: The value comparer.
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.IDictionaryEnumerator:
        """
        Returns an IDictionaryEnumerator object for the IDictionary object.
        
        :returns: An IDictionaryEnumerator object for the IDictionary object.
        """
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]]:
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Immutable.ImmutableSortedDictionary.Enumerator:
        ...

    @overload
    def Remove(self, value: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def Remove(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def Remove(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> bool:
        """
        Removes the element with the specified key from the IDictionary{TKey, TValue}.
        
        :param key: The key of the element to remove.
        :returns: true if the element is successfully removed; otherwise, false.  This method also returns false if  was not found in the original IDictionary{TKey, TValue}.
        """
        ...

    @overload
    def Remove(self, item: System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]) -> bool:
        ...

    @overload
    def Remove(self, key: typing.Any) -> None:
        """
        Removes the element with the specified key from the IDictionary object.
        
        :param key: The key of the element to remove.
        """
        ...

    @overload
    def RemoveRange(self, keys: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedDictionary_TKey]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def RemoveRange(self, keys: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedDictionary_TKey]) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def SetItem(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, value: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def SetItem(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, value: System_Collections_Immutable_ImmutableSortedDictionary_TValue) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def SetItems(self, items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """
        Applies a given set of key=value pairs to an immutable dictionary, replacing any conflicting keys in the resulting dictionary.
        
        :param items: The key=value pairs to set on the map.  Any keys that conflict with existing keys will overwrite the previous values.
        :returns: An immutable dictionary.
        """
        ...

    @overload
    def SetItems(self, items: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]]) -> System.Collections.Immutable.IImmutableDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """
        Applies a given set of key=value pairs to an immutable dictionary, replacing any conflicting keys in the resulting dictionary.
        
        :param items: The key=value pairs to set on the map.  Any keys that conflict with existing keys will overwrite the previous values.
        :returns: An immutable dictionary.
        """
        ...

    def ToBuilder(self) -> System.Collections.Immutable.ImmutableSortedDictionary.Builder:
        ...

    @staticmethod
    @overload
    def ToImmutableSortedDictionary(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource], keySelector: typing.Callable[[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource], System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey], elementSelector: typing.Callable[[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource], System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue], keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]:
        """
        Constructs an immutable sorted dictionary based on some transformation of a sequence.
        
        :param source: The sequence to enumerate to generate the map.
        :param keySelector: The function that will produce the key for the map from each sequence element.
        :param elementSelector: The function that will produce the value for the map from each sequence element.
        :param keyComparer: The key comparer to use for the map.
        :param valueComparer: The value comparer to use for the map.
        :returns: The immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableSortedDictionary(builder: System.Collections.Immutable.ImmutableSortedDictionary.Builder) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]:
        """
        Returns an immutable copy of the current contents of the builder's collection.
        
        :param builder: The builder to create the immutable map from.
        :returns: An immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableSortedDictionary(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource], keySelector: typing.Callable[[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource], System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey], elementSelector: typing.Callable[[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource], System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue], keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]:
        """
        Constructs an immutable sorted dictionary based on some transformation of a sequence.
        
        :param source: The sequence to enumerate to generate the map.
        :param keySelector: The function that will produce the key for the map from each sequence element.
        :param elementSelector: The function that will produce the value for the map from each sequence element.
        :param keyComparer: The key comparer to use for the map.
        :returns: The immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableSortedDictionary(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource], keySelector: typing.Callable[[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource], System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey], elementSelector: typing.Callable[[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TSource], System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]:
        """
        Constructs an immutable sorted dictionary based on some transformation of a sequence.
        
        :param source: The sequence to enumerate to generate the map.
        :param keySelector: The function that will produce the key for the map from each sequence element.
        :param elementSelector: The function that will produce the value for the map from each sequence element.
        :returns: The immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableSortedDictionary(source: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]], keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]:
        """
        Creates an immutable sorted dictionary given a sequence of key=value pairs.
        
        :param source: The sequence of key=value pairs.
        :param keyComparer: The key comparer to use when building the immutable map.
        :param valueComparer: The value comparer to use for the immutable map.
        :returns: An immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableSortedDictionary(source: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]], keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]:
        """
        Creates an immutable sorted dictionary given a sequence of key=value pairs.
        
        :param source: The sequence of key=value pairs.
        :param keyComparer: The key comparer to use when building the immutable map.
        :returns: An immutable map.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableSortedDictionary(source: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_ToImmutableSortedDictionary_TValue]:
        """
        Creates an immutable sorted dictionary given a sequence of key=value pairs.
        
        :param source: The sequence of key=value pairs.
        :returns: An immutable map.
        """
        ...

    def TryGetKey(self, equalKey: System_Collections_Immutable_ImmutableSortedDictionary_TKey, actualKey: typing.Optional[System_Collections_Immutable_ImmutableSortedDictionary_TKey]) -> typing.Union[bool, System_Collections_Immutable_ImmutableSortedDictionary_TKey]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    def TryGetValue(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey, value: typing.Optional[System_Collections_Immutable_ImmutableSortedDictionary_TValue]) -> typing.Union[bool, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    def ValueRef(self, key: System_Collections_Immutable_ImmutableSortedDictionary_TKey) -> typing.Any:
        """Returns a read-only reference to the value associated with the provided key."""
        ...

    @overload
    def WithComparers(self, keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_TKey], valueComparer: System.Collections.Generic.IEqualityComparer[System_Collections_Immutable_ImmutableSortedDictionary_TValue]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...

    @overload
    def WithComparers(self, keyComparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedDictionary_TKey]) -> System.Collections.Immutable.ImmutableSortedDictionary[System_Collections_Immutable_ImmutableSortedDictionary_TKey, System_Collections_Immutable_ImmutableSortedDictionary_TValue]:
        """See the IImmutableDictionary{TKey, TValue} interface."""
        ...


class ImmutableSortedSet(typing.Generic[System_Collections_Immutable_ImmutableSortedSet_T], System.Object, System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableSortedSet_T], System.Collections.Generic.ISortKeyCollection[System_Collections_Immutable_ImmutableSortedSet_T], System.Collections.Generic.IReadOnlyList[System_Collections_Immutable_ImmutableSortedSet_T], System.Collections.Generic.IList[System_Collections_Immutable_ImmutableSortedSet_T], System.Collections.Generic.ISet[System_Collections_Immutable_ImmutableSortedSet_T], System.Collections.IList, System.Collections.Immutable.IStrongEnumerable[System_Collections_Immutable_ImmutableSortedSet_T, System_Collections_Immutable_ImmutableSortedSet_Enumerator], typing.Iterable[System_Collections_Immutable_ImmutableSortedSet_T]):
    """An immutable sorted set implementation."""

    class Builder(System.Object, System.Collections.Generic.ISortKeyCollection[System_Collections_Immutable_ImmutableSortedSet_T], System.Collections.Generic.IReadOnlyCollection[System_Collections_Immutable_ImmutableSortedSet_T], System.Collections.Generic.ISet[System_Collections_Immutable_ImmutableSortedSet_T], typing.Iterable[System_Collections_Immutable_ImmutableSortedSet_T]):
        """
        A sorted set that mutates with little or no memory allocations,
        can produce and/or build on immutable sorted set instances very efficiently.
        """

        @property
        def Count(self) -> int:
            ...

        @property
        def IsReadOnly(self) -> bool:
            """Gets a value indicating whether this instance is read-only."""
            ...

        @property
        def Max(self) -> System_Collections_Immutable_ImmutableSortedSet_T:
            """Gets the maximum value in the collection, as defined by the comparer."""
            ...

        @property
        def Min(self) -> System_Collections_Immutable_ImmutableSortedSet_T:
            """Gets the minimum value in the collection, as defined by the comparer."""
            ...

        @property
        def KeyComparer(self) -> System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedSet_T]:
            """Gets or sets the IComparer{T} object that is used to determine equality for the values in the ImmutableSortedSet{T}."""
            ...

        @KeyComparer.setter
        def KeyComparer(self, value: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedSet_T]):
            """Gets or sets the IComparer{T} object that is used to determine equality for the values in the ImmutableSortedSet{T}."""
            ...

        @property
        def Version(self) -> int:
            """Gets the current version of the contents of this builder."""
            ...

        @property
        def IsSynchronized(self) -> bool:
            """Gets a value indicating whether access to the ICollection is synchronized (thread safe)."""
            ...

        @property
        def SyncRoot(self) -> System.Object:
            """Gets an object that can be used to synchronize access to the ICollection."""
            ...

        def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableSortedSet_T:
            ...

        @overload
        def Add(self, item: System_Collections_Immutable_ImmutableSortedSet_T) -> bool:
            ...

        @overload
        def Add(self, item: System_Collections_Immutable_ImmutableSortedSet_T) -> None:
            """
            Adds an element to the current set and returns a value to indicate if the
            element was successfully added.
            
            :param item: The element to add to the set.
            """
            ...

        def Clear(self) -> None:
            """Removes all elements from this set."""
            ...

        def Contains(self, item: System_Collections_Immutable_ImmutableSortedSet_T) -> bool:
            """
            Determines whether the set contains a specific value.
            
            :param item: The object to locate in the set.
            :returns: true if item is found in the set; false otherwise.
            """
            ...

        @overload
        def CopyTo(self, array: typing.List[System_Collections_Immutable_ImmutableSortedSet_T], arrayIndex: int) -> None:
            """See ICollection{T}"""
            ...

        @overload
        def CopyTo(self, array: System.Array, arrayIndex: int) -> None:
            ...

        def ExceptWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> None:
            """
            Removes all elements in the specified collection from the current set.
            
            :param other: The collection of items to remove from the set.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Immutable.ImmutableSortedSet.Enumerator:
            """
            Returns an enumerator that iterates through the collection.
            
            :returns: A enumerator that can be used to iterate through the collection.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableSortedSet_T]:
            """
            Returns an enumerator that iterates through the collection.
            
            :returns: A enumerator that can be used to iterate through the collection.
            """
            ...

        @overload
        def GetEnumerator(self) -> System.Collections.IEnumerator:
            """
            Returns an enumerator that iterates through the collection.
            
            :returns: A enumerator that can be used to iterate through the collection.
            """
            ...

        def IndexOf(self, item: System_Collections_Immutable_ImmutableSortedSet_T) -> int:
            ...

        def IntersectWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> None:
            """
            Modifies the current set so that it contains only elements that are also in a specified collection.
            
            :param other: The collection to compare to the current set.
            """
            ...

        def IsProperSubsetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
            """
            Determines whether the current set is a proper (strict) subset of a specified collection.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set is a correct subset of other; otherwise, false.
            """
            ...

        def IsProperSupersetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
            """
            Determines whether the current set is a proper (strict) superset of a specified collection.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set is a superset of other; otherwise, false.
            """
            ...

        def IsSubsetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
            """
            Determines whether the current set is a subset of a specified collection.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set is a subset of other; otherwise, false.
            """
            ...

        def IsSupersetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
            """
            Determines whether the current set is a superset of a specified collection.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set is a superset of other; otherwise, false.
            """
            ...

        def ItemRef(self, index: int) -> typing.Any:
            """
            Gets a read-only reference to the element of the set at the given index.
            
            :param index: The 0-based index of the element in the set to return.
            :returns: A read-only reference to the element at the given position.
            """
            ...

        def Overlaps(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
            """
            Determines whether the current set overlaps with the specified collection.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set and other share at least one common element; otherwise, false.
            """
            ...

        def Remove(self, item: System_Collections_Immutable_ImmutableSortedSet_T) -> bool:
            """
            Removes the first occurrence of a specific object from the set.
            
            :param item: The object to remove from the set.
            :returns: true if the item was removed from the set; false if the item was not found in the set.
            """
            ...

        def Reverse(self) -> System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]:
            """
            Returns an IEnumerable{T} that iterates over this
            collection in reverse order.
            
            :returns: An enumerator that iterates over the ImmutableSortedSet{T}.Builder in reverse order.
            """
            ...

        def SetEquals(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
            """
            Determines whether the current set and the specified collection contain the same elements.
            
            :param other: The collection to compare to the current set.
            :returns: true if the current set is equal to other; otherwise, false.
            """
            ...

        def SymmetricExceptWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> None:
            """
            Modifies the current set so that it contains only elements that are present either in the current set or in the specified collection, but not both.
            
            :param other: The collection to compare to the current set.
            """
            ...

        def ToImmutable(self) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_T]:
            """
            Creates an immutable sorted set based on the contents of this instance.
            
            :returns: An immutable set.
            """
            ...

        def TryGetValue(self, equalValue: System_Collections_Immutable_ImmutableSortedSet_T, actualValue: typing.Optional[System_Collections_Immutable_ImmutableSortedSet_T]) -> typing.Union[bool, System_Collections_Immutable_ImmutableSortedSet_T]:
            """
            Searches the set for a given value and returns the equal value it finds, if any.
            
            :param equalValue: The value for which to search.
            :param actualValue: The value from the set that the search found, or the original value if the search yielded no match.
            :returns: A value indicating whether the search was successful.
            """
            ...

        def UnionWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> None:
            """
            Modifies the current set so that it contains all elements that are present in both the current set and in the specified collection.
            
            :param other: The collection to compare to the current set.
            """
            ...

    class Enumerator(System.Collections.Immutable.ISecurePooledObjectUser, System.Collections.Immutable.IStrongEnumerator[System_Collections_Immutable_ImmutableSortedSet_T]):
        """Enumerates the contents of a binary tree."""

        @property
        def PoolUserId(self) -> int:
            ...

        @property
        def Current(self) -> System_Collections_Immutable_ImmutableSortedSet_T:
            """The current element."""
            ...

        def Dispose(self) -> None:
            """Disposes of this enumerator and returns the stack reference to the resource pool."""
            ...

        def MoveNext(self) -> bool:
            """
            Advances enumeration to the next element.
            
            :returns: A value indicating whether there is another element in the enumeration.
            """
            ...

        def Reset(self) -> None:
            """Restarts enumeration."""
            ...

    Empty: System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_T] = ...
    """An empty sorted set with the default sort comparer."""

    @property
    def Max(self) -> System_Collections_Immutable_ImmutableSortedSet_T:
        """Gets the maximum value in the collection, as defined by the comparer."""
        ...

    @property
    def Min(self) -> System_Collections_Immutable_ImmutableSortedSet_T:
        """Gets the minimum value in the collection, as defined by the comparer."""
        ...

    @property
    def IsEmpty(self) -> bool:
        ...

    @property
    def Count(self) -> int:
        """See the IImmutableSet{T} interface."""
        ...

    @property
    def KeyComparer(self) -> System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedSet_T]:
        ...

    @property
    def Root(self) -> System.Collections.Immutable.IBinaryTree:
        ...

    @property
    def IsReadOnly(self) -> bool:
        ...

    @property
    def IsFixedSize(self) -> bool:
        ...

    @property
    def SyncRoot(self) -> System.Object:
        ...

    @property
    def IsSynchronized(self) -> bool:
        """See the ICollection interface."""
        ...

    @overload
    def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableSortedSet_T:
        ...

    @overload
    def __getitem__(self, index: int) -> System_Collections_Immutable_ImmutableSortedSet_T:
        ...

    @overload
    def __getitem__(self, index: int) -> typing.Any:
        """
        Gets or sets the object at the specified index.
        
        :param index: The index.
        """
        ...

    @overload
    def __setitem__(self, index: int, value: System_Collections_Immutable_ImmutableSortedSet_T) -> None:
        ...

    @overload
    def __setitem__(self, index: int, value: typing.Any) -> None:
        """
        Gets or sets the object at the specified index.
        
        :param index: The index.
        """
        ...

    @overload
    def Add(self, value: System_Collections_Immutable_ImmutableSortedSet_T) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Add(self, value: System_Collections_Immutable_ImmutableSortedSet_T) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Add(self, item: System_Collections_Immutable_ImmutableSortedSet_T) -> bool:
        ...

    @overload
    def Add(self, item: System_Collections_Immutable_ImmutableSortedSet_T) -> None:
        """See the IList{T} interface."""
        ...

    @overload
    def Add(self, value: typing.Any) -> int:
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Clear(self) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Clear(self) -> None:
        """See the ICollection{T} interface."""
        ...

    @overload
    def Clear(self) -> None:
        """Clears this instance."""
        ...

    @overload
    def Contains(self, value: System_Collections_Immutable_ImmutableSortedSet_T) -> bool:
        ...

    @overload
    def Contains(self, value: typing.Any) -> bool:
        """
        Determines whether the IList contains a specific value.
        
        :param value: The object to locate in the IList.
        :returns: true if the object is found in the IList; otherwise, false.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[System_Collections_Immutable_ImmutableSortedSet_T], arrayIndex: int) -> None:
        """See the ICollection{T} interface."""
        ...

    @overload
    def CopyTo(self, array: System.Array, index: int) -> None:
        ...

    @staticmethod
    @overload
    def Create() -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_Create_T]:
        """
        Returns an empty collection.
        
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedSet_Create_T]) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_Create_T]:
        """
        Returns an empty collection.
        
        :param comparer: The comparer.
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(item: System_Collections_Immutable_ImmutableSortedSet_Create_T) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified item.
        
        :param item: The item to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedSet_Create_T], item: System_Collections_Immutable_ImmutableSortedSet_Create_T) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified item.
        
        :param comparer: The comparer.
        :param item: The item to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(*items: System_Collections_Immutable_ImmutableSortedSet_Create_T) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def Create(comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedSet_Create_T], *items: System_Collections_Immutable_ImmutableSortedSet_Create_T) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_Create_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param comparer: The comparer.
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder() -> System.Collections.Immutable.ImmutableSortedSet.Builder:
        """
        Returns an empty collection.
        
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateBuilder(comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedSet_CreateBuilder_T]) -> System.Collections.Immutable.ImmutableSortedSet.Builder:
        """
        Returns an empty collection.
        
        :param comparer: The comparer.
        :returns: The immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_CreateRange_T]) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_CreateRange_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @staticmethod
    @overload
    def CreateRange(comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedSet_CreateRange_T], items: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_CreateRange_T]) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_CreateRange_T]:
        """
        Creates a new immutable collection prefilled with the specified items.
        
        :param comparer: The comparer.
        :param items: The items to prepopulate.
        :returns: The new immutable collection.
        """
        ...

    @overload
    def Except(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Except(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    def ExceptWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> None:
        """See ISet{T}"""
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[System_Collections_Immutable_ImmutableSortedSet_T]:
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        ...

    @overload
    def GetEnumerator(self) -> System.Collections.Immutable.ImmutableSortedSet.Enumerator:
        ...

    @overload
    def IndexOf(self, item: System_Collections_Immutable_ImmutableSortedSet_T) -> int:
        """
        Gets the position within this set that the specified value does or would appear.
        
        :param item: The value whose position is being sought.
        :returns: The index of the specified  in the sorted set, if  is found.  If  is not found and  is less than one or more elements in this set, a negative number which is the bitwise complement of the index of the first element that is larger than value. If  is not found and  is greater than any of the elements in the set, a negative number which is the bitwise complement of (the index of the last element plus 1).
        """
        ...

    @overload
    def IndexOf(self, value: typing.Any) -> int:
        """
        Determines the index of a specific item in the IList.
        
        :param value: The object to locate in the IList.
        :returns: The index of  if found in the list; otherwise, -1.
        """
        ...

    @overload
    def Insert(self, index: int, item: System_Collections_Immutable_ImmutableSortedSet_T) -> None:
        """See the IList{T} interface."""
        ...

    @overload
    def Insert(self, index: int, value: typing.Any) -> None:
        """
        Inserts an item to the IList at the specified index.
        
        :param index: The zero-based index at which  should be inserted.
        :param value: The object to insert into the IList.
        """
        ...

    @overload
    def Intersect(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Intersect(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    def IntersectWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> None:
        """See ISet{T}"""
        ...

    def IsProperSubsetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
        """
        Determines whether the current set is a property (strict) subset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a correct subset of other; otherwise, false.
        """
        ...

    def IsProperSupersetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
        """
        Determines whether the current set is a correct superset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a correct superset of other; otherwise, false.
        """
        ...

    def IsSubsetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
        """
        Determines whether a set is a subset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a subset of other; otherwise, false.
        """
        ...

    def IsSupersetOf(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
        """
        Determines whether the current set is a superset of a specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set is a superset of other; otherwise, false.
        """
        ...

    def ItemRef(self, index: int) -> typing.Any:
        """
        Gets a read-only reference of the element of the set at the given index.
        
        :param index: The 0-based index of the element in the set to return.
        :returns: A read-only reference of the element at the given position.
        """
        ...

    def Overlaps(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
        """
        Determines whether the current set overlaps with the specified collection.
        
        :param other: The collection to compare to the current set.
        :returns: true if the current set and other share at least one common element; otherwise, false.
        """
        ...

    @overload
    def Remove(self, value: System_Collections_Immutable_ImmutableSortedSet_T) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Remove(self, value: System_Collections_Immutable_ImmutableSortedSet_T) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Remove(self, item: System_Collections_Immutable_ImmutableSortedSet_T) -> bool:
        """See the IList{T} interface."""
        ...

    @overload
    def Remove(self, value: typing.Any) -> None:
        """
        Removes the first occurrence of a specific object from the IList.
        
        :param value: The object to remove from the IList.
        """
        ...

    @overload
    def RemoveAt(self, index: int) -> None:
        """See the IList{T} interface."""
        ...

    @overload
    def RemoveAt(self, index: int) -> None:
        """
        Removes at.
        
        :param index: The index.
        """
        ...

    def Reverse(self) -> System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]:
        """
        Returns an IEnumerable{T} that iterates over this
        collection in reverse order.
        
        :returns: An enumerator that iterates over the ImmutableSortedSet{T} in reverse order.
        """
        ...

    def SetEquals(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> bool:
        """
        Checks whether a given sequence of items entirely describe the contents of this set.
        
        :param other: The sequence of items to check against this set.
        :returns: A value indicating whether the sets are equal.
        """
        ...

    @overload
    def SymmetricExcept(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """
        Produces a set that contains elements either in this set or a given sequence, but not both.
        
        :param other: The other sequence of items.
        :returns: The new set.
        """
        ...

    @overload
    def SymmetricExcept(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """
        Produces a set that contains elements either in this set or a given sequence, but not both.
        
        :param other: The other sequence of items.
        :returns: The new set.
        """
        ...

    def SymmetricExceptWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> None:
        """See ISet{T}"""
        ...

    def ToBuilder(self) -> System.Collections.Immutable.ImmutableSortedSet.Builder:
        ...

    @staticmethod
    @overload
    def ToImmutableSortedSet(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_ToImmutableSortedSet_TSource], comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedSet_ToImmutableSortedSet_TSource]) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_ToImmutableSortedSet_TSource]:
        """
        Enumerates a sequence exactly once and produces an immutable set of its contents.
        
        :param source: The sequence to enumerate.
        :param comparer: The comparer to use for initializing and adding members to the sorted set.
        :returns: An immutable set.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableSortedSet(source: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_ToImmutableSortedSet_TSource]) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_ToImmutableSortedSet_TSource]:
        """
        Enumerates a sequence exactly once and produces an immutable set of its contents.
        
        :param source: The sequence to enumerate.
        :returns: An immutable set.
        """
        ...

    @staticmethod
    @overload
    def ToImmutableSortedSet(builder: System.Collections.Immutable.ImmutableSortedSet.Builder) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_ToImmutableSortedSet_TSource]:
        """
        Returns an immutable copy of the current contents of the builder's collection.
        
        :param builder: The builder to create the immutable set from.
        :returns: An immutable set.
        """
        ...

    def TryGetValue(self, equalValue: System_Collections_Immutable_ImmutableSortedSet_T, actualValue: typing.Optional[System_Collections_Immutable_ImmutableSortedSet_T]) -> typing.Union[bool, System_Collections_Immutable_ImmutableSortedSet_T]:
        """
        Searches the set for a given value and returns the equal value it finds, if any.
        
        :param equalValue: The value to search for.
        :param actualValue: The value from the set that the search found, or the original value if the search yielded no match.
        :returns: A value indicating whether the search was successful.
        """
        ...

    @overload
    def Union(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    @overload
    def Union(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> System.Collections.Immutable.IImmutableSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...

    def UnionWith(self, other: System.Collections.Generic.IEnumerable[System_Collections_Immutable_ImmutableSortedSet_T]) -> None:
        """See ISet{T}"""
        ...

    def WithComparer(self, comparer: System.Collections.Generic.IComparer[System_Collections_Immutable_ImmutableSortedSet_T]) -> System.Collections.Immutable.ImmutableSortedSet[System_Collections_Immutable_ImmutableSortedSet_T]:
        """See the IImmutableSet{T} interface."""
        ...


