# mypy-boto3-ec2

[![PyPI - mypy-boto3-ec2](https://img.shields.io/pypi/v/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.EC2 1.15.4](https://boto3.amazonaws.com/v1/documentation/api/1.15.4/reference/services/ec2.html#EC2) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-ec2](#mypy-boto3-ec2)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `EC2` service.

```bash
python -m pip install boto3-stubs[ec2]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ec2]` in your environment: `python -m pip install 'boto3-stubs[ec2]'`

Both type checking and auto-complete should work for `EC2` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[ec2]` in your environment: `python -m pip install 'boto3-stubs[ec2]'`

Both type checking and auto-complete should work for `EC2` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ec2]` in your environment: `python -m pip install 'boto3-stubs[ec2]'`
- Run `mypy` as usual

Type checking should work for `EC2` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ec2]` in your environment: `python -m pip install 'boto3-stubs[ec2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `EC2` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`EC2Client` provides annotations for `boto3.client("ec2")`.

```python
import boto3

from mypy_boto3_ec2 import EC2Client

client: EC2Client = boto3.client("ec2")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: EC2Client = session.client("ec2")
```

### Paginators annotations

`mypy_boto3_ec2.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ec2 import EC2Client
from mypy_boto3_ec2.paginator import (
    DescribeByoipCidrsPaginator,
    DescribeCapacityReservationsPaginator,
    DescribeCarrierGatewaysPaginator,
    DescribeClassicLinkInstancesPaginator,
    DescribeClientVpnAuthorizationRulesPaginator,
    DescribeClientVpnConnectionsPaginator,
    DescribeClientVpnEndpointsPaginator,
    DescribeClientVpnRoutesPaginator,
    DescribeClientVpnTargetNetworksPaginator,
    DescribeCoipPoolsPaginator,
    DescribeDhcpOptionsPaginator,
    DescribeEgressOnlyInternetGatewaysPaginator,
    DescribeExportImageTasksPaginator,
    DescribeFastSnapshotRestoresPaginator,
    DescribeFleetsPaginator,
    DescribeFlowLogsPaginator,
    DescribeFpgaImagesPaginator,
    DescribeHostReservationOfferingsPaginator,
    DescribeHostReservationsPaginator,
    DescribeHostsPaginator,
    DescribeIamInstanceProfileAssociationsPaginator,
    DescribeImportImageTasksPaginator,
    DescribeImportSnapshotTasksPaginator,
    DescribeInstanceCreditSpecificationsPaginator,
    DescribeInstancesPaginator,
    DescribeInstanceStatusPaginator,
    DescribeInstanceTypeOfferingsPaginator,
    DescribeInstanceTypesPaginator,
    DescribeInternetGatewaysPaginator,
    DescribeIpv6PoolsPaginator,
    DescribeLaunchTemplatesPaginator,
    DescribeLaunchTemplateVersionsPaginator,
    DescribeLocalGatewayRouteTablesPaginator,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator,
    DescribeLocalGatewayRouteTableVpcAssociationsPaginator,
    DescribeLocalGatewaysPaginator,
    DescribeLocalGatewayVirtualInterfaceGroupsPaginator,
    DescribeLocalGatewayVirtualInterfacesPaginator,
    DescribeManagedPrefixListsPaginator,
    DescribeMovingAddressesPaginator,
    DescribeNatGatewaysPaginator,
    DescribeNetworkAclsPaginator,
    DescribeNetworkInterfacePermissionsPaginator,
    DescribeNetworkInterfacesPaginator,
    DescribePrefixListsPaginator,
    DescribePrincipalIdFormatPaginator,
    DescribePublicIpv4PoolsPaginator,
    DescribeReservedInstancesModificationsPaginator,
    DescribeReservedInstancesOfferingsPaginator,
    DescribeRouteTablesPaginator,
    DescribeScheduledInstanceAvailabilityPaginator,
    DescribeScheduledInstancesPaginator,
    DescribeSecurityGroupsPaginator,
    DescribeSnapshotsPaginator,
    DescribeSpotFleetInstancesPaginator,
    DescribeSpotFleetRequestsPaginator,
    DescribeSpotInstanceRequestsPaginator,
    DescribeSpotPriceHistoryPaginator,
    DescribeStaleSecurityGroupsPaginator,
    DescribeSubnetsPaginator,
    DescribeTagsPaginator,
    DescribeTrafficMirrorFiltersPaginator,
    DescribeTrafficMirrorSessionsPaginator,
    DescribeTrafficMirrorTargetsPaginator,
    DescribeTransitGatewayAttachmentsPaginator,
    DescribeTransitGatewayMulticastDomainsPaginator,
    DescribeTransitGatewayPeeringAttachmentsPaginator,
    DescribeTransitGatewayRouteTablesPaginator,
    DescribeTransitGatewaysPaginator,
    DescribeTransitGatewayVpcAttachmentsPaginator,
    DescribeVolumesModificationsPaginator,
    DescribeVolumesPaginator,
    DescribeVolumeStatusPaginator,
    DescribeVpcClassicLinkDnsSupportPaginator,
    DescribeVpcEndpointConnectionNotificationsPaginator,
    DescribeVpcEndpointConnectionsPaginator,
    DescribeVpcEndpointServiceConfigurationsPaginator,
    DescribeVpcEndpointServicePermissionsPaginator,
    DescribeVpcEndpointServicesPaginator,
    DescribeVpcEndpointsPaginator,
    DescribeVpcPeeringConnectionsPaginator,
    DescribeVpcsPaginator,
    GetAssociatedIpv6PoolCidrsPaginator,
    GetGroupsForCapacityReservationPaginator,
    GetManagedPrefixListAssociationsPaginator,
    GetManagedPrefixListEntriesPaginator,
    GetTransitGatewayAttachmentPropagationsPaginator,
    GetTransitGatewayMulticastDomainAssociationsPaginator,
    GetTransitGatewayPrefixListReferencesPaginator,
    GetTransitGatewayRouteTableAssociationsPaginator,
    GetTransitGatewayRouteTablePropagationsPaginator,
    SearchLocalGatewayRoutesPaginator,
    SearchTransitGatewayMulticastGroupsPaginator,
)

client: EC2Client = boto3.client("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_byoip_cidrs_paginator: DescribeByoipCidrsPaginator = client.get_paginator("describe_byoip_cidrs")
describe_capacity_reservations_paginator: DescribeCapacityReservationsPaginator = client.get_paginator("describe_capacity_reservations")
describe_carrier_gateways_paginator: DescribeCarrierGatewaysPaginator = client.get_paginator("describe_carrier_gateways")
describe_classic_link_instances_paginator: DescribeClassicLinkInstancesPaginator = client.get_paginator("describe_classic_link_instances")
describe_client_vpn_authorization_rules_paginator: DescribeClientVpnAuthorizationRulesPaginator = client.get_paginator("describe_client_vpn_authorization_rules")
describe_client_vpn_connections_paginator: DescribeClientVpnConnectionsPaginator = client.get_paginator("describe_client_vpn_connections")
describe_client_vpn_endpoints_paginator: DescribeClientVpnEndpointsPaginator = client.get_paginator("describe_client_vpn_endpoints")
describe_client_vpn_routes_paginator: DescribeClientVpnRoutesPaginator = client.get_paginator("describe_client_vpn_routes")
describe_client_vpn_target_networks_paginator: DescribeClientVpnTargetNetworksPaginator = client.get_paginator("describe_client_vpn_target_networks")
describe_coip_pools_paginator: DescribeCoipPoolsPaginator = client.get_paginator("describe_coip_pools")
describe_dhcp_options_paginator: DescribeDhcpOptionsPaginator = client.get_paginator("describe_dhcp_options")
describe_egress_only_internet_gateways_paginator: DescribeEgressOnlyInternetGatewaysPaginator = client.get_paginator("describe_egress_only_internet_gateways")
describe_export_image_tasks_paginator: DescribeExportImageTasksPaginator = client.get_paginator("describe_export_image_tasks")
describe_fast_snapshot_restores_paginator: DescribeFastSnapshotRestoresPaginator = client.get_paginator("describe_fast_snapshot_restores")
describe_fleets_paginator: DescribeFleetsPaginator = client.get_paginator("describe_fleets")
describe_flow_logs_paginator: DescribeFlowLogsPaginator = client.get_paginator("describe_flow_logs")
describe_fpga_images_paginator: DescribeFpgaImagesPaginator = client.get_paginator("describe_fpga_images")
describe_host_reservation_offerings_paginator: DescribeHostReservationOfferingsPaginator = client.get_paginator("describe_host_reservation_offerings")
describe_host_reservations_paginator: DescribeHostReservationsPaginator = client.get_paginator("describe_host_reservations")
describe_hosts_paginator: DescribeHostsPaginator = client.get_paginator("describe_hosts")
describe_iam_instance_profile_associations_paginator: DescribeIamInstanceProfileAssociationsPaginator = client.get_paginator("describe_iam_instance_profile_associations")
describe_import_image_tasks_paginator: DescribeImportImageTasksPaginator = client.get_paginator("describe_import_image_tasks")
describe_import_snapshot_tasks_paginator: DescribeImportSnapshotTasksPaginator = client.get_paginator("describe_import_snapshot_tasks")
describe_instance_credit_specifications_paginator: DescribeInstanceCreditSpecificationsPaginator = client.get_paginator("describe_instance_credit_specifications")
describe_instance_status_paginator: DescribeInstanceStatusPaginator = client.get_paginator("describe_instance_status")
describe_instance_type_offerings_paginator: DescribeInstanceTypeOfferingsPaginator = client.get_paginator("describe_instance_type_offerings")
describe_instance_types_paginator: DescribeInstanceTypesPaginator = client.get_paginator("describe_instance_types")
describe_instances_paginator: DescribeInstancesPaginator = client.get_paginator("describe_instances")
describe_internet_gateways_paginator: DescribeInternetGatewaysPaginator = client.get_paginator("describe_internet_gateways")
describe_ipv6_pools_paginator: DescribeIpv6PoolsPaginator = client.get_paginator("describe_ipv6_pools")
describe_launch_template_versions_paginator: DescribeLaunchTemplateVersionsPaginator = client.get_paginator("describe_launch_template_versions")
describe_launch_templates_paginator: DescribeLaunchTemplatesPaginator = client.get_paginator("describe_launch_templates")
describe_local_gateway_route_table_virtual_interface_group_associations_paginator: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_virtual_interface_group_associations")
describe_local_gateway_route_table_vpc_associations_paginator: DescribeLocalGatewayRouteTableVpcAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_vpc_associations")
describe_local_gateway_route_tables_paginator: DescribeLocalGatewayRouteTablesPaginator = client.get_paginator("describe_local_gateway_route_tables")
describe_local_gateway_virtual_interface_groups_paginator: DescribeLocalGatewayVirtualInterfaceGroupsPaginator = client.get_paginator("describe_local_gateway_virtual_interface_groups")
describe_local_gateway_virtual_interfaces_paginator: DescribeLocalGatewayVirtualInterfacesPaginator = client.get_paginator("describe_local_gateway_virtual_interfaces")
describe_local_gateways_paginator: DescribeLocalGatewaysPaginator = client.get_paginator("describe_local_gateways")
describe_managed_prefix_lists_paginator: DescribeManagedPrefixListsPaginator = client.get_paginator("describe_managed_prefix_lists")
describe_moving_addresses_paginator: DescribeMovingAddressesPaginator = client.get_paginator("describe_moving_addresses")
describe_nat_gateways_paginator: DescribeNatGatewaysPaginator = client.get_paginator("describe_nat_gateways")
describe_network_acls_paginator: DescribeNetworkAclsPaginator = client.get_paginator("describe_network_acls")
describe_network_interface_permissions_paginator: DescribeNetworkInterfacePermissionsPaginator = client.get_paginator("describe_network_interface_permissions")
describe_network_interfaces_paginator: DescribeNetworkInterfacesPaginator = client.get_paginator("describe_network_interfaces")
describe_prefix_lists_paginator: DescribePrefixListsPaginator = client.get_paginator("describe_prefix_lists")
describe_principal_id_format_paginator: DescribePrincipalIdFormatPaginator = client.get_paginator("describe_principal_id_format")
describe_public_ipv4_pools_paginator: DescribePublicIpv4PoolsPaginator = client.get_paginator("describe_public_ipv4_pools")
describe_reserved_instances_modifications_paginator: DescribeReservedInstancesModificationsPaginator = client.get_paginator("describe_reserved_instances_modifications")
describe_reserved_instances_offerings_paginator: DescribeReservedInstancesOfferingsPaginator = client.get_paginator("describe_reserved_instances_offerings")
describe_route_tables_paginator: DescribeRouteTablesPaginator = client.get_paginator("describe_route_tables")
describe_scheduled_instance_availability_paginator: DescribeScheduledInstanceAvailabilityPaginator = client.get_paginator("describe_scheduled_instance_availability")
describe_scheduled_instances_paginator: DescribeScheduledInstancesPaginator = client.get_paginator("describe_scheduled_instances")
describe_security_groups_paginator: DescribeSecurityGroupsPaginator = client.get_paginator("describe_security_groups")
describe_snapshots_paginator: DescribeSnapshotsPaginator = client.get_paginator("describe_snapshots")
describe_spot_fleet_instances_paginator: DescribeSpotFleetInstancesPaginator = client.get_paginator("describe_spot_fleet_instances")
describe_spot_fleet_requests_paginator: DescribeSpotFleetRequestsPaginator = client.get_paginator("describe_spot_fleet_requests")
describe_spot_instance_requests_paginator: DescribeSpotInstanceRequestsPaginator = client.get_paginator("describe_spot_instance_requests")
describe_spot_price_history_paginator: DescribeSpotPriceHistoryPaginator = client.get_paginator("describe_spot_price_history")
describe_stale_security_groups_paginator: DescribeStaleSecurityGroupsPaginator = client.get_paginator("describe_stale_security_groups")
describe_subnets_paginator: DescribeSubnetsPaginator = client.get_paginator("describe_subnets")
describe_tags_paginator: DescribeTagsPaginator = client.get_paginator("describe_tags")
describe_traffic_mirror_filters_paginator: DescribeTrafficMirrorFiltersPaginator = client.get_paginator("describe_traffic_mirror_filters")
describe_traffic_mirror_sessions_paginator: DescribeTrafficMirrorSessionsPaginator = client.get_paginator("describe_traffic_mirror_sessions")
describe_traffic_mirror_targets_paginator: DescribeTrafficMirrorTargetsPaginator = client.get_paginator("describe_traffic_mirror_targets")
describe_transit_gateway_attachments_paginator: DescribeTransitGatewayAttachmentsPaginator = client.get_paginator("describe_transit_gateway_attachments")
describe_transit_gateway_multicast_domains_paginator: DescribeTransitGatewayMulticastDomainsPaginator = client.get_paginator("describe_transit_gateway_multicast_domains")
describe_transit_gateway_peering_attachments_paginator: DescribeTransitGatewayPeeringAttachmentsPaginator = client.get_paginator("describe_transit_gateway_peering_attachments")
describe_transit_gateway_route_tables_paginator: DescribeTransitGatewayRouteTablesPaginator = client.get_paginator("describe_transit_gateway_route_tables")
describe_transit_gateway_vpc_attachments_paginator: DescribeTransitGatewayVpcAttachmentsPaginator = client.get_paginator("describe_transit_gateway_vpc_attachments")
describe_transit_gateways_paginator: DescribeTransitGatewaysPaginator = client.get_paginator("describe_transit_gateways")
describe_volume_status_paginator: DescribeVolumeStatusPaginator = client.get_paginator("describe_volume_status")
describe_volumes_paginator: DescribeVolumesPaginator = client.get_paginator("describe_volumes")
describe_volumes_modifications_paginator: DescribeVolumesModificationsPaginator = client.get_paginator("describe_volumes_modifications")
describe_vpc_classic_link_dns_support_paginator: DescribeVpcClassicLinkDnsSupportPaginator = client.get_paginator("describe_vpc_classic_link_dns_support")
describe_vpc_endpoint_connection_notifications_paginator: DescribeVpcEndpointConnectionNotificationsPaginator = client.get_paginator("describe_vpc_endpoint_connection_notifications")
describe_vpc_endpoint_connections_paginator: DescribeVpcEndpointConnectionsPaginator = client.get_paginator("describe_vpc_endpoint_connections")
describe_vpc_endpoint_service_configurations_paginator: DescribeVpcEndpointServiceConfigurationsPaginator = client.get_paginator("describe_vpc_endpoint_service_configurations")
describe_vpc_endpoint_service_permissions_paginator: DescribeVpcEndpointServicePermissionsPaginator = client.get_paginator("describe_vpc_endpoint_service_permissions")
describe_vpc_endpoint_services_paginator: DescribeVpcEndpointServicesPaginator = client.get_paginator("describe_vpc_endpoint_services")
describe_vpc_endpoints_paginator: DescribeVpcEndpointsPaginator = client.get_paginator("describe_vpc_endpoints")
describe_vpc_peering_connections_paginator: DescribeVpcPeeringConnectionsPaginator = client.get_paginator("describe_vpc_peering_connections")
describe_vpcs_paginator: DescribeVpcsPaginator = client.get_paginator("describe_vpcs")
get_associated_ipv6_pool_cidrs_paginator: GetAssociatedIpv6PoolCidrsPaginator = client.get_paginator("get_associated_ipv6_pool_cidrs")
get_groups_for_capacity_reservation_paginator: GetGroupsForCapacityReservationPaginator = client.get_paginator("get_groups_for_capacity_reservation")
get_managed_prefix_list_associations_paginator: GetManagedPrefixListAssociationsPaginator = client.get_paginator("get_managed_prefix_list_associations")
get_managed_prefix_list_entries_paginator: GetManagedPrefixListEntriesPaginator = client.get_paginator("get_managed_prefix_list_entries")
get_transit_gateway_attachment_propagations_paginator: GetTransitGatewayAttachmentPropagationsPaginator = client.get_paginator("get_transit_gateway_attachment_propagations")
get_transit_gateway_multicast_domain_associations_paginator: GetTransitGatewayMulticastDomainAssociationsPaginator = client.get_paginator("get_transit_gateway_multicast_domain_associations")
get_transit_gateway_prefix_list_references_paginator: GetTransitGatewayPrefixListReferencesPaginator = client.get_paginator("get_transit_gateway_prefix_list_references")
get_transit_gateway_route_table_associations_paginator: GetTransitGatewayRouteTableAssociationsPaginator = client.get_paginator("get_transit_gateway_route_table_associations")
get_transit_gateway_route_table_propagations_paginator: GetTransitGatewayRouteTablePropagationsPaginator = client.get_paginator("get_transit_gateway_route_table_propagations")
search_local_gateway_routes_paginator: SearchLocalGatewayRoutesPaginator = client.get_paginator("search_local_gateway_routes")
search_transit_gateway_multicast_groups_paginator: SearchTransitGatewayMulticastGroupsPaginator = client.get_paginator("search_transit_gateway_multicast_groups")
```


### Waiters annotations

`mypy_boto3_ec2.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_ec2 import EC2Client
from mypy_boto3_ec2.waiter import (
    BundleTaskCompleteWaiter,
    ConversionTaskCancelledWaiter,
    ConversionTaskCompletedWaiter,
    ConversionTaskDeletedWaiter,
    CustomerGatewayAvailableWaiter,
    ExportTaskCancelledWaiter,
    ExportTaskCompletedWaiter,
    ImageAvailableWaiter,
    ImageExistsWaiter,
    InstanceExistsWaiter,
    InstanceRunningWaiter,
    InstanceStatusOkWaiter,
    InstanceStoppedWaiter,
    InstanceTerminatedWaiter,
    KeyPairExistsWaiter,
    NatGatewayAvailableWaiter,
    NetworkInterfaceAvailableWaiter,
    PasswordDataAvailableWaiter,
    SecurityGroupExistsWaiter,
    SnapshotCompletedWaiter,
    SpotInstanceRequestFulfilledWaiter,
    SubnetAvailableWaiter,
    SystemStatusOkWaiter,
    VolumeAvailableWaiter,
    VolumeDeletedWaiter,
    VolumeInUseWaiter,
    VpcAvailableWaiter,
    VpcExistsWaiter,
    VpcPeeringConnectionDeletedWaiter,
    VpcPeeringConnectionExistsWaiter,
    VpnConnectionAvailableWaiter,
    VpnConnectionDeletedWaiter,
)

client: EC2Client = boto3.client("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
bundle_task_complete_waiter: BundleTaskCompleteWaiter = client.get_waiter("bundle_task_complete")
conversion_task_cancelled_waiter: ConversionTaskCancelledWaiter = client.get_waiter("conversion_task_cancelled")
conversion_task_completed_waiter: ConversionTaskCompletedWaiter = client.get_waiter("conversion_task_completed")
conversion_task_deleted_waiter: ConversionTaskDeletedWaiter = client.get_waiter("conversion_task_deleted")
customer_gateway_available_waiter: CustomerGatewayAvailableWaiter = client.get_waiter("customer_gateway_available")
export_task_cancelled_waiter: ExportTaskCancelledWaiter = client.get_waiter("export_task_cancelled")
export_task_completed_waiter: ExportTaskCompletedWaiter = client.get_waiter("export_task_completed")
image_available_waiter: ImageAvailableWaiter = client.get_waiter("image_available")
image_exists_waiter: ImageExistsWaiter = client.get_waiter("image_exists")
instance_exists_waiter: InstanceExistsWaiter = client.get_waiter("instance_exists")
instance_running_waiter: InstanceRunningWaiter = client.get_waiter("instance_running")
instance_status_ok_waiter: InstanceStatusOkWaiter = client.get_waiter("instance_status_ok")
instance_stopped_waiter: InstanceStoppedWaiter = client.get_waiter("instance_stopped")
instance_terminated_waiter: InstanceTerminatedWaiter = client.get_waiter("instance_terminated")
key_pair_exists_waiter: KeyPairExistsWaiter = client.get_waiter("key_pair_exists")
nat_gateway_available_waiter: NatGatewayAvailableWaiter = client.get_waiter("nat_gateway_available")
network_interface_available_waiter: NetworkInterfaceAvailableWaiter = client.get_waiter("network_interface_available")
password_data_available_waiter: PasswordDataAvailableWaiter = client.get_waiter("password_data_available")
security_group_exists_waiter: SecurityGroupExistsWaiter = client.get_waiter("security_group_exists")
snapshot_completed_waiter: SnapshotCompletedWaiter = client.get_waiter("snapshot_completed")
spot_instance_request_fulfilled_waiter: SpotInstanceRequestFulfilledWaiter = client.get_waiter("spot_instance_request_fulfilled")
subnet_available_waiter: SubnetAvailableWaiter = client.get_waiter("subnet_available")
system_status_ok_waiter: SystemStatusOkWaiter = client.get_waiter("system_status_ok")
volume_available_waiter: VolumeAvailableWaiter = client.get_waiter("volume_available")
volume_deleted_waiter: VolumeDeletedWaiter = client.get_waiter("volume_deleted")
volume_in_use_waiter: VolumeInUseWaiter = client.get_waiter("volume_in_use")
vpc_available_waiter: VpcAvailableWaiter = client.get_waiter("vpc_available")
vpc_exists_waiter: VpcExistsWaiter = client.get_waiter("vpc_exists")
vpc_peering_connection_deleted_waiter: VpcPeeringConnectionDeletedWaiter = client.get_waiter("vpc_peering_connection_deleted")
vpc_peering_connection_exists_waiter: VpcPeeringConnectionExistsWaiter = client.get_waiter("vpc_peering_connection_exists")
vpn_connection_available_waiter: VpnConnectionAvailableWaiter = client.get_waiter("vpn_connection_available")
vpn_connection_deleted_waiter: VpnConnectionDeletedWaiter = client.get_waiter("vpn_connection_deleted")
```


### Service Resource annotations

`EC2ServiceResource` provides annotations for `boto3.resource("ec2")`.

```python
from mypy_boto3_ec2 import EC2ServiceResource

resource: EC2ServiceResource = boto3.resource("ec2")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: EC2ServiceResource = session.resource("ec2")
```


### Other resources annotations

`mypy_boto3_ec2.service_resource` module contains type annotations for all resources.

```python
from mypy_boto3_ec2 import EC2ServiceResource
from mypy_boto3_ec2.service_resource import (
    ClassicAddress,
    DhcpOptions,
    Image,
    Instance,
    InternetGateway,
    KeyPair,
    KeyPairInfo,
    NetworkAcl,
    NetworkInterface,
    NetworkInterfaceAssociation,
    PlacementGroup,
    Route,
    RouteTable,
    RouteTableAssociation,
    SecurityGroup,
    Snapshot,
    Subnet,
    Tag,
    Volume,
    Vpc,
    VpcAddress,
    VpcPeeringConnection,
)

resource: EC2ServiceResource = boto3.resource("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_classic_address: ClassicAddress = resource.ClassicAddress(...)
my_dhcp_options: DhcpOptions = resource.DhcpOptions(...)
my_image: Image = resource.Image(...)
my_instance: Instance = resource.Instance(...)
my_internet_gateway: InternetGateway = resource.InternetGateway(...)
my_key_pair: KeyPair = resource.KeyPair(...)
my_key_pair_info: KeyPairInfo = resource.KeyPairInfo(...)
my_network_acl: NetworkAcl = resource.NetworkAcl(...)
my_network_interface: NetworkInterface = resource.NetworkInterface(...)
my_network_interface_association: NetworkInterfaceAssociation = resource.NetworkInterfaceAssociation(...)
my_placement_group: PlacementGroup = resource.PlacementGroup(...)
my_route: Route = resource.Route(...)
my_route_table: RouteTable = resource.RouteTable(...)
my_route_table_association: RouteTableAssociation = resource.RouteTableAssociation(...)
my_security_group: SecurityGroup = resource.SecurityGroup(...)
my_snapshot: Snapshot = resource.Snapshot(...)
my_subnet: Subnet = resource.Subnet(...)
my_tag: Tag = resource.Tag(...)
my_volume: Volume = resource.Volume(...)
my_vpc: Vpc = resource.Vpc(...)
my_vpc_peering_connection: VpcPeeringConnection = resource.VpcPeeringConnection(...)
my_vpc_address: VpcAddress = resource.VpcAddress(...)
```



### Collections annotations

`mypy_boto3_ec2.service_resource` module contains type annotations
for all `EC2ServiceResource` collections.

```python
from mypy_boto3_ec2 import EC2ServiceResource
from mypy_boto3_ec2.service_resource import (
    ServiceResourceClassicAddressesCollection,
    ServiceResourceDhcpOptionsSetsCollection,
    ServiceResourceImagesCollection,
    ServiceResourceInstancesCollection,
    ServiceResourceInternetGatewaysCollection,
    ServiceResourceKeyPairsCollection,
    ServiceResourceNetworkAclsCollection,
    ServiceResourceNetworkInterfacesCollection,
    ServiceResourcePlacementGroupsCollection,
    ServiceResourceRouteTablesCollection,
    ServiceResourceSecurityGroupsCollection,
    ServiceResourceSnapshotsCollection,
    ServiceResourceSubnetsCollection,
    ServiceResourceVolumesCollection,
    ServiceResourceVpcAddressesCollection,
    ServiceResourceVpcPeeringConnectionsCollection,
    ServiceResourceVpcsCollection,
)

resource: EC2ServiceResource = boto3.resource("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
classic_addresses: ec2_resources.ServiceResourceClassicAddressesCollection = resource.classic_addresses
dhcp_options_sets: ec2_resources.ServiceResourceDhcpOptionsSetsCollection = resource.dhcp_options_sets
images: ec2_resources.ServiceResourceImagesCollection = resource.images
instances: ec2_resources.ServiceResourceInstancesCollection = resource.instances
internet_gateways: ec2_resources.ServiceResourceInternetGatewaysCollection = resource.internet_gateways
key_pairs: ec2_resources.ServiceResourceKeyPairsCollection = resource.key_pairs
network_acls: ec2_resources.ServiceResourceNetworkAclsCollection = resource.network_acls
network_interfaces: ec2_resources.ServiceResourceNetworkInterfacesCollection = resource.network_interfaces
placement_groups: ec2_resources.ServiceResourcePlacementGroupsCollection = resource.placement_groups
route_tables: ec2_resources.ServiceResourceRouteTablesCollection = resource.route_tables
security_groups: ec2_resources.ServiceResourceSecurityGroupsCollection = resource.security_groups
snapshots: ec2_resources.ServiceResourceSnapshotsCollection = resource.snapshots
subnets: ec2_resources.ServiceResourceSubnetsCollection = resource.subnets
volumes: ec2_resources.ServiceResourceVolumesCollection = resource.volumes
vpc_addresses: ec2_resources.ServiceResourceVpcAddressesCollection = resource.vpc_addresses
vpc_peering_connections: ec2_resources.ServiceResourceVpcPeeringConnectionsCollection = resource.vpc_peering_connections
vpcs: ec2_resources.ServiceResourceVpcsCollection = resource.vpcs
```




### Typed dictionations

`mypy_boto3_ec2.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_ec2.type_defs import (
    AcceptReservedInstancesExchangeQuoteResultTypeDef,
    AcceptTransitGatewayPeeringAttachmentResultTypeDef,
    AcceptTransitGatewayVpcAttachmentResultTypeDef,
    AcceptVpcEndpointConnectionsResultTypeDef,
    AcceptVpcPeeringConnectionResultTypeDef,
    AccountAttributeTypeDef,
    AccountAttributeValueTypeDef,
    ActiveInstanceTypeDef,
    AddPrefixListEntryTypeDef,
    AddressTypeDef,
    AdvertiseByoipCidrResultTypeDef,
    AllocateAddressResultTypeDef,
    AllocateHostsResultTypeDef,
    AllowedPrincipalTypeDef,
    ApplySecurityGroupsToClientVpnTargetNetworkResultTypeDef,
    AssignedPrivateIpAddressTypeDef,
    AssignIpv6AddressesResultTypeDef,
    AssignPrivateIpAddressesResultTypeDef,
    AssociateAddressResultTypeDef,
    AssociateClientVpnTargetNetworkResultTypeDef,
    AssociatedTargetNetworkTypeDef,
    AssociateIamInstanceProfileResultTypeDef,
    AssociateRouteTableResultTypeDef,
    AssociateSubnetCidrBlockResultTypeDef,
    AssociateTransitGatewayMulticastDomainResultTypeDef,
    AssociateTransitGatewayRouteTableResultTypeDef,
    AssociateVpcCidrBlockResultTypeDef,
    AssociationStatusTypeDef,
    AttachClassicLinkVpcResultTypeDef,
    AttachNetworkInterfaceResultTypeDef,
    AttachVpnGatewayResultTypeDef,
    AttributeBooleanValueTypeDef,
    AttributeValueTypeDef,
    AuthorizationRuleTypeDef,
    AuthorizeClientVpnIngressResultTypeDef,
    AvailabilityZoneMessageTypeDef,
    AvailabilityZoneTypeDef,
    AvailableCapacityTypeDef,
    BlobAttributeValueTypeDef,
    BlockDeviceMappingTypeDef,
    BundleInstanceResultTypeDef,
    BundleTaskErrorTypeDef,
    BundleTaskTypeDef,
    ByoipCidrTypeDef,
    CancelBundleTaskResultTypeDef,
    CancelCapacityReservationResultTypeDef,
    CancelImportTaskResultTypeDef,
    CancelledSpotInstanceRequestTypeDef,
    CancelReservedInstancesListingResultTypeDef,
    CancelSpotFleetRequestsErrorItemTypeDef,
    CancelSpotFleetRequestsErrorTypeDef,
    CancelSpotFleetRequestsResponseTypeDef,
    CancelSpotFleetRequestsSuccessItemTypeDef,
    CancelSpotInstanceRequestsResultTypeDef,
    CapacityReservationGroupTypeDef,
    CapacityReservationOptionsRequestTypeDef,
    CapacityReservationOptionsTypeDef,
    CapacityReservationSpecificationResponseTypeDef,
    CapacityReservationSpecificationTypeDef,
    CapacityReservationTargetResponseTypeDef,
    CapacityReservationTargetTypeDef,
    CapacityReservationTypeDef,
    CarrierGatewayTypeDef,
    CertificateAuthenticationRequestTypeDef,
    CertificateAuthenticationTypeDef,
    CidrAuthorizationContextTypeDef,
    CidrBlockTypeDef,
    ClassicLinkDnsSupportTypeDef,
    ClassicLinkInstanceTypeDef,
    ClassicLoadBalancersConfigTypeDef,
    ClassicLoadBalancerTypeDef,
    ClientCertificateRevocationListStatusTypeDef,
    ClientDataTypeDef,
    ClientVpnAuthenticationRequestTypeDef,
    ClientVpnAuthenticationTypeDef,
    ClientVpnAuthorizationRuleStatusTypeDef,
    ClientVpnConnectionStatusTypeDef,
    ClientVpnConnectionTypeDef,
    ClientVpnEndpointStatusTypeDef,
    ClientVpnEndpointTypeDef,
    ClientVpnRouteStatusTypeDef,
    ClientVpnRouteTypeDef,
    CoipAddressUsageTypeDef,
    CoipPoolTypeDef,
    ConfirmProductInstanceResultTypeDef,
    ConnectionLogOptionsTypeDef,
    ConnectionLogResponseOptionsTypeDef,
    ConnectionNotificationTypeDef,
    ConversionTaskTypeDef,
    CopyFpgaImageResultTypeDef,
    CopyImageResultTypeDef,
    CopySnapshotResultTypeDef,
    CpuOptionsRequestTypeDef,
    CpuOptionsTypeDef,
    CreateCapacityReservationResultTypeDef,
    CreateCarrierGatewayResultTypeDef,
    CreateClientVpnEndpointResultTypeDef,
    CreateClientVpnRouteResultTypeDef,
    CreateCustomerGatewayResultTypeDef,
    CreateDefaultSubnetResultTypeDef,
    CreateDefaultVpcResultTypeDef,
    CreateDhcpOptionsResultTypeDef,
    CreateEgressOnlyInternetGatewayResultTypeDef,
    CreateFleetErrorTypeDef,
    CreateFleetInstanceTypeDef,
    CreateFleetResultTypeDef,
    CreateFlowLogsResultTypeDef,
    CreateFpgaImageResultTypeDef,
    CreateImageResultTypeDef,
    CreateInstanceExportTaskResultTypeDef,
    CreateInternetGatewayResultTypeDef,
    CreateLaunchTemplateResultTypeDef,
    CreateLaunchTemplateVersionResultTypeDef,
    CreateLocalGatewayRouteResultTypeDef,
    CreateLocalGatewayRouteTableVpcAssociationResultTypeDef,
    CreateManagedPrefixListResultTypeDef,
    CreateNatGatewayResultTypeDef,
    CreateNetworkAclResultTypeDef,
    CreateNetworkInterfacePermissionResultTypeDef,
    CreateNetworkInterfaceResultTypeDef,
    CreatePlacementGroupResultTypeDef,
    CreateReservedInstancesListingResultTypeDef,
    CreateRouteResultTypeDef,
    CreateRouteTableResultTypeDef,
    CreateSecurityGroupResultTypeDef,
    CreateSnapshotsResultTypeDef,
    CreateSpotDatafeedSubscriptionResultTypeDef,
    CreateSubnetResultTypeDef,
    CreateTrafficMirrorFilterResultTypeDef,
    CreateTrafficMirrorFilterRuleResultTypeDef,
    CreateTrafficMirrorSessionResultTypeDef,
    CreateTrafficMirrorTargetResultTypeDef,
    CreateTransitGatewayMulticastDomainResultTypeDef,
    CreateTransitGatewayPeeringAttachmentResultTypeDef,
    CreateTransitGatewayPrefixListReferenceResultTypeDef,
    CreateTransitGatewayResultTypeDef,
    CreateTransitGatewayRouteResultTypeDef,
    CreateTransitGatewayRouteTableResultTypeDef,
    CreateTransitGatewayVpcAttachmentRequestOptionsTypeDef,
    CreateTransitGatewayVpcAttachmentResultTypeDef,
    CreateVolumePermissionModificationsTypeDef,
    CreateVolumePermissionTypeDef,
    CreateVpcEndpointConnectionNotificationResultTypeDef,
    CreateVpcEndpointResultTypeDef,
    CreateVpcEndpointServiceConfigurationResultTypeDef,
    CreateVpcPeeringConnectionResultTypeDef,
    CreateVpcResultTypeDef,
    CreateVpnConnectionResultTypeDef,
    CreateVpnGatewayResultTypeDef,
    CreditSpecificationRequestTypeDef,
    CreditSpecificationTypeDef,
    CustomerGatewayTypeDef,
    DeleteCarrierGatewayResultTypeDef,
    DeleteClientVpnEndpointResultTypeDef,
    DeleteClientVpnRouteResultTypeDef,
    DeleteEgressOnlyInternetGatewayResultTypeDef,
    DeleteFleetErrorItemTypeDef,
    DeleteFleetErrorTypeDef,
    DeleteFleetsResultTypeDef,
    DeleteFleetSuccessItemTypeDef,
    DeleteFlowLogsResultTypeDef,
    DeleteFpgaImageResultTypeDef,
    DeleteLaunchTemplateResultTypeDef,
    DeleteLaunchTemplateVersionsResponseErrorItemTypeDef,
    DeleteLaunchTemplateVersionsResponseSuccessItemTypeDef,
    DeleteLaunchTemplateVersionsResultTypeDef,
    DeleteLocalGatewayRouteResultTypeDef,
    DeleteLocalGatewayRouteTableVpcAssociationResultTypeDef,
    DeleteManagedPrefixListResultTypeDef,
    DeleteNatGatewayResultTypeDef,
    DeleteNetworkInterfacePermissionResultTypeDef,
    DeleteQueuedReservedInstancesErrorTypeDef,
    DeleteQueuedReservedInstancesResultTypeDef,
    DeleteTrafficMirrorFilterResultTypeDef,
    DeleteTrafficMirrorFilterRuleResultTypeDef,
    DeleteTrafficMirrorSessionResultTypeDef,
    DeleteTrafficMirrorTargetResultTypeDef,
    DeleteTransitGatewayMulticastDomainResultTypeDef,
    DeleteTransitGatewayPeeringAttachmentResultTypeDef,
    DeleteTransitGatewayPrefixListReferenceResultTypeDef,
    DeleteTransitGatewayResultTypeDef,
    DeleteTransitGatewayRouteResultTypeDef,
    DeleteTransitGatewayRouteTableResultTypeDef,
    DeleteTransitGatewayVpcAttachmentResultTypeDef,
    DeleteVpcEndpointConnectionNotificationsResultTypeDef,
    DeleteVpcEndpointServiceConfigurationsResultTypeDef,
    DeleteVpcEndpointsResultTypeDef,
    DeleteVpcPeeringConnectionResultTypeDef,
    DeprovisionByoipCidrResultTypeDef,
    DeregisterInstanceEventNotificationAttributesResultTypeDef,
    DeregisterInstanceTagAttributeRequestTypeDef,
    DeregisterTransitGatewayMulticastGroupMembersResultTypeDef,
    DeregisterTransitGatewayMulticastGroupSourcesResultTypeDef,
    DescribeAccountAttributesResultTypeDef,
    DescribeAddressesResultTypeDef,
    DescribeAggregateIdFormatResultTypeDef,
    DescribeAvailabilityZonesResultTypeDef,
    DescribeBundleTasksResultTypeDef,
    DescribeByoipCidrsResultTypeDef,
    DescribeCapacityReservationsResultTypeDef,
    DescribeCarrierGatewaysResultTypeDef,
    DescribeClassicLinkInstancesResultTypeDef,
    DescribeClientVpnAuthorizationRulesResultTypeDef,
    DescribeClientVpnConnectionsResultTypeDef,
    DescribeClientVpnEndpointsResultTypeDef,
    DescribeClientVpnRoutesResultTypeDef,
    DescribeClientVpnTargetNetworksResultTypeDef,
    DescribeCoipPoolsResultTypeDef,
    DescribeConversionTasksResultTypeDef,
    DescribeCustomerGatewaysResultTypeDef,
    DescribeDhcpOptionsResultTypeDef,
    DescribeEgressOnlyInternetGatewaysResultTypeDef,
    DescribeElasticGpusResultTypeDef,
    DescribeExportImageTasksResultTypeDef,
    DescribeExportTasksResultTypeDef,
    DescribeFastSnapshotRestoresResultTypeDef,
    DescribeFastSnapshotRestoreSuccessItemTypeDef,
    DescribeFleetErrorTypeDef,
    DescribeFleetHistoryResultTypeDef,
    DescribeFleetInstancesResultTypeDef,
    DescribeFleetsInstancesTypeDef,
    DescribeFleetsResultTypeDef,
    DescribeFlowLogsResultTypeDef,
    DescribeFpgaImageAttributeResultTypeDef,
    DescribeFpgaImagesResultTypeDef,
    DescribeHostReservationOfferingsResultTypeDef,
    DescribeHostReservationsResultTypeDef,
    DescribeHostsResultTypeDef,
    DescribeIamInstanceProfileAssociationsResultTypeDef,
    DescribeIdentityIdFormatResultTypeDef,
    DescribeIdFormatResultTypeDef,
    DescribeImagesResultTypeDef,
    DescribeImportImageTasksResultTypeDef,
    DescribeImportSnapshotTasksResultTypeDef,
    DescribeInstanceCreditSpecificationsResultTypeDef,
    DescribeInstanceEventNotificationAttributesResultTypeDef,
    DescribeInstancesResultTypeDef,
    DescribeInstanceStatusResultTypeDef,
    DescribeInstanceTypeOfferingsResultTypeDef,
    DescribeInstanceTypesResultTypeDef,
    DescribeInternetGatewaysResultTypeDef,
    DescribeIpv6PoolsResultTypeDef,
    DescribeKeyPairsResultTypeDef,
    DescribeLaunchTemplatesResultTypeDef,
    DescribeLaunchTemplateVersionsResultTypeDef,
    DescribeLocalGatewayRouteTablesResultTypeDef,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResultTypeDef,
    DescribeLocalGatewayRouteTableVpcAssociationsResultTypeDef,
    DescribeLocalGatewaysResultTypeDef,
    DescribeLocalGatewayVirtualInterfaceGroupsResultTypeDef,
    DescribeLocalGatewayVirtualInterfacesResultTypeDef,
    DescribeManagedPrefixListsResultTypeDef,
    DescribeMovingAddressesResultTypeDef,
    DescribeNatGatewaysResultTypeDef,
    DescribeNetworkAclsResultTypeDef,
    DescribeNetworkInterfaceAttributeResultTypeDef,
    DescribeNetworkInterfacePermissionsResultTypeDef,
    DescribeNetworkInterfacesResultTypeDef,
    DescribePlacementGroupsResultTypeDef,
    DescribePrefixListsResultTypeDef,
    DescribePrincipalIdFormatResultTypeDef,
    DescribePublicIpv4PoolsResultTypeDef,
    DescribeRegionsResultTypeDef,
    DescribeReservedInstancesListingsResultTypeDef,
    DescribeReservedInstancesModificationsResultTypeDef,
    DescribeReservedInstancesOfferingsResultTypeDef,
    DescribeReservedInstancesResultTypeDef,
    DescribeRouteTablesResultTypeDef,
    DescribeScheduledInstanceAvailabilityResultTypeDef,
    DescribeScheduledInstancesResultTypeDef,
    DescribeSecurityGroupReferencesResultTypeDef,
    DescribeSecurityGroupsResultTypeDef,
    DescribeSnapshotAttributeResultTypeDef,
    DescribeSnapshotsResultTypeDef,
    DescribeSpotDatafeedSubscriptionResultTypeDef,
    DescribeSpotFleetInstancesResponseTypeDef,
    DescribeSpotFleetRequestHistoryResponseTypeDef,
    DescribeSpotFleetRequestsResponseTypeDef,
    DescribeSpotInstanceRequestsResultTypeDef,
    DescribeSpotPriceHistoryResultTypeDef,
    DescribeStaleSecurityGroupsResultTypeDef,
    DescribeSubnetsResultTypeDef,
    DescribeTagsResultTypeDef,
    DescribeTrafficMirrorFiltersResultTypeDef,
    DescribeTrafficMirrorSessionsResultTypeDef,
    DescribeTrafficMirrorTargetsResultTypeDef,
    DescribeTransitGatewayAttachmentsResultTypeDef,
    DescribeTransitGatewayMulticastDomainsResultTypeDef,
    DescribeTransitGatewayPeeringAttachmentsResultTypeDef,
    DescribeTransitGatewayRouteTablesResultTypeDef,
    DescribeTransitGatewaysResultTypeDef,
    DescribeTransitGatewayVpcAttachmentsResultTypeDef,
    DescribeVolumeAttributeResultTypeDef,
    DescribeVolumesModificationsResultTypeDef,
    DescribeVolumesResultTypeDef,
    DescribeVolumeStatusResultTypeDef,
    DescribeVpcAttributeResultTypeDef,
    DescribeVpcClassicLinkDnsSupportResultTypeDef,
    DescribeVpcClassicLinkResultTypeDef,
    DescribeVpcEndpointConnectionNotificationsResultTypeDef,
    DescribeVpcEndpointConnectionsResultTypeDef,
    DescribeVpcEndpointServiceConfigurationsResultTypeDef,
    DescribeVpcEndpointServicePermissionsResultTypeDef,
    DescribeVpcEndpointServicesResultTypeDef,
    DescribeVpcEndpointsResultTypeDef,
    DescribeVpcPeeringConnectionsResultTypeDef,
    DescribeVpcsResultTypeDef,
    DescribeVpnConnectionsResultTypeDef,
    DescribeVpnGatewaysResultTypeDef,
    DetachClassicLinkVpcResultTypeDef,
    DhcpConfigurationTypeDef,
    DhcpOptionsTypeDef,
    DirectoryServiceAuthenticationRequestTypeDef,
    DirectoryServiceAuthenticationTypeDef,
    DisableEbsEncryptionByDefaultResultTypeDef,
    DisableFastSnapshotRestoreErrorItemTypeDef,
    DisableFastSnapshotRestoresResultTypeDef,
    DisableFastSnapshotRestoreStateErrorItemTypeDef,
    DisableFastSnapshotRestoreStateErrorTypeDef,
    DisableFastSnapshotRestoreSuccessItemTypeDef,
    DisableTransitGatewayRouteTablePropagationResultTypeDef,
    DisableVpcClassicLinkDnsSupportResultTypeDef,
    DisableVpcClassicLinkResultTypeDef,
    DisassociateClientVpnTargetNetworkResultTypeDef,
    DisassociateIamInstanceProfileResultTypeDef,
    DisassociateSubnetCidrBlockResultTypeDef,
    DisassociateTransitGatewayMulticastDomainResultTypeDef,
    DisassociateTransitGatewayRouteTableResultTypeDef,
    DisassociateVpcCidrBlockResultTypeDef,
    DiskImageDescriptionTypeDef,
    DiskImageDetailTypeDef,
    DiskImageTypeDef,
    DiskImageVolumeDescriptionTypeDef,
    DiskInfoTypeDef,
    DnsEntryTypeDef,
    DnsServersOptionsModifyStructureTypeDef,
    EbsBlockDeviceTypeDef,
    EbsInfoTypeDef,
    EbsInstanceBlockDeviceSpecificationTypeDef,
    EbsInstanceBlockDeviceTypeDef,
    EbsOptimizedInfoTypeDef,
    EgressOnlyInternetGatewayTypeDef,
    ElasticGpuAssociationTypeDef,
    ElasticGpuHealthTypeDef,
    ElasticGpuSpecificationResponseTypeDef,
    ElasticGpuSpecificationTypeDef,
    ElasticGpusTypeDef,
    ElasticInferenceAcceleratorAssociationTypeDef,
    ElasticInferenceAcceleratorTypeDef,
    EnableEbsEncryptionByDefaultResultTypeDef,
    EnableFastSnapshotRestoreErrorItemTypeDef,
    EnableFastSnapshotRestoresResultTypeDef,
    EnableFastSnapshotRestoreStateErrorItemTypeDef,
    EnableFastSnapshotRestoreStateErrorTypeDef,
    EnableFastSnapshotRestoreSuccessItemTypeDef,
    EnableTransitGatewayRouteTablePropagationResultTypeDef,
    EnableVpcClassicLinkDnsSupportResultTypeDef,
    EnableVpcClassicLinkResultTypeDef,
    EventInformationTypeDef,
    ExportClientVpnClientCertificateRevocationListResultTypeDef,
    ExportClientVpnClientConfigurationResultTypeDef,
    ExportImageResultTypeDef,
    ExportImageTaskTypeDef,
    ExportTaskS3LocationRequestTypeDef,
    ExportTaskS3LocationTypeDef,
    ExportTaskTypeDef,
    ExportToS3TaskSpecificationTypeDef,
    ExportToS3TaskTypeDef,
    ExportTransitGatewayRoutesResultTypeDef,
    FailedQueuedPurchaseDeletionTypeDef,
    FederatedAuthenticationRequestTypeDef,
    FederatedAuthenticationTypeDef,
    FilterTypeDef,
    FleetDataTypeDef,
    FleetLaunchTemplateConfigRequestTypeDef,
    FleetLaunchTemplateConfigTypeDef,
    FleetLaunchTemplateOverridesRequestTypeDef,
    FleetLaunchTemplateOverridesTypeDef,
    FleetLaunchTemplateSpecificationRequestTypeDef,
    FleetLaunchTemplateSpecificationTypeDef,
    FlowLogTypeDef,
    FpgaDeviceInfoTypeDef,
    FpgaDeviceMemoryInfoTypeDef,
    FpgaImageAttributeTypeDef,
    FpgaImageStateTypeDef,
    FpgaImageTypeDef,
    FpgaInfoTypeDef,
    GetAssociatedIpv6PoolCidrsResultTypeDef,
    GetCapacityReservationUsageResultTypeDef,
    GetCoipPoolUsageResultTypeDef,
    GetConsoleOutputResultTypeDef,
    GetConsoleScreenshotResultTypeDef,
    GetDefaultCreditSpecificationResultTypeDef,
    GetEbsDefaultKmsKeyIdResultTypeDef,
    GetEbsEncryptionByDefaultResultTypeDef,
    GetGroupsForCapacityReservationResultTypeDef,
    GetHostReservationPurchasePreviewResultTypeDef,
    GetLaunchTemplateDataResultTypeDef,
    GetManagedPrefixListAssociationsResultTypeDef,
    GetManagedPrefixListEntriesResultTypeDef,
    GetPasswordDataResultTypeDef,
    GetReservedInstancesExchangeQuoteResultTypeDef,
    GetTransitGatewayAttachmentPropagationsResultTypeDef,
    GetTransitGatewayMulticastDomainAssociationsResultTypeDef,
    GetTransitGatewayPrefixListReferencesResultTypeDef,
    GetTransitGatewayRouteTableAssociationsResultTypeDef,
    GetTransitGatewayRouteTablePropagationsResultTypeDef,
    GpuDeviceInfoTypeDef,
    GpuDeviceMemoryInfoTypeDef,
    GpuInfoTypeDef,
    GroupIdentifierTypeDef,
    HibernationOptionsRequestTypeDef,
    HibernationOptionsTypeDef,
    HistoryRecordEntryTypeDef,
    HistoryRecordTypeDef,
    HostInstanceTypeDef,
    HostOfferingTypeDef,
    HostPropertiesTypeDef,
    HostReservationTypeDef,
    HostTypeDef,
    IamInstanceProfileAssociationTypeDef,
    IamInstanceProfileSpecificationTypeDef,
    IamInstanceProfileTypeDef,
    IcmpTypeCodeTypeDef,
    IdFormatTypeDef,
    IKEVersionsListValueTypeDef,
    IKEVersionsRequestListValueTypeDef,
    ImageAttributeTypeDef,
    ImageDiskContainerTypeDef,
    ImageTypeDef,
    ImportClientVpnClientCertificateRevocationListResultTypeDef,
    ImportImageLicenseConfigurationRequestTypeDef,
    ImportImageLicenseConfigurationResponseTypeDef,
    ImportImageResultTypeDef,
    ImportImageTaskTypeDef,
    ImportInstanceLaunchSpecificationTypeDef,
    ImportInstanceResultTypeDef,
    ImportInstanceTaskDetailsTypeDef,
    ImportInstanceVolumeDetailItemTypeDef,
    ImportKeyPairResultTypeDef,
    ImportSnapshotResultTypeDef,
    ImportSnapshotTaskTypeDef,
    ImportVolumeResultTypeDef,
    ImportVolumeTaskDetailsTypeDef,
    InferenceAcceleratorInfoTypeDef,
    InferenceDeviceInfoTypeDef,
    InstanceAttributeTypeDef,
    InstanceBlockDeviceMappingSpecificationTypeDef,
    InstanceBlockDeviceMappingTypeDef,
    InstanceCapacityTypeDef,
    InstanceCountTypeDef,
    InstanceCreditSpecificationRequestTypeDef,
    InstanceCreditSpecificationTypeDef,
    InstanceExportDetailsTypeDef,
    InstanceFamilyCreditSpecificationTypeDef,
    InstanceIpv6AddressRequestTypeDef,
    InstanceIpv6AddressTypeDef,
    InstanceMarketOptionsRequestTypeDef,
    InstanceMetadataOptionsRequestTypeDef,
    InstanceMetadataOptionsResponseTypeDef,
    InstanceMonitoringTypeDef,
    InstanceNetworkInterfaceAssociationTypeDef,
    InstanceNetworkInterfaceAttachmentTypeDef,
    InstanceNetworkInterfaceSpecificationTypeDef,
    InstanceNetworkInterfaceTypeDef,
    InstancePrivateIpAddressTypeDef,
    InstanceSpecificationTypeDef,
    InstanceStateChangeTypeDef,
    InstanceStateTypeDef,
    InstanceStatusDetailsTypeDef,
    InstanceStatusEventTypeDef,
    InstanceStatusSummaryTypeDef,
    InstanceStatusTypeDef,
    InstanceStorageInfoTypeDef,
    InstanceTagNotificationAttributeTypeDef,
    InstanceTypeDef,
    InstanceTypeInfoTypeDef,
    InstanceTypeOfferingTypeDef,
    InstanceUsageTypeDef,
    InternetGatewayAttachmentTypeDef,
    InternetGatewayTypeDef,
    IpPermissionTypeDef,
    IpRangeTypeDef,
    Ipv6CidrAssociationTypeDef,
    Ipv6CidrBlockTypeDef,
    Ipv6PoolTypeDef,
    Ipv6RangeTypeDef,
    KeyPairInfoTypeDef,
    KeyPairTypeDef,
    LastErrorTypeDef,
    LaunchPermissionModificationsTypeDef,
    LaunchPermissionTypeDef,
    LaunchSpecificationTypeDef,
    LaunchTemplateAndOverridesResponseTypeDef,
    LaunchTemplateBlockDeviceMappingRequestTypeDef,
    LaunchTemplateBlockDeviceMappingTypeDef,
    LaunchTemplateCapacityReservationSpecificationRequestTypeDef,
    LaunchTemplateCapacityReservationSpecificationResponseTypeDef,
    LaunchTemplateConfigTypeDef,
    LaunchTemplateCpuOptionsRequestTypeDef,
    LaunchTemplateCpuOptionsTypeDef,
    LaunchTemplateEbsBlockDeviceRequestTypeDef,
    LaunchTemplateEbsBlockDeviceTypeDef,
    LaunchTemplateElasticInferenceAcceleratorResponseTypeDef,
    LaunchTemplateElasticInferenceAcceleratorTypeDef,
    LaunchTemplateHibernationOptionsRequestTypeDef,
    LaunchTemplateHibernationOptionsTypeDef,
    LaunchTemplateIamInstanceProfileSpecificationRequestTypeDef,
    LaunchTemplateIamInstanceProfileSpecificationTypeDef,
    LaunchTemplateInstanceMarketOptionsRequestTypeDef,
    LaunchTemplateInstanceMarketOptionsTypeDef,
    LaunchTemplateInstanceMetadataOptionsRequestTypeDef,
    LaunchTemplateInstanceMetadataOptionsTypeDef,
    LaunchTemplateInstanceNetworkInterfaceSpecificationRequestTypeDef,
    LaunchTemplateInstanceNetworkInterfaceSpecificationTypeDef,
    LaunchTemplateLicenseConfigurationRequestTypeDef,
    LaunchTemplateLicenseConfigurationTypeDef,
    LaunchTemplateOverridesTypeDef,
    LaunchTemplatePlacementRequestTypeDef,
    LaunchTemplatePlacementTypeDef,
    LaunchTemplatesMonitoringRequestTypeDef,
    LaunchTemplatesMonitoringTypeDef,
    LaunchTemplateSpecificationTypeDef,
    LaunchTemplateSpotMarketOptionsRequestTypeDef,
    LaunchTemplateSpotMarketOptionsTypeDef,
    LaunchTemplateTagSpecificationRequestTypeDef,
    LaunchTemplateTagSpecificationTypeDef,
    LaunchTemplateTypeDef,
    LaunchTemplateVersionTypeDef,
    LicenseConfigurationRequestTypeDef,
    LicenseConfigurationTypeDef,
    LoadBalancersConfigTypeDef,
    LoadPermissionModificationsTypeDef,
    LoadPermissionRequestTypeDef,
    LoadPermissionTypeDef,
    LocalGatewayRouteTableTypeDef,
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationTypeDef,
    LocalGatewayRouteTableVpcAssociationTypeDef,
    LocalGatewayRouteTypeDef,
    LocalGatewayTypeDef,
    LocalGatewayVirtualInterfaceGroupTypeDef,
    LocalGatewayVirtualInterfaceTypeDef,
    ManagedPrefixListTypeDef,
    MemoryInfoTypeDef,
    ModifyAvailabilityZoneGroupResultTypeDef,
    ModifyCapacityReservationResultTypeDef,
    ModifyClientVpnEndpointResultTypeDef,
    ModifyDefaultCreditSpecificationResultTypeDef,
    ModifyEbsDefaultKmsKeyIdResultTypeDef,
    ModifyFleetResultTypeDef,
    ModifyFpgaImageAttributeResultTypeDef,
    ModifyHostsResultTypeDef,
    ModifyInstanceCapacityReservationAttributesResultTypeDef,
    ModifyInstanceCreditSpecificationResultTypeDef,
    ModifyInstanceEventStartTimeResultTypeDef,
    ModifyInstanceMetadataOptionsResultTypeDef,
    ModifyInstancePlacementResultTypeDef,
    ModifyLaunchTemplateResultTypeDef,
    ModifyManagedPrefixListResultTypeDef,
    ModifyReservedInstancesResultTypeDef,
    ModifySpotFleetRequestResponseTypeDef,
    ModifyTrafficMirrorFilterNetworkServicesResultTypeDef,
    ModifyTrafficMirrorFilterRuleResultTypeDef,
    ModifyTrafficMirrorSessionResultTypeDef,
    ModifyTransitGatewayOptionsTypeDef,
    ModifyTransitGatewayPrefixListReferenceResultTypeDef,
    ModifyTransitGatewayResultTypeDef,
    ModifyTransitGatewayVpcAttachmentRequestOptionsTypeDef,
    ModifyTransitGatewayVpcAttachmentResultTypeDef,
    ModifyVolumeResultTypeDef,
    ModifyVpcEndpointConnectionNotificationResultTypeDef,
    ModifyVpcEndpointResultTypeDef,
    ModifyVpcEndpointServiceConfigurationResultTypeDef,
    ModifyVpcEndpointServicePermissionsResultTypeDef,
    ModifyVpcPeeringConnectionOptionsResultTypeDef,
    ModifyVpcTenancyResultTypeDef,
    ModifyVpnConnectionOptionsResultTypeDef,
    ModifyVpnConnectionResultTypeDef,
    ModifyVpnTunnelCertificateResultTypeDef,
    ModifyVpnTunnelOptionsResultTypeDef,
    ModifyVpnTunnelOptionsSpecificationTypeDef,
    MonitoringTypeDef,
    MonitorInstancesResultTypeDef,
    MoveAddressToVpcResultTypeDef,
    MovingAddressStatusTypeDef,
    NatGatewayAddressTypeDef,
    NatGatewayTypeDef,
    NetworkAclAssociationTypeDef,
    NetworkAclEntryTypeDef,
    NetworkAclTypeDef,
    NetworkInfoTypeDef,
    NetworkInterfaceAssociationTypeDef,
    NetworkInterfaceAttachmentChangesTypeDef,
    NetworkInterfaceAttachmentTypeDef,
    NetworkInterfaceIpv6AddressTypeDef,
    NetworkInterfacePermissionStateTypeDef,
    NetworkInterfacePermissionTypeDef,
    NetworkInterfacePrivateIpAddressTypeDef,
    NetworkInterfaceTypeDef,
    NewDhcpConfigurationTypeDef,
    OnDemandOptionsRequestTypeDef,
    OnDemandOptionsTypeDef,
    PaginatorConfigTypeDef,
    PciIdTypeDef,
    PeeringAttachmentStatusTypeDef,
    PeeringConnectionOptionsRequestTypeDef,
    PeeringConnectionOptionsTypeDef,
    PeeringTgwInfoTypeDef,
    Phase1DHGroupNumbersListValueTypeDef,
    Phase1DHGroupNumbersRequestListValueTypeDef,
    Phase1EncryptionAlgorithmsListValueTypeDef,
    Phase1EncryptionAlgorithmsRequestListValueTypeDef,
    Phase1IntegrityAlgorithmsListValueTypeDef,
    Phase1IntegrityAlgorithmsRequestListValueTypeDef,
    Phase2DHGroupNumbersListValueTypeDef,
    Phase2DHGroupNumbersRequestListValueTypeDef,
    Phase2EncryptionAlgorithmsListValueTypeDef,
    Phase2EncryptionAlgorithmsRequestListValueTypeDef,
    Phase2IntegrityAlgorithmsListValueTypeDef,
    Phase2IntegrityAlgorithmsRequestListValueTypeDef,
    PlacementGroupInfoTypeDef,
    PlacementGroupTypeDef,
    PlacementResponseTypeDef,
    PlacementTypeDef,
    PoolCidrBlockTypeDef,
    PortRangeTypeDef,
    PrefixListAssociationTypeDef,
    PrefixListEntryTypeDef,
    PrefixListIdTypeDef,
    PrefixListTypeDef,
    PriceScheduleSpecificationTypeDef,
    PriceScheduleTypeDef,
    PricingDetailTypeDef,
    PrincipalIdFormatTypeDef,
    PrivateDnsNameConfigurationTypeDef,
    PrivateIpAddressSpecificationTypeDef,
    ProcessorInfoTypeDef,
    ProductCodeTypeDef,
    PropagatingVgwTypeDef,
    ProvisionByoipCidrResultTypeDef,
    ProvisionedBandwidthTypeDef,
    PublicIpv4PoolRangeTypeDef,
    PublicIpv4PoolTypeDef,
    PurchaseHostReservationResultTypeDef,
    PurchaseRequestTypeDef,
    PurchaseReservedInstancesOfferingResultTypeDef,
    PurchaseScheduledInstancesResultTypeDef,
    PurchaseTypeDef,
    RecurringChargeTypeDef,
    RegionTypeDef,
    RegisterImageResultTypeDef,
    RegisterInstanceEventNotificationAttributesResultTypeDef,
    RegisterInstanceTagAttributeRequestTypeDef,
    RegisterTransitGatewayMulticastGroupMembersResultTypeDef,
    RegisterTransitGatewayMulticastGroupSourcesResultTypeDef,
    RejectTransitGatewayPeeringAttachmentResultTypeDef,
    RejectTransitGatewayVpcAttachmentResultTypeDef,
    RejectVpcEndpointConnectionsResultTypeDef,
    RejectVpcPeeringConnectionResultTypeDef,
    ReleaseHostsResultTypeDef,
    RemovePrefixListEntryTypeDef,
    ReplaceIamInstanceProfileAssociationResultTypeDef,
    ReplaceNetworkAclAssociationResultTypeDef,
    ReplaceRouteTableAssociationResultTypeDef,
    ReplaceTransitGatewayRouteResultTypeDef,
    RequestLaunchTemplateDataTypeDef,
    RequestSpotFleetResponseTypeDef,
    RequestSpotInstancesResultTypeDef,
    RequestSpotLaunchSpecificationTypeDef,
    ReservationTypeDef,
    ReservationValueTypeDef,
    ReservedInstanceLimitPriceTypeDef,
    ReservedInstanceReservationValueTypeDef,
    ReservedInstancesConfigurationTypeDef,
    ReservedInstancesIdTypeDef,
    ReservedInstancesListingTypeDef,
    ReservedInstancesModificationResultTypeDef,
    ReservedInstancesModificationTypeDef,
    ReservedInstancesOfferingTypeDef,
    ReservedInstancesTypeDef,
    ResetEbsDefaultKmsKeyIdResultTypeDef,
    ResetFpgaImageAttributeResultTypeDef,
    ResponseErrorTypeDef,
    ResponseLaunchTemplateDataTypeDef,
    RestoreAddressToClassicResultTypeDef,
    RestoreManagedPrefixListVersionResultTypeDef,
    RevokeClientVpnIngressResultTypeDef,
    RouteTableAssociationStateTypeDef,
    RouteTableAssociationTypeDef,
    RouteTableTypeDef,
    RouteTypeDef,
    RunInstancesMonitoringEnabledTypeDef,
    RunScheduledInstancesResultTypeDef,
    S3StorageTypeDef,
    ScheduledInstanceAvailabilityTypeDef,
    ScheduledInstanceRecurrenceRequestTypeDef,
    ScheduledInstanceRecurrenceTypeDef,
    ScheduledInstancesBlockDeviceMappingTypeDef,
    ScheduledInstancesEbsTypeDef,
    ScheduledInstancesIamInstanceProfileTypeDef,
    ScheduledInstancesIpv6AddressTypeDef,
    ScheduledInstancesLaunchSpecificationTypeDef,
    ScheduledInstancesMonitoringTypeDef,
    ScheduledInstancesNetworkInterfaceTypeDef,
    ScheduledInstancesPlacementTypeDef,
    ScheduledInstancesPrivateIpAddressConfigTypeDef,
    ScheduledInstanceTypeDef,
    SearchLocalGatewayRoutesResultTypeDef,
    SearchTransitGatewayMulticastGroupsResultTypeDef,
    SearchTransitGatewayRoutesResultTypeDef,
    SecurityGroupIdentifierTypeDef,
    SecurityGroupReferenceTypeDef,
    SecurityGroupTypeDef,
    ServiceConfigurationTypeDef,
    ServiceDetailTypeDef,
    ServiceTypeDetailTypeDef,
    SlotDateTimeRangeRequestTypeDef,
    SlotStartTimeRangeRequestTypeDef,
    SnapshotDetailTypeDef,
    SnapshotDiskContainerTypeDef,
    SnapshotInfoTypeDef,
    SnapshotTaskDetailTypeDef,
    SnapshotTypeDef,
    SpotDatafeedSubscriptionTypeDef,
    SpotFleetLaunchSpecificationTypeDef,
    SpotFleetMonitoringTypeDef,
    SpotFleetRequestConfigDataTypeDef,
    SpotFleetRequestConfigTypeDef,
    SpotFleetTagSpecificationTypeDef,
    SpotInstanceRequestTypeDef,
    SpotInstanceStateFaultTypeDef,
    SpotInstanceStatusTypeDef,
    SpotMarketOptionsTypeDef,
    SpotOptionsRequestTypeDef,
    SpotOptionsTypeDef,
    SpotPlacementTypeDef,
    SpotPriceTypeDef,
    StaleIpPermissionTypeDef,
    StaleSecurityGroupTypeDef,
    StartInstancesResultTypeDef,
    StartVpcEndpointServicePrivateDnsVerificationResultTypeDef,
    StateReasonTypeDef,
    StopInstancesResultTypeDef,
    StorageLocationTypeDef,
    StorageTypeDef,
    SubnetAssociationTypeDef,
    SubnetCidrBlockStateTypeDef,
    SubnetIpv6CidrBlockAssociationTypeDef,
    SubnetTypeDef,
    SuccessfulInstanceCreditSpecificationItemTypeDef,
    SuccessfulQueuedPurchaseDeletionTypeDef,
    TagDescriptionTypeDef,
    TagSpecificationTypeDef,
    TagTypeDef,
    TargetCapacitySpecificationRequestTypeDef,
    TargetCapacitySpecificationTypeDef,
    TargetConfigurationRequestTypeDef,
    TargetConfigurationTypeDef,
    TargetGroupsConfigTypeDef,
    TargetGroupTypeDef,
    TargetNetworkTypeDef,
    TargetReservationValueTypeDef,
    TerminateClientVpnConnectionsResultTypeDef,
    TerminateConnectionStatusTypeDef,
    TerminateInstancesResultTypeDef,
    TrafficMirrorFilterRuleTypeDef,
    TrafficMirrorFilterTypeDef,
    TrafficMirrorPortRangeRequestTypeDef,
    TrafficMirrorPortRangeTypeDef,
    TrafficMirrorSessionTypeDef,
    TrafficMirrorTargetTypeDef,
    TransitGatewayAssociationTypeDef,
    TransitGatewayAttachmentAssociationTypeDef,
    TransitGatewayAttachmentPropagationTypeDef,
    TransitGatewayAttachmentTypeDef,
    TransitGatewayMulticastDeregisteredGroupMembersTypeDef,
    TransitGatewayMulticastDeregisteredGroupSourcesTypeDef,
    TransitGatewayMulticastDomainAssociationsTypeDef,
    TransitGatewayMulticastDomainAssociationTypeDef,
    TransitGatewayMulticastDomainTypeDef,
    TransitGatewayMulticastGroupTypeDef,
    TransitGatewayMulticastRegisteredGroupMembersTypeDef,
    TransitGatewayMulticastRegisteredGroupSourcesTypeDef,
    TransitGatewayOptionsTypeDef,
    TransitGatewayPeeringAttachmentTypeDef,
    TransitGatewayPrefixListAttachmentTypeDef,
    TransitGatewayPrefixListReferenceTypeDef,
    TransitGatewayPropagationTypeDef,
    TransitGatewayRequestOptionsTypeDef,
    TransitGatewayRouteAttachmentTypeDef,
    TransitGatewayRouteTableAssociationTypeDef,
    TransitGatewayRouteTablePropagationTypeDef,
    TransitGatewayRouteTableTypeDef,
    TransitGatewayRouteTypeDef,
    TransitGatewayTypeDef,
    TransitGatewayVpcAttachmentOptionsTypeDef,
    TransitGatewayVpcAttachmentTypeDef,
    TunnelOptionTypeDef,
    UnassignIpv6AddressesResultTypeDef,
    UnmonitorInstancesResultTypeDef,
    UnsuccessfulInstanceCreditSpecificationItemErrorTypeDef,
    UnsuccessfulInstanceCreditSpecificationItemTypeDef,
    UnsuccessfulItemErrorTypeDef,
    UnsuccessfulItemTypeDef,
    UpdateSecurityGroupRuleDescriptionsEgressResultTypeDef,
    UpdateSecurityGroupRuleDescriptionsIngressResultTypeDef,
    UserBucketDetailsTypeDef,
    UserBucketTypeDef,
    UserDataTypeDef,
    UserIdGroupPairTypeDef,
    ValidationErrorTypeDef,
    ValidationWarningTypeDef,
    VCpuInfoTypeDef,
    VgwTelemetryTypeDef,
    VolumeAttachmentTypeDef,
    VolumeDetailTypeDef,
    VolumeModificationTypeDef,
    VolumeStatusActionTypeDef,
    VolumeStatusAttachmentStatusTypeDef,
    VolumeStatusDetailsTypeDef,
    VolumeStatusEventTypeDef,
    VolumeStatusInfoTypeDef,
    VolumeStatusItemTypeDef,
    VolumeTypeDef,
    VpcAttachmentTypeDef,
    VpcCidrBlockAssociationTypeDef,
    VpcCidrBlockStateTypeDef,
    VpcClassicLinkTypeDef,
    VpcEndpointConnectionTypeDef,
    VpcEndpointTypeDef,
    VpcIpv6CidrBlockAssociationTypeDef,
    VpcPeeringConnectionOptionsDescriptionTypeDef,
    VpcPeeringConnectionStateReasonTypeDef,
    VpcPeeringConnectionTypeDef,
    VpcPeeringConnectionVpcInfoTypeDef,
    VpcTypeDef,
    VpnConnectionOptionsSpecificationTypeDef,
    VpnConnectionOptionsTypeDef,
    VpnConnectionTypeDef,
    VpnGatewayTypeDef,
    VpnStaticRouteTypeDef,
    VpnTunnelOptionsSpecificationTypeDef,
    WaiterConfigTypeDef,
    WithdrawByoipCidrResultTypeDef,
)

def get_structure() -> AccountAttributeTypeDef:
    return {
      ...
    }
```
