# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CustomDomainVerificationInitArgs', 'CustomDomainVerification']

@pulumi.input_type
class CustomDomainVerificationInitArgs:
    def __init__(__self__, *,
                 custom_domain_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a CustomDomainVerification resource.
        :param pulumi.Input[str] custom_domain_id: String. ID of the custom domain resource.
        """
        pulumi.set(__self__, "custom_domain_id", custom_domain_id)

    @property
    @pulumi.getter(name="customDomainId")
    def custom_domain_id(self) -> pulumi.Input[str]:
        """
        String. ID of the custom domain resource.
        """
        return pulumi.get(self, "custom_domain_id")

    @custom_domain_id.setter
    def custom_domain_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "custom_domain_id", value)


@pulumi.input_type
class _CustomDomainVerificationState:
    def __init__(__self__, *,
                 custom_domain_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CustomDomainVerification resources.
        :param pulumi.Input[str] custom_domain_id: String. ID of the custom domain resource.
        """
        if custom_domain_id is not None:
            pulumi.set(__self__, "custom_domain_id", custom_domain_id)

    @property
    @pulumi.getter(name="customDomainId")
    def custom_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        String. ID of the custom domain resource.
        """
        return pulumi.get(self, "custom_domain_id")

    @custom_domain_id.setter
    def custom_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_domain_id", value)


class CustomDomainVerification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_domain_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        With Auth0, you can use a custom domain to maintain a consistent user experience. This is a three-step process; you must
        configure the custom domain in Auth0, then create a DNS record for the domain, then verify the DNS record in Auth0.
        This resource allows for automating the verification part of the process.

        ## Import

        You can import this resource using the custom domain id, e.g.

        ```sh
         $ pulumi import auth0:index/customDomainVerification:CustomDomainVerification my_custom_domain_verification cd_XXXXXXXXXXXXXXXX
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_domain_id: String. ID of the custom domain resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomDomainVerificationInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With Auth0, you can use a custom domain to maintain a consistent user experience. This is a three-step process; you must
        configure the custom domain in Auth0, then create a DNS record for the domain, then verify the DNS record in Auth0.
        This resource allows for automating the verification part of the process.

        ## Import

        You can import this resource using the custom domain id, e.g.

        ```sh
         $ pulumi import auth0:index/customDomainVerification:CustomDomainVerification my_custom_domain_verification cd_XXXXXXXXXXXXXXXX
        ```

        :param str resource_name: The name of the resource.
        :param CustomDomainVerificationInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDomainVerificationInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_domain_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDomainVerificationInitArgs.__new__(CustomDomainVerificationInitArgs)

            if custom_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'custom_domain_id'")
            __props__.__dict__["custom_domain_id"] = custom_domain_id
        super(CustomDomainVerification, __self__).__init__(
            'auth0:index/customDomainVerification:CustomDomainVerification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_domain_id: Optional[pulumi.Input[str]] = None) -> 'CustomDomainVerification':
        """
        Get an existing CustomDomainVerification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_domain_id: String. ID of the custom domain resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDomainVerificationState.__new__(_CustomDomainVerificationState)

        __props__.__dict__["custom_domain_id"] = custom_domain_id
        return CustomDomainVerification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customDomainId")
    def custom_domain_id(self) -> pulumi.Output[str]:
        """
        String. ID of the custom domain resource.
        """
        return pulumi.get(self, "custom_domain_id")

