<a id="mypy-boto3-iotanalytics"></a>

# mypy-boto3-iotanalytics

[![PyPI - mypy-boto3-iotanalytics](https://img.shields.io/pypi/v/mypy-boto3-iotanalytics.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotanalytics)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iotanalytics.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotanalytics)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-iotanalytics?color=blue)](https://pypistats.org/packages/mypy-boto3-iotanalytics)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.IoTAnalytics 1.17.105](https://boto3.amazonaws.com/v1/documentation/api/1.17.105/reference/services/iotanalytics.html#IoTAnalytics)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.22.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-iotanalytics docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotanalytics/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-iotanalytics](#mypy-boto3-iotanalytics)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `IoTAnalytics` service.

```bash
python -m pip install boto3-stubs[iotanalytics]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[iotanalytics]` in your environment:
  `python -m pip install 'boto3-stubs[iotanalytics]'`

Both type checking and auto-complete should work for `IoTAnalytics` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[iotanalytics]` in your environment:
  `python -m pip install 'boto3-stubs[iotanalytics]'`

Both type checking and auto-complete should work for `IoTAnalytics` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[iotanalytics]` in your environment:
  `python -m pip install 'boto3-stubs[iotanalytics]'`
- Run `mypy` as usual

Type checking should work for `IoTAnalytics` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[iotanalytics]` in your environment:
  `python -m pip install 'boto3-stubs[iotanalytics]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IoTAnalytics` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`IoTAnalyticsClient` provides annotations for `boto3.client("iotanalytics")`.

```python
import boto3

from mypy_boto3_iotanalytics import IoTAnalyticsClient

client: IoTAnalyticsClient = boto3.client("iotanalytics")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoTAnalyticsClient = session.client("iotanalytics")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_iotanalytics.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_iotanalytics import IoTAnalyticsClient
from mypy_boto3_iotanalytics.paginator import (
    ListChannelsPaginator,
    ListDatasetContentsPaginator,
    ListDatasetsPaginator,
    ListDatastoresPaginator,
    ListPipelinesPaginator,
)

client: IoTAnalyticsClient = boto3.client("iotanalytics")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_channels_paginator: ListChannelsPaginator = client.get_paginator("list_channels")
list_dataset_contents_paginator: ListDatasetContentsPaginator = client.get_paginator("list_dataset_contents")
list_datasets_paginator: ListDatasetsPaginator = client.get_paginator("list_datasets")
list_datastores_paginator: ListDatastoresPaginator = client.get_paginator("list_datastores")
list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
```

<a id="literals"></a>

### Literals

`mypy_boto3_iotanalytics.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_iotanalytics.literals import (
    ChannelStatusType,
    ComputeTypeType,
    DatasetActionTypeType,
    DatasetContentStateType,
    DatasetStatusType,
    DatastoreStatusType,
    FileFormatTypeType,
    ListChannelsPaginatorName,
    ListDatasetContentsPaginatorName,
    ListDatasetsPaginatorName,
    ListDatastoresPaginatorName,
    ListPipelinesPaginatorName,
    LoggingLevelType,
    ReprocessingStatusType,
)

def check_value(value: ChannelStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_iotanalytics.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_iotanalytics.type_defs import (
    AddAttributesActivityTypeDef,
    BatchPutMessageErrorEntryTypeDef,
    BatchPutMessageRequestRequestTypeDef,
    BatchPutMessageResponseTypeDef,
    CancelPipelineReprocessingRequestRequestTypeDef,
    ChannelActivityTypeDef,
    ChannelMessagesTypeDef,
    ChannelStatisticsTypeDef,
    ChannelStorageSummaryTypeDef,
    ChannelStorageTypeDef,
    ChannelSummaryTypeDef,
    ChannelTypeDef,
    ColumnTypeDef,
    ContainerDatasetActionTypeDef,
    CreateChannelRequestRequestTypeDef,
    CreateChannelResponseTypeDef,
    CreateDatasetContentRequestRequestTypeDef,
    CreateDatasetContentResponseTypeDef,
    CreateDatasetRequestRequestTypeDef,
    CreateDatasetResponseTypeDef,
    CreateDatastoreRequestRequestTypeDef,
    CreateDatastoreResponseTypeDef,
    CreatePipelineRequestRequestTypeDef,
    CreatePipelineResponseTypeDef,
    CustomerManagedChannelS3StorageSummaryTypeDef,
    CustomerManagedChannelS3StorageTypeDef,
    CustomerManagedDatastoreS3StorageSummaryTypeDef,
    CustomerManagedDatastoreS3StorageTypeDef,
    DatasetActionSummaryTypeDef,
    DatasetActionTypeDef,
    DatasetContentDeliveryDestinationTypeDef,
    DatasetContentDeliveryRuleTypeDef,
    DatasetContentStatusTypeDef,
    DatasetContentSummaryTypeDef,
    DatasetContentVersionValueTypeDef,
    DatasetEntryTypeDef,
    DatasetSummaryTypeDef,
    DatasetTriggerTypeDef,
    DatasetTypeDef,
    DatastoreActivityTypeDef,
    DatastorePartitionTypeDef,
    DatastorePartitionsTypeDef,
    DatastoreStatisticsTypeDef,
    DatastoreStorageSummaryTypeDef,
    DatastoreStorageTypeDef,
    DatastoreSummaryTypeDef,
    DatastoreTypeDef,
    DeleteChannelRequestRequestTypeDef,
    DeleteDatasetContentRequestRequestTypeDef,
    DeleteDatasetRequestRequestTypeDef,
    DeleteDatastoreRequestRequestTypeDef,
    DeletePipelineRequestRequestTypeDef,
    DeltaTimeSessionWindowConfigurationTypeDef,
    DeltaTimeTypeDef,
    DescribeChannelRequestRequestTypeDef,
    DescribeChannelResponseTypeDef,
    DescribeDatasetRequestRequestTypeDef,
    DescribeDatasetResponseTypeDef,
    DescribeDatastoreRequestRequestTypeDef,
    DescribeDatastoreResponseTypeDef,
    DescribeLoggingOptionsResponseTypeDef,
    DescribePipelineRequestRequestTypeDef,
    DescribePipelineResponseTypeDef,
    DeviceRegistryEnrichActivityTypeDef,
    DeviceShadowEnrichActivityTypeDef,
    EstimatedResourceSizeTypeDef,
    FileFormatConfigurationTypeDef,
    FilterActivityTypeDef,
    GetDatasetContentRequestRequestTypeDef,
    GetDatasetContentResponseTypeDef,
    GlueConfigurationTypeDef,
    IotEventsDestinationConfigurationTypeDef,
    LambdaActivityTypeDef,
    LateDataRuleConfigurationTypeDef,
    LateDataRuleTypeDef,
    ListChannelsRequestRequestTypeDef,
    ListChannelsResponseTypeDef,
    ListDatasetContentsRequestRequestTypeDef,
    ListDatasetContentsResponseTypeDef,
    ListDatasetsRequestRequestTypeDef,
    ListDatasetsResponseTypeDef,
    ListDatastoresRequestRequestTypeDef,
    ListDatastoresResponseTypeDef,
    ListPipelinesRequestRequestTypeDef,
    ListPipelinesResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    LoggingOptionsTypeDef,
    MathActivityTypeDef,
    MessageTypeDef,
    OutputFileUriValueTypeDef,
    PaginatorConfigTypeDef,
    ParquetConfigurationTypeDef,
    PartitionTypeDef,
    PipelineActivityTypeDef,
    PipelineSummaryTypeDef,
    PipelineTypeDef,
    PutLoggingOptionsRequestRequestTypeDef,
    QueryFilterTypeDef,
    RemoveAttributesActivityTypeDef,
    ReprocessingSummaryTypeDef,
    ResourceConfigurationTypeDef,
    ResponseMetadataTypeDef,
    RetentionPeriodTypeDef,
    RunPipelineActivityRequestRequestTypeDef,
    RunPipelineActivityResponseTypeDef,
    S3DestinationConfigurationTypeDef,
    SampleChannelDataRequestRequestTypeDef,
    SampleChannelDataResponseTypeDef,
    ScheduleTypeDef,
    SchemaDefinitionTypeDef,
    SelectAttributesActivityTypeDef,
    SqlQueryDatasetActionTypeDef,
    StartPipelineReprocessingRequestRequestTypeDef,
    StartPipelineReprocessingResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    TimestampPartitionTypeDef,
    TriggeringDatasetTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateChannelRequestRequestTypeDef,
    UpdateDatasetRequestRequestTypeDef,
    UpdateDatastoreRequestRequestTypeDef,
    UpdatePipelineRequestRequestTypeDef,
    VariableTypeDef,
    VersioningConfigurationTypeDef,
)

def get_structure() -> AddAttributesActivityTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-iotanalytics` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-iotanalytics docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotanalytics/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
