"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenerCertificate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A certificate source for an ELBv2 listener.
 *
 * @stability stable
 */
class ListenerCertificate {
    /**
     * @stability stable
     */
    constructor(certificateArn) {
        this.certificateArn = certificateArn;
    }
    /**
     * Use an ACM certificate as a listener certificate.
     *
     * @stability stable
     */
    static fromCertificateManager(acmCertificate) {
        return new ListenerCertificate(acmCertificate.certificateArn);
    }
    /**
     * Use any certificate, identified by its ARN, as a listener certificate.
     *
     * @stability stable
     */
    static fromArn(certificateArn) {
        return new ListenerCertificate(certificateArn);
    }
}
exports.ListenerCertificate = ListenerCertificate;
_a = JSII_RTTI_SYMBOL_1;
ListenerCertificate[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2.ListenerCertificate", version: "1.95.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdGVuZXItY2VydGlmaWNhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaXN0ZW5lci1jZXJ0aWZpY2F0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBZUEsTUFBYSxtQkFBbUI7Ozs7SUFvQjlCLFlBQXNCLGNBQXNCO1FBQzFDLElBQUksQ0FBQyxjQUFjLEdBQUcsY0FBYyxDQUFDO0lBQ3ZDLENBQUM7Ozs7OztJQWxCTSxNQUFNLENBQUMsc0JBQXNCLENBQUMsY0FBZ0M7UUFDbkUsT0FBTyxJQUFJLG1CQUFtQixDQUFDLGNBQWMsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNoRSxDQUFDOzs7Ozs7SUFLTSxNQUFNLENBQUMsT0FBTyxDQUFDLGNBQXNCO1FBQzFDLE9BQU8sSUFBSSxtQkFBbUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDOztBQWJILGtEQXVCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGFjbSBmcm9tICdAYXdzLWNkay9hd3MtY2VydGlmaWNhdGVtYW5hZ2VyJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSUxpc3RlbmVyQ2VydGlmaWNhdGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2VydGlmaWNhdGVBcm46IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBMaXN0ZW5lckNlcnRpZmljYXRlIGltcGxlbWVudHMgSUxpc3RlbmVyQ2VydGlmaWNhdGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tQ2VydGlmaWNhdGVNYW5hZ2VyKGFjbUNlcnRpZmljYXRlOiBhY20uSUNlcnRpZmljYXRlKSB7XG4gICAgcmV0dXJuIG5ldyBMaXN0ZW5lckNlcnRpZmljYXRlKGFjbUNlcnRpZmljYXRlLmNlcnRpZmljYXRlQXJuKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGZyb21Bcm4oY2VydGlmaWNhdGVBcm46IHN0cmluZykge1xuICAgIHJldHVybiBuZXcgTGlzdGVuZXJDZXJ0aWZpY2F0ZShjZXJ0aWZpY2F0ZUFybik7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGNlcnRpZmljYXRlQXJuOiBzdHJpbmc7XG5cbiAgcHJvdGVjdGVkIGNvbnN0cnVjdG9yKGNlcnRpZmljYXRlQXJuOiBzdHJpbmcpIHtcbiAgICB0aGlzLmNlcnRpZmljYXRlQXJuID0gY2VydGlmaWNhdGVBcm47XG4gIH1cbn1cbiJdfQ==