# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RegistrypredictionPrediction(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'dataset_id': 'str',
        'model_id': 'RimeUUID',
        'project_ids': 'list[RimeUUID]',
        'creator_id': 'RimeUUID',
        'creation_time': 'datetime',
        'user_metadata': 'SchemaregistryMetadata',
        'integration_id': 'RimeUUID',
        'pred_info': 'TestrunPredInfo'
    }

    attribute_map = {
        'dataset_id': 'datasetId',
        'model_id': 'modelId',
        'project_ids': 'projectIds',
        'creator_id': 'creatorId',
        'creation_time': 'creationTime',
        'user_metadata': 'userMetadata',
        'integration_id': 'integrationId',
        'pred_info': 'predInfo'
    }

    def __init__(self, dataset_id=None, model_id=None, project_ids=None, creator_id=None, creation_time=None, user_metadata=None, integration_id=None, pred_info=None):  # noqa: E501
        """RegistrypredictionPrediction - a model defined in Swagger"""  # noqa: E501
        self._dataset_id = None
        self._model_id = None
        self._project_ids = None
        self._creator_id = None
        self._creation_time = None
        self._user_metadata = None
        self._integration_id = None
        self._pred_info = None
        self.discriminator = None
        if dataset_id is not None:
            self.dataset_id = dataset_id
        if model_id is not None:
            self.model_id = model_id
        if project_ids is not None:
            self.project_ids = project_ids
        if creator_id is not None:
            self.creator_id = creator_id
        if creation_time is not None:
            self.creation_time = creation_time
        if user_metadata is not None:
            self.user_metadata = user_metadata
        if integration_id is not None:
            self.integration_id = integration_id
        if pred_info is not None:
            self.pred_info = pred_info

    @property
    def dataset_id(self):
        """Gets the dataset_id of this RegistrypredictionPrediction.  # noqa: E501

        The dataset_id and model_id are used to uniquely identify a prediction. These must be provided by the user.  # noqa: E501

        :return: The dataset_id of this RegistrypredictionPrediction.  # noqa: E501
        :rtype: str
        """
        return self._dataset_id

    @dataset_id.setter
    def dataset_id(self, dataset_id):
        """Sets the dataset_id of this RegistrypredictionPrediction.

        The dataset_id and model_id are used to uniquely identify a prediction. These must be provided by the user.  # noqa: E501

        :param dataset_id: The dataset_id of this RegistrypredictionPrediction.  # noqa: E501
        :type: str
        """

        self._dataset_id = dataset_id

    @property
    def model_id(self):
        """Gets the model_id of this RegistrypredictionPrediction.  # noqa: E501


        :return: The model_id of this RegistrypredictionPrediction.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """Sets the model_id of this RegistrypredictionPrediction.


        :param model_id: The model_id of this RegistrypredictionPrediction.  # noqa: E501
        :type: RimeUUID
        """

        self._model_id = model_id

    @property
    def project_ids(self):
        """Gets the project_ids of this RegistrypredictionPrediction.  # noqa: E501

        For now, a pred will only have one project_id associated with it. We make this an array to allow pred's to be shared in the future.  # noqa: E501

        :return: The project_ids of this RegistrypredictionPrediction.  # noqa: E501
        :rtype: list[RimeUUID]
        """
        return self._project_ids

    @project_ids.setter
    def project_ids(self, project_ids):
        """Sets the project_ids of this RegistrypredictionPrediction.

        For now, a pred will only have one project_id associated with it. We make this an array to allow pred's to be shared in the future.  # noqa: E501

        :param project_ids: The project_ids of this RegistrypredictionPrediction.  # noqa: E501
        :type: list[RimeUUID]
        """

        self._project_ids = project_ids

    @property
    def creator_id(self):
        """Gets the creator_id of this RegistrypredictionPrediction.  # noqa: E501


        :return: The creator_id of this RegistrypredictionPrediction.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._creator_id

    @creator_id.setter
    def creator_id(self, creator_id):
        """Sets the creator_id of this RegistrypredictionPrediction.


        :param creator_id: The creator_id of this RegistrypredictionPrediction.  # noqa: E501
        :type: RimeUUID
        """

        self._creator_id = creator_id

    @property
    def creation_time(self):
        """Gets the creation_time of this RegistrypredictionPrediction.  # noqa: E501


        :return: The creation_time of this RegistrypredictionPrediction.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this RegistrypredictionPrediction.


        :param creation_time: The creation_time of this RegistrypredictionPrediction.  # noqa: E501
        :type: datetime
        """

        self._creation_time = creation_time

    @property
    def user_metadata(self):
        """Gets the user_metadata of this RegistrypredictionPrediction.  # noqa: E501


        :return: The user_metadata of this RegistrypredictionPrediction.  # noqa: E501
        :rtype: SchemaregistryMetadata
        """
        return self._user_metadata

    @user_metadata.setter
    def user_metadata(self, user_metadata):
        """Sets the user_metadata of this RegistrypredictionPrediction.


        :param user_metadata: The user_metadata of this RegistrypredictionPrediction.  # noqa: E501
        :type: SchemaregistryMetadata
        """

        self._user_metadata = user_metadata

    @property
    def integration_id(self):
        """Gets the integration_id of this RegistrypredictionPrediction.  # noqa: E501


        :return: The integration_id of this RegistrypredictionPrediction.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id):
        """Sets the integration_id of this RegistrypredictionPrediction.


        :param integration_id: The integration_id of this RegistrypredictionPrediction.  # noqa: E501
        :type: RimeUUID
        """

        self._integration_id = integration_id

    @property
    def pred_info(self):
        """Gets the pred_info of this RegistrypredictionPrediction.  # noqa: E501


        :return: The pred_info of this RegistrypredictionPrediction.  # noqa: E501
        :rtype: TestrunPredInfo
        """
        return self._pred_info

    @pred_info.setter
    def pred_info(self, pred_info):
        """Sets the pred_info of this RegistrypredictionPrediction.


        :param pred_info: The pred_info of this RegistrypredictionPrediction.  # noqa: E501
        :type: TestrunPredInfo
        """

        self._pred_info = pred_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RegistrypredictionPrediction, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RegistrypredictionPrediction):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
