import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a Fastly service
 *
 * @schema CfnS3Props
 */
export interface CfnS3Props {
    /**
     * The access key for your S3 account. Not required if iam_role is provided.
     *
     * @schema CfnS3Props#AccessKey
     */
    readonly accessKey?: string;
    /**
     * The access control list (ACL) specific request header
     *
     * @schema CfnS3Props#Acl
     */
    readonly acl?: string;
    /**
     * The bucket name for S3 account.
     *
     * @schema CfnS3Props#BucketName
     */
    readonly bucketName: string;
    /**
     * The codec used for compressing your logs.
     *
     * @schema CfnS3Props#CompressionCodec
     */
    readonly compressionCodec?: CfnS3PropsCompressionCodec;
    /**
     * The domain of the Amazon S3 endpoint.
     *
     * @schema CfnS3Props#Domain
     */
    readonly domain?: string;
    /**
     * A Fastly log format string.
     *
     * @schema CfnS3Props#Format
     */
    readonly format?: string;
    /**
     * The version of the custom logging format used for the configured endpoint.
     *
     * @schema CfnS3Props#FormatVersion
     */
    readonly formatVersion?: CfnS3PropsFormatVersion;
    /**
     * The level of gzip encoding when sending logs (default 0, no compression).
     *
     * @schema CfnS3Props#GzipLevel
     */
    readonly gzipLevel?: number;
    /**
     * The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if access_key and secret_key are provided.
     *
     * @schema CfnS3Props#IamRole
     */
    readonly iamRole?: string;
    /**
     * How the message should be formatted. [Default classic]
     *
     * @schema CfnS3Props#MessageType
     */
    readonly messageType?: CfnS3PropsMessageType;
    /**
     * The name for the real-time logging configuration.
     *
     * @schema CfnS3Props#Name
     */
    readonly name?: string;
    /**
     * The path to upload logs to.
     *
     * @schema CfnS3Props#Path
     */
    readonly path?: string;
    /**
     * How frequently log files are finalized so they can be available for reading (in seconds).
     *
     * @schema CfnS3Props#Period
     */
    readonly period?: number;
    /**
     * Where in the generated VCL the logging call should be placed.
     *
     * @schema CfnS3Props#Placement
     */
    readonly placement?: CfnS3PropsPlacement;
    /**
     * A PGP public key that Fastly will use to encrypt your log files before writing them to disk.
     *
     * @schema CfnS3Props#PublicKey
     */
    readonly publicKey?: string;
    /**
     * The S3 redundancy level
     *
     * @schema CfnS3Props#Redundancy
     */
    readonly redundancy?: string;
    /**
     * The name of an existing condition in the configured endpoint, or leave blank to always execute.
     *
     * @schema CfnS3Props#ResponseCondition
     */
    readonly responseCondition?: string;
    /**
     * The secret key for your S3 account. Not required if iam_role is provided.
     *
     * @schema CfnS3Props#SecretKey
     */
    readonly secretKey?: string;
    /**
     * Set this to AES256 or aws:kms to enable S3 Server Side Encryption.
     *
     * @schema CfnS3Props#ServerSideEncryption
     */
    readonly serverSideEncryption?: string;
    /**
     * Optional server-side KMS Key Id. Must be set if server_side_encryption is set to aws:kms or AES256.
     *
     * @schema CfnS3Props#ServerSideEncryptionKmsKeyId
     */
    readonly serverSideEncryptionKmsKeyId?: string;
    /**
     * Alphanumeric string identifying the service. Read-only.
     *
     * @schema CfnS3Props#ServiceId
     */
    readonly serviceId?: string;
    /**
     * Alphanumeric string identifying the service version.
     *
     * @schema CfnS3Props#VersionId
     */
    readonly versionId?: string;
    /**
     * Integer identifying a domain version. Read-only.
     *
     * @schema CfnS3Props#Version
     */
    readonly version?: string;
}
/**
 * Converts an object of type 'CfnS3Props' to JSON representation.
 */
export declare function toJson_CfnS3Props(obj: CfnS3Props | undefined): Record<string, any> | undefined;
/**
 * The codec used for compressing your logs.
 *
 * @schema CfnS3PropsCompressionCodec
 */
export declare enum CfnS3PropsCompressionCodec {
    /** zstd */
    ZSTD = "zstd",
    /** snappy */
    SNAPPY = "snappy",
    /** gzip */
    GZIP = "gzip"
}
/**
 * The version of the custom logging format used for the configured endpoint.
 *
 * @schema CfnS3PropsFormatVersion
 */
export declare enum CfnS3PropsFormatVersion {
    /** 1 */
    VALUE_1 = 1,
    /** 2 */
    VALUE_2 = 2
}
/**
 * How the message should be formatted. [Default classic]
 *
 * @schema CfnS3PropsMessageType
 */
export declare enum CfnS3PropsMessageType {
    /** classic */
    CLASSIC = "classic",
    /** loggly */
    LOGGLY = "loggly",
    /** logplex */
    LOGPLEX = "logplex",
    /** blank */
    BLANK = "blank"
}
/**
 * Where in the generated VCL the logging call should be placed.
 *
 * @schema CfnS3PropsPlacement
 */
export declare enum CfnS3PropsPlacement {
    /** none */
    NONE = "none",
    /** waf_debug */
    WAF_DEBUG = "waf_debug"
}
/**
 * A CloudFormation `Fastly::Logging::S3`
 *
 * @cloudformationResource Fastly::Logging::S3
 * @stability external
 * @link https://developer.fastly.com/reference/api/logging/s3/
 */
export declare class CfnS3 extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Fastly::Logging::S3";
    /**
     * Resource props.
     */
    readonly props: CfnS3Props;
    /**
     * Attribute `Fastly::Logging::S3.CreatedAt`
     * @link https://developer.fastly.com/reference/api/logging/s3/
     */
    readonly attrCreatedAt: string;
    /**
     * Attribute `Fastly::Logging::S3.DeletedAt`
     * @link https://developer.fastly.com/reference/api/logging/s3/
     */
    readonly attrDeletedAt: string;
    /**
     * Attribute `Fastly::Logging::S3.UpdatedAt`
     * @link https://developer.fastly.com/reference/api/logging/s3/
     */
    readonly attrUpdatedAt: string;
    /**
     * Create a new `Fastly::Logging::S3`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnS3Props);
}
