"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnS3 = exports.CfnS3PropsPlacement = exports.CfnS3PropsMessageType = exports.CfnS3PropsFormatVersion = exports.CfnS3PropsCompressionCodec = exports.toJson_CfnS3Props = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnS3Props' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnS3Props(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccessKey': obj.accessKey,
        'Acl': obj.acl,
        'BucketName': obj.bucketName,
        'CompressionCodec': obj.compressionCodec,
        'Domain': obj.domain,
        'Format': obj.format,
        'FormatVersion': obj.formatVersion,
        'GzipLevel': obj.gzipLevel,
        'IamRole': obj.iamRole,
        'MessageType': obj.messageType,
        'Name': obj.name,
        'Path': obj.path,
        'Period': obj.period,
        'Placement': obj.placement,
        'PublicKey': obj.publicKey,
        'Redundancy': obj.redundancy,
        'ResponseCondition': obj.responseCondition,
        'SecretKey': obj.secretKey,
        'ServerSideEncryption': obj.serverSideEncryption,
        'ServerSideEncryptionKmsKeyId': obj.serverSideEncryptionKmsKeyId,
        'ServiceId': obj.serviceId,
        'VersionId': obj.versionId,
        'Version': obj.version,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnS3Props = toJson_CfnS3Props;
/* eslint-enable max-len, quote-props */
/**
 * The codec used for compressing your logs.
 *
 * @schema CfnS3PropsCompressionCodec
 */
var CfnS3PropsCompressionCodec;
(function (CfnS3PropsCompressionCodec) {
    /** zstd */
    CfnS3PropsCompressionCodec["ZSTD"] = "zstd";
    /** snappy */
    CfnS3PropsCompressionCodec["SNAPPY"] = "snappy";
    /** gzip */
    CfnS3PropsCompressionCodec["GZIP"] = "gzip";
})(CfnS3PropsCompressionCodec = exports.CfnS3PropsCompressionCodec || (exports.CfnS3PropsCompressionCodec = {}));
/**
 * The version of the custom logging format used for the configured endpoint.
 *
 * @schema CfnS3PropsFormatVersion
 */
var CfnS3PropsFormatVersion;
(function (CfnS3PropsFormatVersion) {
    /** 1 */
    CfnS3PropsFormatVersion[CfnS3PropsFormatVersion["VALUE_1"] = 1] = "VALUE_1";
    /** 2 */
    CfnS3PropsFormatVersion[CfnS3PropsFormatVersion["VALUE_2"] = 2] = "VALUE_2";
})(CfnS3PropsFormatVersion = exports.CfnS3PropsFormatVersion || (exports.CfnS3PropsFormatVersion = {}));
/**
 * How the message should be formatted. [Default classic]
 *
 * @schema CfnS3PropsMessageType
 */
var CfnS3PropsMessageType;
(function (CfnS3PropsMessageType) {
    /** classic */
    CfnS3PropsMessageType["CLASSIC"] = "classic";
    /** loggly */
    CfnS3PropsMessageType["LOGGLY"] = "loggly";
    /** logplex */
    CfnS3PropsMessageType["LOGPLEX"] = "logplex";
    /** blank */
    CfnS3PropsMessageType["BLANK"] = "blank";
})(CfnS3PropsMessageType = exports.CfnS3PropsMessageType || (exports.CfnS3PropsMessageType = {}));
/**
 * Where in the generated VCL the logging call should be placed.
 *
 * @schema CfnS3PropsPlacement
 */
var CfnS3PropsPlacement;
(function (CfnS3PropsPlacement) {
    /** none */
    CfnS3PropsPlacement["NONE"] = "none";
    /** waf_debug */
    CfnS3PropsPlacement["WAF_DEBUG"] = "waf_debug";
})(CfnS3PropsPlacement = exports.CfnS3PropsPlacement || (exports.CfnS3PropsPlacement = {}));
/**
 * A CloudFormation `Fastly::Logging::S3`
 *
 * @cloudformationResource Fastly::Logging::S3
 * @stability external
 * @link https://developer.fastly.com/reference/api/logging/s3/
 */
class CfnS3 extends cdk.CfnResource {
    /**
     * Create a new `Fastly::Logging::S3`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnS3.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnS3Props(props) });
        this.props = props;
        this.attrCreatedAt = cdk.Token.asString(this.getAtt('CreatedAt'));
        this.attrDeletedAt = cdk.Token.asString(this.getAtt('DeletedAt'));
        this.attrUpdatedAt = cdk.Token.asString(this.getAtt('UpdatedAt'));
    }
}
exports.CfnS3 = CfnS3;
_a = JSII_RTTI_SYMBOL_1;
CfnS3[_a] = { fqn: "@cdk-cloudformation/fastly-logging-s3.CfnS3", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnS3.CFN_RESOURCE_TYPE_NAME = "Fastly::Logging::S3";
//# sourceMappingURL=data:application/json;base64,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