/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ncx;

import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;

public class NCXHandler
implements XMLHandler {
    private final XMLParser parser;
    private final String path;
    private final XRefChecker xrefChecker;
    String uid;
    boolean checkedUnsupportedXmlVersion = false;

    NCXHandler(XMLParser parser, String path, XRefChecker xrefChecker) {
        this.parser = parser;
        this.path = path;
        this.xrefChecker = xrefChecker;
    }

    @Override
    public void characters(char[] chars, int start, int len) {
        boolean keepValue;
        XMLElement e = this.parser.getCurrentElement();
        String name = e.getName();
        String ns = e.getNamespace();
        boolean bl = keepValue = "http://www.daisy.org/z3986/2005/ncx/".equals(ns) && "text".equals(name);
        if (keepValue) {
            String val = (String)e.getPrivateData();
            String text = new String(chars, start, len);
            e.setPrivateData(val == null ? text : val + text);
        }
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void startElement() {
        if (!this.checkedUnsupportedXmlVersion) {
            HandlerUtil.checkXMLVersion(this.parser);
            this.checkedUnsupportedXmlVersion = true;
        }
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        if (ns.equals("http://www.daisy.org/z3986/2005/ncx/")) {
            String metaName;
            if ("content".equals(name)) {
                String href = e.getAttribute("src");
                if (href != null) {
                    if ((href = PathUtil.resolveRelativeReference(this.path, href)).startsWith("http:")) {
                        this.parser.getReport().info(this.path, FeatureEnum.REFERENCE, href);
                    }
                    this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, XRefChecker.Type.HYPERLINK);
                }
            } else if ("meta".equals(name) && "dtb:uid".equals(metaName = e.getAttribute("name"))) {
                this.uid = e.getAttribute("content");
            }
        }
    }

    @Override
    public void endElement() {
        String text;
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        if (ns.equals("http://www.daisy.org/z3986/2005/ncx/") && "text".equals(name) && ((text = (String)e.getPrivateData()) == null || text.trim().isEmpty())) {
            this.parser.getReport().message(MessageId.NCX_006, this.parser.getLocation(), new Object[0]);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }

    public String getUid() {
        return this.uid;
    }
}

