"""
Harissa
=======

Gene regulatory network inference from single-cell data
-------------------------------------------------------

Mechanistic model-based gene network inference using
a self-consistent proteomic field (SCPF) approximation.
It is analogous to the unrestricted Hartree approximation
in quantum mechanics, applied to gene expression modeled
as a piecewise-deterministic Markov process (PDMP).

The package also includes a simulation module to generate
single-cell data with transcriptional bursting.

Author: Ulysse Herbach (ulysse.herbach@inria.fr)
"""
__version__ = '3.0.5'

from .model import NetworkModel, Cascade, Tree

__all__ = ['NetworkModel', 'Cascade', 'Tree']
