"""Make some required fields not nullable

Revision ID: 5be555fe9dc0
Revises: 5686f64a46c8
Create Date: 2020-10-29 15:12:53.172977

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects.postgresql import JSONB


# revision identifiers, used by Alembic.
revision = "5be555fe9dc0"
down_revision = "5686f64a46c8"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("grid_optimization_procedure", "initial_molecule", existing_type=sa.INTEGER(), nullable=False)
    op.alter_column("optimization_procedure", "initial_molecule", existing_type=sa.INTEGER(), nullable=False)
    op.alter_column("base_result", "procedure", existing_type=sa.VARCHAR(length=100), nullable=False)
    op.alter_column("base_result", "protocols", existing_type=JSONB(astext_type=sa.Text()), nullable=False)
    op.alter_column("result", "molecule", existing_type=sa.INTEGER(), nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("base_result", "protocols", existing_type=JSONB(astext_type=sa.Text()), nullable=True)
    op.alter_column("base_result", "procedure", existing_type=sa.VARCHAR(length=100), nullable=True)
    op.alter_column("result", "molecule", existing_type=sa.INTEGER(), nullable=True)
    op.alter_column("optimization_procedure", "initial_molecule", existing_type=sa.INTEGER(), nullable=True)
    op.alter_column("grid_optimization_procedure", "initial_molecule", existing_type=sa.INTEGER(), nullable=True)
    # ### end Alembic commands ###
