"use strict";
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-08-27T08:14:58.319Z","fingerprint":"0/Xa6A4sYUktWZyZXcxiy0GMp+LtQNdHzjkMNSMeGi4="}
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnSimpleAD = exports.CfnMicrosoftAD = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnMicrosoftADProps`
 *
 * @param properties - the TypeScript properties of a `CfnMicrosoftADProps`
 *
 * @returns the result of the validation.
 */
function CfnMicrosoftADPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('createAlias', cdk.validateBoolean)(properties.createAlias));
    errors.collect(cdk.propertyValidator('edition', cdk.validateString)(properties.edition));
    errors.collect(cdk.propertyValidator('enableSso', cdk.validateBoolean)(properties.enableSso));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('password', cdk.requiredValidator)(properties.password));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('shortName', cdk.validateString)(properties.shortName));
    errors.collect(cdk.propertyValidator('vpcSettings', cdk.requiredValidator)(properties.vpcSettings));
    errors.collect(cdk.propertyValidator('vpcSettings', CfnMicrosoftAD_VpcSettingsPropertyValidator)(properties.vpcSettings));
    return errors.wrap('supplied properties not correct for "CfnMicrosoftADProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DirectoryService::MicrosoftAD` resource
 *
 * @param properties - the TypeScript properties of a `CfnMicrosoftADProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DirectoryService::MicrosoftAD` resource.
 */
// @ts-ignore TS6133
function cfnMicrosoftADPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMicrosoftADPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Password: cdk.stringToCloudFormation(properties.password),
        VpcSettings: cfnMicrosoftADVpcSettingsPropertyToCloudFormation(properties.vpcSettings),
        CreateAlias: cdk.booleanToCloudFormation(properties.createAlias),
        Edition: cdk.stringToCloudFormation(properties.edition),
        EnableSso: cdk.booleanToCloudFormation(properties.enableSso),
        ShortName: cdk.stringToCloudFormation(properties.shortName),
    };
}
// @ts-ignore TS6133
function CfnMicrosoftADPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        name: cfn_parse.FromCloudFormation.getString(properties.Name),
        password: cfn_parse.FromCloudFormation.getString(properties.Password),
        vpcSettings: CfnMicrosoftADVpcSettingsPropertyFromCloudFormation(properties.VpcSettings),
        createAlias: properties.CreateAlias != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CreateAlias) : undefined,
        edition: properties.Edition != null ? cfn_parse.FromCloudFormation.getString(properties.Edition) : undefined,
        enableSso: properties.EnableSso != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableSso) : undefined,
        shortName: properties.ShortName != null ? cfn_parse.FromCloudFormation.getString(properties.ShortName) : undefined,
    };
}
/**
 * A CloudFormation `AWS::DirectoryService::MicrosoftAD`
 *
 * @cloudformationResource AWS::DirectoryService::MicrosoftAD
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html
 */
class CfnMicrosoftAD extends cdk.CfnResource {
    /**
     * Create a new `AWS::DirectoryService::MicrosoftAD`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMicrosoftAD.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'password', this);
        cdk.requireProperty(props, 'vpcSettings', this);
        this.attrAlias = cdk.Token.asString(this.getAtt('Alias'));
        this.attrDnsIpAddresses = cdk.Token.asList(this.getAtt('DnsIpAddresses'));
        this.name = props.name;
        this.password = props.password;
        this.vpcSettings = props.vpcSettings;
        this.createAlias = props.createAlias;
        this.edition = props.edition;
        this.enableSso = props.enableSso;
        this.shortName = props.shortName;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const props = CfnMicrosoftADPropsFromCloudFormation(resourceProperties);
        const ret = new CfnMicrosoftAD(scope, id, props);
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMicrosoftAD.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            password: this.password,
            vpcSettings: this.vpcSettings,
            createAlias: this.createAlias,
            edition: this.edition,
            enableSso: this.enableSso,
            shortName: this.shortName,
        };
    }
    renderProperties(props) {
        return cfnMicrosoftADPropsToCloudFormation(props);
    }
}
exports.CfnMicrosoftAD = CfnMicrosoftAD;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMicrosoftAD.CFN_RESOURCE_TYPE_NAME = "AWS::DirectoryService::MicrosoftAD";
/**
 * Determine whether the given properties match those of a `VpcSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `VpcSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnMicrosoftAD_VpcSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('vpcId', cdk.requiredValidator)(properties.vpcId));
    errors.collect(cdk.propertyValidator('vpcId', cdk.validateString)(properties.vpcId));
    return errors.wrap('supplied properties not correct for "VpcSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DirectoryService::MicrosoftAD.VpcSettings` resource
 *
 * @param properties - the TypeScript properties of a `VpcSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DirectoryService::MicrosoftAD.VpcSettings` resource.
 */
// @ts-ignore TS6133
function cfnMicrosoftADVpcSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMicrosoftAD_VpcSettingsPropertyValidator(properties).assertSuccess();
    return {
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        VpcId: cdk.stringToCloudFormation(properties.vpcId),
    };
}
// @ts-ignore TS6133
function CfnMicrosoftADVpcSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        subnetIds: cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds),
        vpcId: cfn_parse.FromCloudFormation.getString(properties.VpcId),
    };
}
/**
 * Determine whether the given properties match those of a `CfnSimpleADProps`
 *
 * @param properties - the TypeScript properties of a `CfnSimpleADProps`
 *
 * @returns the result of the validation.
 */
function CfnSimpleADPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('createAlias', cdk.validateBoolean)(properties.createAlias));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enableSso', cdk.validateBoolean)(properties.enableSso));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('password', cdk.requiredValidator)(properties.password));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('shortName', cdk.validateString)(properties.shortName));
    errors.collect(cdk.propertyValidator('size', cdk.requiredValidator)(properties.size));
    errors.collect(cdk.propertyValidator('size', cdk.validateString)(properties.size));
    errors.collect(cdk.propertyValidator('vpcSettings', cdk.requiredValidator)(properties.vpcSettings));
    errors.collect(cdk.propertyValidator('vpcSettings', CfnSimpleAD_VpcSettingsPropertyValidator)(properties.vpcSettings));
    return errors.wrap('supplied properties not correct for "CfnSimpleADProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DirectoryService::SimpleAD` resource
 *
 * @param properties - the TypeScript properties of a `CfnSimpleADProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DirectoryService::SimpleAD` resource.
 */
// @ts-ignore TS6133
function cfnSimpleADPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnSimpleADPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Password: cdk.stringToCloudFormation(properties.password),
        Size: cdk.stringToCloudFormation(properties.size),
        VpcSettings: cfnSimpleADVpcSettingsPropertyToCloudFormation(properties.vpcSettings),
        CreateAlias: cdk.booleanToCloudFormation(properties.createAlias),
        Description: cdk.stringToCloudFormation(properties.description),
        EnableSso: cdk.booleanToCloudFormation(properties.enableSso),
        ShortName: cdk.stringToCloudFormation(properties.shortName),
    };
}
// @ts-ignore TS6133
function CfnSimpleADPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        name: cfn_parse.FromCloudFormation.getString(properties.Name),
        password: cfn_parse.FromCloudFormation.getString(properties.Password),
        size: cfn_parse.FromCloudFormation.getString(properties.Size),
        vpcSettings: CfnSimpleADVpcSettingsPropertyFromCloudFormation(properties.VpcSettings),
        createAlias: properties.CreateAlias != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CreateAlias) : undefined,
        description: properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined,
        enableSso: properties.EnableSso != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableSso) : undefined,
        shortName: properties.ShortName != null ? cfn_parse.FromCloudFormation.getString(properties.ShortName) : undefined,
    };
}
/**
 * A CloudFormation `AWS::DirectoryService::SimpleAD`
 *
 * @cloudformationResource AWS::DirectoryService::SimpleAD
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html
 */
class CfnSimpleAD extends cdk.CfnResource {
    /**
     * Create a new `AWS::DirectoryService::SimpleAD`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnSimpleAD.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'password', this);
        cdk.requireProperty(props, 'size', this);
        cdk.requireProperty(props, 'vpcSettings', this);
        this.attrAlias = cdk.Token.asString(this.getAtt('Alias'));
        this.attrDnsIpAddresses = cdk.Token.asList(this.getAtt('DnsIpAddresses'));
        this.name = props.name;
        this.password = props.password;
        this.size = props.size;
        this.vpcSettings = props.vpcSettings;
        this.createAlias = props.createAlias;
        this.description = props.description;
        this.enableSso = props.enableSso;
        this.shortName = props.shortName;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const props = CfnSimpleADPropsFromCloudFormation(resourceProperties);
        const ret = new CfnSimpleAD(scope, id, props);
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnSimpleAD.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            password: this.password,
            size: this.size,
            vpcSettings: this.vpcSettings,
            createAlias: this.createAlias,
            description: this.description,
            enableSso: this.enableSso,
            shortName: this.shortName,
        };
    }
    renderProperties(props) {
        return cfnSimpleADPropsToCloudFormation(props);
    }
}
exports.CfnSimpleAD = CfnSimpleAD;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnSimpleAD.CFN_RESOURCE_TYPE_NAME = "AWS::DirectoryService::SimpleAD";
/**
 * Determine whether the given properties match those of a `VpcSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `VpcSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnSimpleAD_VpcSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('vpcId', cdk.requiredValidator)(properties.vpcId));
    errors.collect(cdk.propertyValidator('vpcId', cdk.validateString)(properties.vpcId));
    return errors.wrap('supplied properties not correct for "VpcSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DirectoryService::SimpleAD.VpcSettings` resource
 *
 * @param properties - the TypeScript properties of a `VpcSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DirectoryService::SimpleAD.VpcSettings` resource.
 */
// @ts-ignore TS6133
function cfnSimpleADVpcSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnSimpleAD_VpcSettingsPropertyValidator(properties).assertSuccess();
    return {
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        VpcId: cdk.stringToCloudFormation(properties.vpcId),
    };
}
// @ts-ignore TS6133
function CfnSimpleADVpcSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        subnetIds: cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds),
        vpcId: cfn_parse.FromCloudFormation.getString(properties.VpcId),
    };
}
//# sourceMappingURL=data:application/json;base64,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