# talos-aclient
FastAPI Best Architecture

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 1.6.0
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import talos_aclient
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import talos_aclient
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import talos_aclient
from talos_aclient.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = talos_aclient.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with talos_aclient.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = talos_aclient.CredentialsApi(api_client)
    create_credentials_request = talos_aclient.CreateCredentialsRequest() # CreateCredentialsRequest | 

    try:
        # Create
        api_response = await api_instance.create(create_credentials_request)
        print("The response of CredentialsApi->create:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CredentialsApi->create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CredentialsApi* | [**create**](docs/CredentialsApi.md#create) | **POST** /v1/talos/credentials/create | Create
*CredentialsApi* | [**get**](docs/CredentialsApi.md#get) | **GET** /v1/talos/credentials/get | Get
*DatasetApi* | [**add_resource**](docs/DatasetApi.md#add_resource) | **POST** /v1/talos/dataset/add_resource | Add Resource
*DatasetApi* | [**batch_add_resources**](docs/DatasetApi.md#batch_add_resources) | **POST** /v1/talos/dataset/batch_add_resources | Batch Add Resources
*DatasetApi* | [**clone_dataset**](docs/DatasetApi.md#clone_dataset) | **POST** /v1/talos/dataset/clone | Clone Dataset
*DatasetApi* | [**create_dataset**](docs/DatasetApi.md#create_dataset) | **POST** /v1/talos/dataset/create | Create Dataset
*DatasetApi* | [**delete_dataset**](docs/DatasetApi.md#delete_dataset) | **POST** /v1/talos/dataset/delete | Delete Dataset
*DatasetApi* | [**delete_dataset_resource**](docs/DatasetApi.md#delete_dataset_resource) | **POST** /v1/talos/dataset/delete_resource | Delete Dataset Resource
*DatasetApi* | [**enable_dataset_resource**](docs/DatasetApi.md#enable_dataset_resource) | **POST** /v1/talos/dataset/enable_resource | Enable Dataset Resource
*DatasetApi* | [**enable_model**](docs/DatasetApi.md#enable_model) | **POST** /v1/talos/dataset/enable_model | Enable Model
*DatasetApi* | [**get_dataset**](docs/DatasetApi.md#get_dataset) | **POST** /v1/talos/dataset/get | 获取数据集详情
*DatasetApi* | [**get_dataset_resource**](docs/DatasetApi.md#get_dataset_resource) | **POST** /v1/talos/dataset/get_resource | Get Dataset Resource
*DatasetApi* | [**list_dataset**](docs/DatasetApi.md#list_dataset) | **POST** /v1/talos/dataset/list | List Dataset
*DatasetApi* | [**list_resources**](docs/DatasetApi.md#list_resources) | **POST** /v1/talos/dataset/list_resources | List Resources
*DatasetApi* | [**list_rows**](docs/DatasetApi.md#list_rows) | **POST** /v1/talos/dataset/list_rows | List Rows
*DatasetApi* | [**merge_dataset_graph**](docs/DatasetApi.md#merge_dataset_graph) | **POST** /v1/talos/dataset/merge_dataset_graph | Merge Dataset Graph
*DatasetApi* | [**merge_resource_graph**](docs/DatasetApi.md#merge_resource_graph) | **POST** /v1/talos/dataset/merge_resource_graph | Merge Resource Graph
*DatasetApi* | [**migrate_resources**](docs/DatasetApi.md#migrate_resources) | **POST** /v1/talos/dataset/migrate_resources | Migrate Resources
*DatasetApi* | [**refresh_dataset**](docs/DatasetApi.md#refresh_dataset) | **POST** /v1/talos/dataset/refresh | Refresh Dataset
*DatasetApi* | [**refresh_resource**](docs/DatasetApi.md#refresh_resource) | **POST** /v1/talos/dataset/refresh_resource | Refresh Resource
*DatasetApi* | [**search_resource_by_meta**](docs/DatasetApi.md#search_resource_by_meta) | **POST** /v1/talos/dataset/search_resource_by_meta | Search Resource By Meta
*DatasetApi* | [**update_dataset**](docs/DatasetApi.md#update_dataset) | **POST** /v1/talos/dataset/update | Update Dataset
*DatasetApi* | [**update_dataset_resource**](docs/DatasetApi.md#update_dataset_resource) | **POST** /v1/talos/dataset/update_resource | Update Dataset Resource
*DatasetApi* | [**update_resource_meta**](docs/DatasetApi.md#update_resource_meta) | **POST** /v1/talos/dataset/update_resource_meta | Update Resource Meta
*DefaultApi* | [**health**](docs/DefaultApi.md#health) | **GET** /health | Health
*GraphApi* | [**count_edge**](docs/GraphApi.md#count_edge) | **POST** /v1/talos/graph/edge/count | Count Edge
*GraphApi* | [**count_node**](docs/GraphApi.md#count_node) | **POST** /v1/talos/graph/node/count | Count Node
*GraphApi* | [**create_edge**](docs/GraphApi.md#create_edge) | **POST** /v1/talos/graph/edge/create | Create Edge
*GraphApi* | [**create_node**](docs/GraphApi.md#create_node) | **POST** /v1/talos/graph/node/create | Create Node
*GraphApi* | [**delete_edge**](docs/GraphApi.md#delete_edge) | **POST** /v1/talos/graph/edge/delete | Delete Edge
*GraphApi* | [**delete_node**](docs/GraphApi.md#delete_node) | **POST** /v1/talos/graph/node/delete | Delete Node
*GraphApi* | [**detect_community**](docs/GraphApi.md#detect_community) | **POST** /v1/talos/graph/community/detect | Detect Community
*GraphApi* | [**get_edge**](docs/GraphApi.md#get_edge) | **POST** /v1/talos/graph/edge/get | Get Edge
*GraphApi* | [**get_node**](docs/GraphApi.md#get_node) | **POST** /v1/talos/graph/node/get | Get Node
*GraphApi* | [**list_edge**](docs/GraphApi.md#list_edge) | **POST** /v1/talos/graph/edge/list | List Edge
*GraphApi* | [**list_node**](docs/GraphApi.md#list_node) | **POST** /v1/talos/graph/node/list | List Node
*GraphApi* | [**list_subgraph_edge**](docs/GraphApi.md#list_subgraph_edge) | **POST** /v1/talos/graph/subgraph/edge/list | List Subgraph Edge
*GraphApi* | [**list_subgraph_node**](docs/GraphApi.md#list_subgraph_node) | **POST** /v1/talos/graph/subgraph/node/list | List Subgraph Node
*GraphApi* | [**merge_node**](docs/GraphApi.md#merge_node) | **POST** /v1/talos/graph/node/merge | Merge Node
*GraphApi* | [**mget_edge**](docs/GraphApi.md#mget_edge) | **POST** /v1/talos/graph/edge/mget | Mget Edge
*GraphApi* | [**mget_node**](docs/GraphApi.md#mget_node) | **POST** /v1/talos/graph/node/mget | Mget Node
*GraphApi* | [**run_cypher**](docs/GraphApi.md#run_cypher) | **POST** /v1/talos/graph/cypher/run | Run Cypher
*GraphApi* | [**update_edge**](docs/GraphApi.md#update_edge) | **POST** /v1/talos/graph/edge/update | Update Edge
*GraphApi* | [**update_node**](docs/GraphApi.md#update_node) | **POST** /v1/talos/graph/node/update | Update Node
*ModelApi* | [**upsert_model**](docs/ModelApi.md#upsert_model) | **POST** /v1/talos/model/upsert | Upsert Model
*OntologyApi* | [**create_entity**](docs/OntologyApi.md#create_entity) | **POST** /v1/talos/ontology/entity/create | Create Entity
*OntologyApi* | [**create_ontology**](docs/OntologyApi.md#create_ontology) | **POST** /v1/talos/ontology/create | Create Ontology
*OntologyApi* | [**create_relation**](docs/OntologyApi.md#create_relation) | **POST** /v1/talos/ontology/relation/create | Create Relation
*OntologyApi* | [**delete_entity**](docs/OntologyApi.md#delete_entity) | **POST** /v1/talos/ontology/entity/delete | Delete Entity
*OntologyApi* | [**delete_relation**](docs/OntologyApi.md#delete_relation) | **POST** /v1/talos/ontology/relation/delete | Delete Relation
*OntologyApi* | [**get_ontology**](docs/OntologyApi.md#get_ontology) | **POST** /v1/talos/ontology/get | Get Ontology
*OntologyApi* | [**list_entity**](docs/OntologyApi.md#list_entity) | **POST** /v1/talos/ontology/entity/list | List Entity
*OntologyApi* | [**list_relation**](docs/OntologyApi.md#list_relation) | **POST** /v1/talos/ontology/relation/list | List Relation
*OntologyApi* | [**update_entity**](docs/OntologyApi.md#update_entity) | **POST** /v1/talos/ontology/entity/update | Update Entity
*OntologyApi* | [**update_relation**](docs/OntologyApi.md#update_relation) | **POST** /v1/talos/ontology/relation/update | Update Relation
*ResourceApi* | [**create_resource**](docs/ResourceApi.md#create_resource) | **POST** /v1/talos/resource/create | Create Resource
*ResourceApi* | [**delete_resource**](docs/ResourceApi.md#delete_resource) | **POST** /v1/talos/resource/delete | Delete Resource
*ResourceApi* | [**get_resource**](docs/ResourceApi.md#get_resource) | **POST** /v1/talos/resource/get | Get Resource
*ResourceApi* | [**get_resource_image**](docs/ResourceApi.md#get_resource_image) | **POST** /v1/talos/resource/get_image | Get Resource Image
*SegmentApi* | [**add_hit**](docs/SegmentApi.md#add_hit) | **POST** /v1/talos/segment/add_hit | Add Hit
*SegmentApi* | [**add_segment**](docs/SegmentApi.md#add_segment) | **POST** /v1/talos/segment/add | Add Segment
*SegmentApi* | [**batch_add_segments**](docs/SegmentApi.md#batch_add_segments) | **POST** /v1/talos/segment/batch_add | Batch Add Segments
*SegmentApi* | [**delete_segment**](docs/SegmentApi.md#delete_segment) | **POST** /v1/talos/segment/delete | Delete Segment
*SegmentApi* | [**expand**](docs/SegmentApi.md#expand) | **POST** /v1/talos/segment/expand | Expand
*SegmentApi* | [**get_segment**](docs/SegmentApi.md#get_segment) | **POST** /v1/talos/segment/get | Get Segment
*SegmentApi* | [**list_segments**](docs/SegmentApi.md#list_segments) | **POST** /v1/talos/segment/list | List Segments
*SegmentApi* | [**merge**](docs/SegmentApi.md#merge) | **POST** /v1/talos/segment/merge | Merge
*SegmentApi* | [**migrate_segments**](docs/SegmentApi.md#migrate_segments) | **POST** /v1/talos/segment/migrate | Migrate Segments
*SegmentApi* | [**update_segment**](docs/SegmentApi.md#update_segment) | **POST** /v1/talos/segment/update | Update Segment
*TaskApi* | [**add_task**](docs/TaskApi.md#add_task) | **POST** /v1/talos/task/add | Add Task
*TaskApi* | [**list_tasks**](docs/TaskApi.md#list_tasks) | **POST** /v1/talos/task/list | List Tasks
*VectorApi* | [**vector_retrieve**](docs/VectorApi.md#vector_retrieve) | **POST** /v1/talos/vector/retrieve | Vector Retrieve


## Documentation For Models

 - [APIKeyLocation](docs/APIKeyLocation.md)
 - [AddHitRequest](docs/AddHitRequest.md)
 - [AddResourceToDatasetRequest](docs/AddResourceToDatasetRequest.md)
 - [AddSegmentRequest](docs/AddSegmentRequest.md)
 - [AddSegmentResponse](docs/AddSegmentResponse.md)
 - [AddTaskRequest](docs/AddTaskRequest.md)
 - [AppTalosSchemaDatasetGetResourceRequest](docs/AppTalosSchemaDatasetGetResourceRequest.md)
 - [AppTalosSchemaDatasetGraphMetadata](docs/AppTalosSchemaDatasetGraphMetadata.md)
 - [AppTalosSchemaGraphGraphMetadata](docs/AppTalosSchemaGraphGraphMetadata.md)
 - [AppTalosSchemaResourceGetResourceRequest](docs/AppTalosSchemaResourceGetResourceRequest.md)
 - [AppTalosSchemaResourceGraphMetadata](docs/AppTalosSchemaResourceGraphMetadata.md)
 - [AuthAPIKey](docs/AuthAPIKey.md)
 - [AuthBasic](docs/AuthBasic.md)
 - [AuthOauth2](docs/AuthOauth2.md)
 - [AuthType](docs/AuthType.md)
 - [AutoContextConfig](docs/AutoContextConfig.md)
 - [BatchAddDatasetResourcesResponse](docs/BatchAddDatasetResourcesResponse.md)
 - [BatchAddResourcesToDatasetRequest](docs/BatchAddResourcesToDatasetRequest.md)
 - [BatchAddSegmentsRequest](docs/BatchAddSegmentsRequest.md)
 - [BatchAddSegmentsResponse](docs/BatchAddSegmentsResponse.md)
 - [BatchExtractorConfig](docs/BatchExtractorConfig.md)
 - [CleanConfig](docs/CleanConfig.md)
 - [CloneDatasetRequest](docs/CloneDatasetRequest.md)
 - [Column](docs/Column.md)
 - [CommunityDetectRequest](docs/CommunityDetectRequest.md)
 - [CommunityDetectResponse](docs/CommunityDetectResponse.md)
 - [ConditionGroup](docs/ConditionGroup.md)
 - [Config](docs/Config.md)
 - [Config1](docs/Config1.md)
 - [Config2](docs/Config2.md)
 - [CountEdgeRequest](docs/CountEdgeRequest.md)
 - [CountEdgeResponse](docs/CountEdgeResponse.md)
 - [CountNodeRequest](docs/CountNodeRequest.md)
 - [CountNodeResponse](docs/CountNodeResponse.md)
 - [CreateCredentialsRequest](docs/CreateCredentialsRequest.md)
 - [CreateCredentialsResponse](docs/CreateCredentialsResponse.md)
 - [CreateCredentialsResponseItem](docs/CreateCredentialsResponseItem.md)
 - [CreateDatasetRequest](docs/CreateDatasetRequest.md)
 - [CreateDatasetResponse](docs/CreateDatasetResponse.md)
 - [CreateDatasetResponseItem](docs/CreateDatasetResponseItem.md)
 - [CreateEdge](docs/CreateEdge.md)
 - [CreateEdgeRequest](docs/CreateEdgeRequest.md)
 - [CreateEdgeResponse](docs/CreateEdgeResponse.md)
 - [CreateEdgeResponseItem](docs/CreateEdgeResponseItem.md)
 - [CreateEntity](docs/CreateEntity.md)
 - [CreateEntityRequest](docs/CreateEntityRequest.md)
 - [CreateEntityResponse](docs/CreateEntityResponse.md)
 - [CreateEntityResponseItem](docs/CreateEntityResponseItem.md)
 - [CreateNode](docs/CreateNode.md)
 - [CreateNodeRequest](docs/CreateNodeRequest.md)
 - [CreateNodeResponse](docs/CreateNodeResponse.md)
 - [CreateNodeResponseItem](docs/CreateNodeResponseItem.md)
 - [CreateOntologyRequest](docs/CreateOntologyRequest.md)
 - [CreateRelation](docs/CreateRelation.md)
 - [CreateRelationRequest](docs/CreateRelationRequest.md)
 - [CreateRelationResponse](docs/CreateRelationResponse.md)
 - [CreateRelationResponseItem](docs/CreateRelationResponseItem.md)
 - [CreateResourceRequest](docs/CreateResourceRequest.md)
 - [CreateResourceRespItem](docs/CreateResourceRespItem.md)
 - [CreateResourceResponse](docs/CreateResourceResponse.md)
 - [CreateSegmentRespItem](docs/CreateSegmentRespItem.md)
 - [Credentials](docs/Credentials.md)
 - [CredentialsDataLark](docs/CredentialsDataLark.md)
 - [CredentialsStatus](docs/CredentialsStatus.md)
 - [CredentialsType](docs/CredentialsType.md)
 - [Data](docs/Data.md)
 - [DataType](docs/DataType.md)
 - [DatabaseSegmentsFilter](docs/DatabaseSegmentsFilter.md)
 - [Dataset](docs/Dataset.md)
 - [DatasetResourceGraphArgs](docs/DatasetResourceGraphArgs.md)
 - [DatasetResourceIndexConfig](docs/DatasetResourceIndexConfig.md)
 - [DatasetType](docs/DatasetType.md)
 - [DeleteDatasetRequest](docs/DeleteDatasetRequest.md)
 - [DeleteDatasetResourceRequest](docs/DeleteDatasetResourceRequest.md)
 - [DeleteEdgeRequest](docs/DeleteEdgeRequest.md)
 - [DeleteEntityRequest](docs/DeleteEntityRequest.md)
 - [DeleteNodeRequest](docs/DeleteNodeRequest.md)
 - [DeleteRelationRequest](docs/DeleteRelationRequest.md)
 - [DeleteResourcesRequest](docs/DeleteResourcesRequest.md)
 - [DeleteSegmentRequest](docs/DeleteSegmentRequest.md)
 - [DocumentMetadata](docs/DocumentMetadata.md)
 - [DocumentType](docs/DocumentType.md)
 - [Edge](docs/Edge.md)
 - [ElasticsearchAnalyzer](docs/ElasticsearchAnalyzer.md)
 - [ElasticsearchArgs](docs/ElasticsearchArgs.md)
 - [EnableModelRequest](docs/EnableModelRequest.md)
 - [EnableResourceRequest](docs/EnableResourceRequest.md)
 - [Entity](docs/Entity.md)
 - [EnumCeleryQueue](docs/EnumCeleryQueue.md)
 - [EnumModelProvider](docs/EnumModelProvider.md)
 - [EnumModelRole](docs/EnumModelRole.md)
 - [ExpandSegmentRequest](docs/ExpandSegmentRequest.md)
 - [ExpandSegmentsResponse](docs/ExpandSegmentsResponse.md)
 - [ExtractorConfig](docs/ExtractorConfig.md)
 - [Format](docs/Format.md)
 - [GetCredentialsRequest](docs/GetCredentialsRequest.md)
 - [GetCredentialsResponse](docs/GetCredentialsResponse.md)
 - [GetDatasetRequest](docs/GetDatasetRequest.md)
 - [GetDatasetResponse](docs/GetDatasetResponse.md)
 - [GetEdgeRequest](docs/GetEdgeRequest.md)
 - [GetEdgeResponse](docs/GetEdgeResponse.md)
 - [GetNodeRequest](docs/GetNodeRequest.md)
 - [GetNodeResponse](docs/GetNodeResponse.md)
 - [GetOntologyRequest](docs/GetOntologyRequest.md)
 - [GetOntologyResponse](docs/GetOntologyResponse.md)
 - [GetResourceImageRequest](docs/GetResourceImageRequest.md)
 - [GetResourceImageResponse](docs/GetResourceImageResponse.md)
 - [GetResourceResponse](docs/GetResourceResponse.md)
 - [GetSegmentRequest](docs/GetSegmentRequest.md)
 - [GetSegmentResponse](docs/GetSegmentResponse.md)
 - [GraphArgs](docs/GraphArgs.md)
 - [GraphExtractorMethod](docs/GraphExtractorMethod.md)
 - [GraphStoreType](docs/GraphStoreType.md)
 - [HTTPMethod](docs/HTTPMethod.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [IndexConfigInput](docs/IndexConfigInput.md)
 - [IndexConfigOutput](docs/IndexConfigOutput.md)
 - [ListDatasetRequest](docs/ListDatasetRequest.md)
 - [ListDatasetResourcesRequest](docs/ListDatasetResourcesRequest.md)
 - [ListDatasetResourcesResponse](docs/ListDatasetResourcesResponse.md)
 - [ListDatasetResponse](docs/ListDatasetResponse.md)
 - [ListEdgeRequest](docs/ListEdgeRequest.md)
 - [ListEdgeResponse](docs/ListEdgeResponse.md)
 - [ListEntityRequest](docs/ListEntityRequest.md)
 - [ListEntityResponse](docs/ListEntityResponse.md)
 - [ListNodeRequest](docs/ListNodeRequest.md)
 - [ListNodeResponse](docs/ListNodeResponse.md)
 - [ListRelationRequest](docs/ListRelationRequest.md)
 - [ListRelationResponse](docs/ListRelationResponse.md)
 - [ListResourcesResponse](docs/ListResourcesResponse.md)
 - [ListRowsRequest](docs/ListRowsRequest.md)
 - [ListRowsResponse](docs/ListRowsResponse.md)
 - [ListSegmentsRequest](docs/ListSegmentsRequest.md)
 - [ListSegmentsResponse](docs/ListSegmentsResponse.md)
 - [ListSubGraphEdgeRequest](docs/ListSubGraphEdgeRequest.md)
 - [ListSubGraphEdgeResponse](docs/ListSubGraphEdgeResponse.md)
 - [ListSubGraphNodeRequest](docs/ListSubGraphNodeRequest.md)
 - [ListSubGraphNodeResponse](docs/ListSubGraphNodeResponse.md)
 - [ListTasksRequest](docs/ListTasksRequest.md)
 - [ListTasksResponse](docs/ListTasksResponse.md)
 - [LoaderConfigInput](docs/LoaderConfigInput.md)
 - [LoaderConfigOutput](docs/LoaderConfigOutput.md)
 - [MGetEdgeRequest](docs/MGetEdgeRequest.md)
 - [MGetEdgeResponse](docs/MGetEdgeResponse.md)
 - [MGetNodeRequest](docs/MGetNodeRequest.md)
 - [MGetNodeResponse](docs/MGetNodeResponse.md)
 - [MentionStrategy](docs/MentionStrategy.md)
 - [MergeDatasetGraphRequest](docs/MergeDatasetGraphRequest.md)
 - [MergeDatasetGraphResponse](docs/MergeDatasetGraphResponse.md)
 - [MergeNodeRequest](docs/MergeNodeRequest.md)
 - [MergeResourceGraphRequest](docs/MergeResourceGraphRequest.md)
 - [MergeSegmentRequest](docs/MergeSegmentRequest.md)
 - [MetadataFilter](docs/MetadataFilter.md)
 - [MigrateResourceRequest](docs/MigrateResourceRequest.md)
 - [MigrateResourcesRequest](docs/MigrateResourcesRequest.md)
 - [MigrateSegmentsRequest](docs/MigrateSegmentsRequest.md)
 - [MilvusArgs](docs/MilvusArgs.md)
 - [Node](docs/Node.md)
 - [NodeDetail](docs/NodeDetail.md)
 - [Ontology](docs/Ontology.md)
 - [PaginationConfig](docs/PaginationConfig.md)
 - [ParseConfigInput](docs/ParseConfigInput.md)
 - [ParseConfigOutput](docs/ParseConfigOutput.md)
 - [ParseJsonConfig](docs/ParseJsonConfig.md)
 - [ParseMdConfig](docs/ParseMdConfig.md)
 - [ParseMethod](docs/ParseMethod.md)
 - [ParseStructureConfigInput](docs/ParseStructureConfigInput.md)
 - [ParseStructureConfigOutput](docs/ParseStructureConfigOutput.md)
 - [ParseUnStructureConfig](docs/ParseUnStructureConfig.md)
 - [Position](docs/Position.md)
 - [PropertyCondition](docs/PropertyCondition.md)
 - [QueueConfig](docs/QueueConfig.md)
 - [QueueLimitConfig](docs/QueueLimitConfig.md)
 - [RefreshDatasetRequest](docs/RefreshDatasetRequest.md)
 - [RefreshDatasetResourceRequest](docs/RefreshDatasetResourceRequest.md)
 - [Relation](docs/Relation.md)
 - [RelationFilterConfig](docs/RelationFilterConfig.md)
 - [RelationalDBConfigInput](docs/RelationalDBConfigInput.md)
 - [RelationalDBConfigOutput](docs/RelationalDBConfigOutput.md)
 - [Resource](docs/Resource.md)
 - [ResourceCron](docs/ResourceCron.md)
 - [ResourceDataDb](docs/ResourceDataDb.md)
 - [ResourceDataFile](docs/ResourceDataFile.md)
 - [ResourceDataQA](docs/ResourceDataQA.md)
 - [ResourceDataTable](docs/ResourceDataTable.md)
 - [ResourceInfo](docs/ResourceInfo.md)
 - [ResourceOnlineProvider](docs/ResourceOnlineProvider.md)
 - [ResourceOnlineService](docs/ResourceOnlineService.md)
 - [ResourceType](docs/ResourceType.md)
 - [ResponseModel](docs/ResponseModel.md)
 - [RetrieveArgs](docs/RetrieveArgs.md)
 - [RetrieveMetadata](docs/RetrieveMetadata.md)
 - [RetrieveSearchType](docs/RetrieveSearchType.md)
 - [RetrieveSegment](docs/RetrieveSegment.md)
 - [RetrieveSegmentsRequest](docs/RetrieveSegmentsRequest.md)
 - [RetrieveSegmentsResponse](docs/RetrieveSegmentsResponse.md)
 - [RetrieveType](docs/RetrieveType.md)
 - [Rule](docs/Rule.md)
 - [RunCypherRequest](docs/RunCypherRequest.md)
 - [RunCypherResponse](docs/RunCypherResponse.md)
 - [SchemaArg](docs/SchemaArg.md)
 - [SchemaArgType](docs/SchemaArgType.md)
 - [SchemaConfigInput](docs/SchemaConfigInput.md)
 - [SchemaConfigOutput](docs/SchemaConfigOutput.md)
 - [SearchResourceLabelRequest](docs/SearchResourceLabelRequest.md)
 - [Segment](docs/Segment.md)
 - [SegmentContent](docs/SegmentContent.md)
 - [SegmentContentForMigrate](docs/SegmentContentForMigrate.md)
 - [SegmentMetadata](docs/SegmentMetadata.md)
 - [SelectedField](docs/SelectedField.md)
 - [SplitterConfig](docs/SplitterConfig.md)
 - [StatusFilter](docs/StatusFilter.md)
 - [StatusType](docs/StatusType.md)
 - [StorageType](docs/StorageType.md)
 - [StorageURLProperty](docs/StorageURLProperty.md)
 - [StructureColumn](docs/StructureColumn.md)
 - [StructureSheet](docs/StructureSheet.md)
 - [SyncStrategy](docs/SyncStrategy.md)
 - [TableMetadata](docs/TableMetadata.md)
 - [TableRow](docs/TableRow.md)
 - [Task](docs/Task.md)
 - [TaskConfig](docs/TaskConfig.md)
 - [TaskData](docs/TaskData.md)
 - [TaskStatus](docs/TaskStatus.md)
 - [TaskStatusInfo](docs/TaskStatusInfo.md)
 - [TaskStep](docs/TaskStep.md)
 - [TaskType](docs/TaskType.md)
 - [TextStoreType](docs/TextStoreType.md)
 - [TransformStep](docs/TransformStep.md)
 - [URLAuthentication](docs/URLAuthentication.md)
 - [UpdateDatasetRequest](docs/UpdateDatasetRequest.md)
 - [UpdateDatasetResourceRequest](docs/UpdateDatasetResourceRequest.md)
 - [UpdateEdgeRequest](docs/UpdateEdgeRequest.md)
 - [UpdateEntityRequest](docs/UpdateEntityRequest.md)
 - [UpdateNodeRequest](docs/UpdateNodeRequest.md)
 - [UpdateRelationRequest](docs/UpdateRelationRequest.md)
 - [UpdateResourceMetaRequest](docs/UpdateResourceMetaRequest.md)
 - [UpdateResourceMetadata](docs/UpdateResourceMetadata.md)
 - [UpdateResourceOnline](docs/UpdateResourceOnline.md)
 - [UpdateResourceProperty](docs/UpdateResourceProperty.md)
 - [UpdateSegmentRequest](docs/UpdateSegmentRequest.md)
 - [UpsertModelRequest](docs/UpsertModelRequest.md)
 - [UpsertModelResponse](docs/UpsertModelResponse.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [VectorDO](docs/VectorDO.md)
 - [VectorDistanceType](docs/VectorDistanceType.md)
 - [VectorIndexType](docs/VectorIndexType.md)
 - [VectorMetadataValueObject](docs/VectorMetadataValueObject.md)
 - [VectorStoreArgs](docs/VectorStoreArgs.md)
 - [VectorStoreType](docs/VectorStoreType.md)
 - [VikingDBArgs](docs/VikingDBArgs.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




