# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AppTalosSchemaDatasetGetResourceRequest(BaseModel):
    """
    AppTalosSchemaDatasetGetResourceRequest
    """ # noqa: E501
    resource_id: StrictStr
    dataset_id: Optional[StrictStr] = 'dataset-default'
    table_name: Optional[StrictStr] = None
    graph_counted: Optional[StrictBool] = Field(default=False, description="若是图谱库，标记是否返回图谱的计数信息")
    __properties: ClassVar[List[str]] = ["resource_id", "dataset_id", "table_name", "graph_counted"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppTalosSchemaDatasetGetResourceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if table_name (nullable) is None
        # and model_fields_set contains the field
        if self.table_name is None and "table_name" in self.model_fields_set:
            _dict['table_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppTalosSchemaDatasetGetResourceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resource_id": obj.get("resource_id"),
            "dataset_id": obj.get("dataset_id") if obj.get("dataset_id") is not None else 'dataset-default',
            "table_name": obj.get("table_name"),
            "graph_counted": obj.get("graph_counted") if obj.get("graph_counted") is not None else False
        })
        return _obj


