# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.create_resource_request import CreateResourceRequest
from talos_aclient.models.queue_config import QueueConfig
from typing import Optional, Set
from typing_extensions import Self

class BatchAddResourcesToDatasetRequest(BaseModel):
    """
    BatchAddResourcesToDatasetRequest
    """ # noqa: E501
    queue_config: Optional[QueueConfig] = None
    trace_info: Optional[Dict[str, Any]] = None
    dataset_id: StrictStr
    resources: List[CreateResourceRequest]
    document_meta: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["queue_config", "trace_info", "dataset_id", "resources", "document_meta"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BatchAddResourcesToDatasetRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of queue_config
        if self.queue_config:
            _dict['queue_config'] = self.queue_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in resources (list)
        _items = []
        if self.resources:
            for _item_resources in self.resources:
                if _item_resources:
                    _items.append(_item_resources.to_dict())
            _dict['resources'] = _items
        # set to None if trace_info (nullable) is None
        # and model_fields_set contains the field
        if self.trace_info is None and "trace_info" in self.model_fields_set:
            _dict['trace_info'] = None

        # set to None if document_meta (nullable) is None
        # and model_fields_set contains the field
        if self.document_meta is None and "document_meta" in self.model_fields_set:
            _dict['document_meta'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BatchAddResourcesToDatasetRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "queue_config": QueueConfig.from_dict(obj["queue_config"]) if obj.get("queue_config") is not None else None,
            "trace_info": obj.get("trace_info"),
            "dataset_id": obj.get("dataset_id"),
            "resources": [CreateResourceRequest.from_dict(_item) for _item in obj["resources"]] if obj.get("resources") is not None else None,
            "document_meta": obj.get("document_meta")
        })
        return _obj


