# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from talos_aclient.models.enum_celery_queue import EnumCeleryQueue
from talos_aclient.models.segment_content import SegmentContent
from typing import Optional, Set
from typing_extensions import Self

class BatchAddSegmentsRequest(BaseModel):
    """
    BatchAddSegmentsRequest
    """ # noqa: E501
    trace_info: Optional[Dict[str, Any]] = None
    resource_id: Annotated[str, Field(min_length=1, strict=True)]
    dataset_id: Annotated[str, Field(min_length=1, strict=True)]
    segments: Annotated[List[SegmentContent], Field(min_length=1)]
    queue: Optional[EnumCeleryQueue] = None
    __properties: ClassVar[List[str]] = ["trace_info", "resource_id", "dataset_id", "segments", "queue"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BatchAddSegmentsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in segments (list)
        _items = []
        if self.segments:
            for _item_segments in self.segments:
                if _item_segments:
                    _items.append(_item_segments.to_dict())
            _dict['segments'] = _items
        # set to None if trace_info (nullable) is None
        # and model_fields_set contains the field
        if self.trace_info is None and "trace_info" in self.model_fields_set:
            _dict['trace_info'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BatchAddSegmentsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trace_info": obj.get("trace_info"),
            "resource_id": obj.get("resource_id"),
            "dataset_id": obj.get("dataset_id"),
            "segments": [SegmentContent.from_dict(_item) for _item in obj["segments"]] if obj.get("segments") is not None else None,
            "queue": obj.get("queue")
        })
        return _obj


