# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from talos_aclient.models.parse_json_config import ParseJsonConfig
from talos_aclient.models.parse_md_config import ParseMdConfig
from talos_aclient.models.parse_structure_config_input import ParseStructureConfigInput
from talos_aclient.models.parse_un_structure_config import ParseUnStructureConfig
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

CONFIG_ANY_OF_SCHEMAS = ["ParseJsonConfig", "ParseMdConfig", "ParseStructureConfigInput", "ParseUnStructureConfig"]

class Config(BaseModel):
    """
    Config
    """

    # data type: ParseUnStructureConfig
    anyof_schema_1_validator: Optional[ParseUnStructureConfig] = None
    # data type: ParseStructureConfigInput
    anyof_schema_2_validator: Optional[ParseStructureConfigInput] = None
    # data type: ParseJsonConfig
    anyof_schema_3_validator: Optional[ParseJsonConfig] = None
    # data type: ParseMdConfig
    anyof_schema_4_validator: Optional[ParseMdConfig] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[ParseJsonConfig, ParseMdConfig, ParseStructureConfigInput, ParseUnStructureConfig]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "ParseJsonConfig", "ParseMdConfig", "ParseStructureConfigInput", "ParseUnStructureConfig" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = Config.model_construct()
        error_messages = []
        # validate data type: ParseUnStructureConfig
        if not isinstance(v, ParseUnStructureConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ParseUnStructureConfig`")
        else:
            return v

        # validate data type: ParseStructureConfigInput
        if not isinstance(v, ParseStructureConfigInput):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ParseStructureConfigInput`")
        else:
            return v

        # validate data type: ParseJsonConfig
        if not isinstance(v, ParseJsonConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ParseJsonConfig`")
        else:
            return v

        # validate data type: ParseMdConfig
        if not isinstance(v, ParseMdConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ParseMdConfig`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in Config with anyOf schemas: ParseJsonConfig, ParseMdConfig, ParseStructureConfigInput, ParseUnStructureConfig. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[ParseUnStructureConfig] = None
        try:
            instance.actual_instance = ParseUnStructureConfig.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[ParseStructureConfigInput] = None
        try:
            instance.actual_instance = ParseStructureConfigInput.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[ParseJsonConfig] = None
        try:
            instance.actual_instance = ParseJsonConfig.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[ParseMdConfig] = None
        try:
            instance.actual_instance = ParseMdConfig.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Config with anyOf schemas: ParseJsonConfig, ParseMdConfig, ParseStructureConfigInput, ParseUnStructureConfig. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ParseJsonConfig, ParseMdConfig, ParseStructureConfigInput, ParseUnStructureConfig]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


