# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from talos_aclient.models.auth_api_key import AuthAPIKey
from talos_aclient.models.auth_basic import AuthBasic
from talos_aclient.models.auth_oauth2 import AuthOauth2
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

CONFIG2_ANY_OF_SCHEMAS = ["AuthAPIKey", "AuthBasic", "AuthOauth2"]

class Config2(BaseModel):
    """
    Config2
    """

    # data type: AuthAPIKey
    anyof_schema_1_validator: Optional[AuthAPIKey] = None
    # data type: AuthBasic
    anyof_schema_2_validator: Optional[AuthBasic] = None
    # data type: AuthOauth2
    anyof_schema_3_validator: Optional[AuthOauth2] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[AuthAPIKey, AuthBasic, AuthOauth2]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "AuthAPIKey", "AuthBasic", "AuthOauth2" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        if v is None:
            return v

        instance = Config2.model_construct()
        error_messages = []
        # validate data type: AuthAPIKey
        if not isinstance(v, AuthAPIKey):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AuthAPIKey`")
        else:
            return v

        # validate data type: AuthBasic
        if not isinstance(v, AuthBasic):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AuthBasic`")
        else:
            return v

        # validate data type: AuthOauth2
        if not isinstance(v, AuthOauth2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AuthOauth2`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in Config2 with anyOf schemas: AuthAPIKey, AuthBasic, AuthOauth2. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        if json_str is None:
            return instance

        error_messages = []
        # anyof_schema_1_validator: Optional[AuthAPIKey] = None
        try:
            instance.actual_instance = AuthAPIKey.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[AuthBasic] = None
        try:
            instance.actual_instance = AuthBasic.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[AuthOauth2] = None
        try:
            instance.actual_instance = AuthOauth2.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Config2 with anyOf schemas: AuthAPIKey, AuthBasic, AuthOauth2. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AuthAPIKey, AuthBasic, AuthOauth2]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


