# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CountNodeRequest(BaseModel):
    """
    CountNodeRequest
    """ # noqa: E501
    trace_info: Optional[Dict[str, Any]] = None
    dataset_id: StrictStr
    resource_id: Optional[StrictStr] = None
    label_id: Optional[Annotated[str, Field(strict=True, max_length=32)]] = None
    label_name: Optional[Annotated[str, Field(strict=True, max_length=128)]] = None
    keyword: Optional[StrictStr] = None
    filter_by_property_value: Optional[StrictBool] = Field(default=False, description="是否根据property value contains keyword过滤节点")
    __properties: ClassVar[List[str]] = ["trace_info", "dataset_id", "resource_id", "label_id", "label_name", "keyword", "filter_by_property_value"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CountNodeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if trace_info (nullable) is None
        # and model_fields_set contains the field
        if self.trace_info is None and "trace_info" in self.model_fields_set:
            _dict['trace_info'] = None

        # set to None if resource_id (nullable) is None
        # and model_fields_set contains the field
        if self.resource_id is None and "resource_id" in self.model_fields_set:
            _dict['resource_id'] = None

        # set to None if label_id (nullable) is None
        # and model_fields_set contains the field
        if self.label_id is None and "label_id" in self.model_fields_set:
            _dict['label_id'] = None

        # set to None if label_name (nullable) is None
        # and model_fields_set contains the field
        if self.label_name is None and "label_name" in self.model_fields_set:
            _dict['label_name'] = None

        # set to None if keyword (nullable) is None
        # and model_fields_set contains the field
        if self.keyword is None and "keyword" in self.model_fields_set:
            _dict['keyword'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CountNodeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trace_info": obj.get("trace_info"),
            "dataset_id": obj.get("dataset_id"),
            "resource_id": obj.get("resource_id"),
            "label_id": obj.get("label_id"),
            "label_name": obj.get("label_name"),
            "keyword": obj.get("keyword"),
            "filter_by_property_value": obj.get("filter_by_property_value") if obj.get("filter_by_property_value") is not None else False
        })
        return _obj


