# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.dataset_type import DatasetType
from talos_aclient.models.index_config_input import IndexConfigInput
from talos_aclient.models.parse_config_input import ParseConfigInput
from talos_aclient.models.schema_config_input import SchemaConfigInput
from typing import Optional, Set
from typing_extensions import Self

class CreateDatasetRequest(BaseModel):
    """
    如果dataset_type与index_config 冲突，优先dataset_type 如果由talos-maas 决定gdb/vdb 选型，则不应暴漏index_config.text_store/vector_store/graph_store等参数
    """ # noqa: E501
    trace_info: Optional[Dict[str, Any]] = None
    id: Optional[StrictStr] = None
    dataset_type: Optional[DatasetType] = None
    parse_config: Optional[ParseConfigInput] = None
    index_config: Optional[IndexConfigInput] = None
    schema_config: Optional[SchemaConfigInput] = None
    __properties: ClassVar[List[str]] = ["trace_info", "id", "dataset_type", "parse_config", "index_config", "schema_config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateDatasetRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parse_config
        if self.parse_config:
            _dict['parse_config'] = self.parse_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of index_config
        if self.index_config:
            _dict['index_config'] = self.index_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schema_config
        if self.schema_config:
            _dict['schema_config'] = self.schema_config.to_dict()
        # set to None if trace_info (nullable) is None
        # and model_fields_set contains the field
        if self.trace_info is None and "trace_info" in self.model_fields_set:
            _dict['trace_info'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if schema_config (nullable) is None
        # and model_fields_set contains the field
        if self.schema_config is None and "schema_config" in self.model_fields_set:
            _dict['schema_config'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateDatasetRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trace_info": obj.get("trace_info"),
            "id": obj.get("id"),
            "dataset_type": obj.get("dataset_type"),
            "parse_config": ParseConfigInput.from_dict(obj["parse_config"]) if obj.get("parse_config") is not None else None,
            "index_config": IndexConfigInput.from_dict(obj["index_config"]) if obj.get("index_config") is not None else None,
            "schema_config": SchemaConfigInput.from_dict(obj["schema_config"]) if obj.get("schema_config") is not None else None
        })
        return _obj


