# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.resource_cron import ResourceCron
from typing import Optional, Set
from typing_extensions import Self

class CreateResourceRespItem(BaseModel):
    """
    CreateResourceRespItem
    """ # noqa: E501
    id: StrictStr
    size: Optional[StrictInt] = 0
    dry_run: Optional[StrictBool] = False
    cron: Optional[ResourceCron] = None
    name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "size", "dry_run", "cron", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateResourceRespItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cron
        if self.cron:
            _dict['cron'] = self.cron.to_dict()
        # set to None if cron (nullable) is None
        # and model_fields_set contains the field
        if self.cron is None and "cron" in self.model_fields_set:
            _dict['cron'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateResourceRespItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "size": obj.get("size") if obj.get("size") is not None else 0,
            "dry_run": obj.get("dry_run") if obj.get("dry_run") is not None else False,
            "cron": ResourceCron.from_dict(obj["cron"]) if obj.get("cron") is not None else None,
            "name": obj.get("name")
        })
        return _obj


