# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, Dict, Optional
from talos_aclient.models.resource_data_db import ResourceDataDb
from talos_aclient.models.resource_data_file import ResourceDataFile
from talos_aclient.models.resource_data_qa import ResourceDataQA
from talos_aclient.models.resource_data_table import ResourceDataTable
from talos_aclient.models.resource_online_service import ResourceOnlineService
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

DATA_ANY_OF_SCHEMAS = ["ResourceDataDb", "ResourceDataFile", "ResourceDataQA", "ResourceDataTable", "ResourceOnlineService", "object"]

class Data(BaseModel):
    """
    Data
    """

    # data type: ResourceDataFile
    anyof_schema_1_validator: Optional[ResourceDataFile] = None
    # data type: ResourceDataDb
    anyof_schema_2_validator: Optional[ResourceDataDb] = None
    # data type: ResourceDataTable
    anyof_schema_3_validator: Optional[ResourceDataTable] = None
    # data type: ResourceOnlineService
    anyof_schema_4_validator: Optional[ResourceOnlineService] = None
    # data type: object
    anyof_schema_5_validator: Optional[Dict[str, Any]] = None
    # data type: ResourceDataQA
    anyof_schema_6_validator: Optional[ResourceDataQA] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[ResourceDataDb, ResourceDataFile, ResourceDataQA, ResourceDataTable, ResourceOnlineService, object]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "ResourceDataDb", "ResourceDataFile", "ResourceDataQA", "ResourceDataTable", "ResourceOnlineService", "object" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = Data.model_construct()
        error_messages = []
        # validate data type: ResourceDataFile
        if not isinstance(v, ResourceDataFile):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResourceDataFile`")
        else:
            return v

        # validate data type: ResourceDataDb
        if not isinstance(v, ResourceDataDb):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResourceDataDb`")
        else:
            return v

        # validate data type: ResourceDataTable
        if not isinstance(v, ResourceDataTable):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResourceDataTable`")
        else:
            return v

        # validate data type: ResourceOnlineService
        if not isinstance(v, ResourceOnlineService):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResourceOnlineService`")
        else:
            return v

        # validate data type: object
        try:
            instance.anyof_schema_5_validator = v
            return v
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # validate data type: ResourceDataQA
        if not isinstance(v, ResourceDataQA):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ResourceDataQA`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in Data with anyOf schemas: ResourceDataDb, ResourceDataFile, ResourceDataQA, ResourceDataTable, ResourceOnlineService, object. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[ResourceDataFile] = None
        try:
            instance.actual_instance = ResourceDataFile.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[ResourceDataDb] = None
        try:
            instance.actual_instance = ResourceDataDb.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[ResourceDataTable] = None
        try:
            instance.actual_instance = ResourceDataTable.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[ResourceOnlineService] = None
        try:
            instance.actual_instance = ResourceOnlineService.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # deserialize data into object
        try:
            # validation
            instance.anyof_schema_5_validator = json.loads(json_str)
            # assign value to actual_instance
            instance.actual_instance = instance.anyof_schema_5_validator
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # anyof_schema_6_validator: Optional[ResourceDataQA] = None
        try:
            instance.actual_instance = ResourceDataQA.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Data with anyOf schemas: ResourceDataDb, ResourceDataFile, ResourceDataQA, ResourceDataTable, ResourceOnlineService, object. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ResourceDataDb, ResourceDataFile, ResourceDataQA, ResourceDataTable, ResourceOnlineService, object]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


