# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.app_talos_schema_dataset_graph_metadata import AppTalosSchemaDatasetGraphMetadata
from talos_aclient.models.index_config_output import IndexConfigOutput
from talos_aclient.models.parse_config_output import ParseConfigOutput
from talos_aclient.models.schema_config_output import SchemaConfigOutput
from typing import Optional, Set
from typing_extensions import Self

class Dataset(BaseModel):
    """
    Dataset
    """ # noqa: E501
    id: StrictStr
    parse_config: ParseConfigOutput
    index_config: IndexConfigOutput
    schema_config: Optional[SchemaConfigOutput] = None
    resource_count: Optional[StrictInt] = Field(default=0, description="包含的单元个数")
    success_resource_count: Optional[StrictInt] = Field(default=0, description="处理成功的单元数")
    graph_metadata: Optional[AppTalosSchemaDatasetGraphMetadata] = None
    create_time: datetime
    update_time: datetime
    __properties: ClassVar[List[str]] = ["id", "parse_config", "index_config", "schema_config", "resource_count", "success_resource_count", "graph_metadata", "create_time", "update_time"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Dataset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parse_config
        if self.parse_config:
            _dict['parse_config'] = self.parse_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of index_config
        if self.index_config:
            _dict['index_config'] = self.index_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schema_config
        if self.schema_config:
            _dict['schema_config'] = self.schema_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of graph_metadata
        if self.graph_metadata:
            _dict['graph_metadata'] = self.graph_metadata.to_dict()
        # set to None if schema_config (nullable) is None
        # and model_fields_set contains the field
        if self.schema_config is None and "schema_config" in self.model_fields_set:
            _dict['schema_config'] = None

        # set to None if graph_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.graph_metadata is None and "graph_metadata" in self.model_fields_set:
            _dict['graph_metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Dataset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "parse_config": ParseConfigOutput.from_dict(obj["parse_config"]) if obj.get("parse_config") is not None else None,
            "index_config": IndexConfigOutput.from_dict(obj["index_config"]) if obj.get("index_config") is not None else None,
            "schema_config": SchemaConfigOutput.from_dict(obj["schema_config"]) if obj.get("schema_config") is not None else None,
            "resource_count": obj.get("resource_count") if obj.get("resource_count") is not None else 0,
            "success_resource_count": obj.get("success_resource_count") if obj.get("success_resource_count") is not None else 0,
            "graph_metadata": AppTalosSchemaDatasetGraphMetadata.from_dict(obj["graph_metadata"]) if obj.get("graph_metadata") is not None else None,
            "create_time": obj.get("create_time"),
            "update_time": obj.get("update_time")
        })
        return _obj


